/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.CardPanel;
import ae.ColorUtils;
import ae.DBPanel;
import ae.DButton;
import ae.DCheckbox;
import ae.DComboBox;
import ae.DLabel;
import ae.DPanel;
import ae.DialogYN;
import ae.Icons;
import ae.LocateDialog;
import ae.Memory;
import ae.Messages;
import ae.OS;
import ae.PageSetup;
import ae.Path;
import ae.Preferences;
import ae.SetupWindow;
import ae.Spinner;
import ae.StylePanel;
import ae.TButton;
import ae.Windows;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class AESetup
extends Panel
implements ItemListener,
ActionListener,
ComponentListener,
Messages {
    Frame frame;
    Memory mem;
    List panelList;
    CardPanel cards;
    DButton buttonAutoSetup;
    DButton buttonSave;
    DButton buttonDefault;
    Panel tabGeneral;
    Spinner spinnerMemory;
    Spinner spinnerMemBase;
    Spinner spinnerMenu;
    DCheckbox checkMemory;
    DCheckbox checkAutosave;
    DCheckbox checkSound;
    Label labelLang;
    Choice choiceLang;
    Label labelTab;
    Choice choiceTab;
    DCheckbox checkScale;
    DCheckbox checkDirect;
    DCheckbox checkFScale;
    Panel tabFiles;
    Label labelSetupDirBack;
    Label labelSetupDirFore;
    DCheckbox checkZipSort;
    DCheckbox checkArcRestore;
    DCheckbox checkArcReplace;
    DCheckbox checkDeleteDir;
    DCheckbox checkDeleteFile;
    DCheckbox checkReplace;
    DCheckbox checkFloppies;
    DCheckbox checkOpen;
    DCheckbox checkHtml;
    TextField fieldShort;
    TextField fieldPath;
    TButton buttonShortSet;
    Choice choiceShort;
    public StylePanel tabStylePanel;
    Panel tabText;
    DCheckbox checkEd;
    DCheckbox checkWrap;
    Label labelEd;
    TextField inputEd;
    TButton buttonEdLocate;
    DLabel labelBrowser;
    TButton buttonBBrowse;
    Panel panelSetupAss;
    DComboBox comboExt;
    DComboBox comboAss;
    TButton buttonAssAdd;
    TButton buttonAssDef;
    TButton buttonAssAll;
    TButton buttonAssClear;
    TButton buttonAssCls;
    TButton buttonAssSearch;
    TButton buttonAssBrowse;
    DLabel labelAss;
    DCheckbox checkFirst;
    DCheckbox checkEnable;
    PageSetup pageSetup;
    static boolean resizeMemory = false;
    static int shortnum = 0;
    static boolean[] enableAss = new boolean[256];
    static boolean WINDOWS;
    int listNo = 0;
    ActionListener actionListener = null;
    String message = "";

    public AESetup(Frame f, Color PrgBackground, Font AEFont, Font AEBold) {
        this.frame = f;
        this.mem = null;
        WINDOWS = OS.isWindows();
        this.setLayout(new BorderLayout());
        Dimension screen = this.getToolkit().getScreenSize();
        int fontSize = 14;
        int textSize = 30;
        if (screen.width >= 1024) {
            fontSize = 16;
        }
        if (WINDOWS) {
            textSize = 24;
        }
        Font setupFont = new Font("Dialog", 0, 14);
        DBPanel panelControl = new DBPanel(1);
        panelControl.setBounds(0, 0, 616, 40);
        panelControl.setPadding(0, 3, 0, 3);
        panelControl.setIPadding(0, 0, 0, 0);
        panelControl.setInnerBackground(ColorUtils.shadow(PrgBackground));
        this.add((Component)panelControl, "North");
        this.buttonDefault = new DButton(Icons.New, "Defaults");
        this.buttonDefault.setBounds(16, 6, 104, 30);
        this.buttonDefault.setTip("Restore default settings");
        this.buttonDefault.addActionListener(this);
        panelControl.add(this.buttonDefault);
        this.buttonAutoSetup = new DButton(Icons.Locate, "AutoSetup");
        this.buttonAutoSetup.setBounds(144, 6, 120, 30);
        this.buttonAutoSetup.setTip("Search for drives and useful programs");
        this.buttonAutoSetup.addActionListener(this);
        panelControl.add(this.buttonAutoSetup);
        this.buttonSave = new DButton(Icons.Save, "Save");
        this.buttonSave.setBounds(272, 6, 96, 30);
        this.buttonSave.setTip("Save the settings");
        this.buttonSave.addActionListener(this);
        panelControl.add(this.buttonSave);
        DLabel labelTitle = new DLabel("USER'S PREFERENCES", 0, 2);
        labelTitle.setBounds(500, 7, 240, 24);
        labelTitle.setFont(AEBold);
        labelTitle.setForeground(Color.white);
        panelControl.add(labelTitle);
        DPanel panelContent = new DPanel(new BorderLayout());
        this.add((Component)panelContent, "Center");
        this.panelList = new List();
        this.panelList.add("Desktop");
        this.panelList.add("Styles");
        this.panelList.add("File management");
        this.panelList.add("Editor / HTML");
        this.panelList.add("Images");
        this.panelList.add("Associations");
        this.panelList.add("Web pages");
        this.panelList.setSize(1024, 256);
        this.panelList.addItemListener(this);
        panelContent.add((Component)this.panelList, "West");
        this.cards = new CardPanel();
        panelContent.add(this.cards);
        this.tabGeneral = new Panel();
        this.tabGeneral.setLayout(null);
        this.tabGeneral.setVisible(false);
        this.tabGeneral.setBounds(12, 33, 574, 328);
        this.tabGeneral.addComponentListener(this);
        this.cards.add(this.tabGeneral);
        this.spinnerMemory = new Spinner(Preferences.MemorySize, 0, 64);
        this.spinnerMemory.setBounds(32, 44, 54, 27);
        this.spinnerMemory.addActionListener(this);
        this.tabGeneral.add(this.spinnerMemory);
        Label labelMemory = new Label("Entries in lists of paths");
        labelMemory.setBounds(96, 43, 200, 28);
        this.tabGeneral.add(labelMemory);
        this.spinnerMemBase = new Spinner(Preferences.MemBaseSize, 0, 32);
        this.spinnerMemBase.setBounds(308, 44, 54, 27);
        this.spinnerMemBase.addActionListener(this);
        Label labelMemBase = new Label("Permanent entries up to");
        labelMemBase.setBounds(374, 43, 200, 28);
        if (!WINDOWS) {
            this.tabGeneral.add(this.spinnerMemBase);
            this.tabGeneral.add(labelMemBase);
        }
        this.spinnerMenu = new Spinner(Preferences.menuSize, 0, 64);
        this.spinnerMenu.setBounds(32, 92, 54, 27);
        this.spinnerMenu.addActionListener(this);
        this.tabGeneral.add(this.spinnerMenu);
        Label labelMenu = new Label("Entries in menues");
        labelMenu.setBounds(96, 91, 200, 28);
        this.tabGeneral.add(labelMenu);
        this.checkMemory = new DCheckbox("Saving lists at exit", Preferences.SaveMemory);
        this.checkMemory.setBounds(32, 140, 200, 22);
        this.checkMemory.addItemListener(this);
        this.tabGeneral.add(this.checkMemory);
        this.checkAutosave = new DCheckbox("Auto save setup", Preferences.AutoSave);
        this.checkAutosave.setBounds(32, 164, 200, 22);
        this.checkAutosave.addItemListener(this);
        this.tabGeneral.add(this.checkAutosave);
        this.checkSound = new DCheckbox("Sound", Preferences.Sound);
        this.checkSound.setBounds(32, 188, 80, 22);
        this.checkSound.addItemListener(this);
        this.tabGeneral.add(this.checkSound);
        this.labelTab = new Label("Tabs");
        this.labelTab.setBounds(32, 228, 40, 22);
        this.tabGeneral.add(this.labelTab);
        this.choiceTab = new Choice();
        this.choiceTab.setBounds(80, 228, 112, 24);
        this.choiceTab.setBackground(PrgBackground);
        this.choiceTab.addItem("Rounded");
        this.choiceTab.addItem("Cutted");
        this.choiceTab.addItem("Slanted");
        this.choiceTab.addItemListener(this);
        this.tabGeneral.add(this.choiceTab);
        this.labelLang = new Label("Manual");
        this.labelLang.setBounds(32, 268, 64, 22);
        this.tabGeneral.add(this.labelLang);
        this.choiceLang = new Choice();
        this.choiceLang.setBounds(100, 268, 132, 24);
        this.choiceLang.setBackground(PrgBackground);
        this.choiceLang.addItem("English");
        this.choiceLang.addItem("Fran\u00e7ais");
        this.choiceLang.addItem("Espanol");
        this.choiceLang.addItem("Deutsch");
        this.choiceLang.addItem("Russian");
        this.choiceLang.addItem("Italiano");
        this.choiceLang.addItem("Portugues");
        this.choiceLang.addItem("Dansk");
        this.choiceLang.addItem("Norsk");
        this.choiceLang.addItem("Svensk");
        this.choiceLang.addItem("Suomi");
        this.choiceLang.addItem("Roman");
        this.choiceLang.addItem("Polski");
        this.choiceLang.addItem("Hungarian");
        this.choiceLang.addItem("Cesko");
        this.choiceLang.addItem("Slovnik");
        this.choiceLang.addItem("Other");
        this.choiceLang.addItemListener(this);
        this.tabGeneral.add(this.choiceLang);
        this.tabStylePanel = new StylePanel(48, 32);
        this.tabStylePanel.setBounds(12, 12, 574, 358);
        this.tabStylePanel.addActionListener(this);
        this.tabStylePanel.addComponentListener(this);
        this.cards.add(this.tabStylePanel);
        this.tabFiles = new Panel();
        this.tabFiles.setLayout(null);
        this.tabFiles.setVisible(false);
        this.tabFiles.setBounds(12, 12, 574, 372);
        this.tabFiles.addComponentListener(this);
        this.cards.add(this.tabFiles);
        this.checkZipSort = new DCheckbox("Display content of archive sorted", Preferences.ArcSort);
        this.checkZipSort.setBounds(32, 32, 256, 22);
        this.checkZipSort.addItemListener(this);
        this.tabFiles.add(this.checkZipSort);
        this.checkDeleteDir = new DCheckbox("Prompt to delete no empty dir", Preferences.AskDeleteDir);
        this.checkDeleteDir.setBounds(32, 64, 232, 22);
        this.checkDeleteDir.addItemListener(this);
        this.tabFiles.add(this.checkDeleteDir);
        this.checkDeleteFile = new DCheckbox("Prompt to delete file", Preferences.AskDeleteFile);
        this.checkDeleteFile.setBounds(32, 96, 200, 22);
        this.checkDeleteFile.addItemListener(this);
        this.tabFiles.add(this.checkDeleteFile);
        this.checkReplace = new DCheckbox("Prompt before replacing existing file", Preferences.AskReplace);
        this.checkReplace.setBounds(32, 128, 280, 22);
        this.checkReplace.addItemListener(this);
        this.tabFiles.add(this.checkReplace);
        this.checkHtml = new DCheckbox("Prompt to replace generated html", Preferences.AskHtml);
        this.checkHtml.setBounds(32, 160, 256, 22);
        this.checkHtml.addItemListener(this);
        this.tabFiles.add(this.checkHtml);
        this.checkArcRestore = new DCheckbox("Restore paths when unarchiving", Preferences.ArcRestore);
        this.checkArcRestore.setBounds(32, 192, 248, 22);
        this.checkArcRestore.addItemListener(this);
        this.tabFiles.add(this.checkArcRestore);
        this.checkArcReplace = new DCheckbox("Erase previous when unarchiving", Preferences.ArcReplace);
        this.checkArcReplace.setBounds(32, 224, 248, 22);
        this.checkArcReplace.addItemListener(this);
        this.tabFiles.add(this.checkArcReplace);
        this.checkFloppies = new DCheckbox("Including floppies in tree list", Preferences.FLOPPIES);
        this.checkFloppies.setBounds(32, 256, 248, 22);
        this.checkFloppies.addItemListener(this);
        this.tabFiles.add(this.checkFloppies);
        this.checkOpen = new DCheckbox("Open dir created in target", Preferences.OpenDir);
        this.checkOpen.setBounds(32, 288, 248, 22);
        this.checkOpen.addItemListener(this);
        this.tabFiles.add(this.checkOpen);
        this.choiceShort = new Choice();
        this.choiceShort.setBounds(32, 356, 100, textSize);
        this.choiceShort.setBackground(PrgBackground);
        this.choiceShort.addItem("Button 1");
        this.choiceShort.addItem("Button 2");
        this.choiceShort.addItem("Button 3");
        this.choiceShort.addItem("Button 4");
        this.choiceShort.addItem("Button 5");
        this.choiceShort.addItem("Button 6");
        this.choiceShort.addItem("Button 7");
        this.choiceShort.addItem("Button 8");
        this.choiceShort.addItemListener(this);
        this.choiceShort.select(0);
        this.tabFiles.add(this.choiceShort);
        Label lfs = new Label("Name");
        lfs.setBounds(134, 332, 128, 22);
        this.tabFiles.add(lfs);
        Label lfp = new Label("Path");
        lfp.setBounds(264, 332, 200, 22);
        this.tabFiles.add(lfp);
        this.fieldShort = new TextField(Preferences.shortcut[0], 1);
        this.fieldShort.setBounds(134, 356, 128, textSize);
        this.fieldShort.setFont(setupFont);
        this.tabFiles.add(this.fieldShort);
        this.fieldPath = new TextField(Preferences.longpath[0], 1);
        this.fieldPath.setBounds(264, 356, 200, textSize);
        this.fieldPath.setFont(setupFont);
        this.tabFiles.add(this.fieldPath);
        this.buttonShortSet = new TButton("Set it");
        this.buttonShortSet.setBounds(466, 356, 72, textSize);
        this.buttonShortSet.setStyle(true, true, 1);
        this.buttonShortSet.addActionListener(this);
        this.buttonShortSet.setTip("Set changes");
        this.tabFiles.add(this.buttonShortSet);
        this.tabText = new Panel(null);
        this.tabText.setVisible(false);
        this.tabText.setBounds(12, 33, 574, 258);
        this.tabText.addComponentListener(this);
        this.cards.add(this.tabText);
        this.labelEd = new Label("Alternate text editor:");
        this.labelEd.setBounds(16, 26, 192, 20);
        this.tabText.add(this.labelEd);
        this.inputEd = new TextField();
        this.inputEd.setBounds(16, 48, 400, textSize);
        this.inputEd.setFont(setupFont);
        this.tabText.add(this.inputEd);
        this.buttonEdLocate = new TButton(Icons.Locate, "Browse");
        this.buttonEdLocate.setBounds(418, 48, 96, textSize);
        this.buttonEdLocate.setStyle(true, true, 1);
        this.buttonEdLocate.setTip("Find the editor");
        this.buttonEdLocate.addActionListener(this);
        this.tabText.add(this.buttonEdLocate);
        this.checkEd = new DCheckbox("Use this alternate editor for any text", Preferences.EditorAss);
        this.checkEd.setBounds(16, 96, 308, 22);
        this.checkEd.addItemListener(this);
        this.tabText.add(this.checkEd);
        this.checkWrap = new DCheckbox("Wrap-around - AE must be restarted", Preferences.wordWrap);
        this.checkWrap.setBounds(16, 124, 300, 22);
        this.checkWrap.addItemListener(this);
        this.tabText.add(this.checkWrap);
        Label lb = new Label("HTML viewer:");
        lb.setBounds(16, 188, 160, 20);
        this.tabText.add(lb);
        String brow = WINDOWS ? "Internet Explorer" : "Mozilla";
        this.labelBrowser = new DLabel(brow, 3, 1);
        this.labelBrowser.setBounds(16, 210, 222, textSize);
        this.tabText.add(this.labelBrowser);
        this.buttonBBrowse = new TButton(Icons.Locate, "Browse");
        this.buttonBBrowse.setBounds(240, 210, 96, textSize);
        this.buttonBBrowse.setStyle(true, true, 1);
        this.buttonBBrowse.setTip("Locate the browser");
        this.buttonBBrowse.addActionListener(this);
        this.tabText.add(this.buttonBBrowse);
        Panel tabImage = new Panel(null);
        tabImage.setVisible(false);
        tabImage.setBounds(12, 12, 574, 258);
        this.cards.add(tabImage);
        this.checkScale = new DCheckbox("Scaled to panel", Preferences.Scale);
        this.checkScale.setBounds(32, 48, 140, 22);
        this.checkScale.addItemListener(this);
        tabImage.add(this.checkScale);
        this.checkDirect = new DCheckbox("Directly full screen", Preferences.Direct);
        this.checkDirect.setBounds(32, 80, 160, 22);
        this.checkDirect.addItemListener(this);
        tabImage.add(this.checkDirect);
        this.checkFScale = new DCheckbox("Scaled to screen", Preferences.FScale);
        this.checkFScale.setBounds(32, 112, 160, 22);
        this.checkFScale.addItemListener(this);
        tabImage.add(this.checkFScale);
        this.panelSetupAss = new Panel(null);
        this.panelSetupAss.setVisible(false);
        this.panelSetupAss.setBounds(4, 12, 628, 358);
        this.cards.add(this.panelSetupAss);
        this.labelAss = new DLabel("Type an extension");
        this.labelAss.setBounds(10, 20, 320, 20);
        this.panelSetupAss.add(this.labelAss);
        this.comboExt = new DComboBox();
        this.comboExt.setBounds(16, 48, 128, textSize);
        this.comboExt.setFont(AEFont);
        this.comboExt.setBackground(PrgBackground);
        this.comboExt.setArrowStyle(true, false, 1);
        this.comboExt.setMaxItems(256);
        this.comboExt.addActionListener(this);
        this.panelSetupAss.add(this.comboExt);
        this.checkEnable = new DCheckbox("Enabled", false);
        this.checkEnable.setBounds(224, 50, 80, 24);
        this.checkEnable.addItemListener(this);
        this.panelSetupAss.add(this.checkEnable);
        DLabel labelProg = new DLabel("Program using this extension");
        labelProg.setBounds(10, 96, 320, 20);
        this.panelSetupAss.add(labelProg);
        this.comboAss = new DComboBox();
        this.comboAss.setBounds(16, 124, 480, textSize);
        this.comboAss.setFont(AEFont);
        this.comboAss.setBackground(PrgBackground);
        this.comboAss.setArrowStyle(true, false, 1);
        this.comboAss.setMaxItems(256);
        this.comboAss.addActionListener(this);
        this.panelSetupAss.add(this.comboAss);
        this.buttonAssCls = new TButton("X");
        this.buttonAssCls.setBounds(498, 124, 24, 26);
        this.buttonAssCls.setBackground(PrgBackground);
        this.buttonAssCls.setStyle(true, true, 1);
        this.buttonAssCls.setTip("Clear the field");
        this.buttonAssCls.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssCls);
        this.buttonAssSearch = new TButton(Icons.Locate, "Find");
        this.buttonAssSearch.setBounds(526, 124, 96, 28);
        this.buttonAssSearch.setStyle(true, true, 1);
        this.buttonAssSearch.setTip("Find the program");
        this.buttonAssSearch.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssSearch);
        this.buttonAssBrowse = new TButton(Icons.Locate, "Browse");
        this.buttonAssBrowse.setBounds(526, 156, 96, 28);
        this.buttonAssBrowse.setStyle(true, true, 1);
        this.buttonAssBrowse.setTip("Browse directories");
        this.buttonAssBrowse.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssBrowse);
        this.buttonAssAdd = new TButton("Add");
        this.buttonAssAdd.setBounds(16, 200, 90, 26);
        this.buttonAssAdd.setBackground(Color.green.darker());
        this.buttonAssAdd.setStyle(true, true, 1);
        this.buttonAssAdd.setTip("Add the new association to the list");
        this.buttonAssAdd.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssAdd);
        this.buttonAssDef = new TButton("Defaults");
        this.buttonAssDef.setBounds(122, 200, 90, 26);
        this.buttonAssDef.setBackground(PrgBackground);
        this.buttonAssDef.setStyle(true, true, 1);
        this.buttonAssDef.setTip("Clear and set the default list");
        this.buttonAssDef.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssDef);
        this.buttonAssClear = new TButton("Delete");
        this.buttonAssClear.setBounds(228, 200, 90, 26);
        this.buttonAssClear.setBackground(PrgBackground);
        this.buttonAssClear.setStyle(true, true, 1);
        this.buttonAssClear.setTip("Delete the displayed association");
        this.buttonAssClear.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssClear);
        this.buttonAssAll = new TButton("Clear all");
        this.buttonAssAll.setBounds(334, 200, 90, 26);
        this.buttonAssAll.setBackground(PrgBackground);
        this.buttonAssAll.setStyle(true, true, 1);
        this.buttonAssAll.setTip("Reset the whole list");
        this.buttonAssAll.addActionListener(this);
        this.panelSetupAss.add(this.buttonAssAll);
        this.checkFirst = new DCheckbox("Priority over built-in associations", Preferences.AssFirst);
        this.checkFirst.setBounds(16, 248, 280, 24);
        this.checkFirst.addItemListener(this);
        this.panelSetupAss.add(this.checkFirst);
        this.pageSetup = new PageSetup(this.frame);
        this.pageSetup.setVisible(false);
        this.pageSetup.setBounds(12, 12, 574, 328);
        this.cards.add(this.pageSetup);
        this.choiceTab.select(Preferences.tabStyle);
        this.choiceLang.select(Preferences.Language);
        this.tabStylePanel.addItem(Preferences.TextStyle, "Editor");
        this.tabStylePanel.addItem(Preferences.DirStyle, "Directories");
        this.tabStylePanel.addItem(Preferences.TreeStyle, "Tree");
        this.tabStylePanel.addItem(Preferences.MessageStyle, "Message Bar");
        this.tabStylePanel.setCurrentStyle(Preferences.CurrentStyle);
        for (int i = 0; i < 256; ++i) {
            AESetup.enableAss[i] = true;
        }
        this.inputEd.setText(Preferences.edName);
        this.cards.first();
    }

    public void setMemory(Memory m) {
        this.mem = m;
    }

    public void setTab(int no) {
        this.cards.select(no);
        this.panelList.select(no);
        this.listNo = no;
    }

    protected void sourceActionEvent(int action) {
        if (this.actionListener == null) {
            return;
        }
        String actionCommand = new Integer(action).toString();
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, actionCommand));
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    void Message(String s) {
        this.message = s;
        this.sourceActionEvent(0);
    }

    void dispTip(String s) {
        this.message = s;
        this.sourceActionEvent(1);
    }

    void beep() {
        this.sourceActionEvent(3);
    }

    void Exit_Action() {
        this.sourceActionEvent(4);
    }

    void updateConditional() {
        this.sourceActionEvent(2);
    }

    void setTabs() {
        this.sourceActionEvent(5);
    }

    void ExtensionAction() {
        int num = this.comboExt.getSelectedIndex();
        this.comboAss.select(num);
        this.checkEnable.setState(enableAss[num]);
    }

    void AssocAction() {
        int num = this.comboAss.getSelectedIndex();
        this.comboExt.select(num);
        this.checkEnable.setState(enableAss[num]);
    }

    boolean assocFilled() {
        String ext = this.comboExt.editBox.getText();
        String ass = this.comboAss.editBox.getText();
        boolean valid = true;
        if (ext == null) {
            valid = false;
        } else if (ext.length() == 0) {
            valid = false;
        }
        if (ass == null) {
            valid = false;
        } else if (ass.length() == 0) {
            valid = false;
        }
        return valid;
    }

    void AssocAdd() {
        if (!this.assocFilled()) {
            this.dispTip("Fill the two fields first, please!");
            this.beep();
            return;
        }
        String ext = this.comboExt.editBox.getText();
        if (this.comboExt.addUnicItem(ext)) {
            this.comboAss.addItem(this.comboAss.editBox.getText());
            AESetup.enableAss[this.comboExt.countItems() - 1] = true;
            this.checkEnable.setState(true);
            this.Message("Extension " + ext + " added to the list");
        } else {
            this.dispTip("Sorry, already in the list");
        }
    }

    void assAdd(String ext, String prog) {
        this.comboExt.addItem(ext);
        this.comboAss.addItem(prog);
        AESetup.enableAss[this.comboExt.countItems() - 1] = true;
        this.checkEnable.setState(true);
    }

    void assDel(String ext, String path) {
        int num = this.comboExt.search(ext);
        this.comboExt.delItem(num);
        this.comboAss.delItem(num);
        int max = this.comboExt.countItems();
        for (int i = num; i < max - 1; ++i) {
            AESetup.enableAss[i] = enableAss[i + 1];
        }
    }

    void assocAll() {
        this.comboExt.clear();
        this.comboAss.clear();
        this.Message("All extensions removed");
    }

    void assocDef() {
        this.assocAll();
        this.assAdd("htm", Preferences.htmName);
        this.assAdd("html", Preferences.htmName);
        this.assAdd("asp", Preferences.htmName);
        this.assAdd("php", Preferences.htmName);
        this.assAdd("rtf", Preferences.edName);
        this.assAdd("pcx", Preferences.paintPath);
        this.assAdd("png", Preferences.htmName);
        this.assAdd("wav", Preferences.playPath);
        this.assAdd("au", Preferences.playPath);
        this.assAdd("avi", Preferences.playPath);
        this.assAdd("mpg", Preferences.playPath);
        this.assAdd("mpeg", Preferences.playPath);
        this.assAdd("mid", Preferences.playPath);
        this.assAdd("pdf", Preferences.pdfPath);
        if (WINDOWS) {
            this.assAdd("bmp", Preferences.paintPath);
            this.assAdd("doc", Preferences.edName);
            this.assAdd("wri", Preferences.edName);
            this.assAdd("hlp", Preferences.helpPath);
            this.assAdd("chm", "hh.exe");
            this.assAdd("fon", "fontview.exe");
            this.assAdd("ttf", "fontview.exe");
            this.assAdd("cda", "cdplayer");
        } else {
            this.assAdd("tga", Preferences.paintPath);
        }
        this.Message("List filled with default extensions");
    }

    void assocSearch() {
        String type = "program";
        String name = Path.splitFile(this.comboAss.editBox.getText());
        LocateDialog ld = new LocateDialog(this.frame);
        ld.show();
        if (ld.result > 0) {
            String found = Path.merge(ld.dirfound, ld.filefound);
            this.comboAss.editBox.setText(found);
            this.assAdd(this.comboExt.editBox.getText(), found);
            return;
        }
        this.beep();
    }

    void assocBrowse() {
        FileDialog openDialog = new FileDialog(this.frame, " Locate the program", 0);
        if (WINDOWS) {
            openDialog.setDirectory("c:\\");
        } else {
            openDialog.setDirectory("/");
        }
        openDialog.show();
        String name = openDialog.getFile();
        if (name == null) {
            return;
        }
        String path = Path.merge(openDialog.getDirectory(), name);
        String ext = this.comboExt.editBox.getText();
        this.comboAss.editBox.setText(path);
        this.assAdd(ext, path);
    }

    void AssocDel() {
        if (!this.assocFilled()) {
            this.dispTip("Select an entry, please!");
            this.beep();
            return;
        }
        int num = this.comboExt.getSelectedIndex();
        if (num >= 0) {
            String ext = this.comboExt.getSelectedItem();
            this.comboExt.deselect(num);
            this.comboExt.delItem(num);
            this.comboAss.deselect(num);
            this.comboAss.delItem(num);
            this.checkEnable.setState(false);
            this.Message("Extension " + ext + " removed from the list");
        } else {
            this.dispTip("Select an item to delete");
        }
    }

    void setupDefault() {
        if (Preferences.delete()) {
            Preferences.Load();
            Preferences.Save();
            this.Message("Setup restored");
            DialogYN mb = new DialogYN(this.frame, "AE must be restarted to keep the change. Close it?");
            mb.show();
            if (mb.choice) {
                this.Exit_Action();
            }
        } else {
            this.Message("Enable to delete old setup");
        }
    }

    void autoSetup() {
        try {
            SetupWindow sw = new SetupWindow(this.frame);
            sw.show();
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (OS.isWindows() || OS.isMacintosh()) {
            try {
                this.mem.addDrives(Windows.DiskBase);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.assocDef();
    }

    void locateEditor() {
        String root = WINDOWS ? "c:\\" : "/";
        FileDialog openDialog = new FileDialog(this.frame, " Locate editor", 0);
        openDialog.setDirectory(root);
        openDialog.setFile("");
        openDialog.show();
        String name = openDialog.getFile();
        if (name == null) {
            return;
        }
        String path = Path.merge(openDialog.getDirectory(), name);
        this.inputEd.setText(path);
        Preferences.edName = path;
        this.assDel("doc", Preferences.edName);
        this.assAdd("doc", Preferences.edName);
        this.assDel("wri", Preferences.edName);
        this.assAdd("wri", Preferences.edName);
        this.assDel("rtf", Preferences.edName);
        this.assAdd("rtf", Preferences.edName);
    }

    void browserBrowse() {
        String navigator;
        String root;
        if (WINDOWS) {
            root = "c:\\";
            navigator = "iexplore.exe";
        } else {
            root = "/";
            navigator = "mozilla";
        }
        FileDialog openDialog = new FileDialog(this.frame, " Locate browser", 0);
        openDialog.setDirectory(root);
        openDialog.setFile(navigator);
        openDialog.show();
        String name = openDialog.getFile();
        if (name == null) {
            return;
        }
        String path = Path.merge(openDialog.getDirectory(), name);
        if (name.equalsIgnoreCase("iexplore.exe")) {
            name = "Internet Explorer";
        } else if (name.equalsIgnoreCase("netscape.exe")) {
            name = "Netscape";
        }
        this.labelBrowser.setText(name);
        Preferences.htmName = path;
        this.assDel("htm", Preferences.htmName);
        this.assAdd("htm", Preferences.htmName);
        this.assDel("html", Preferences.htmName);
        this.assAdd("html", Preferences.htmName);
        this.assDel("php", Preferences.htmName);
        this.assAdd("php", Preferences.htmName);
    }

    void save() {
        if (Preferences.Save()) {
            this.Message("User settings saved");
            this.updateConditional();
        } else {
            this.Message("Enable to save " + Preferences.Filename);
        }
    }

    public boolean hasHtml() {
        int l = this.comboExt.countItems();
        if (l == 0) {
            return false;
        }
        int l2 = this.comboAss.countItems();
        if (l2 == 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.comboExt.getListText(i).compareTo("html") != 0) continue;
            return true;
        }
        return false;
    }

    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this.checkMemory) {
            Preferences.SaveMemory = this.checkMemory.getState();
        } else if (object == this.checkAutosave) {
            Preferences.AutoSave = this.checkAutosave.getState();
        } else if (object == this.checkSound) {
            Preferences.Sound = this.checkSound.getState();
        } else if (object == this.checkScale) {
            Preferences.Scale = this.checkScale.getState();
        } else if (object == this.checkDirect) {
            Preferences.Direct = this.checkDirect.getState();
        } else if (object == this.checkFScale) {
            Preferences.FScale = this.checkFScale.getState();
        } else if (object == this.checkEd) {
            Preferences.EditorAss = this.checkEd.getState();
        } else if (object == this.checkWrap) {
            Preferences.wordWrap = this.checkEd.getState();
        } else if (object == this.checkZipSort) {
            boolean res;
            Preferences.ArcSort = res = this.checkZipSort.getState();
            this.sourceActionEvent(9);
        } else if (object == this.checkArcRestore) {
            Preferences.ArcRestore = this.checkArcRestore.getState();
        } else if (object == this.checkArcReplace) {
            Preferences.ArcReplace = this.checkArcReplace.getState();
        } else if (object == this.checkDeleteDir) {
            Preferences.AskDeleteDir = this.checkDeleteDir.getState();
        } else if (object == this.checkDeleteFile) {
            Preferences.AskDeleteFile = this.checkDeleteFile.getState();
        } else if (object == this.checkReplace) {
            Preferences.AskReplace = this.checkReplace.getState();
        } else if (object == this.checkHtml) {
            Preferences.AskHtml = this.checkHtml.getState();
        } else if (object == this.checkFloppies) {
            Preferences.FLOPPIES = this.checkFloppies.getState();
            this.sourceActionEvent(8);
        } else if (object == this.checkOpen) {
            Preferences.OpenDir = this.checkOpen.getState();
        } else {
            if (object == this.choiceTab) {
                Preferences.tabStyle = this.choiceTab.getSelectedIndex();
                this.setTabs();
                return;
            }
            if (object == this.choiceLang) {
                Preferences.Language = this.choiceLang.getSelectedIndex();
            } else if (object == this.checkFirst) {
                Preferences.AssFirst = this.checkFirst.getState();
            } else if (object == this.checkEnable) {
                AESetup.enableAss[this.comboExt.getSelectedIndex()] = this.checkEnable.getState();
            } else if (object == this.choiceShort) {
                shortnum = this.choiceShort.getSelectedIndex();
                this.fieldShort.setText(Preferences.shortcut[shortnum]);
                this.fieldPath.setText(Preferences.longpath[shortnum]);
            } else if (object == this.panelList) {
                this.listNo = this.panelList.getSelectedIndex();
                this.cards.select(this.listNo);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonDefault) {
            this.setupDefault();
        } else if (object == this.buttonAutoSetup) {
            this.autoSetup();
        } else if (object == this.buttonSave) {
            this.save();
        } else if (object == this.buttonEdLocate) {
            this.locateEditor();
        } else if (object == this.buttonBBrowse) {
            this.browserBrowse();
        } else if (object == this.comboExt) {
            this.ExtensionAction();
        } else if (object == this.comboAss) {
            this.AssocAction();
        } else {
            if (object == this.buttonAssCls) {
                this.comboAss.editBox.setText("");
                return;
            }
            if (object == this.buttonAssSearch) {
                this.assocSearch();
            } else if (object == this.buttonAssBrowse) {
                this.assocBrowse();
            } else if (object == this.buttonAssAdd) {
                this.AssocAdd();
            } else if (object == this.buttonAssDef) {
                this.assocDef();
            } else if (object == this.buttonAssClear) {
                this.AssocDel();
            } else if (object == this.buttonAssAll) {
                this.assocAll();
            } else if (object == this.spinnerMemory) {
                Preferences.MemorySize = this.spinnerMemory.getValue();
                resizeMemory = true;
            } else if (object == this.spinnerMemBase) {
                Preferences.MemBaseSize = this.spinnerMemBase.getValue();
                resizeMemory = true;
            } else if (object == this.spinnerMenu) {
                Preferences.menuSize = this.spinnerMenu.getValue();
                this.sourceActionEvent(12);
            } else if (object == this.tabStylePanel) {
                this.sourceActionEvent(7);
            } else if (object == this.buttonShortSet) {
                String label;
                Preferences.shortcut[AESetup.shortnum] = label = this.fieldShort.getText();
                Preferences.longpath[AESetup.shortnum] = this.fieldPath.getText();
                this.sourceActionEvent(6);
            }
        }
    }

    void general_componentShown() {
        this.dispTip("Desktop's look and feel, auto saving...");
    }

    void SetupDir_componentShown() {
        this.dispTip("Directory lists and path fields");
    }

    void SetupText_componentShown() {
        this.dispTip("Editor preferences");
    }

    void SetupStyle_componentShown() {
        this.dispTip("Fonts and colors");
        this.tabStylePanel.setVisible(true);
    }

    public void componentShown(ComponentEvent event) {
        Object object = event.getSource();
        if (object == this.tabGeneral) {
            this.general_componentShown();
        } else if (object == this.tabStylePanel) {
            this.SetupStyle_componentShown();
        } else if (object == this.tabFiles) {
            this.SetupDir_componentShown();
        } else if (object == this.tabText) {
            this.SetupText_componentShown();
        }
        this.panelList.select(this.listNo);
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

