/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Plasma;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;

public class AboutPlasma
extends Plasma {
    Image imageOffScreen;
    Image imageAuthor;
    String version = "2008.0";
    String release = "";
    int width = 460;
    int height = 240;
    boolean initOk = false;

    public AboutPlasma() {
        this.setBackground(new Color(128, 228, 255));
    }

    void debug(String s) {
        System.out.println(s);
    }

    public void setRelease(String rel, String ver, String sub) {
        this.release = rel;
        this.version = rel + " V.: " + ver + sub;
    }

    public void init(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.makeScreen();
        if (this.imageOffScreen == null) {
            return;
        }
        g.drawImage(this.imageOffScreen, 0, 0, this);
    }

    public void makeText(Graphics g) {
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        int sx = 54;
        int sy = 78;
        Font sfont = new Font("Dialog", 0, 40);
        FontMetrics fm = this.getFontMetrics(sfont);
        String ae = "Advanced Explorer";
        g.setFont(sfont);
        g.setColor(Color.black);
        g.drawString(ae, 46, 72);
        g.setColor(Color.green.darker());
        g.drawString(ae, 44, 70);
        String scriptol = "www.scriptol.org";
        sfont = new Font("Dialog", 1, 22);
        fm = this.getFontMetrics(sfont);
        g.setFont(sfont);
        g.setColor(Color.black);
        g.drawString(scriptol, 116, 130);
        g.setFont(new Font("Dialog", 1, 14));
        int x = (w - this.version.length() * 8 + 16) / 2;
        g.drawString(this.version, x + 8, h - 64);
        String free = "Open source under GNU GPL 2.0 License";
        x = (w - free.length() * 8) / 2;
        g.drawString(free, x, h - 34);
        g.setColor(Color.black);
        g.drawRect(0, 0, w - 1, h - 1);
    }

    public void loadTitle() {
        try {
            String user = System.getProperty("user.dir");
            String ipath = user + File.separator + "aexplorer.gif";
            this.imageAuthor = Toolkit.getDefaultToolkit().getImage(ipath);
            this.imageAuthor = this.imageAuthor.getScaledInstance(320, 50, 1);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void makeScreen() {
        try {
            this.imageOffScreen = this.createImage(this.width, this.height);
            Graphics g = this.imageOffScreen.getGraphics();
            this.loadTitle();
            Dimension d = this.getSize();
            int w = d.width;
            int iw = this.imageAuthor.getWidth(this);
            g.drawImage(this.imageAuthor, (w - iw) / 2, 50, this);
            this.makeText(g);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

