/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.AESetup;
import ae.AboutDialog;
import ae.Archiver;
import ae.CPanel;
import ae.ColorList;
import ae.DButton;
import ae.DMenu;
import ae.DMessageBar;
import ae.DToolBar;
import ae.DialogCYN;
import ae.DialogCompare;
import ae.DialogMessage;
import ae.DialogUpdate;
import ae.DirManager;
import ae.DirTools;
import ae.Directory;
import ae.Disp;
import ae.EmptyPanel;
import ae.FileCopy;
import ae.FileList;
import ae.History;
import ae.HtmlList;
import ae.Icons;
import ae.ImageViewer;
import ae.Input;
import ae.LocateDialog;
import ae.Memory;
import ae.MenuDynamic;
import ae.Messages;
import ae.OS;
import ae.Outline;
import ae.PanelArchive;
import ae.PanelGenerator;
import ae.PanelList;
import ae.PanelOutline;
import ae.PanelThumbnail;
import ae.Path;
import ae.Preferences;
import ae.Splash;
import ae.Style;
import ae.TabPanel;
import ae.Temporary;
import ae.TextEditor;
import ae.Thumbnail;
import ae.Tip;
import ae.Tool;
import ae.TreeManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;

public class AdvancedExplorer
extends Frame
implements Messages,
WindowListener {
    static final String VERSION = "2008";
    static final String SUBVERSION = ".0";
    static final String RELEASE = "(c) 1999-2008 Denis Sureau";
    static final String SITE = "www.scriptol.org";
    static final boolean LIBINCLUDED = false;
    static final boolean DEBUG = false;
    final int TARGET = 0;
    final int THUMBNAIL = 1;
    final int LIST = 2;
    final int OUTLINE = 3;
    final int ARCHIVER = 4;
    Memory mem = new Memory();
    Font AEFont;
    Font AEBold;
    History history = new History();
    AESetup aesetup;
    Archiver archiver = null;
    Temporary tempo = new Temporary(System.getProperty("user.dir"));
    DirTools dirtools = new DirTools();
    FileCopy filecopy = new FileCopy(this);
    String AEDir = System.getProperty("user.dir");
    String version = System.getProperty("java.version");
    String LocatePrevious = "";
    String m_dirName;
    String m_fileName;
    String m_pathName;
    boolean WINDOWS = true;
    boolean OrigineIsSrc = true;
    boolean statuscreated = false;
    boolean dirmask = false;
    boolean editmask = false;
    boolean imagemask = false;
    boolean setupmask = false;
    boolean displayFlag = true;
    final int CANCEL = 0;
    final int YES = 1;
    final int NO = 2;
    final int tabDirNo = 0;
    final int tabTextNo = 1;
    final int tabSetupNo = 2;
    final int noTarget = 0;
    final int noTree = 1;
    final int noViewer = 2;
    String ZipName;
    String TreeDisk;
    int SrcIndex;
    TabPanel tabbedAE;
    Panel tabDir;
    CPanel panelSrc;
    CPanel panelRight;
    TabPanel tabDst;
    PanelThumbnail panelThumbnail;
    PanelList panelList;
    PanelOutline panelOutline;
    PanelArchive panelArchive;
    CPanel panelTool;
    DToolBar toolDir;
    DToolBar toolText;
    DButton buttonSwap;
    DButton buttonLR;
    DButton buttonLocate;
    DButton buttonDirCompare;
    DButton buttonFileCopy;
    DButton buttonUnarc;
    DButton buttonExplorer;
    DButton buttonDirNew;
    DButton buttonDirOpen;
    DButton buttonTextNew;
    DButton buttonTextOpen;
    DButton buttonTextSave;
    DButton buttonTextFind;
    DButton buttonTextReplace;
    DirManager source;
    DirManager target;
    TreeManager treemanager;
    DButton buttonA;
    DButton buttonC;
    DButton buttonD;
    DButton buttonE;
    DButton buttonF;
    DButton buttonG;
    DButton buttonH;
    DButton buttonI;
    DMessageBar statusbar;
    TextEditor editor;
    Panel tabSetup;
    String EdPrevious;
    ImageViewer imageViewer;
    MenuBar mainMenuBar;
    DMenu menuFile;
    MenuItem miFileLocate;
    MenuItem miFileCopy;
    MenuItem miFileComp;
    MenuItem miFileSelectAll;
    MenuItem miFileSelectAny;
    MenuItem miCopyRen;
    MenuItem miCopyInDir;
    MenuItem miFile;
    MenuItem miExit;
    DMenu menuDir;
    MenuItem miMake;
    MenuItem miDirCompare;
    MenuItem miCmpVersions;
    MenuItem miCmpContent;
    MenuItem miCmpFull;
    MenuItem miUpdate;
    MenuItem miSwap;
    MenuItem miDirExtend;
    DMenu menuZip;
    MenuItem miView;
    MenuItem miExtract;
    MenuItem miZip;
    DMenu menuEdit;
    MenuItem miUndo;
    MenuItem miFind;
    MenuItem miFindAgain;
    MenuItem miReplace;
    MenuItem miSelectAll;
    MenuItem miNew;
    MenuItem miOpenText;
    MenuItem miClose;
    MenuItem miInsert;
    MenuItem miSave;
    MenuItem miSaveAs;
    MenuItem miSaveBlock;
    DMenu menuWeb;
    MenuItem miThumbnail;
    MenuItem miListe;
    MenuItem miOutline;
    MenuDynamic tools;
    MenuItem miProgSearch;
    MenuItem miProgClear;
    MenuItem miFree;
    MenuItem miDOS;
    MenuItem miHistory;
    MenuItem miCalc;
    MenuItem miScan;
    MenuItem miExplorer;
    MenuDynamic references;
    MenuItem miTextClear;
    MenuDynamic recents;
    MenuItem miRecentClear;
    DMenu menuHelp;
    MenuItem miHelp;
    MenuItem miAbout;
    static Color PrgBackground;
    static Color PrgForeground;
    boolean fComponentsAdjusted = false;
    String extGraphic = ".gif.jpg.jpe.png.";
    String extUnsupported = ".ico.tga.pic.tiff.bmp.wmf.";
    String extSound = ".wav.au.";
    final int CMPLIST = 0;
    final int CMPANY = 1;
    final int CMPVERSION = 2;
    final int CMPCONTENT = 3;
    String blank = "                                                              ";

    public AdvancedExplorer() {
        String temp;
        Disp.it("Advanced Explorer - Scriptol.org");
        Disp.it("Java 1.5 version required, for AE V.: 2008.0");
        Disp.it("Loading user preferences");
        this.WINDOWS = OS.isWindows();
        boolean iniLoad = Preferences.Load();
        PrgBackground = SystemColor.control;
        PrgForeground = Preferences.PrgFg;
        ColorList.changeColor("User", Preferences.UserColor);
        this.setBackground(PrgBackground);
        this.setForeground(PrgForeground);
        this.EdPrevious = Path.splitFile(Preferences.edName);
        Tool.setBeep(Preferences.Sound);
        Action action = new Action();
        DButtonAction dbAction = new DButtonAction();
        AEMainKeys AEKey = new AEMainKeys();
        SymComponent comlisten = new SymComponent();
        this.archiver = new Archiver();
        this.archiver.addActionListener(action);
        Disp.it("Building the user interface");
        Icons ic = new Icons();
        this.setIconImage(Icons.Save);
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        this.dirtools.addActionListener(action);
        Dimension screen = this.getToolkit().getScreenSize();
        int w = 1024;
        int h = 600;
        int fSize = 16;
        int dWidth = 56;
        int dHeight = 48;
        this.setLocation(50, 50);
        if (screen.width <= 1024) {
            dWidth = 48;
            dHeight = 40;
        }
        if (screen.width <= 800) {
            fSize = 12;
            dWidth = 42;
            dHeight = 35;
            this.setLocation(0, 0);
        }
        if (screen.width < 700) {
            w = 640;
            h = 439;
            dWidth = 36;
            dHeight = 30;
            fSize = 12;
            this.setLocation(0, 0);
        }
        this.setSize(this.getInsets().left + this.getInsets().right + w, this.getInsets().top + this.getInsets().bottom + h);
        this.AEFont = new Font("Dialog", 0, fSize);
        this.AEBold = new Font("Dialog", 1, fSize);
        Font tabFont = new Font("SansSerif", 0, fSize - 1);
        this.setFont(this.AEFont);
        DButton.setDefaultSize(dWidth, dHeight);
        DButton.setDefaultFont(this.AEFont);
        Tip.setParent(this);
        Font menuFont = new Font("Dialog", 0, 14);
        this.mainMenuBar = new MenuBar();
        this.mainMenuBar.setFont(menuFont);
        this.menuFile = new DMenu("File");
        this.menuFile.setFont(menuFont);
        this.miFileLocate = new MenuItem("Find a file", new MenuShortcut(76));
        this.miFileLocate.addActionListener(action);
        this.miFileLocate.setFont(menuFont);
        this.menuFile.add(this.miFileLocate);
        this.menuFile.addSeparator();
        this.miFileCopy = new MenuItem("Copy", new MenuShortcut(67));
        this.miFileCopy.addActionListener(action);
        this.miFileCopy.setFont(menuFont);
        this.menuFile.add(this.miFileCopy);
        this.miCopyInDir = new MenuItem("Copy inside dir", new MenuShortcut(68));
        this.miCopyInDir.addActionListener(action);
        this.miCopyInDir.setFont(menuFont);
        this.menuFile.add(this.miCopyInDir);
        this.miCopyRen = new MenuItem("Copy and rename");
        this.miCopyRen.addActionListener(action);
        this.miCopyRen.setFont(menuFont);
        this.menuFile.add(this.miCopyRen);
        this.menuFile.addSeparator();
        this.miFileSelectAll = new MenuItem("Select all files");
        this.miFileSelectAll.addActionListener(action);
        this.miFileSelectAll.setFont(menuFont);
        this.menuFile.add(this.miFileSelectAll);
        this.miFileSelectAny = new MenuItem("Select all entries");
        this.miFileSelectAny.addActionListener(action);
        this.miFileSelectAny.setFont(menuFont);
        this.menuFile.add(this.miFileSelectAny);
        this.menuFile.addSeparator();
        this.miExit = new MenuItem(this.menuLabel("Exit", "         Alt+F4"));
        this.miExit.addActionListener(action);
        this.miExit.setFont(menuFont);
        this.menuFile.add(this.miExit);
        this.mainMenuBar.add(this.menuFile);
        this.menuDir = new DMenu("Dir");
        this.menuDir.setFont(menuFont);
        this.miSwap = new MenuItem("Swap dirs", new MenuShortcut(83));
        this.miSwap.addActionListener(action);
        this.miSwap.setFont(menuFont);
        this.menuDir.add(this.miSwap);
        this.miDirExtend = new MenuItem("Use source for target");
        this.miDirExtend.addActionListener(action);
        this.miDirExtend.setFont(menuFont);
        this.menuDir.add(this.miDirExtend);
        this.menuDir.addSeparator();
        this.miDirCompare = new MenuItem("Compare names", new MenuShortcut(69));
        this.miDirCompare.addActionListener(action);
        this.miDirCompare.setFont(menuFont);
        this.menuDir.add(this.miDirCompare);
        this.miCmpVersions = new MenuItem("Compare versions");
        this.miCmpVersions.addActionListener(action);
        this.miCmpVersions.setFont(menuFont);
        this.menuDir.add(this.miCmpVersions);
        this.miCmpContent = new MenuItem("Compare data");
        this.miCmpContent.addActionListener(action);
        this.miCmpContent.setFont(menuFont);
        this.menuDir.add(this.miCmpContent);
        this.miCmpFull = new MenuItem("Compare any");
        this.miCmpFull.addActionListener(action);
        this.miCmpFull.setFont(menuFont);
        this.menuDir.add(this.miCmpFull);
        this.menuDir.addSeparator();
        this.miFileComp = new MenuItem("Tagged compare", new MenuShortcut(80));
        this.miFileComp.addActionListener(action);
        this.miFileComp.setFont(menuFont);
        this.menuDir.add(this.miFileComp);
        this.miUpdate = new MenuItem("Tagged update");
        this.miUpdate.addActionListener(action);
        this.miUpdate.setFont(menuFont);
        this.menuDir.add(this.miUpdate);
        this.menuDir.addSeparator();
        this.miMake = new MenuItem("Make dir", new MenuShortcut(75));
        this.miMake.addActionListener(action);
        this.miMake.setFont(menuFont);
        this.menuDir.add(this.miMake);
        this.mainMenuBar.add(this.menuDir);
        this.menuZip = new DMenu("Archive");
        this.menuZip.setFont(menuFont);
        this.menuZip.setFont(menuFont);
        this.miView = new MenuItem("View");
        this.miView.addActionListener(action);
        this.miView.setFont(menuFont);
        this.menuZip.add(this.miView);
        this.miExtract = new MenuItem("Unarchive", new MenuShortcut(85));
        this.miExtract.addActionListener(action);
        this.miExtract.setFont(menuFont);
        this.menuZip.add(this.miExtract);
        this.miZip = new MenuItem("Archive", new MenuShortcut(90));
        this.miZip.addActionListener(action);
        this.miZip.setFont(menuFont);
        this.menuZip.add(this.miZip);
        this.mainMenuBar.add(this.menuZip);
        this.menuEdit = new DMenu("Editor");
        this.menuEdit.setFont(menuFont);
        this.miUndo = new MenuItem(this.menuLabel("Undo", "Ctrl+Z"));
        this.miUndo.addActionListener(action);
        this.miUndo.setEnabled(false);
        this.miUndo.setFont(menuFont);
        this.menuEdit.add(this.miUndo);
        this.menuEdit.addSeparator();
        this.miFind = new MenuItem(this.menuLabel("Find", "Ctrl+F"));
        this.miFind.addActionListener(action);
        this.miFind.setEnabled(false);
        this.miFind.setFont(menuFont);
        this.menuEdit.add(this.miFind);
        this.miFindAgain = new MenuItem(this.menuLabel("Find again", "F3"));
        this.miFindAgain.addActionListener(action);
        this.miFindAgain.setEnabled(false);
        this.miFindAgain.setFont(menuFont);
        this.menuEdit.add(this.miFindAgain);
        this.miReplace = new MenuItem(this.menuLabel("Replace", "Ctrl+R"));
        this.miReplace.addActionListener(action);
        this.miReplace.setEnabled(false);
        this.miReplace.setFont(menuFont);
        this.menuEdit.add(this.miReplace);
        this.menuEdit.addSeparator();
        this.miSelectAll = new MenuItem("Select all");
        this.miSelectAll.addActionListener(action);
        this.miSelectAll.setEnabled(false);
        this.miSelectAll.setFont(menuFont);
        this.menuEdit.add(this.miSelectAll);
        this.menuEdit.addSeparator();
        this.miNew = new MenuItem("Create a blank text");
        this.miNew.addActionListener(action);
        this.miNew.setFont(menuFont);
        this.menuEdit.add(this.miNew);
        this.miOpenText = new MenuItem("Edit a text");
        this.miOpenText.addActionListener(action);
        this.miOpenText.setFont(menuFont);
        this.menuEdit.add(this.miOpenText);
        this.miClose = new MenuItem("Close the text");
        this.miClose.addActionListener(action);
        this.miClose.setFont(menuFont);
        this.menuEdit.add(this.miClose);
        this.menuEdit.addSeparator();
        this.miInsert = new MenuItem(this.menuLabel("Insert a file", "Alt+I"));
        this.miInsert.addActionListener(action);
        this.miInsert.setEnabled(false);
        this.miInsert.setFont(menuFont);
        this.menuEdit.add(this.miInsert);
        this.menuEdit.addSeparator();
        this.miSave = new MenuItem(this.menuLabel("Save", "Ctrl+S"));
        this.miSave.addActionListener(action);
        this.miSave.setEnabled(false);
        this.miSave.setFont(menuFont);
        this.menuEdit.add(this.miSave);
        this.miSaveAs = new MenuItem("Save as");
        this.miSaveAs.addActionListener(action);
        this.miSaveAs.setEnabled(false);
        this.miSaveAs.setFont(menuFont);
        this.menuEdit.add(this.miSaveAs);
        this.miSaveBlock = new MenuItem(this.menuLabel("Save selection", "Alt+W"));
        this.miSaveBlock.addActionListener(action);
        this.miSaveBlock.setEnabled(false);
        this.miSaveBlock.setFont(menuFont);
        this.menuEdit.add(this.miSaveBlock);
        this.mainMenuBar.add(this.menuEdit);
        this.menuWeb = new DMenu("Web pages");
        this.menuWeb.setFont(menuFont);
        this.miThumbnail = new MenuItem("Thumbnail");
        this.miThumbnail.addActionListener(action);
        this.miThumbnail.setFont(menuFont);
        this.menuWeb.add(this.miThumbnail);
        this.miListe = new MenuItem("File list");
        this.miListe.addActionListener(action);
        this.miListe.setFont(menuFont);
        this.menuWeb.add(this.miListe);
        this.miOutline = new MenuItem("Outlined text");
        this.miOutline.addActionListener(action);
        this.miOutline.setFont(menuFont);
        this.menuWeb.add(this.miOutline);
        this.mainMenuBar.add(this.menuWeb);
        this.tools = new MenuDynamic("Tools", menuFont, Preferences.menuSize);
        this.tools.addActionListener(action);
        this.mainMenuBar.add(this.tools);
        this.miProgSearch = new MenuItem("Search and add");
        this.miProgSearch.addActionListener(action);
        this.tools.add(this.miProgSearch);
        this.miProgClear = new MenuItem("Clear all");
        this.miProgClear.addActionListener(action);
        this.tools.add(this.miProgClear);
        this.tools.addSeparator();
        if (this.WINDOWS) {
            temp = "DOS window";
            Directory.root = "\\";
        } else {
            Directory.root = "/";
            temp = "Console";
        }
        this.miDOS = new MenuItem(temp);
        this.miDOS.addActionListener(action);
        this.miDOS.setFont(menuFont);
        this.tools.add(this.miDOS);
        this.miHistory = new MenuItem("Last messages", new MenuShortcut(72));
        this.miHistory.addActionListener(action);
        this.miHistory.setFont(menuFont);
        this.tools.add(this.miHistory);
        this.miFree = new MenuItem("Free memory");
        this.miFree.setFont(menuFont);
        this.miCalc = new MenuItem("Calculator");
        this.miCalc.setFont(menuFont);
        this.miCalc.addActionListener(action);
        if (this.WINDOWS) {
            this.tools.add(this.miCalc);
        }
        this.miScan = new MenuItem("Disk Scan");
        this.miScan.addActionListener(action);
        this.miScan.setFont(menuFont);
        if (this.WINDOWS) {
            this.tools.add(this.miScan);
        }
        this.miExplorer = new MenuItem("Explorer");
        this.miExplorer.addActionListener(action);
        this.miExplorer.setFont(menuFont);
        if (this.WINDOWS) {
            this.tools.add(this.miExplorer);
        }
        this.tools.addSeparator();
        this.references = new MenuDynamic("References", menuFont, Preferences.menuSize);
        this.references.addActionListener(action);
        this.mainMenuBar.add(this.references);
        this.miTextClear = new MenuItem("Clear all");
        this.miTextClear.addActionListener(action);
        this.references.add(this.miTextClear);
        this.references.addSeparator();
        this.recents = new MenuDynamic("Recents", menuFont, Preferences.menuSize);
        this.recents.addActionListener(action);
        this.mainMenuBar.add(this.recents);
        this.miRecentClear = new MenuItem("Clear all");
        this.miRecentClear.addActionListener(action);
        this.recents.add(this.miRecentClear);
        this.recents.addSeparator();
        this.menuHelp = new DMenu("   Help");
        this.menuHelp.setFont(menuFont);
        this.mainMenuBar.setHelpMenu(this.menuHelp);
        this.miHelp = new MenuItem("Manual       F1");
        this.miHelp.addActionListener(action);
        this.miHelp.setFont(menuFont);
        this.menuHelp.add(this.miHelp);
        this.miAbout = new MenuItem("About...");
        this.miAbout.addActionListener(action);
        this.miAbout.setFont(menuFont);
        this.menuHelp.add(this.miAbout);
        this.mainMenuBar.add(this.menuHelp);
        this.setMenuBar(this.mainMenuBar);
        this.panelTool = new CPanel();
        this.panelTool.setBounds(this.getInsets().left + 0, this.getInsets().top + 0, 640, 38);
        this.add((Component)this.panelTool, "North");
        this.toolDir = new DToolBar();
        this.toolDir.setBackground(PrgBackground);
        this.panelTool.add((Component)this.toolDir, "");
        this.toolText = new DToolBar();
        this.toolText.setBackground(PrgBackground);
        this.panelTool.add((Component)this.toolText, "");
        this.panelTool.validate();
        this.statusbar = new DMessageBar();
        this.statusbar.setBounds(this.getInsets().left + 0, this.getInsets().top + 446, 636, 16);
        this.add((Component)this.statusbar, "South");
        this.statuscreated = true;
        this.tabbedAE = new TabPanel(0, Preferences.tabStyle);
        this.tabbedAE.setBackground(PrgBackground);
        this.add((Component)this.tabbedAE, "Center");
        this.tabDir = new Panel(new GridLayout(1, 2));
        this.tabDir.addKeyListener(AEKey);
        this.tabDir.addComponentListener(comlisten);
        this.tabbedAE.addTabPanel("+File Manager", true, this.tabDir);
        this.editor = new TextEditor(this);
        this.editor.setVisible(false);
        this.editor.addActionListener(action);
        this.editor.addKeyListener(AEKey);
        this.editor.addComponentListener(comlisten);
        this.tabbedAE.addTabPanel("+Editor", true, this.editor);
        this.tabSetup = new Panel(new GridLayout());
        this.tabSetup.setVisible(false);
        this.tabSetup.addComponentListener(comlisten);
        this.tabbedAE.addTabPanel("+Options", true, this.tabSetup);
        EmptyPanel panelLeft = new EmptyPanel(new BorderLayout());
        this.tabDir.add(panelLeft);
        DToolBar favopanel = new DToolBar(0);
        panelLeft.add((Component)favopanel, "North");
        this.panelSrc = new CPanel();
        this.panelSrc.setBackground(PrgBackground);
        panelLeft.add((Component)this.panelSrc, "Center");
        this.panelRight = new CPanel();
        this.tabDir.add(this.panelRight);
        this.tabDst = new TabPanel(0, Preferences.tabStyle);
        this.tabDst.setBevel(0);
        this.tabDst.setBackground(PrgBackground);
        this.tabDst.setMargins(1, 2, 2, 0);
        this.tabDst.addComponentListener(comlisten);
        this.panelRight.add(this.tabDst);
        this.panelThumbnail = new PanelThumbnail(this);
        this.panelThumbnail.addActionListener(action);
        this.panelRight.add(this.panelThumbnail);
        this.panelList = new PanelList(this);
        this.panelList.addActionListener(action);
        this.panelRight.add(this.panelList);
        this.panelOutline = new PanelOutline(this);
        this.panelOutline.addActionListener(action);
        this.panelRight.add(this.panelOutline);
        this.panelArchive = new PanelArchive(this);
        this.panelArchive.addActionListener(action);
        this.panelRight.add(this.panelArchive);
        this.panelRight.select(0);
        this.source = new DirManager(this, this.statusbar);
        this.source.addActionListener(action);
        this.source.addKeyListener(AEKey);
        this.source.addComponentListener(comlisten);
        this.source.setHistory(this.history);
        this.source.setArchiver(this.archiver);
        this.source.setUsage(0);
        this.source.setTemporary(this.tempo);
        this.panelSrc.add(this.source);
        this.target = new DirManager(this, this.statusbar);
        this.target.addActionListener(action);
        this.target.addKeyListener(AEKey);
        this.target.addComponentListener(comlisten);
        this.target.setHistory(this.history);
        this.target.setUsage(1);
        this.target.setTemporary(this.tempo);
        this.tabDst.addTabPanel("Target", true, this.target);
        this.treemanager = new TreeManager(this, this.statusbar);
        this.treemanager.addActionListener(action);
        this.treemanager.addComponentListener(comlisten);
        this.tabDst.addTabPanel("Tree", true, this.treemanager);
        this.imageViewer = new ImageViewer();
        this.imageViewer.addActionListener(action);
        this.imageViewer.addComponentListener(comlisten);
        this.tabDst.addTabPanel("Image", true, this.imageViewer);
        this.aesetup = new AESetup(this, PrgBackground, this.AEFont, this.AEBold);
        this.aesetup.addActionListener(action);
        this.tabSetup.add(this.aesetup);
        this.aesetup.setMemory(this.mem);
        this.setTitle(" Advanced Explorer  2008 - www.scriptol.org");
        this.buttonSwap = new DButton(Icons.Swap, Icons.SwapGray);
        this.buttonSwap.setTip("Swap source and target");
        this.buttonSwap.addActionListener(dbAction);
        this.toolDir.add(this.buttonSwap);
        this.buttonLR = new DButton(Icons.LR, Icons.LRGray);
        this.buttonLR.setTip("Make source directory the target");
        this.buttonLR.addActionListener(dbAction);
        this.toolDir.add(this.buttonLR);
        this.buttonFileCopy = new DButton(Icons.FileCopy, Icons.CopyGray);
        this.buttonFileCopy.setTip("Copy the selection into target");
        this.buttonFileCopy.addActionListener(dbAction);
        this.toolDir.add(this.buttonFileCopy);
        this.buttonUnarc = new DButton(Icons.Unzip, Icons.UnzipGray);
        this.buttonUnarc.setTip("Extract tagged archive or selection inside");
        this.buttonUnarc.addActionListener(dbAction);
        this.toolDir.add(this.buttonUnarc);
        this.buttonLocate = new DButton(Icons.Locate);
        this.buttonLocate.setTip("Find a file or a directory");
        this.buttonLocate.addActionListener(dbAction);
        this.toolDir.add(this.buttonLocate);
        this.buttonDirCompare = new DButton(Icons.Dcomp, Icons.DCompGray);
        this.buttonDirCompare.setTip("Compare source and target lists");
        this.buttonDirCompare.addActionListener(dbAction);
        this.toolDir.add(this.buttonDirCompare);
        this.buttonExplorer = new DButton(Icons.Microsoft);
        this.buttonExplorer.setTip("Windows' Explorer");
        this.buttonExplorer.addActionListener(dbAction);
        if (this.WINDOWS) {
            this.toolDir.add(this.buttonExplorer);
        }
        this.toolDir.addSeparator(30, 36);
        this.buttonDirNew = new DButton(Icons.New);
        this.buttonDirNew.setTip("Create a blank text");
        this.buttonDirNew.addActionListener(dbAction);
        this.toolDir.add(this.buttonDirNew);
        this.buttonDirOpen = new DButton(Icons.Open);
        this.buttonDirOpen.setTip("Open a document");
        this.buttonDirOpen.addActionListener(dbAction);
        this.toolDir.add(this.buttonDirOpen);
        this.buttonTextNew = new DButton(Icons.New);
        this.buttonTextNew.setTip("Create a blank text");
        this.buttonTextNew.addActionListener(dbAction);
        this.toolText.add(this.buttonTextNew);
        this.buttonTextOpen = new DButton(Icons.Open);
        this.buttonTextOpen.setTip("Open a document");
        this.buttonTextOpen.addActionListener(dbAction);
        this.toolText.add(this.buttonTextOpen);
        this.buttonTextSave = new DButton(Icons.Save);
        this.buttonTextSave.setTip("Save the current document");
        this.buttonTextSave.addActionListener(dbAction);
        this.toolText.add(this.buttonTextSave);
        this.toolText.addSpacer(30, 36);
        this.buttonTextFind = new DButton(Icons.Search);
        this.buttonTextFind.addActionListener(dbAction);
        this.buttonTextFind.setTip("Find a string");
        this.toolText.add(this.buttonTextFind);
        this.buttonTextReplace = new DButton(Icons.Replace);
        this.buttonTextReplace.addActionListener(dbAction);
        this.buttonTextReplace.setTip("Replace a string");
        this.toolText.add(this.buttonTextReplace);
        this.buttonA = new DButton(true);
        this.buttonA.setLabel(Preferences.shortcut[0], true);
        this.buttonA.setTip("Shortcut for path");
        this.buttonA.addActionListener(dbAction);
        favopanel.add(this.buttonA);
        this.buttonC = new DButton(true);
        this.buttonC.setLabel(Preferences.shortcut[1], true);
        this.buttonC.setTip("Shortcut for path");
        this.buttonC.addActionListener(dbAction);
        favopanel.add(this.buttonC);
        this.buttonD = new DButton(true);
        this.buttonD.setLabel(Preferences.shortcut[2], true);
        this.buttonD.setTip("Shortcut for path");
        this.buttonD.addActionListener(dbAction);
        favopanel.add(this.buttonD);
        this.buttonE = new DButton(true);
        this.buttonE.setLabel(Preferences.shortcut[3], true);
        this.buttonE.setTip("Shortcut for path");
        this.buttonE.addActionListener(dbAction);
        favopanel.add(this.buttonE);
        this.buttonF = new DButton(true);
        this.buttonF.setLabel(Preferences.shortcut[4], true);
        this.buttonF.setTip("Shortcut for path");
        this.buttonF.addActionListener(dbAction);
        favopanel.add(this.buttonF);
        this.buttonG = new DButton(true);
        this.buttonG.setLabel(Preferences.shortcut[5], true);
        this.buttonG.setTip("Shortcut for path");
        this.buttonG.addActionListener(dbAction);
        favopanel.add(this.buttonG);
        this.buttonH = new DButton(true);
        this.buttonH.setLabel(Preferences.shortcut[6], true);
        this.buttonH.setTip("Shortcut for path");
        this.buttonH.addActionListener(dbAction);
        favopanel.add(this.buttonH);
        this.buttonI = new DButton(true);
        this.buttonI.setLabel(Preferences.shortcut[7], true);
        this.buttonI.setTip("Shortcut for path");
        this.buttonI.addActionListener(dbAction);
        favopanel.add(this.buttonI);
        this.setTextStyle();
        this.setDirStyle();
        this.setTreeStyle();
        this.setMessageStyle();
        this.addWindowListener(this);
        this.filecopy.addActionListener(action);
        Disp.it("Loading lists to fill memories");
        this.mem.srcPath = this.AEDir;
        this.mem.dstPath = this.AEDir;
        this.mem.setComponents(this.source.combo, this.target.combo, this.tools.dynList, this.references.dynList, this.recents.dynList, this.aesetup.cards, this.aesetup.comboExt, this.aesetup.comboAss);
        if (!iniLoad) {
            this.tabbedAE.select(1);
            this.editor.setPath(this.AEDir, "install.txt");
            this.editor.open();
        } else {
            this.tabbedAE.select(0);
        }
        this.mem.load(this.AEDir);
        this.source.setArcSort(Preferences.ArcSort);
        this.target.setArcSort(Preferences.ArcSort);
        String s = this.mem.srcPath;
        if (s.startsWith("a:")) {
            s = "c:\\";
        }
        this.setSrcPath(s);
        s = this.mem.dstPath;
        if (s.startsWith("a:")) {
            s = "c:\\";
        }
        this.setDstPath(s);
        this.tools.restore();
        this.references.restore();
        this.recents.restore();
        this.editor.setMessage(this.statusbar);
        this.editor.setHistory(this.history);
        System.out.println("Reading directories");
        this.maskAll();
        this.dirmask = true;
        this.unmaskSome();
        this.source.setSelected(0);
        this.source.requestFocus();
        this.panelSrc.first();
        this.tabDst.select(Preferences.panelTarget);
        this.aesetup.setTab(new Integer(this.mem.SetupPanel));
        this.panelTool.showPanel(this.toolDir);
        this.source.setPopupParent(this.tabDir, this.AEFont);
        this.target.setPopupParent(this.tabDst, this.AEFont);
        this.source.combo.setPopupParent(this.AEFont);
        this.target.combo.setPopupParent(this.AEFont);
        this.target.miCopy.setEnabled(false);
        this.target.miUnarc.setEnabled(false);
    }

    public AdvancedExplorer(String title) {
        this();
        this.setTitle(title);
    }

    public synchronized void show() {
        super.show();
        this.SrcFocus();
    }

    public static void main(String[] args) {
        AdvancedExplorer aemain = new AdvancedExplorer();
        aemain.setVisible(true);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    void addNotify(boolean state) {
        this.fComponentsAdjusted = state;
        this.addNotify();
    }

    void Exit_Action() {
        if (this.editor.saveBefore() == 0) {
            return;
        }
        if (this.source.dir.zipMode) {
            this.source.parent();
        }
        if (this.tempo != null) {
            this.tempo.kill();
            this.tempo = null;
        }
        System.gc();
        if (Preferences.SaveMemory) {
            this.mem.srcPath = this.source.getPath();
            this.mem.dstPath = this.target.getPath();
            this.mem.save(this.AEDir);
        }
        if (Preferences.AutoSave) {
            Preferences.Save();
        }
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    void About() {
        AboutDialog ad = new AboutDialog(this);
        ad.setRelease(RELEASE, VERSION, SUBVERSION);
        ad.setVisible(true);
    }

    void Explorer() {
        String dir;
        if (this.tabDst.getTab() == 1) {
            dir = this.treemanager.getSelected();
        } else {
            DirManager dirman = this.srcSelected() ? this.source : this.target;
            dir = dirman.getSelected();
            if (dir == null || dirman.getSelectedIndex() >= dirman.firstFile()) {
                dir = "";
            }
            dir = Path.merge(dirman.getDir(), dir);
        }
        this.dirtools.Run("explorer.exe ", dir, false);
    }

    boolean webPrompt(String name) {
        if (!Preferences.AskHtml) {
            return true;
        }
        String path = Path.merge(this.target.getDir(), name);
        File dst = new File(path);
        if (dst.exists()) {
            DialogCYN ask = new DialogCYN((Frame)this, path + " exists, replace?");
            ask.show();
            return ask.answer == 1;
        }
        return true;
    }

    void indexAction() {
        String dir = this.source.getDir();
        HtmlList t = new HtmlList(dir, this.source.getTaggedItems());
        if (!this.webPrompt(this.panelList.htmlName)) {
            return;
        }
        String dest = this.panelList.htmlDir;
        t.setFile(dest, this.panelList.htmlName);
        int num = t.createHtml();
        this.Message(num + " names found");
        if (num > 0) {
            this.associate(t.htmlFile, t.htmlName, false);
            if (this.srcis(dest)) {
                this.SrcDisp();
            }
            if (this.dstis(dest)) {
                this.DstDisp();
            }
        }
    }

    void outlineAction() {
        String srcname;
        String srcdir = this.source.getDir();
        if (this.srcSelected()) {
            srcname = this.source.getSelected();
        } else if (this.source.isTagged()) {
            srcname = this.source.getTagged();
        } else {
            this.beep();
            this.Message("Select a text to convert, please.");
            return;
        }
        Outline t = new Outline(srcdir, srcname);
        String dstName = this.panelOutline.htmlName;
        String dstDir = this.panelOutline.htmlDir;
        if (!this.webPrompt(dstName)) {
            return;
        }
        t.setFile(dstDir, dstName);
        int size = t.createHtml();
        if (size > 0) {
            this.associate(t.htmlFile, t.htmlName, false);
            if (this.srcis(dstDir)) {
                this.SrcDisp();
            }
            if (this.dstis(dstDir)) {
                this.DstDisp();
            }
        }
        this.Message("Generated " + t.htmlFile + " " + size + " lines");
    }

    void thumbnailAction() {
        String dir = this.source.getDir();
        int start = this.source.dir.MAXINDIRS;
        Dimension screen = this.getToolkit().getScreenSize();
        Thumbnail t = new Thumbnail(screen, this.source.dirList, start, dir);
        if (!this.webPrompt(this.panelThumbnail.htmlName)) {
            return;
        }
        String gendir = this.panelThumbnail.getDir(this.source.getDir());
        Thumbnail.setFile(gendir, this.panelThumbnail.htmlName);
        int num = t.createHtml();
        if (num > 0) {
            this.associate(Thumbnail.htmlFile, Thumbnail.htmlName, false);
            if (this.srcis(gendir)) {
                this.SrcDisp();
            }
            if (this.dstis(gendir)) {
                this.DstDisp();
            }
        }
        this.Message(t.getFile() + " created with " + num + " images");
    }

    void MakeSrc(boolean mode) {
        this.source.setPath(this.treemanager.getSelected());
        this.source.dirDisp(true);
    }

    void setPath(String dir, String fic) {
        this.m_dirName = dir;
        this.m_fileName = fic;
        this.m_pathName = Path.merge(this.m_dirName, this.m_fileName);
    }

    void setPath(String dir) {
        this.m_dirName = dir;
        this.m_fileName = "";
        this.m_pathName = dir;
    }

    void manual() {
        String extension;
        if (this.aesetup.hasHtml()) {
            extension = ".html";
        } else {
            extension = ".txt";
            if (this.editor.savePrevious()) {
                return;
            }
        }
        String name = Preferences.LangFile[Preferences.Language] + extension;
        this.Message("Loading manual: " + this.AEDir + name);
        this.source.openPath(Path.merge(this.AEDir, name), name, false, false);
    }

    void newText() {
        this.editor.setPath(this.source.getDir(), "+Editor");
        if (this.editor.newText()) {
            this.changeTextTab();
            this.displayText();
            this.Message("New empty document created");
        } else {
            this.dispTip("Cancelled");
        }
    }

    void closeText() {
        if (this.editor.close()) {
            this.editor.setPath(null, "+Editor");
            this.changeTextTab();
            this.setPath(null, null);
            this.Message("Document closed");
        }
    }

    void openTextDialog(boolean editflag) {
        if (this.editor.savePrevious()) {
            return;
        }
        FileDialog openDialog = new FileDialog((Frame)this, "Open", 0);
        openDialog.show();
        this.setPath(openDialog.getDirectory(), openDialog.getFile());
        if (!editflag && this.associate(this.m_pathName, this.m_fileName, true)) {
            return;
        }
        this.openText(this.m_pathName, this.m_fileName, true);
    }

    void setModified() {
        String origin = this.editor.getDir();
        if (this.dstis(origin)) {
            this.target.modified = true;
        }
        if (this.srcis(origin)) {
            this.source.modified = true;
        }
    }

    void saveAs() {
        if (this.editor.saveAs()) {
            this.changeTextTab();
            this.displayText();
            this.updateConditional(this.editor.UpdateDir);
        }
    }

    void openText(String path, String name, boolean addit) {
        if (Preferences.EditorAss) {
            this.openWordpad(path, addit);
            return;
        }
        if (this.editor.savePrevious()) {
            return;
        }
        this.m_pathName = path;
        this.m_fileName = name;
        this.m_dirName = Path.getPath(path);
        File f = new File(this.m_pathName);
        if (!f.exists()) {
            this.dispTip("File not found " + this.m_pathName);
            return;
        }
        long len = f.length();
        if (len == 0L) {
            this.dispTip("Size is " + len + " character...");
            return;
        }
        if (!this.openViewer(addit)) {
            this.openWordpad(path, addit);
            return;
        }
    }

    boolean openViewer(boolean addit) {
        this.Message("Reading " + this.m_pathName);
        this.editor.setPath(this.m_dirName, this.m_fileName);
        if (!this.editor.open()) {
            this.setPath(null, null);
            this.editor.setPath("", "+Editor");
            this.changeTextTab();
            return false;
        }
        this.changeTextTab();
        if (addit) {
            this.addRecents(this.m_dirName, this.m_fileName);
        }
        this.tabbedAE.select(1);
        return true;
    }

    void openWordpad(String path, boolean addit) {
        if (this.dirtools.LaunchPrgFile(Preferences.edName, path) && addit) {
            this.addRecents(this.m_dirName, this.m_fileName);
        }
    }

    void processAny(DirManager dirman, String command, boolean addit) {
        String path = dirman.m_pathName;
        String name = dirman.m_fileName;
        String ext = Path.getExtension(name);
        if (command.equals("assoc") && this.associate(path, name, addit)) {
            dirman.associated = true;
            return;
        }
        if (command.equals("graph")) {
            if (DirManager.inside(this.extGraphic, ext)) {
                this.display(path, name, true);
                return;
            }
            if (DirManager.inside(this.extUnsupported, ext)) {
                this.dispTip(ext + " format not supported");
                return;
            }
        }
        if (command.equals("sound") && DirManager.inside(this.extSound, ext)) {
            this.dirtools.sound(path, name);
            return;
        }
        if (command.equals("addprg")) {
            this.addPrograms();
            return;
        }
        if (command.equals("adddoc")) {
            this.addReferences();
            return;
        }
        if (command.equals("text")) {
            this.openText(path, name, addit);
            return;
        }
        this.dispTip("Command not processed");
    }

    void actionDynamic(FileList fl, String com) {
        int numero = new Integer(com);
        String dir = fl.getDir(numero);
        String name = fl.getName(numero);
        this.setPath(dir, name);
        String extension = Path.getExtension(name);
        if (DirManager.inside(DirManager.graflist, extension)) {
            this.tabbedAE.setPanel(0);
            this.display(this.m_pathName, name, false);
            return;
        }
        if (DirManager.inside(DirManager.soundlist, extension)) {
            this.dirtools.sound(this.m_pathName, name);
            return;
        }
        if (this.associate(this.m_pathName, name, false)) {
            return;
        }
        this.openText(this.m_pathName, name, false);
    }

    boolean associate(String path, String name, boolean addit) {
        String ext = Path.getExtension(name);
        int index = this.aesetup.comboExt.search(ext);
        if (index == -1) {
            return false;
        }
        if (!AESetup.enableAss[index]) {
            return false;
        }
        String prog = this.aesetup.comboAss.getListText(index);
        if (this.dirtools.LaunchPrgFile(prog, path) && addit) {
            this.addRecents(path, name);
        }
        return true;
    }

    void swapDirs() {
        String left = this.source.getDir();
        String right = this.target.getDir();
        int dsel = this.target.getSelectedIndex();
        int ssel = this.source.getSelectedIndex();
        this.setSrcPath(right);
        this.setDstPath(left);
        this.SrcDisp();
        this.DstDisp();
        this.dispTip("Source and destination swapped");
        this.source.showIt(dsel);
        this.target.showIt(ssel);
        this.source.requestFocus();
    }

    public void compare(int MODE) {
        int found = 0;
        int diff = 0;
        String[] mode = new String[]{"lists, ", "any, ", "versions, ", "data, "};
        String[] src = this.source.getListItems();
        String[] dst = this.target.getListItems();
        this.dispTip("Comparing source and target lists...");
        this.source.setPainting(false);
        this.source.deselectAll();
        this.setCursor(new Cursor(3));
        int srcSize = this.source.countItems();
        for (int s = 0; s < srcSize; ++s) {
            boolean select = MODE <= 1;
            for (int d = 0; d < this.target.countItems(); ++d) {
                if (!Path.equals(src[s], dst[d])) continue;
                if (MODE != 0) {
                    select = true;
                    String sf = Path.merge(this.source.getDir(), src[s]);
                    String df = Path.merge(this.target.getDir(), dst[d]);
                    if (MODE == 2 ? Path.newVersion(sf, df) : !DirTools.compare(sf, df)) break;
                }
                ++found;
                select = false;
                break;
            }
            if (!select) continue;
            this.source.selectMultiple(s);
            if (MODE <= 1) continue;
            ++diff;
        }
        String cmessage = "";
        int nofound = srcSize - found;
        switch (MODE) {
            case 0: 
            case 1: {
                cmessage = "Comparing " + mode[MODE] + found + "/" + srcSize + " matches and " + nofound + " no found or different";
                if (nofound <= 0) break;
                cmessage = cmessage + " and tagged";
                break;
            }
            case 2: 
            case 3: {
                int all = found + diff;
                cmessage = "Comparing " + mode[MODE] + found + "/" + all + " identical, " + diff + " different";
                if (diff <= 0) break;
                cmessage = cmessage + " and tagged";
            }
        }
        this.Message(cmessage);
        this.source.setPainting(true);
        this.source.update(false);
        this.setCursor(new Cursor(0));
    }

    boolean srcSelected() {
        return this.source.isSelected();
    }

    boolean dstSelected() {
        return this.target.isSelected();
    }

    boolean dstTagged() {
        return this.target.isTagged();
    }

    int whatWindow() {
        boolean src = this.source.isSelected();
        boolean dst = this.target.isSelected();
        if (src && !dst) {
            return 0;
        }
        if (!src && dst) {
            return 1;
        }
        return -1;
    }

    int whichWindow() {
        int i = this.whatWindow();
        if (i == -1) {
            this.dispTip("Select files ever in source or target window");
            this.beep();
        }
        return i;
    }

    void processEdit(DirManager dirman) {
        String dir = dirman.getDir();
        String name = dirman.getSelected();
        this.openText(Path.merge(dir, name), name, true);
    }

    void Make() {
        int win = this.whichWindow();
        if (win == -1) {
            return;
        }
        String[] mode = new String[]{"source", "target"};
        String title = "Creating a sub-directory in " + mode[win];
        if (win == 1) {
            this.target.make(title);
        } else {
            this.source.make(title);
        }
    }

    void actionProgram(int numero) {
        int w = this.whatWindow();
        String prog = this.tools.get(numero);
        String progname = this.tools.getName(numero);
        if (w == -1) {
            this.dirtools.Launch(prog, progname);
            return;
        }
        String name = null;
        String dir = null;
        if (w == 0) {
            dir = this.source.getDir();
            name = this.source.getSelected();
        }
        if (w == 1) {
            dir = this.target.getDir();
            name = this.target.getSelected();
        }
        this.Message("Launching " + prog + " with " + name);
        this.dirtools.LaunchPrgFile(prog, Path.merge(dir, name));
    }

    void shortcut(int number) {
        this.setSrcPath(Preferences.longpath[number]);
        this.SrcDisp();
    }

    void Locate() {
        LocateDialog ld = new LocateDialog((Frame)this, this.LocatePrevious);
        ld.setCurDrive(this.source.getDrive());
        ld.setVisible(true);
        this.LocatePrevious = Path.splitFile(ld.getInput());
        if (ld.result == 1) {
            this.setSrcPath(ld.dirfound);
            this.source.dirDisp(true);
            this.source.setSelected(ld.filefound, true);
            this.source.requestFocus();
            return;
        }
        if (ld.result == 2) {
            this.OrigineIsSrc = true;
            this.setPath(ld.dirfound, ld.filefound);
            this.tabbedAE.select(0);
            this.source.makePath(ld.dirfound, ld.filefound);
            this.source.openCommon(true);
            this.source.requestFocus();
        }
    }

    void messageInDir() {
        this.dispTip("Select a directory in target to copy into");
        this.beep();
    }

    void fileCopy(boolean inside) {
        boolean success = true;
        String destdir = null;
        String lastname = "";
        if (this.editor.isVisible()) {
            return;
        }
        if (!this.source.testSelected(0)) {
            return;
        }
        if (inside) {
            if (this.dstTagged() && this.target.isDir()) {
                destdir = this.target.getTagged();
            } else {
                this.messageInDir();
                return;
            }
        }
        String[] fics = this.source.getSelectedItems();
        int i = 0;
        boolean test = true;
        String origine = Path.noSuffixed(this.source.getDir());
        String destination = Path.noSuffixed(this.target.getDir());
        String child = "";
        if (destdir != null) {
            destination = Path.merge(destination, destdir);
        }
        int copied = 0;
        if (fics.length == 0) {
            this.source.noSelected();
            return;
        }
        if (Path.isDrive(destination)) {
            child = Directory.root;
        }
        File fdest = new File(destination, child);
        this.setCursor(new Cursor(3));
        while (test) {
            String fic = null;
            try {
                fic = fics[i];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                test = false;
            }
            if (!test) continue;
            File forig = new File(origine, fic);
            try {
                lastname = forig.getName();
                copied += this.filecopy.copy(forig, fdest);
                if (FileCopy.cancel) {
                    test = false;
                }
                AdvancedExplorer advancedExplorer = this;
                if (advancedExplorer.filecopy.success()) {
                    if (destdir == null) {
                        this.DstDisp();
                    }
                    this.SrcFocus();
                } else {
                    success = false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.setCursor(new Cursor(0));
        String name = null;
        name = copied > 1 ? copied + " files" : lastname;
        this.Message(name + " copied    into " + destination);
        if (!success) {
            new DialogMessage((Frame)this, "Error, copy failed!").show();
        }
        this.setCursor(new Cursor(0));
    }

    void CopyRename() {
        String fic = this.source.getSelected();
        int[] fnum = this.source.getSelectedIndexes();
        int first = this.source.getSelectedIndex();
        if (fnum.length == 0) {
            this.source.noSelected();
            return;
        }
        if (fnum.length > 1) {
            this.dispTip("Select a single file or dir, please");
            this.beep();
            return;
        }
        String origine = Path.noSuffixed(this.source.getDir());
        String destination = Path.noSuffixed(this.target.getDir());
        Input ren = new Input(this);
        ren.setTitle("New name");
        ren.setLabel("Type the new name:");
        ren.setInput(fic);
        ren.show();
        if (!ren.ok()) {
            this.Message("Cancelled");
            return;
        }
        File forig = new File(origine, fic);
        File fdest = new File(destination);
        String newName = ren.getInput();
        String oldName = forig.getName();
        try {
            this.dispTip(oldName + " copied as " + newName + " into " + destination + ", waiting...");
            int copied = this.filecopy.copyRename(forig, fdest, newName);
            AdvancedExplorer advancedExplorer = this;
            if (advancedExplorer.filecopy.success()) {
                this.DstDisp();
                if (this.synchro()) {
                    this.source.dirDisp(false);
                    this.source.setSelected(first);
                }
                this.Message(oldName + " copied as " + newName + " into " + destination);
                this.SrcFocus();
            } else {
                this.Message("Enable to copy " + oldName + " as " + newName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void compareTagged() {
        String[] fics = this.source.getSelectedItems();
        if (fics.length == 0) {
            this.source.noSelected();
            return;
        }
        String origine = Path.noSuffixed(this.source.getDir());
        String destination = Path.noSuffixed(this.target.getDir());
        DialogCompare cd = new DialogCompare((Frame)this, false);
        cd.source = origine;
        cd.target = destination;
        cd.theList = fics;
        cd.setSource(origine + "[Tagged entries]");
        cd.setTarget(destination);
        cd.statusBar = this.statusbar;
        cd.result = "Comparing tagged entries";
        cd.show();
        DirTools.occupation(origine, fics, 0);
        cd.setResult(DirTools.fileNumber + " files to verify, " + DirTools.fileSize + " " + DirTools.base);
        cd.labelComp.setText("Press START");
        this.Message(cd.result);
    }

    void updateTagged() {
        String[] fics = this.source.getSelectedItems();
        if (fics.length == 0) {
            this.source.noSelected();
            return;
        }
        String origine = Path.noSuffixed(this.source.getDir());
        String destination = Path.noSuffixed(this.target.getDir());
        DialogUpdate cd = new DialogUpdate((Frame)this, false);
        cd.source = origine;
        cd.target = destination;
        cd.theList = fics;
        cd.setSource(origine + "[Tagged entries]");
        cd.setTarget(destination);
        cd.statusBar = this.statusbar;
        cd.result = "Updating tagged directories and files";
        cd.show();
        DirTools.occupation(origine, fics, 0);
        cd.setResult(DirTools.fileNumber + " files to update, " + DirTools.fileSize + " " + DirTools.base);
        cd.labelComp.setText("Press the Update button");
        this.Message(cd.result);
    }

    void console() {
        if (this.WINDOWS) {
            this.dirtools.console(this.source.getDir());
            return;
        }
        this.dirtools.Run("", null, false);
    }

    public boolean synchro() {
        return this.srcis(this.target.getDir());
    }

    public boolean srcis(String path) {
        if (OS.isWindows()) {
            return this.source.getDir().equalsIgnoreCase(path);
        }
        return this.source.getDir().equals(path);
    }

    public boolean dstis(String path) {
        if (OS.isWindows()) {
            return this.target.getDir().equalsIgnoreCase(path);
        }
        return this.target.getDir().equals(path);
    }

    public void SrcDisp() {
        this.source.dirDisp(false);
    }

    public void DstDisp() {
        if (this.target.isVisible()) {
            this.target.dirDisp(false);
        } else {
            this.target.modified = true;
        }
    }

    void SrcRedisp() {
        this.SrcDisp();
        if (this.synchro()) {
            this.DstDisp();
        }
    }

    void DstRedisp() {
        this.DstDisp();
        if (this.synchro()) {
            this.SrcDisp();
        }
    }

    void SrcFocus() {
        this.target.deselectAll();
        this.source.requestFocus();
    }

    void DstFocus() {
        this.target.requestFocus();
    }

    void setSrcPath(String str) {
        if (str == null) {
            str = this.AEDir;
        }
        this.source.setPath(str);
    }

    void setDstPath(String str) {
        if (str == null) {
            str = this.AEDir;
        }
        this.target.setPath(str);
    }

    void updateConditional(String path) {
        if (this.srcis(path = Path.getPath(path))) {
            this.source.modified = true;
        }
        if (this.dstis(path)) {
            this.target.modified = true;
        }
    }

    public void changeTextTab() {
        this.editor.changeName();
        this.tabbedAE.setTab(this.editor.TextName, true, 1);
    }

    public void displayText() {
        this.tabbedAE.select(1);
    }

    boolean getSelection(boolean mflag) {
        String path = null;
        String name = null;
        if (this.srcSelected()) {
            path = this.source.getDir();
            name = this.source.getSelected();
        }
        if (name == null && this.dstSelected()) {
            path = this.target.getDir();
            name = this.target.getSelected();
        }
        if (name == null) {
            if (mflag) {
                this.dispTip("Select a file");
            }
            this.debug("name " + name + " return false");
            return false;
        }
        this.m_dirName = path;
        this.m_fileName = name;
        return true;
    }

    void unArchive() {
        if (this.source.unArchive(this.target.getDir())) {
            this.target.dirDisp(true);
        }
        if (this.synchro()) {
            this.source.refresh(true);
        }
        this.SrcFocus();
    }

    void setTextStyle() {
        Preferences.TextStyle.makeColors();
        Preferences.TextStyle.makeFont();
        this.editor.setStyle(Preferences.TextStyle);
    }

    void setDirStyle() {
        Preferences.DirStyle.makeColors();
        Preferences.DirStyle.makeFont();
        Style s = Preferences.DirStyle;
        this.source.setStyle(s);
        this.target.setStyle(s);
    }

    void setTreeStyle() {
        Preferences.TreeStyle.makeColors();
        Preferences.TreeStyle.makeFont();
        this.treemanager.setStyle(Preferences.TreeStyle);
    }

    void setMessageStyle() {
        Preferences.MessageStyle.makeColors();
        Preferences.MessageStyle.makeFont();
        this.statusbar.setStyle(Preferences.MessageStyle);
    }

    public void display(String path, String name, boolean addit) {
        this.dispTip("Loading " + name + "...");
        if (addit) {
            this.addRecents(path, name);
        }
        System.gc();
        if (Preferences.Direct) {
            Image img = this.getToolkit().getImage(path);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(img, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Splash ad = new Splash(this, img);
            ad.show();
            ad.requestFocus();
        } else {
            this.tabDst.select(2);
            if (Preferences.Scale) {
                this.imageViewer.setImage(path, 2);
            } else {
                this.imageViewer.setImage(path);
                this.imageViewer.setStyle(2);
            }
            this.imageViewer.name = name;
            if (name.length() > 20) {
                int stt = Math.max(0, name.length() - 17);
                name = "..." + name.substring(stt);
            }
            this.tabDst.setLabel(name, 2);
            this.displayFlag = true;
        }
    }

    void actionFull() {
        Image img = this.imageViewer.getImage();
        Splash ad = new Splash(this, img);
        ad.show();
    }

    void imageMessage() {
        if (this.imageViewer.name != null) {
            int OW = this.imageViewer.originW;
            int OH = this.imageViewer.originH;
            int W = this.imageViewer.imageW;
            int H = this.imageViewer.imageH;
            String mess = OW != W || OH != H ? this.imageViewer.name + " originally was " + OW + "x" + OH + ", scaled to " + W + "x" + H : this.imageViewer.name + ", width " + W + ", height " + H;
            if (this.displayFlag) {
                this.Message(mess);
            } else {
                this.dispTip(mess);
            }
            this.displayFlag = false;
            return;
        }
        this.dispTip("Image viewer");
    }

    void progAddDyn(String m_dirName, String m_fileName) {
        if (this.tools.addDynamic(m_dirName, m_fileName)) {
            this.Message("Added " + m_fileName + " to the list of programs");
        } else {
            this.beep();
        }
    }

    void addPrograms() {
        if (!this.dirmask) {
            return;
        }
        if (!this.getSelection(true)) {
            return;
        }
        if (this.m_fileName == null || this.m_fileName == "") {
            this.source.noSelected();
            return;
        }
        this.progAddDyn(this.m_dirName, this.m_fileName);
    }

    void progSearch() {
        if (!this.dirmask) {
            return;
        }
        LocateDialog ld = new LocateDialog(this);
        ld.setCurDrive(this.source.getDrive());
        ld.show();
        if (ld.result > 0) {
            this.progAddDyn(ld.dirfound, ld.filefound);
        }
    }

    void addReferences() {
        if (this.dirmask) {
            if (!this.getSelection(true)) {
                return;
            }
        } else if (this.editmask) {
            this.m_dirName = this.editor.TextDir;
            this.m_fileName = this.editor.TextName;
        }
        if (this.m_fileName == null || this.m_fileName == "") {
            this.source.noSelected();
            return;
        }
        this.recents.remove(this.m_dirName, this.m_fileName);
        if (this.references.addDynamic(this.m_dirName, this.m_fileName)) {
            this.Message("Added " + this.m_fileName + " to the list of documents");
        } else {
            this.beep();
        }
    }

    void addRecents(String dir, String name) {
        if (this.recents.already(dir = Path.getPath(dir), name)) {
            return;
        }
        this.recents.addDynamic(dir, name);
    }

    void addRecents() {
        this.addRecents(this.editor.TextDir, this.editor.TextName);
    }

    void maskAll() {
        this.dirmask = false;
        this.editmask = false;
        this.imagemask = false;
        this.setupmask = false;
    }

    void unmaskSome() {
        this.buttonSwap.setEnabled(this.dirmask);
        this.buttonLR.setEnabled(this.dirmask);
        this.buttonFileCopy.setEnabled(this.dirmask);
        this.buttonUnarc.setEnabled(this.dirmask);
        this.buttonLocate.setEnabled(true);
        this.buttonDirCompare.setEnabled(this.dirmask);
        this.buttonTextSave.setEnabled(this.editmask);
        this.buttonTextFind.setEnabled(this.editmask);
        this.buttonTextReplace.setEnabled(this.editmask && this.editor.Editable);
        this.menuFile.setEnabled(this.dirmask);
        this.menuDir.setEnabled(this.dirmask);
        this.menuZip.setEnabled(this.dirmask);
        this.menuWeb.setEnabled(this.dirmask);
        this.miFileCopy.setEnabled(this.dirmask);
    }

    void tabDir_componentHidden(ComponentEvent event) {
        this.miProgSearch.setEnabled(false);
        this.miFileLocate.setEnabled(false);
        this.miSwap.setEnabled(false);
    }

    void tabDir_componentShown(ComponentEvent event) {
        this.dispTip("Directory");
        this.maskAll();
        this.dirmask = true;
        this.unmaskSome();
        this.miProgSearch.setEnabled(true);
        this.miFileLocate.setEnabled(true);
        if (AESetup.resizeMemory) {
            this.source.comboResize(Preferences.MemorySize);
            this.target.comboResize(Preferences.MemorySize);
            AESetup.resizeMemory = false;
        }
        if (this.source.modified) {
            this.source.refresh(false);
        }
        if (this.target.modified) {
            this.target.refresh(false);
        }
        this.source.requestFocus();
    }

    void source_componentShown(ComponentEvent event) {
        if (this.source.getPath() == null) {
            this.setSrcPath(this.AEDir);
        }
        if (this.source.modified) {
            this.SrcDisp();
        }
        if (this.synchro()) {
            this.DstDisp();
        }
        this.SrcFocus();
    }

    void source_componentHidden(ComponentEvent event) {
    }

    void targetEnable(boolean mode) {
        this.miSwap.setEnabled(mode);
        this.miDirExtend.setEnabled(mode);
        this.buttonSwap.setEnabled(mode);
        this.buttonLR.setEnabled(mode);
        this.miFileCopy.setEnabled(mode);
        this.miFileComp.setEnabled(mode);
        this.miUpdate.setEnabled(mode);
        this.miCopyRen.setEnabled(mode);
        this.miCopyInDir.setEnabled(mode);
        this.miDirCompare.setEnabled(mode);
        this.miCmpVersions.setEnabled(mode);
        this.miCmpContent.setEnabled(mode);
        this.miCmpFull.setEnabled(mode);
        this.miExtract.setEnabled(mode);
        this.miZip.setEnabled(mode);
        this.buttonDirCompare.setEnabled(mode);
        this.buttonUnarc.setEnabled(mode);
        this.buttonFileCopy.setEnabled(mode);
    }

    void target_componentShown(ComponentEvent event) {
        this.targetEnable(true);
        if (this.target.modified) {
            this.target.refresh(true);
        }
    }

    void target_componentHidden(ComponentEvent event) {
        this.targetEnable(false);
    }

    void tabDst_componentShown() {
        if (this.target != null) {
            this.targetEnable(true);
            if (this.target.modified) {
                this.target.refresh(true);
            }
        }
        this.dispTip("");
    }

    void tabDst_componentHidden() {
        if (this.target != null) {
            this.targetEnable(false);
        }
    }

    void editorEnable(boolean mode) {
        this.miUndo.setEnabled(mode);
        this.miFind.setEnabled(mode);
        this.miFindAgain.setEnabled(mode);
        this.miReplace.setEnabled(mode);
        this.miSelectAll.setEnabled(mode);
        this.miSave.setEnabled(mode);
        this.miSaveAs.setEnabled(mode);
        this.miSaveBlock.setEnabled(mode);
    }

    void editor_componentShown(ComponentEvent event) {
        this.maskAll();
        this.editmask = true;
        this.unmaskSome();
        this.editorEnable(true);
        this.editor.setTextInfo();
        this.panelTool.showPanel(this.toolText);
        this.editor.setFocusable(true);
        this.editor.requestFocus();
    }

    void editor_componentHidden(ComponentEvent event) {
        this.editor.setFocusable(false);
        this.editorEnable(false);
        this.panelTool.showPanel(this.toolDir);
    }

    void tabSetup_componentShown() {
        this.maskAll();
        this.setupmask = true;
        this.unmaskSome();
    }

    void debug(String s) {
        Disp.it(s);
    }

    void ErrorMessage(String s) {
        Disp.it(s);
    }

    void beep() {
        if (Preferences.Sound) {
            Tool.beep();
        }
    }

    public boolean Message(String message) {
        if (this.statuscreated) {
            this.statusbar.setText(" " + message);
        }
        this.history.tell(message);
        return false;
    }

    public boolean dispTip(String message) {
        if (this.statuscreated) {
            this.statusbar.setText(" " + message);
        }
        return false;
    }

    String menuLabel(String lab, String sc) {
        int l = lab.length() + sc.length();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int bw = fm.charWidth(' ');
        int w = fm.stringWidth(lab + sc);
        int tt = 184;
        int diff = Math.max(0, (tt - w) / bw);
        return lab + this.blank.substring(0, diff) + sc;
    }

    boolean panelMessage(PanelGenerator panel) {
        switch (panel.action) {
            case 1: {
                this.dispTip(panel.message);
                return true;
            }
            case 0: {
                this.Message(panel.message);
                return true;
            }
        }
        return false;
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.Exit_Action();
        }
    }

    class DButtonAction
    implements ActionListener {
        DButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == AdvancedExplorer.this.buttonSwap) {
                AdvancedExplorer.this.swapDirs();
            } else if (object == AdvancedExplorer.this.buttonLR) {
                AdvancedExplorer.this.setDstPath(AdvancedExplorer.this.source.getDir());
                AdvancedExplorer.this.DstDisp();
            } else if (object == AdvancedExplorer.this.buttonLocate) {
                AdvancedExplorer.this.Locate();
            } else if (object == AdvancedExplorer.this.buttonDirCompare) {
                AdvancedExplorer.this.compareTagged();
            } else if (object == AdvancedExplorer.this.buttonUnarc) {
                AdvancedExplorer.this.unArchive();
            } else if (object == AdvancedExplorer.this.buttonFileCopy) {
                AdvancedExplorer.this.fileCopy(false);
            } else if (object == AdvancedExplorer.this.buttonExplorer) {
                AdvancedExplorer.this.Explorer();
            } else if (object == AdvancedExplorer.this.buttonA) {
                AdvancedExplorer.this.shortcut(0);
            } else if (object == AdvancedExplorer.this.buttonC) {
                AdvancedExplorer.this.shortcut(1);
            } else if (object == AdvancedExplorer.this.buttonD) {
                AdvancedExplorer.this.shortcut(2);
            } else if (object == AdvancedExplorer.this.buttonE) {
                AdvancedExplorer.this.shortcut(3);
            } else if (object == AdvancedExplorer.this.buttonF) {
                AdvancedExplorer.this.shortcut(4);
            } else if (object == AdvancedExplorer.this.buttonG) {
                AdvancedExplorer.this.shortcut(5);
            } else if (object == AdvancedExplorer.this.buttonH) {
                AdvancedExplorer.this.shortcut(6);
            } else if (object == AdvancedExplorer.this.buttonI) {
                AdvancedExplorer.this.shortcut(7);
            } else if (object == AdvancedExplorer.this.buttonDirOpen) {
                AdvancedExplorer.this.openTextDialog(false);
            } else if (object == AdvancedExplorer.this.buttonTextNew || object == AdvancedExplorer.this.buttonDirNew) {
                AdvancedExplorer.this.tabbedAE.select(1);
                AdvancedExplorer.this.newText();
            } else if (object == AdvancedExplorer.this.buttonTextOpen) {
                AdvancedExplorer.this.openTextDialog(false);
            } else if (object == AdvancedExplorer.this.buttonTextSave) {
                AdvancedExplorer.this.editor.save();
            } else if (object == AdvancedExplorer.this.buttonTextFind) {
                AdvancedExplorer.this.editor.find();
            } else if (object == AdvancedExplorer.this.buttonTextReplace) {
                AdvancedExplorer.this.editor.replace();
            }
        }
    }

    class Action
    implements ActionListener {
        Action() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == AdvancedExplorer.this.miFree) {
                AdvancedExplorer.this.dirtools.free();
                return;
            }
            if (object == AdvancedExplorer.this.filecopy) {
                AdvancedExplorer.this.Message(AdvancedExplorer.this.filecopy.actionCommand);
                return;
            }
            if (object == AdvancedExplorer.this.miFileLocate) {
                AdvancedExplorer.this.Locate();
                return;
            }
            if (object == AdvancedExplorer.this.miHistory) {
                AdvancedExplorer.this.history.show();
                return;
            }
            if (object == AdvancedExplorer.this.miDOS) {
                AdvancedExplorer.this.console();
                return;
            }
            if (object == AdvancedExplorer.this.miCalc) {
                AdvancedExplorer.this.dirtools.Run("calc.exe", null, false);
                return;
            }
            if (object == AdvancedExplorer.this.miScan) {
                AdvancedExplorer.this.dirtools.Run("scandskw.exe", null, false);
                return;
            }
            if (object == AdvancedExplorer.this.miExplorer) {
                AdvancedExplorer.this.Explorer();
                return;
            }
            if (object == AdvancedExplorer.this.miThumbnail) {
                AdvancedExplorer.this.panelThumbnail.select(AdvancedExplorer.this.source);
                AdvancedExplorer.this.panelRight.select(1);
                AdvancedExplorer.this.panelThumbnail.init(AdvancedExplorer.this.source, AdvancedExplorer.this.target, false);
                return;
            }
            if (object == AdvancedExplorer.this.miListe) {
                AdvancedExplorer.this.panelRight.select(2);
                AdvancedExplorer.this.panelList.init(AdvancedExplorer.this.source, AdvancedExplorer.this.target, true);
                return;
            }
            if (object == AdvancedExplorer.this.miOutline) {
                if (AdvancedExplorer.this.panelOutline.select(AdvancedExplorer.this.source)) {
                    AdvancedExplorer.this.panelRight.select(3);
                    AdvancedExplorer.this.panelOutline.init(AdvancedExplorer.this.source, AdvancedExplorer.this.target, false);
                }
                return;
            }
            if (object == AdvancedExplorer.this.miZip) {
                AdvancedExplorer.this.panelRight.select(4);
                AdvancedExplorer.this.panelArchive.setFilename("");
                AdvancedExplorer.this.panelArchive.init(AdvancedExplorer.this.source, AdvancedExplorer.this.target, true);
                AdvancedExplorer.this.panelArchive.setDir(AdvancedExplorer.this.target.getDir());
                AdvancedExplorer.this.panelArchive.makeFile();
            } else {
                if (object == AdvancedExplorer.this.archiver) {
                    char c = event.getActionCommand().charAt(0);
                    AdvancedExplorer advancedExplorer = AdvancedExplorer.this;
                    String mess = advancedExplorer.archiver.getMessage();
                    if (c == 'm') {
                        AdvancedExplorer.this.Message(mess);
                    } else {
                        AdvancedExplorer.this.dispTip(mess);
                    }
                    return;
                }
                if (object == AdvancedExplorer.this.miProgSearch) {
                    AdvancedExplorer.this.progSearch();
                    return;
                }
                if (object == AdvancedExplorer.this.miProgClear) {
                    AdvancedExplorer.this.tools.clear();
                    AdvancedExplorer.this.tools.restore();
                    return;
                }
                if (object == AdvancedExplorer.this.tools) {
                    String com = event.getActionCommand();
                    AdvancedExplorer.this.actionProgram(new Integer(com));
                    return;
                }
                if (object == AdvancedExplorer.this.miTextClear) {
                    AdvancedExplorer.this.references.clear();
                    AdvancedExplorer.this.references.restore();
                    return;
                }
                if (object == AdvancedExplorer.this.references) {
                    AdvancedExplorer.this.actionDynamic(AdvancedExplorer.this.references.dynList, event.getActionCommand());
                    return;
                }
                if (object == AdvancedExplorer.this.miRecentClear) {
                    AdvancedExplorer.this.recents.clear();
                    AdvancedExplorer.this.recents.restore();
                    return;
                }
                if (object == AdvancedExplorer.this.recents) {
                    AdvancedExplorer.this.actionDynamic(AdvancedExplorer.this.recents.dynList, event.getActionCommand());
                    return;
                }
                if (object == AdvancedExplorer.this.miHelp) {
                    AdvancedExplorer.this.manual();
                    return;
                }
                if (object == AdvancedExplorer.this.miAbout) {
                    AdvancedExplorer.this.About();
                    return;
                }
            }
            if (object == AdvancedExplorer.this.miNew) {
                AdvancedExplorer.this.tabbedAE.select(1);
                AdvancedExplorer.this.newText();
            } else if (object == AdvancedExplorer.this.miOpenText) {
                AdvancedExplorer.this.openTextDialog(true);
            } else if (object == AdvancedExplorer.this.miSave) {
                AdvancedExplorer.this.editor.save();
            } else if (object == AdvancedExplorer.this.miSelectAll) {
                AdvancedExplorer.this.editor.selectAll();
            } else if (object == AdvancedExplorer.this.miClose) {
                AdvancedExplorer.this.closeText();
            } else if (object == AdvancedExplorer.this.miSaveAs) {
                AdvancedExplorer.this.saveAs();
            } else if (object == AdvancedExplorer.this.miSaveBlock) {
                AdvancedExplorer.this.editor.saveBlock();
            } else if (object == AdvancedExplorer.this.miUndo) {
                AdvancedExplorer.this.editor.undo();
            } else if (object == AdvancedExplorer.this.miFind) {
                AdvancedExplorer.this.editor.find();
            } else if (object == AdvancedExplorer.this.miFindAgain) {
                AdvancedExplorer.this.editor.findAgain();
            } else if (object == AdvancedExplorer.this.miReplace) {
                AdvancedExplorer.this.editor.replace();
            } else if (object == AdvancedExplorer.this.miInsert) {
                AdvancedExplorer.this.editor.insert();
            } else if (object == AdvancedExplorer.this.miExit) {
                AdvancedExplorer.this.Exit_Action();
            } else {
                if (object == AdvancedExplorer.this.miFileSelectAll) {
                    if (AdvancedExplorer.this.whichWindow() == 0) {
                        AdvancedExplorer.this.source.deselectAll();
                        AdvancedExplorer.this.source.selectAll();
                        return;
                    }
                    if (AdvancedExplorer.this.whichWindow() == 1) {
                        AdvancedExplorer.this.target.deselectAll();
                        AdvancedExplorer.this.target.selectAll();
                    }
                    return;
                }
                if (object == AdvancedExplorer.this.miFileSelectAny) {
                    if (AdvancedExplorer.this.whichWindow() == 0) {
                        AdvancedExplorer.this.source.deselectAll();
                        AdvancedExplorer.this.source.selectAny();
                        return;
                    }
                    if (AdvancedExplorer.this.whichWindow() == 1) {
                        AdvancedExplorer.this.target.deselectAll();
                        AdvancedExplorer.this.target.selectAny();
                    }
                    return;
                }
                if (object == AdvancedExplorer.this.miFileComp) {
                    AdvancedExplorer.this.compareTagged();
                } else if (object == AdvancedExplorer.this.miUpdate) {
                    AdvancedExplorer.this.updateTagged();
                } else if (object == AdvancedExplorer.this.miFileCopy) {
                    AdvancedExplorer.this.fileCopy(false);
                } else if (object == AdvancedExplorer.this.miCopyRen) {
                    AdvancedExplorer.this.CopyRename();
                } else if (object == AdvancedExplorer.this.miCopyInDir) {
                    AdvancedExplorer.this.fileCopy(true);
                } else if (object == AdvancedExplorer.this.miDirCompare) {
                    AdvancedExplorer.this.compare(0);
                } else if (object == AdvancedExplorer.this.miCmpVersions) {
                    AdvancedExplorer.this.compare(2);
                } else if (object == AdvancedExplorer.this.miCmpContent) {
                    AdvancedExplorer.this.compare(3);
                } else if (object == AdvancedExplorer.this.miCmpFull) {
                    AdvancedExplorer.this.compare(1);
                } else if (object == AdvancedExplorer.this.miSwap) {
                    AdvancedExplorer.this.swapDirs();
                } else if (object == AdvancedExplorer.this.miDirExtend) {
                    AdvancedExplorer.this.setDstPath(AdvancedExplorer.this.source.getDir());
                    AdvancedExplorer.this.DstDisp();
                } else if (object == AdvancedExplorer.this.miMake) {
                    AdvancedExplorer.this.Make();
                } else if (object == AdvancedExplorer.this.miView) {
                    AdvancedExplorer.this.source.viewZip();
                } else if (object == AdvancedExplorer.this.miExtract) {
                    AdvancedExplorer.this.unArchive();
                } else if (object == AdvancedExplorer.this.imageViewer) {
                    String command = event.getActionCommand();
                    if (command.equals("full")) {
                        AdvancedExplorer.this.actionFull();
                        return;
                    }
                    AdvancedExplorer.this.displayFlag = true;
                    AdvancedExplorer.this.imageMessage();
                } else if (object == AdvancedExplorer.this.aesetup) {
                    int messnum = new Integer(event.getActionCommand());
                    switch (messnum) {
                        case 0: {
                            AdvancedExplorer.this.Message(AdvancedExplorer.this.aesetup.message);
                            break;
                        }
                        case 1: {
                            AdvancedExplorer.this.dispTip(AdvancedExplorer.this.aesetup.message);
                            break;
                        }
                        case 2: {
                            AdvancedExplorer.this.updateConditional(AdvancedExplorer.this.AEDir);
                            break;
                        }
                        case 3: {
                            AdvancedExplorer.this.beep();
                            break;
                        }
                        case 4: {
                            AdvancedExplorer.this.Exit_Action();
                            break;
                        }
                        case 5: {
                            AdvancedExplorer.this.tabbedAE.setTabsInfo(0, Preferences.tabStyle);
                            AdvancedExplorer.this.tabDst.setTabsInfo(0, Preferences.tabStyle);
                            break;
                        }
                        case 7: {
                            AdvancedExplorer.this.setTextStyle();
                            AdvancedExplorer.this.setDirStyle();
                            AdvancedExplorer.this.setTreeStyle();
                            AdvancedExplorer.this.setMessageStyle();
                            break;
                        }
                        case 6: {
                            AESetup cfr_ignored_0 = AdvancedExplorer.this.aesetup;
                            String label = Preferences.shortcut[AESetup.shortnum];
                            AESetup cfr_ignored_1 = AdvancedExplorer.this.aesetup;
                            switch (AESetup.shortnum) {
                                case 0: {
                                    AdvancedExplorer.this.buttonA.setLabel(label, true);
                                    break;
                                }
                                case 1: {
                                    AdvancedExplorer.this.buttonC.setLabel(label, true);
                                    break;
                                }
                                case 2: {
                                    AdvancedExplorer.this.buttonD.setLabel(label, true);
                                    break;
                                }
                                case 3: {
                                    AdvancedExplorer.this.buttonE.setLabel(label, true);
                                    break;
                                }
                                case 4: {
                                    AdvancedExplorer.this.buttonF.setLabel(label, true);
                                    break;
                                }
                                case 5: {
                                    AdvancedExplorer.this.buttonG.setLabel(label, true);
                                    break;
                                }
                                case 6: {
                                    AdvancedExplorer.this.buttonH.setLabel(label, true);
                                    break;
                                }
                                case 7: {
                                    AdvancedExplorer.this.buttonI.setLabel(label, true);
                                }
                            }
                        }
                        case 8: {
                            AdvancedExplorer.this.treemanager.rebuild();
                            break;
                        }
                        case 9: {
                            AdvancedExplorer.this.source.setArcSort(Preferences.ArcSort);
                            AdvancedExplorer.this.target.setArcSort(Preferences.ArcSort);
                            break;
                        }
                        case 12: {
                            int s = Preferences.menuSize;
                            AdvancedExplorer.this.recents.setSize(s);
                            AdvancedExplorer.this.references.setSize(s);
                            AdvancedExplorer.this.tools.setSize(s);
                        }
                    }
                } else if (object == AdvancedExplorer.this.dirtools) {
                    DirTools cfr_ignored_2 = AdvancedExplorer.this.dirtools;
                    DirTools cfr_ignored_3 = AdvancedExplorer.this.dirtools;
                    if (DirTools.messnum == 0) {
                        DirTools cfr_ignored_4 = AdvancedExplorer.this.dirtools;
                        AdvancedExplorer.this.Message(DirTools.message);
                    } else {
                        DirTools cfr_ignored_5 = AdvancedExplorer.this.dirtools;
                        AdvancedExplorer.this.dispTip(DirTools.message);
                    }
                } else {
                    if (object == AdvancedExplorer.this.source) {
                        String command = event.getActionCommand();
                        if (command.equals("md")) {
                            if (AdvancedExplorer.this.synchro()) {
                                AdvancedExplorer.this.DstDisp();
                            }
                            AdvancedExplorer.this.source.requestFocus();
                            return;
                        }
                        if (command.equals("modified")) {
                            if (AdvancedExplorer.this.synchro()) {
                                AdvancedExplorer.this.target.dirDisp(false);
                            }
                            AdvancedExplorer.this.source.requestFocus();
                            return;
                        }
                        if (command.equals("focus")) {
                            AdvancedExplorer.this.SrcFocus();
                            return;
                        }
                        if (command.equals("copy")) {
                            AdvancedExplorer.this.fileCopy(false);
                            return;
                        }
                        if (command.equals("unarc")) {
                            AdvancedExplorer.this.unArchive();
                            return;
                        }
                        if (command.equals("edit")) {
                            AdvancedExplorer.this.processEdit(AdvancedExplorer.this.source);
                            return;
                        }
                        AdvancedExplorer.this.processAny(AdvancedExplorer.this.source, command, AdvancedExplorer.this.source.addit);
                        return;
                    }
                    if (object == AdvancedExplorer.this.target) {
                        String command = event.getActionCommand();
                        if (command.equals("md")) {
                            if (AdvancedExplorer.this.synchro()) {
                                AdvancedExplorer.this.source.dirDisp(false);
                            }
                            if (Preferences.OpenDir) {
                                AdvancedExplorer.this.target.setPath(Path.merge(AdvancedExplorer.this.target.getDir(), AdvancedExplorer.this.target.dirmade));
                            }
                            AdvancedExplorer.this.DstDisp();
                            return;
                        }
                        if (command.equals("modified")) {
                            AdvancedExplorer.this.target.modified = true;
                            if (AdvancedExplorer.this.synchro()) {
                                AdvancedExplorer.this.source.dirDisp(false);
                            }
                            AdvancedExplorer.this.target.requestFocus();
                            return;
                        }
                        if (command.equals("focus")) {
                            AdvancedExplorer.this.DstFocus();
                            return;
                        }
                        if (command.equals("edit")) {
                            AdvancedExplorer.this.processEdit(AdvancedExplorer.this.target);
                            return;
                        }
                        AdvancedExplorer.this.processAny(AdvancedExplorer.this.target, command, AdvancedExplorer.this.target.addit);
                    } else if (object == AdvancedExplorer.this.treemanager) {
                        String command = event.getActionCommand();
                        if (command.equals("src")) {
                            AdvancedExplorer.this.MakeSrc(true);
                            return;
                        }
                        if (command.equals("dst")) {
                            AdvancedExplorer.this.target.setPath(AdvancedExplorer.this.treemanager.getSelected());
                            AdvancedExplorer.this.tabDst.select(0);
                            return;
                        }
                    } else if (object == AdvancedExplorer.this.editor) {
                        String com = event.getActionCommand();
                        if (com.equals("modified")) {
                            AdvancedExplorer.this.changeTextTab();
                            AdvancedExplorer.this.updateConditional(AdvancedExplorer.this.editor.UpdateDir);
                            AdvancedExplorer.this.displayText();
                        }
                        if (com.equals("tip")) {
                            AdvancedExplorer.this.dispTip(AdvancedExplorer.this.editor.TextMessage);
                        }
                        if (com.equals("message")) {
                            AdvancedExplorer.this.Message(AdvancedExplorer.this.editor.TextMessage);
                        }
                    } else {
                        if (object == AdvancedExplorer.this.panelThumbnail) {
                            if (AdvancedExplorer.this.panelMessage(AdvancedExplorer.this.panelThumbnail)) {
                                return;
                            }
                            PanelThumbnail cfr_ignored_6 = AdvancedExplorer.this.panelThumbnail;
                            if (AdvancedExplorer.this.panelThumbnail.action == 10) {
                                AdvancedExplorer.this.thumbnailAction();
                            }
                            AdvancedExplorer.this.panelRight.select(0);
                            return;
                        }
                        if (object == AdvancedExplorer.this.panelList) {
                            if (AdvancedExplorer.this.panelMessage(AdvancedExplorer.this.panelList)) {
                                return;
                            }
                            PanelList cfr_ignored_7 = AdvancedExplorer.this.panelList;
                            if (AdvancedExplorer.this.panelList.action == 10) {
                                AdvancedExplorer.this.indexAction();
                            }
                            AdvancedExplorer.this.panelRight.select(0);
                            return;
                        }
                        if (object == AdvancedExplorer.this.panelOutline) {
                            if (AdvancedExplorer.this.panelMessage(AdvancedExplorer.this.panelOutline)) {
                                return;
                            }
                            PanelOutline cfr_ignored_8 = AdvancedExplorer.this.panelOutline;
                            if (AdvancedExplorer.this.panelOutline.action == 10) {
                                AdvancedExplorer.this.outlineAction();
                            }
                            AdvancedExplorer.this.panelRight.select(0);
                            return;
                        }
                        if (object == AdvancedExplorer.this.panelArchive) {
                            if (AdvancedExplorer.this.panelMessage(AdvancedExplorer.this.panelArchive)) {
                                return;
                            }
                            PanelArchive cfr_ignored_9 = AdvancedExplorer.this.panelArchive;
                            if (AdvancedExplorer.this.panelArchive.action == 10) {
                                if (!AdvancedExplorer.this.panelArchive.archive(AdvancedExplorer.this.source)) {
                                    return;
                                }
                                AdvancedExplorer.this.updateConditional(AdvancedExplorer.this.panelArchive.getDir());
                                if (AdvancedExplorer.this.synchro()) {
                                    AdvancedExplorer.this.source.refresh(false);
                                }
                            }
                            AdvancedExplorer.this.panelRight.select(0);
                            return;
                        }
                    }
                }
            }
        }
    }

    class AEMainKeys
    extends KeyAdapter {
        AEMainKeys() {
        }

        public void keyPressed(KeyEvent event) {
            Object object = event.getSource();
            if (event.isAltDown()) {
                int keypressed = event.getKeyCode();
                int panel = -1;
                switch (keypressed) {
                    case 70: {
                        panel = 0;
                        break;
                    }
                    case 88: {
                        panel = 0;
                        break;
                    }
                    case 69: {
                        panel = 1;
                        break;
                    }
                    case 79: {
                        panel = 2;
                        break;
                    }
                    case 115: {
                        AdvancedExplorer.this.Exit_Action();
                    }
                }
                if (panel > -1) {
                    AdvancedExplorer.this.tabbedAE.select(panel);
                }
            }
        }
    }

    class SymComponent
    extends ComponentAdapter {
        SymComponent() {
        }

        public void componentShown(ComponentEvent event) {
            Object object = event.getSource();
            if (object == AdvancedExplorer.this.tabDir) {
                AdvancedExplorer.this.tabDir_componentShown(event);
            } else if (object == AdvancedExplorer.this.source) {
                AdvancedExplorer.this.source_componentShown(event);
            } else if (object == AdvancedExplorer.this.target) {
                AdvancedExplorer.this.target_componentShown(event);
            } else if (object == AdvancedExplorer.this.editor) {
                AdvancedExplorer.this.editor_componentShown(event);
            } else if (object == AdvancedExplorer.this.tabSetup) {
                AdvancedExplorer.this.tabSetup_componentShown();
            } else if (object == AdvancedExplorer.this.imageViewer) {
                AdvancedExplorer.this.imageMessage();
            } else if (object == AdvancedExplorer.this.tabDst) {
                AdvancedExplorer.this.tabDst_componentShown();
            } else if (object == AdvancedExplorer.this.treemanager) {
                AdvancedExplorer.this.treemanager.init();
            }
        }

        public void componentHidden(ComponentEvent event) {
            Object object = event.getSource();
            if (object == AdvancedExplorer.this.tabDir) {
                AdvancedExplorer.this.tabDir_componentHidden(event);
            } else if (object == AdvancedExplorer.this.source) {
                AdvancedExplorer.this.source_componentHidden(event);
            } else if (object == AdvancedExplorer.this.target) {
                AdvancedExplorer.this.target_componentHidden(event);
            } else if (object == AdvancedExplorer.this.editor) {
                AdvancedExplorer.this.editor_componentHidden(event);
            } else if (object == AdvancedExplorer.this.tabDst) {
                AdvancedExplorer.this.tabDst_componentHidden();
            }
        }
    }
}

