/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.IVector;
import ae.ImageViewer;
import ae.Raw;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Animator {
    public static final int BRANCH = 65536;
    public static final int IMAGE = 0;
    public static final int RAW = 1;
    public static final int GIF = 2;
    public static final int JPG = 3;
    public static final int PNG = 4;
    public static final int WAV = 8;
    public static final int AU = 9;
    public static final int DOC = 16;
    Vector pictures = new Vector();
    Vector names = new Vector();
    IVector types = new IVector();
    IVector parents = new IVector();
    IVector nexts = new IVector();
    IVector childs = new IVector();
    int count = 0;
    int index = 0;
    int delay = 50;
    public String dir = "";
    public String name = null;
    public String message = "ok";
    int fieldX = 0;
    int fieldY = 0;
    int fieldW = 0;
    int fieldH = 0;
    int parent = 0;
    int previous = 0;
    int newfolder = -1;

    public void restart() {
        this.index = 0;
    }

    public void setSlow(int s) {
        this.delay = s;
    }

    public boolean next() {
        return ++this.index < this.count;
    }

    public int getType(int index) {
        return this.types.elementAt(index);
    }

    public int getType() {
        return this.types.elementAt(this.index);
    }

    public Object getPicture(int i) {
        return this.pictures.elementAt(i);
    }

    public Object getPicture() {
        return this.pictures.elementAt(this.index);
    }

    public Object getPicture(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!((String)this.names.elementAt(i)).equalsIgnoreCase(name)) continue;
            return this.getPicture(i);
        }
        return null;
    }

    int next(int index) {
        return this.nexts.elementAt(index);
    }

    int child(int index) {
        return this.childs.elementAt(index);
    }

    public void setSpeed(int millis) {
        this.delay = millis;
    }

    public void setField(ImageViewer iv) {
        Dimension fieldDim = iv.getSize();
        this.fieldW = fieldDim.width;
        this.fieldH = fieldDim.height;
        this.fieldX = 0;
        this.fieldY = 0;
    }

    public void clearField(Graphics g) {
        g.clearRect(this.fieldX, this.fieldY, this.fieldW, this.fieldH);
    }

    public void animate(Graphics g, int x, int y) {
        this.restart();
        do {
            int type = this.getType();
            Object picture = this.getPicture();
            this.clearField(g);
            switch (type) {
                case 0: 
                case 2: {
                    g.drawImage((Image)picture, x, y, null);
                    break;
                }
                case 1: {
                    Raw raw = (Raw)picture;
                    Image image = raw.getImage();
                    g.drawImage(image, x, y, null);
                    break;
                }
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        } while (this.next());
    }

    public void clear(int size) {
        this.pictures = new Vector(size);
        this.names = new Vector(size);
        this.types = new IVector(size);
        this.parents = new IVector(size);
        this.nexts = new IVector(size);
        this.childs = new IVector(size);
        this.count = 0;
        this.index = 0;
        this.name = null;
        this.dir = "";
    }

    public void clear() {
        this.clear(16);
    }

    void addBranch(String name, int parent) {
        this.pictures.addElement(null);
        this.names.addElement(name);
        this.types.addElement(65536);
        this.parents.addElement(parent);
        this.nexts.addElement(0);
        this.childs.addElement(0);
        this.newfolder = this.count++;
    }

    int findPrevious(String folder) {
        int index;
        for (index = this.count - 1; index >= 0; --index) {
            if (this.types.elementAt(index) != 65536 || !folder.equalsIgnoreCase((String)this.names.elementAt(index))) continue;
            return index;
        }
        if (this.count > 0) {
            this.nexts.setElementAt(this.count, this.previous);
        }
        this.addBranch(folder, this.newfolder);
        return index;
    }

    void makeFolder(String dir) {
        int i = dir.indexOf(File.separatorChar);
        System.out.println("get parent of " + dir);
        if (i != -1) {
            int previous = this.findPrevious(dir.substring(0, i));
            this.makeFolder(dir.substring(i + 1));
            return;
        }
        int previous = this.findPrevious(dir);
    }

    void insert(String entry, Object data) {
        String ext;
        int i = entry.lastIndexOf(File.separatorChar);
        this.newfolder = -1;
        if (i > -1) {
            this.makeFolder(entry.substring(0, i));
            entry = entry.substring(i + 1);
        }
        int type = (ext = entry.substring((i = entry.lastIndexOf(46)) + 1)).equalsIgnoreCase("Raw") ? 1 : 16;
        this.pictures.addElement(data);
        this.names.addElement(entry);
        this.types.addElement(type);
        this.parents.addElement(this.newfolder);
        this.nexts.addElement(0);
        this.childs.addElement(0);
        if (this.newfolder >= 0) {
            this.childs.setElementAt(this.count, this.newfolder);
        } else {
            this.nexts.setElementAt(this.count, this.previous);
        }
        System.out.println(entry + " no" + this.count + " parent " + this.parent + " type " + type + " *** next of " + this.names.elementAt(this.previous) + " as next " + this.nexts.elementAt(this.previous));
        this.previous = this.count++;
    }

    void insert(String name, byte[] imgdata) {
        this.insert(name, new Raw(imgdata));
    }

    public String zipToJava(String zipentry) {
        return zipentry.replace('/', File.separatorChar);
    }

    public int load(String archive) {
        int counter = 0;
        this.message = "Ok";
        this.previous = 0;
        this.clear();
        try {
            FileInputStream fis = new FileInputStream(archive);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            ZipFile zf = new ZipFile(archive);
            while ((ze = zis.getNextEntry()) != null) {
                String entry = this.zipToJava(ze.getName());
                ZipEntry ge = zf.getEntry(entry);
                if (ze.isDirectory()) continue;
                try {
                    int size = (int)ge.getSize();
                    byte[] byteBuffer = new byte[size];
                    size = zis.read(byteBuffer);
                    this.insert(entry, byteBuffer);
                    ++counter;
                }
                catch (Exception ae) {
                    ae.printStackTrace();
                }
            }
            zis.close();
            bis.close();
            fis.close();
            this.name = archive;
        }
        catch (IOException io) {
            this.message = io.toString();
            System.out.println(this.message);
        }
        catch (InternalError ie) {
            this.message = ie.toString();
            System.out.println(this.message);
        }
        return counter;
    }
}

