/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Animator;
import ae.DTreeNode;
import ae.DTreeView;
import ae.DirIcons;
import ae.Path;
import ae.Raw;
import ae.RawEdit;
import ae.VectorInt;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class AnimatorEdit
extends Animator {
    public int generator = 0;
    Vector images = new Vector();
    VectorInt depths = new VectorInt();
    static String message = "ok";
    private static float test = 1.5f;
    DTreeNode parentNode;
    DTreeNode previousNode;
    DTreeView tree;
    Image expanded = DirIcons.Expanded;
    Image collapsed = DirIcons.IconDir;
    static String extension;
    static String alphanode;
    static String namenode;
    static String namesuffix;
    static int intsuffix;

    public Image getImage(int i) {
        return (Image)this.images.elementAt(i);
    }

    public Image getImage() {
        return this.getImage(this.index);
    }

    public void clear() {
        this.clear(16);
    }

    public void clear(int size) {
        super.clear(size);
        this.images = new Vector(size);
        this.depths = new VectorInt(size);
    }

    protected void add(Object image, String name, int type, int par, int sib, int son, int depth) {
        this.images.addElement(image);
        if (image == null) {
            this.pictures.addElement(null);
        } else {
            this.pictures.addElement(new RawEdit((Image)image).getRaw());
        }
        this.names.addElement(name);
        this.types.addElement(type);
        this.parents.addElement(par);
        this.nexts.addElement(sib);
        this.childs.addElement(son);
        this.depths.addElement(depth);
        ++this.count;
    }

    public final void build(DTreeView tree) {
        if (tree.rootNode == null) {
            return;
        }
        tree.rootNode.depth = 0;
        this.count = 0;
        Vector nodesVector = new Vector(tree.count);
        tree.vectorize(tree.rootNode, false, nodesVector);
        int numNodes = nodesVector.size();
        this.clear(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            DTreeNode node = (DTreeNode)nodesVector.elementAt(i);
            int type = node.isDirectory ? 65536 : 0;
            Object image = node.dataObject;
            int depth = node.depth;
            int par = -1;
            if (node.parent != null) {
                par = nodesVector.indexOf(node.parent);
            }
            int sib = 0;
            if (node.sibling != null) {
                sib = nodesVector.indexOf(node.sibling);
            }
            int son = 0;
            if (node.child != null) {
                son = nodesVector.indexOf(node.child);
            }
            this.add(image, node.text, type, par, sib, son, depth);
        }
        System.gc();
    }

    public static Image resize(Image dataImage) {
        int H;
        int W;
        int OH;
        int OW = dataImage.getWidth(null);
        float rapport = (float)OW / (float)(OH = dataImage.getHeight(null));
        if (rapport > test) {
            W = 24;
            H = (int)(24.0f / rapport);
        } else {
            H = 16;
            W = (int)(16.0f * rapport);
        }
        return dataImage.getScaledInstance(W, H, 1);
    }

    void addNode(DTreeView tree, DTreeNode newnode, DTreeNode parent, boolean asChild) {
        if (parent == null && this.previousNode == null) {
            tree.append(newnode);
            return;
        }
        if (asChild) {
            if (!parent.isDirectory) {
                parent = newnode.parent;
            }
            tree.addChild(newnode, parent);
            return;
        }
        tree.addSibling(newnode, this.previousNode, true);
    }

    public void buildTree(DTreeView newtree) {
        this.tree = newtree;
        this.tree.clear();
        this.parentNode = null;
        this.previousNode = null;
        this.buildRecurse(0);
    }

    void buildRecurse(int no) {
        boolean isChild = true;
        do {
            String name = (String)this.names.elementAt(no);
            DTreeNode node = null;
            if (this.types.elementAt(no) == 65536) {
                int nochild;
                node = new DTreeNode(name, this.collapsed, this.expanded, this.tree);
                node.setDataObject(null);
                node.isDirectory = true;
                node.parent = this.parentNode;
                this.addNode(this.tree, node, this.parentNode, isChild);
                if (this.parentNode != null) {
                    this.parentNode.child = node;
                }
                if (this.previousNode != null) {
                    this.previousNode.sibling = node;
                }
                if ((nochild = this.childs.elementAt(no)) > 0) {
                    this.parentNode = node;
                    this.previousNode = null;
                    this.buildRecurse(nochild);
                }
            } else {
                try {
                    Raw raw = (Raw)this.pictures.elementAt(no);
                    Image dataImage = raw.getImage();
                    Image treeImage = AnimatorEdit.resize(dataImage);
                    node = new DTreeNode(name, treeImage, null, this.tree);
                    node.setDataObject(dataImage);
                    node.parent = this.parentNode;
                    this.addNode(this.tree, node, this.parentNode, isChild);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.parentNode != null) {
                    this.parentNode.child = node;
                }
                if (this.previousNode != null) {
                    this.previousNode.sibling = node;
                }
            }
            this.parentNode = null;
            this.previousNode = null;
            no = this.nexts.elementAt(no);
            if (no <= 0) continue;
            this.previousNode = node;
            isChild = false;
        } while (no > 0);
    }

    public static void getAlphaNode(String name) {
        int i = name.lastIndexOf(".");
        if (i == -1) {
            extension = "";
            namenode = name;
        } else {
            extension = name.substring(i);
            namenode = name.substring(0, i);
        }
        int fin = i;
        boolean bSuffix = false;
        for (i = namenode.length(); i >= 0 && Character.isDigit(namenode.charAt(i - 1)); --i) {
            bSuffix = true;
        }
        intsuffix = 0;
        namesuffix = "";
        if (bSuffix) {
            namesuffix = namenode.substring(i, fin);
            namenode = namenode.substring(0, i);
            intsuffix = Integer.valueOf(namesuffix);
        }
    }

    public static String getUnic(DTreeView tree, String name) {
        while (tree.exists(name)) {
            AnimatorEdit.getAlphaNode(name);
            name = namenode + Integer.toString(intsuffix + 1) + extension;
        }
        return name;
    }

    public String getDir() {
        return this.dir;
    }

    public final boolean save(Frame parent, String ndir, String nfic) {
        if (ndir == null) {
            ndir = "";
        }
        if (nfic == null) {
            FileDialog fd = new FileDialog(parent, "Save animation in Zip archive", 1);
            fd.setDirectory(ndir);
            fd.setFile(Path.changeExt("", "aaz"));
            fd.show();
            nfic = fd.getFile();
            if (nfic == null) {
                return false;
            }
            ndir = fd.getDirectory();
        }
        this.dir = ndir;
        this.name = nfic;
        String path = Path.merge(this.dir, this.name);
        this.archive(path);
        return true;
    }

    static int getMethod() {
        return 8;
    }

    private int[] levelList(int no) {
        if ((no = this.childs.elementAt(no)) == 0) {
            return null;
        }
        VectorInt vi = new VectorInt(16);
        do {
            vi.addElement(no);
        } while ((no = this.nexts.elementAt(no)) > 0);
        int[] liste = new int[vi.size()];
        vi.copyInto(liste);
        return liste;
    }

    private int recurse(String dir, int[] liste, ZipOutputStream zos) {
        System.out.println("enter recurse liste len " + liste.length);
        if (liste == null) {
            return 0;
        }
        int counter = 0;
        for (int i = 0; i < liste.length; ++i) {
            try {
                int no = liste[i];
                String entry = (String)this.names.elementAt(no);
                if (dir.length() > 0) {
                    entry = Path.merge(dir, entry);
                }
                System.out.println(i + ") recurse - next name " + entry);
                Raw raw = (Raw)this.pictures.elementAt(no);
                int type = this.types.elementAt(no);
                ZipEntry ze = null;
                boolean result = true;
                try {
                    System.out.println("entry name " + entry);
                    ze = new ZipEntry(entry);
                }
                catch (NullPointerException npe) {
                    message = entry + " forms bad zip entry ";
                    result = false;
                    System.out.println(message);
                }
                if (!result) {
                    return 0;
                }
                if (type == 65536) {
                    System.out.println(entry + " is BRANCH no=" + no);
                    counter += this.recurse(entry, this.levelList(no), zos);
                    continue;
                }
                byte[] buffer = raw.getBytes();
                try {
                    System.out.println("put next entry size " + buffer.length);
                    zos.putNextEntry(ze);
                    zos.write(buffer, 0, buffer.length);
                    zos.closeEntry();
                    zos.flush();
                    ++counter;
                }
                catch (NullPointerException n) {
                    n.printStackTrace();
                }
                catch (ZipException z) {
                    z.printStackTrace();
                }
                continue;
            }
            catch (Exception e) {
                message = e.toString();
                System.out.println(message);
            }
        }
        return counter;
    }

    public int archive(String archive) {
        System.out.println("archive " + archive);
        if (this.count == 0) {
            return 0;
        }
        File dst = new File(archive);
        int counter = 0;
        try {
            FileOutputStream fos = new FileOutputStream(dst);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(AnimatorEdit.getMethod());
            VectorInt base = new VectorInt(this.count);
            int no = 0;
            do {
                base.addElement(no);
            } while ((no = this.nexts.elementAt(no)) > 0);
            int[] liste = new int[base.size()];
            base.copyInto(liste);
            counter += this.recurse("", liste, zos);
            zos.close();
            fos.close();
        }
        catch (IOException ioe) {
            message = ioe.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return counter;
    }

    int findDepth(int no) {
        int parent = no;
        int nparent = 0;
        int d = 0;
        do {
            try {
                ++d;
                nparent = this.parents.elementAt(parent);
                if (nparent < parent) {
                    parent = nparent;
                    continue;
                }
                nparent = -1;
            }
            catch (ArrayIndexOutOfBoundsException a) {
                a.printStackTrace();
            }
        } while (nparent != -1);
        return d;
    }

    public String toString() {
        if (this.count == 0) {
            return null;
        }
        String text = "";
        String debug = "";
        for (int i = 0; i < this.count; ++i) {
            int depth = this.findDepth(i);
            String sBlanks = "";
            if (depth > 0) {
                StringBuffer blanks = new StringBuffer(depth);
                for (int n = 0; n < depth; ++n) {
                    blanks.append(' ');
                }
                sBlanks = new String(blanks);
            }
            int parent = this.parents.elementAt(i);
            int son = this.childs.elementAt(i);
            int sib = this.nexts.elementAt(i);
            debug = "[ " + i + " parent " + parent + " child " + son + " next " + sib + " ] ";
            text = text + sBlanks + this.names.elementAt(i) + debug + "\n";
            System.out.println(text);
        }
        return text;
    }
}

