/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Archiver;
import ae.DBPanel;
import ae.DButton;
import ae.DCheckbox;
import ae.DialogCYN;
import ae.DialogMessage;
import ae.Directory;
import ae.OS;
import ae.Path;
import ae.Preferences;
import java.awt.AWTEventMulticaster;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

public class ArchivePanel
extends Panel
implements ActionListener,
ItemListener {
    final short ARC_NONE = 0;
    final short ARC_SINGLE = 1;
    final short ARC_TAGGED = (short)2;
    final short ARC_FOLDER = (short)3;
    short ArchiveMode;
    Frame frame;
    TextField fieldPath;
    TextField fieldName;
    DButton buttonMake;
    Label labeltitle;
    Label labelArc;
    Label labelArcName;
    Label labelArcPath;
    DCheckbox checkRecurse;
    DCheckbox checkInclude;
    String[] list = null;
    String srcdir = null;
    String source = null;
    String arcname = null;
    String arcpath = "";
    String message = "";
    final int MESSAGE = 0;
    final int TIP = 1;
    final int MADE = 3;
    ActionListener actionListener = null;

    public ArchivePanel(Frame f) {
        this.setVisible(false);
        this.setLayout(new GridLayout());
        this.frame = f;
        int fieldSize = 24;
        if (!OS.isWindows()) {
            fieldSize = 30;
        }
        DBPanel panelInner = new DBPanel(2);
        panelInner.setBounds(0, 0, 450, 320);
        this.add(panelInner);
        Font font = new Font("Dialog", 1, 16);
        this.labeltitle = new Label();
        this.labeltitle.setBounds(16, 32, 320, 24);
        this.labeltitle.setFont(font);
        panelInner.add(this.labeltitle);
        this.labelArcPath = new Label();
        this.labelArcPath.setBounds(16, 60, 420, 24);
        this.labelArcPath.setFont(font);
        panelInner.add(this.labelArcPath);
        this.labelArc = new Label("Path of the archive:");
        this.labelArc.setBounds(16, 103, 378, 20);
        panelInner.add(this.labelArc);
        this.fieldPath = new TextField();
        this.fieldPath.setBounds(16, 127, 360, fieldSize);
        panelInner.add(this.fieldPath);
        this.labelArcName = new Label("Name of the archive:");
        this.labelArcName.setBounds(16, 160, 158, 20);
        panelInner.add(this.labelArcName);
        this.fieldName = new TextField();
        this.fieldName.setBounds(16, 184, 256, fieldSize);
        panelInner.add(this.fieldName);
        this.checkRecurse = new DCheckbox("Recurse sub-directories", Preferences.ArcRecurse);
        this.checkRecurse.setBounds(32, 248, 200, 24);
        this.checkRecurse.addItemListener(this);
        panelInner.add(this.checkRecurse);
        this.checkInclude = new DCheckbox("Include full paths", Preferences.ArcInclude);
        this.checkInclude.setBounds(32, 272, 200, 24);
        this.checkInclude.addItemListener(this);
        panelInner.add(this.checkInclude);
        this.buttonMake = new DButton("Make", true);
        this.buttonMake.setBounds(200, 320, 120, 40);
        this.buttonMake.setTip("Make the archive with name and path above");
        this.buttonMake.addActionListener(this);
        this.buttonMake.setEnabled(false);
        panelInner.add(this.buttonMake);
    }

    void setAction(String title) {
        this.labeltitle.setText(title);
    }

    void setSource(String title, String fpath) {
        this.setAction(title);
        this.labelArcPath.setText(fpath);
        this.source = fpath;
    }

    void setPath(String dpath) {
        this.fieldPath.setText(dpath);
    }

    void setArchive(String name) {
        this.fieldName.setText(name);
    }

    void setList(String[] l) {
        this.list = l;
    }

    void setButtonEnabled(boolean f) {
        this.buttonMake.setEnabled(f);
    }

    public String getPath() {
        return this.fieldPath.getText();
    }

    public String getArchive() {
        return this.fieldName.getText();
    }

    public String getSource() {
        return this.source;
    }

    public String[] getList() {
        return this.list;
    }

    public void init(String source, String[] fics, String dpath) {
        String title = null;
        String fpath = null;
        this.srcdir = source;
        int number = fics.length;
        this.ArchiveMode = 0;
        if (this.arcname == null) {
            this.arcname = "";
        }
        if (number == 1) {
            String fic = fics[0];
            fpath = Path.merge(source, fic);
            File f = new File(source, fic);
            this.ArchiveMode = f.isDirectory() ? (short)3 : (short)1;
        } else if (number > 1) {
            this.ArchiveMode = (short)2;
        }
        boolean buttonMode = false;
        switch (this.ArchiveMode) {
            default: {
                title = "ARCHIVER";
                fpath = "Select files or directories to archive";
                dpath = "";
                break;
            }
            case 1: {
                title = "Archiving a file";
                buttonMode = true;
                break;
            }
            case 3: {
                title = "Archiving a directory";
                buttonMode = true;
                break;
            }
            case 2: {
                title = "Archiving a list of files";
                fpath = source + File.separator + "[TAGGED LIST]";
                buttonMode = true;
            }
        }
        this.setButtonEnabled(buttonMode);
        this.setSource(title, fpath);
        this.setPath(dpath);
        this.setArchive(this.arcname);
        this.setList(fics);
    }

    void archive() {
        this.arcpath = this.getPath();
        String arcname = this.getArchive();
        String fichiers = this.getSource();
        Archiver.setMessage("Error");
        if (this.ArchiveMode == 0) {
            this.dispTip("Nothing to do! Select files/dir in first panel, please...");
            return;
        }
        if (arcname == null || arcname.length() == 0) {
            this.dispTip("Give a name to the archive, please!");
            return;
        }
        if (Path.hasExtension(arcname)) {
            if (Directory.isGZip(arcname) && this.ArchiveMode != 1) {
                this.dispTip("GZip require a single file");
                return;
            }
            if (!Directory.isArchive(arcname)) {
                this.dispTip("Give a valid archive extension or none (default is zip)");
                return;
            }
        } else {
            arcname = arcname + ".zip";
        }
        this.setArchive(arcname);
        String archive = Path.merge(this.arcpath, arcname);
        boolean replacing = new File(this.arcpath, arcname).exists();
        if (replacing) {
            DialogCYN cd = new DialogCYN(this.frame, "Erasing the current " + arcname.toUpperCase() + " archive, continue?");
            cd.setVisible(true);
            if (cd.answer != 1) {
                return;
            }
        }
        boolean result = false;
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this.ArchiveMode == 1) {
            this.Message("Archiving " + fichiers + " into " + archive);
            result = Archiver.archiveAnyFile(fichiers, archive);
            if (result) {
                this.Message("Archive completed");
            } else {
                this.Message(Archiver.getMessage());
            }
            this.setCursor(cursor);
            return;
        }
        String[] fics = this.getList();
        String srcpath = null;
        if (this.ArchiveMode == 3) {
            String fic = fics[0];
            this.Message("Archiving " + fic + "'s content into " + archive);
            if (Preferences.ArcInclude) {
                srcpath = this.srcdir;
            } else {
                srcpath = Path.merge(this.srcdir, fic);
                fics = new File(srcpath).list();
            }
        }
        if (this.ArchiveMode == 2) {
            this.Message("Archiving " + fichiers + " into " + archive);
            srcpath = this.srcdir;
        }
        if (fics.length > 0) {
            int fr = Archiver.archive(srcpath, fics, archive);
            this.Message("Archived " + fr + " files");
            if (Archiver.error) {
                new DialogMessage(this.frame, "Error in archiving").setVisible(true);
            }
        } else {
            this.dispTip("Nothing to do");
        }
        this.setCursor(cursor);
    }

    void Message(String s) {
        this.message = s;
        this.sourceActionEvent(0);
    }

    void dispTip(String s) {
        this.message = s;
        this.sourceActionEvent(1);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonMake) {
            this.archive();
            this.sourceActionEvent(3);
        }
    }

    protected void sourceActionEvent(int action) {
        if (this.actionListener == null) {
            return;
        }
        String command = new Integer(action).toString();
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this.checkRecurse) {
            Preferences.ArcRecurse = this.checkRecurse.getState();
        } else if (object == this.checkInclude) {
            Preferences.ArcInclude = this.checkInclude.getState();
        }
    }
}

