/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Directory;
import ae.Path;
import ae.Preferences;
import java.awt.AWTEventMulticaster;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class Archiver {
    static String archiveName;
    public static String messagetext;
    static boolean error;
    static boolean insidePath;
    static long lastModified;
    static final int ZNR = 1;
    static final int ETW = 2;
    static final int IOE = 3;
    static final int ETU = 4;
    static int messageNum;
    static int written;
    static String source;
    ActionListener actionListener = null;

    public static String zipToJava(String zipentry) {
        return zipentry.replace('/', File.separatorChar);
    }

    public static String javaToZip(String zipentry) {
        return zipentry.replace(File.separatorChar, '/');
    }

    private static boolean extract(ZipInputStream zis, String dest, String entryname, boolean restore) {
        Path.split(entryname);
        String dir = Path.Dir;
        String fname = Path.Filename;
        boolean ok = true;
        String destpath = restore ? Path.merge(dest, dir) : dest;
        if (!new File(destpath).exists()) {
            Directory.createDir(destpath);
        }
        File df = new File(destpath, fname);
        written = 0;
        if (Preferences.ArcReplace || !df.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(df);
                byte[] buffer = new byte[2048];
                int rsize = 1;
                while (rsize > 0) {
                    try {
                        rsize = zis.read(buffer);
                        if (rsize <= 0) continue;
                        fos.write(buffer, 0, rsize);
                        written += rsize;
                    }
                    catch (InternalError re) {
                        rsize = 0;
                        messageNum = 1;
                        ok = false;
                    }
                }
                fos.close();
                if (lastModified != -1L) {
                    df.setLastModified(lastModified);
                }
            }
            catch (IOException i) {
                messageNum = 3;
                ok = false;
            }
        }
        return ok;
    }

    public static String makeName(String name) {
        StringBuffer b = new StringBuffer(name);
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '+' || c == '!' || c == '#' || c == '?' || c == '-' || c == '/' || c == '\\' || c == '*') continue;
            b.setCharAt(i, '_');
        }
        return new String(b.toString());
    }

    public static boolean extractFile(String archive, String entryname, String dest, boolean restore) {
        boolean error = false;
        messageNum = 0;
        try {
            FileInputStream fis = new FileInputStream(archive);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String zentry = ze.getName();
                lastModified = ze.getTime();
                if (!zentry.equals(entryname)) continue;
                entryname = Archiver.zipToJava(entryname);
                if (ze.isDirectory()) {
                    error = !Directory.createDir(dest, entryname);
                    continue;
                }
                int total = (int)ze.getSize();
                boolean bl = error = !Archiver.extract(zis, dest, entryname, restore);
                if (error) {
                    messageNum = 4;
                }
                if (total == -1 || written == total) continue;
                error = true;
            }
            zis.close();
            bis.close();
            fis.close();
        }
        catch (IOException ioe) {
            messageNum = 3;
        }
        catch (InternalError re) {
            messageNum = 1;
        }
        switch (messageNum) {
            case 1: {
                Archiver.setMessage("Zip format not recognized");
                error = true;
                break;
            }
            case 2: {
                Archiver.setMessage("Enable to write");
                error = true;
                break;
            }
            case 3: {
                Archiver.setMessage("Enable to extract into " + dest);
                error = true;
                break;
            }
            case 4: {
                Archiver.setMessage("Enable to extract " + Archiver.makeName(entryname));
                error = true;
                break;
            }
        }
        return !error;
    }

    public Point unArchive(String archive, String dest) {
        int counter = 0;
        int found = 0;
        error = false;
        messageNum = 0;
        try {
            FileInputStream fis = new FileInputStream(archive);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String entryname = Archiver.zipToJava(ze.getName());
                if (ze.isDirectory()) {
                    if (!Preferences.ArcRestore || Directory.createDir(dest, entryname)) continue;
                    error = true;
                    continue;
                }
                ++found;
                int total = (int)ze.getSize();
                lastModified = ze.getTime();
                boolean ok = Archiver.extract(zis, dest, entryname, Preferences.ArcRestore);
                if (total != -1 && total != written) {
                    error = true;
                }
                if (ok) {
                    ++counter;
                    this.dispTip(entryname + " extracted");
                    continue;
                }
                this.message("Error on " + Archiver.makeName(entryname));
                error = true;
            }
            zis.close();
            bis.close();
            fis.close();
        }
        catch (IOException i) {
            messageNum = 3;
        }
        catch (InternalError re) {
            messageNum = 1;
        }
        switch (messageNum) {
            case 1: {
                Archiver.setMessage("Zip format not recognized");
                error = true;
                break;
            }
            case 2: {
                Archiver.setMessage("Enable to write");
                error = true;
                break;
            }
            case 3: {
                Archiver.setMessage("Error while extracting into " + dest);
                error = true;
                break;
            }
            default: {
                Archiver.setMessage(counter + " unarchived");
            }
        }
        return new Point(found, counter);
    }

    static int getMethod() {
        return 8;
    }

    private static boolean putFile(ZipOutputStream zos, ZipEntry ze, File src) {
        if (!src.exists()) {
            Archiver.setMessage(src + " not found");
            return false;
        }
        if (!src.canRead()) {
            Archiver.setMessage(src + " is unreadable");
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(src);
            zos.putNextEntry(ze);
            int rsize = 1;
            byte[] Buffer = new byte[2048];
            while (rsize > 0) {
                rsize = fis.read(Buffer);
                if (rsize <= 0) continue;
                zos.write(Buffer, 0, rsize);
            }
            zos.closeEntry();
            zos.flush();
            fis.close();
            return true;
        }
        catch (IOException ioe) {
            Archiver.setMessage(ioe.toString());
            return false;
        }
    }

    public static boolean archiveFile(String fname, String arcname) {
        File src = new File(fname);
        File dst = new File(arcname);
        ZipEntry ze = null;
        boolean result = true;
        String rp = Preferences.ArcInclude ? Path.getRelativePath(fname) : Path.getFile(fname);
        try {
            ze = new ZipEntry(rp);
            ze.setTime(src.lastModified());
        }
        catch (NullPointerException npe) {
            Archiver.setMessage(rp + " forms bad zip entry " + ze.getName());
            result = false;
        }
        if (!result) {
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(dst);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(Archiver.getMethod());
            result = Archiver.putFile(zos, ze, src);
            zos.close();
            fos.close();
        }
        catch (IOException ioe) {
            Archiver.setMessage(ioe.toString());
            result = false;
        }
        return result;
    }

    private static int recurse(String path, String[] fics, ZipOutputStream zos) {
        int fl = fics.length;
        int counter = 0;
        for (int i = 0; i < fl; ++i) {
            try {
                String fullpath;
                String fname = fics[i];
                String srcpath = Path.merge(source, path);
                File src = new File(srcpath, fname);
                if (!src.exists()) {
                    System.out.println(src + " not found");
                    break;
                }
                if (insidePath && (fullpath = Path.merge(srcpath, fname)).equals(archiveName)) break;
                String dstfic = Preferences.ArcInclude ? Path.merge(path, fname) : fname;
                ZipEntry ze = null;
                boolean result = true;
                try {
                    ze = new ZipEntry(dstfic);
                    ze.setTime(src.lastModified());
                }
                catch (NullPointerException npe) {
                    Archiver.setMessage(dstfic + " forms bad zip entry ");
                    result = false;
                    error = true;
                }
                if (!result) {
                    return 0;
                }
                if (src.isDirectory()) {
                    if (!Preferences.ArcRecurse) continue;
                    counter += Archiver.recurse(Path.merge(path, fname), src.list(), zos);
                    continue;
                }
                if (!Archiver.putFile(zos, ze, src)) continue;
                ++counter;
                continue;
            }
            catch (Exception e) {
                Archiver.setMessage("Archive error - " + e.toString());
                error = true;
            }
        }
        return counter;
    }

    public static int archive(String srcpath, String[] fics, String archive) {
        String dstpath = Path.splitPath(archive);
        if (dstpath.indexOf(srcpath) != -1) {
            insidePath = true;
            archiveName = archive;
        } else {
            insidePath = false;
            archiveName = "";
        }
        File dst = new File(archive);
        int counter = 0;
        error = false;
        try {
            FileOutputStream fos = new FileOutputStream(dst);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.setMethod(Archiver.getMethod());
            source = srcpath;
            counter += Archiver.recurse("", fics, zos);
            zos.close();
            fos.close();
        }
        catch (IOException ioe) {
            Archiver.setMessage(ioe.toString());
            error = true;
        }
        return counter;
    }

    public static boolean archiveAnyFile(String fname, String arcname) {
        if (Directory.isZip(arcname)) {
            return Archiver.archiveFile(fname, arcname);
        }
        return false;
    }

    protected void dispTip(String mess) {
        if (this.actionListener == null) {
            return;
        }
        Archiver.setMessage(mess);
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, "t"));
    }

    protected void message(String mess) {
        if (this.actionListener == null) {
            return;
        }
        Archiver.setMessage(mess);
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, "m"));
    }

    public static String getMessage() {
        return messagetext;
    }

    public static void setMessage(String s) {
        messagetext = s;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    static {
        messagetext = null;
        error = false;
        insidePath = false;
        lastModified = -1L;
        messageNum = 0;
        written = 0;
        source = "";
    }
}

