/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.util.Vector;

public class CPanel
extends Panel {
    Vector vPanels;
    protected int curIndex = -1;
    private Component userPanel = null;
    private transient int osAdjustment;
    private int lastWidth = -1;

    public CPanel() {
        super.setLayout(null);
        this.vPanels = new Vector();
    }

    public void setBackground(Color b) {
        super.setBackground(b);
    }

    public void setCurrent(int index) {
        if (index == this.curIndex) {
            return;
        }
        this.curIndex = index;
    }

    public int setIndex() {
        int index = this.vPanels.size() - 1;
        if (this.curIndex == -1) {
            this.setCurrent(index);
        }
        return index;
    }

    public int addPanel(Component panel) {
        this.vPanels.addElement(panel);
        return this.setIndex();
    }

    public synchronized Component add(Component comp) {
        int newIndex = this.addPanel(comp);
        if (newIndex == this.curIndex) {
            this.select(newIndex);
        }
        this.repaint();
        return comp;
    }

    public synchronized int getPanelIndex(Component panel) {
        return this.vPanels.indexOf(panel);
    }

    public void setPanel(int index) {
        if (index == this.curIndex) {
            return;
        }
        this.select(index);
    }

    public void first() {
        this.select(0);
    }

    public void last() {
        this.select(this.vPanels.size() - 1);
    }

    public synchronized void select(int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return;
        }
        Component p = (Component)this.vPanels.elementAt(index);
        this.setCurrent(index);
        this.showPanel(p);
    }

    public void showPanel(Component p) {
        if (this.userPanel != null) {
            this.userPanel.setVisible(false);
        }
        this.userPanel = p;
        if (this.userPanel != null) {
            int x;
            Component[] comps = this.getComponents();
            int l = comps.length;
            for (x = 0; x < l && comps[x] != this.userPanel; ++x) {
            }
            if (x == l) {
                super.add(this.userPanel, -1);
            }
            this.curIndex = x;
            this.userPanel.setVisible(true);
            this.userPanel.requestFocus();
            this.validate();
            this.repaint();
        }
    }

    public synchronized Component getTabPanel(int index) {
        if (index < 0 || index >= this.vPanels.size()) {
            return null;
        }
        Component p = (Component)this.vPanels.elementAt(index);
        return p;
    }

    public void doLayout() {
        Rectangle r = this.getBounds();
        if (this.userPanel != null) {
            this.userPanel.setBounds(0, 0, r.width, r.height);
            this.userPanel.invalidate();
            this.userPanel.validate();
            this.userPanel.repaint();
            this.repaint();
        }
    }

    public void setLayout(LayoutManager mgr) {
    }

    public synchronized void addNotify() {
        super.addNotify();
    }

    public synchronized void removeNotify() {
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        Dimension p = this.getSize();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }
}

