/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;
import java.util.Vector;

public class CacheImage
implements ImageProducer {
    private ColorModel colorModel;
    private int width;
    private int height;
    private byte[] pixelByte;
    private int[] pixelInt;
    private Vector consumers = new Vector();
    Enumeration enumerate;

    public CacheImage(Image img, Component comp) {
        MediaTracker mt = new MediaTracker(comp);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
            this.width = img.getWidth(comp);
            this.height = img.getHeight(comp);
            PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, false);
            pg.grabPixels();
            this.colorModel = pg.getColorModel();
            if (this.colorModel instanceof IndexColorModel) {
                this.pixelByte = (byte[])pg.getPixels();
            } else {
                this.pixelInt = (int[])pg.getPixels();
            }
        }
        catch (InterruptedException e) {
            System.out.println("InterruptedException: " + e);
        }
    }

    public void addConsumer(ImageConsumer ic) {
        if (!this.isConsumer(ic)) {
            this.consumers.addElement(ic);
        }
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    public void removeConsumer(ImageConsumer ic) {
        this.consumers.removeElement(ic);
    }

    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        this.enumerate = this.consumers.elements();
        while (this.enumerate.hasMoreElements()) {
            ImageConsumer tempCon = (ImageConsumer)this.enumerate.nextElement();
            tempCon.setDimensions(this.width, this.height);
            tempCon.setHints(30);
            if (this.colorModel instanceof IndexColorModel) {
                tempCon.setPixels(0, 0, this.width, this.height, this.colorModel, this.pixelByte, 0, this.width);
            } else {
                tempCon.setPixels(0, 0, this.width, this.height, this.colorModel, this.pixelInt, 0, this.width);
            }
            tempCon.imageComplete(3);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }
}

