/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Component3d;
import ae.Light;
import ae.Plane;
import ae.Vertex;
import ae.Viewpoint;
import ae.Virtual3d;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class Canvas3d
extends Canvas {
    int width = 0;
    int height = 0;
    private boolean interactive = false;
    private boolean inspect = false;
    private int[] zBuffer;
    private boolean m_tAnimate = true;
    private Virtual3d virtualscreen;
    private Viewpoint viewPoint;
    Component3d world = new Component3d();
    Component3d viewworld = new Component3d();
    Component3d clippedWorld = new Component3d();
    int moveX;
    int moveY;
    int moveZ;
    Light light;
    Light origlight;
    boolean running = true;
    Plane[] frustum = new Plane[5];
    int xOffset;
    int yOffset;

    public Canvas3d() {
    }

    public Canvas3d(Viewpoint viewPoint) {
        this.viewPoint = viewPoint;
        this.viewPoint.parent = this;
        this.setLight(new Light(0.0, 10.0, 0.0));
        this.createfrustum();
    }

    public Dimension getPreferredSize() {
        return new Dimension(160, 120);
    }

    public void add(Component3d vol) {
        this.world.add(vol);
        vol.parent = this;
    }

    public void clearWorld() {
        this.world = new Component3d();
    }

    public void setLight(Light light) {
        this.light = light;
        this.origlight = new Light(light);
    }

    public void setX(int x) {
        this.moveX = x;
        if (this.moveX < 0) {
            this.moveX += 360;
        }
        this.running = true;
    }

    public void setY(int y) {
        this.moveY = y;
        if (this.moveY < 0) {
            this.moveY += 360;
        }
        this.running = true;
    }

    public void setZ(int z) {
        this.moveZ = z;
        if (this.moveZ < 0) {
            this.moveZ += 360;
        }
        this.running = true;
    }

    public void rotate() {
        this.world.rotate(this.moveY, this.moveX, this.moveZ);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Image getImage() {
        return this.virtualscreen.getImage();
    }

    private void createfrustum() {
        this.frustum[0] = new Plane();
        this.frustum[0].normal = new Vertex(0.0, -Math.sqrt(2.0), Math.sqrt(2.0));
        this.frustum[0].dist = 0.0;
        this.frustum[1] = new Plane();
        this.frustum[1].normal = new Vertex(-Math.sqrt(2.0), 0.0, Math.sqrt(2.0));
        this.frustum[1].dist = 0.0;
        this.frustum[2] = new Plane();
        this.frustum[2].normal = new Vertex(Math.sqrt(2.0), 0.0, Math.sqrt(2.0));
        this.frustum[2].dist = 0.0;
        this.frustum[3] = new Plane();
        this.frustum[3].normal = new Vertex(0.0, Math.sqrt(2.0), Math.sqrt(2.0));
        this.frustum[3].dist = 0.0;
        this.frustum[4] = new Plane();
        this.frustum[4].normal = new Vertex(0.0, 0.0, 1.0);
        this.frustum[4].dist = 2.0;
    }

    private void makeViewWorld(Viewpoint viewPoint) {
        Vertex diff1 = new Vertex();
        this.viewworld = new Component3d(this.world);
        diff1.x = -viewPoint.from.x;
        diff1.y = -viewPoint.from.y;
        diff1.z = -viewPoint.from.z;
        this.viewworld.translate(diff1);
        this.viewworld.rotate(viewPoint.o1);
        this.light = new Light(this.origlight);
        this.light.translate(diff1);
        this.light.rotate(viewPoint.o1);
    }

    public void setVirtualSize(int w, int h) {
        this.width = w;
        this.height = h;
        this.virtualscreen = new Virtual3d(this, w * 3 / 4, h * 3 / 4);
        this.xOffset = w / 8;
        this.yOffset = h / 8;
    }

    public void update(Graphics g) {
        if (!this.running) {
            return;
        }
        if (this.virtualscreen != null) {
            this.virtualscreen.clear();
            this.paint(g);
        }
        this.running = false;
    }

    public void paint(Graphics g) {
        if (this.height == 0 || this.width == 0) {
            this.setVirtualSize(this.size().width, this.size().height);
        }
        if (this.world != null) {
            this.makeViewWorld(this.viewPoint);
            this.clippedWorld = this.viewworld.clipworld(this.frustum);
            this.clippedWorld.toScreen(this.width, this.height);
            this.clippedWorld.depthOrder(this.viewPoint);
            if (this.virtualscreen != null) {
                this.clippedWorld.drawVirtual(this.virtualscreen);
                g.setColor(Color.green);
                g.fillRect(0, 0, this.width, this.height);
                g.drawImage(this.virtualscreen.getImage(), this.xOffset, this.yOffset, this);
            }
        }
    }
}

