/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Choice;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ColorList {
    static ColorModel colorModel = null;
    static final int MAXCOL = 40;
    static String[] nom = new String[]{"control", "controlText", "window", "windowText", "black", "blue", "green", "cyan", "red", "magenta", "brown", "lightGray", "gray", "lightBlue", "lightGreen", "lightCyan", "lightRed", "lightMagenta", "yellow", "white", "orange", "pink", "sepia", "slate", "slateLight", "aubergine", "pumpkin", "sand", "sandLight", "picea", "piceaLight", "lilac", "user"};
    static byte[] r = new byte[40];
    static byte[] g = new byte[40];
    static byte[] b = new byte[40];
    static Color[] couleur = new Color[]{SystemColor.control, SystemColor.controlText, SystemColor.window, SystemColor.windowText, Color.black, new Color(0, 0, 164), new Color(0, 164, 0), Color.cyan.darker(), new Color(164, 0, 0), new Color(164, 0, 164), new Color(160, 128, 64), Color.lightGray, Color.gray, Color.blue, Color.green, Color.cyan, Color.red, Color.magenta, Color.yellow, Color.white, Color.orange, Color.pink, new Color(192, 192, 128), new Color(160, 184, 200), new Color(168, 200, 224), new Color(144, 176, 168), new Color(240, 216, 160), new Color(216, 208, 184), new Color(224, 224, 208), new Color(160, 200, 168), new Color(168, 224, 184), new Color(176, 168, 216), new Color(195, 195, 195)};

    public ColorList() {
        for (int i = 0; i < couleur.length; ++i) {
            ColorList.setComponents(i);
        }
        ColorList.setModel();
    }

    static void setModel() {
        colorModel = new IndexColorModel(8, r.length, r, g, b);
    }

    static void setComponents(int i) {
        int rgb = couleur[i].getRGB();
        ColorList.r[i] = (byte)(rgb >> 16 & 0xFF);
        ColorList.g[i] = (byte)(rgb >> 8 & 0xFF);
        ColorList.b[i] = (byte)(rgb & 0xFF);
    }

    public static int Size() {
        return nom.length;
    }

    public static String GetString(int index) {
        return nom[index];
    }

    public static String[] ChoiceList() {
        return nom;
    }

    static Color getColor(int index) {
        if (colorModel == null) {
            ColorList.setModel();
        }
        int red = colorModel.getRed(index);
        int green = colorModel.getGreen(index);
        int blue = colorModel.getBlue(index);
        return new Color(red, green, blue);
    }

    public static Color getColor(String key) {
        for (int i = 0; i < nom.length; ++i) {
            if (!nom[i].equalsIgnoreCase(key)) continue;
            return ColorList.getColor(i);
        }
        return Color.lightGray;
    }

    public static int getRed(int i) {
        return Math.abs(r[i]);
    }

    public static int getGreen(int i) {
        return Math.abs(r[i]);
    }

    public static int getBlue(int i) {
        return Math.abs(r[i]);
    }

    public static void fillChoice(Choice box) {
        for (int i = 0; i < nom.length; ++i) {
            box.add(nom[i]);
        }
    }

    public static int getIndex(String key) {
        for (int i = 0; i < nom.length; ++i) {
            if (!nom[i].equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    public static void changeColor(int index, Color color) {
        if (index >= 0 && index < couleur.length) {
            ColorList.couleur[index] = color;
            ColorList.setComponents(index);
            ColorList.setModel();
        } else {
            System.out.println("Bad color index " + index);
        }
    }

    public static void changeColor(String color, Color col) {
        ColorList.changeColor(ColorList.getIndex(color), col);
    }

    public static String getName(Color c) {
        int rgb = c.getRGB();
        for (int i = 0; i < couleur.length; ++i) {
            if (i >= nom.length || rgb != couleur[i].getRGB()) continue;
            return nom[i];
        }
        return "LightGray";
    }
}

