/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Orient;
import ae.Plane;
import ae.Polygon3d;
import ae.Vertex;
import ae.Viewpoint;
import ae.Virtual3d;
import java.awt.Component;

public class Component3d {
    Component parent;
    Polygon3d[] poly = new Polygon3d[100];
    int polyCount = 0;

    public Component3d() {
    }

    public Component3d(Component3d v) {
        for (int i = 0; i < v.poly.length; ++i) {
            if (v.poly[i] == null) continue;
            this.poly[i] = new Polygon3d(v.poly[i]);
        }
        this.polyCount = v.polyCount;
    }

    public void add(Polygon3d p) {
        this.poly[this.polyCount++] = new Polygon3d(p);
    }

    public void add(Component3d v) {
        for (int i = 0; i < v.polyCount; ++i) {
            this.poly[this.polyCount++] = v.poly[i];
        }
    }

    public void rotate(int a, int b, int c) {
        this.rotate(new Orient(a, b, c));
    }

    public void rotate(Orient o1) {
        for (int i = 0; i < this.polyCount; ++i) {
            this.poly[i].rotate(o1);
        }
    }

    public void translate(Vertex disp1) {
        for (int i = 0; i < this.polyCount; ++i) {
            this.poly[i].translate(disp1);
        }
    }

    public void depthOrder(Viewpoint vp) {
        Polygon3d temp = new Polygon3d();
        for (int i = this.polyCount - 2; i >= 0; --i) {
            for (int j = 0; j <= i; ++j) {
                boolean isCorrectOrder = false;
                if (this.poly[j].minz >= this.poly[j + 1].maxz) {
                    isCorrectOrder = true;
                } else if (!(this.poly[j].maxz < this.poly[j + 1].minz)) {
                    double planeDist = this.poly[j + 1].normal.dotproduct(this.poly[j + 1].p[0]);
                    for (int k = 0; k < this.poly[j].vertcount && !isCorrectOrder; ++k) {
                        if (!(this.poly[j + 1].normal.dotproduct(this.poly[j].p[k]) < planeDist)) continue;
                        isCorrectOrder = true;
                    }
                }
                if (isCorrectOrder) continue;
                temp = this.poly[j];
                this.poly[j] = this.poly[j + 1];
                this.poly[j + 1] = temp;
            }
        }
    }

    public void toScreen(int w, int h) {
        int midwidth = w / 2;
        int midheight = h / 2;
        for (int i = 0; i < this.polyCount; ++i) {
            double minz = 1.0E7;
            double maxz = 0.0;
            for (int j = 0; j < this.poly[i].vertcount; ++j) {
                double z = this.poly[i].p[j].z;
                if (z < minz) {
                    minz = z;
                }
                if (z > maxz) {
                    maxz = z;
                }
                this.poly[i].spx[j] = (int)((double)midwidth + (double)midwidth * (this.poly[i].p[j].x / z));
                this.poly[i].spy[j] = (int)((double)midheight - (double)midwidth * (this.poly[i].p[j].y / z));
            }
            this.poly[i].minz = minz;
            this.poly[i].maxz = maxz;
        }
    }

    public Component3d clipworld(Plane[] frustum) {
        Component3d clippedworld = new Component3d();
        for (int i = 0; i < this.polyCount; ++i) {
            boolean oneoutside = false;
            boolean infrustum = true;
            if (this.poly[i].p[0].dotproduct(this.poly[i].normal) > 0.0) {
                infrustum = false;
            } else {
                for (int j = 0; j < this.poly[i].vertcount && !oneoutside; ++j) {
                    if (this.poly[i].p[j].z <= 2.0) {
                        oneoutside = true;
                        continue;
                    }
                    if (this.poly[i].p[j].z <= Math.abs(this.poly[i].p[j].x)) {
                        oneoutside = true;
                        continue;
                    }
                    if (!(this.poly[i].p[j].z <= Math.abs(this.poly[i].p[j].y))) continue;
                    oneoutside = true;
                }
                if (oneoutside && (infrustum = this.poly[i].clipback(frustum[0])) && (infrustum = this.poly[i].clipback(frustum[1])) && (infrustum = this.poly[i].clipback(frustum[2])) && (infrustum = this.poly[i].clipback(frustum[3]))) {
                    infrustum = this.poly[i].clipback(frustum[4]);
                }
            }
            if (!infrustum) continue;
            clippedworld.add(this.poly[i]);
        }
        return clippedworld;
    }

    public void drawVirtual(Virtual3d g3d) {
        for (int i = 0; i < this.polyCount; ++i) {
            this.poly[i].paint(g3d);
        }
    }
}

