/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Bevel;
import ae.ColorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Vector;

public class DBPanel
extends Panel
implements ContainerListener,
Bevel {
    public static final int BEVEL_NONE = 0;
    public static final int BEVEL_LINE = 1;
    public static final int BEVEL_LOWERED = 2;
    public static final int BEVEL_RAISED = 3;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTERED = 1;
    public static final int ALIGN_RIGHT = 2;
    Dimension oldSize = new Dimension();
    protected static final int labelpadx = 10;
    protected static final int labelipadx = 4;
    protected Color borderColor = Color.black;
    protected Color bevelLighterColor;
    protected Color bevelDarkerColor;
    protected Color labelColor = Color.black;
    protected int padtop = 2;
    protected int padbottom = 2;
    protected int padleft = 2;
    protected int padright = 2;
    protected int ixPadLeft = 2;
    protected int ixPadRight = 2;
    protected int iyPadTop = 2;
    protected int iyPadBottom = 2;
    protected int style;
    protected String label;
    protected int labelAlignment;
    protected Insets internalInsets;
    protected Panel panel;
    private Vector cListeners = null;

    public DBPanel() {
        this(null, 1, 1);
    }

    public DBPanel(int style) {
        this(null, 1, style);
    }

    public DBPanel(String s) {
        this(s, 0, 1);
    }

    public DBPanel(String s, int alignment) {
        this(s, alignment, 1);
    }

    public DBPanel(String s, int alignment, int style) {
        this.label = s != null && s.length() == 0 ? null : s;
        this.labelAlignment = alignment;
        this.internalInsets = new Insets(2, 2, 2, 2);
        this.style = style;
        super.setLayout(null);
        this.panel = new Panel();
        super.add(this.panel);
        this.sizepanel(true);
        this.cListeners = new Vector();
        this.setLayout(null);
    }

    public void setPadding(int top, int bottom, int left, int right) {
        this.padtop = top;
        this.padbottom = bottom;
        this.padleft = left;
        this.padright = right;
        this.sizepanel(true);
        this.invalidate();
    }

    public void setIPadding(int l, int t, int r, int b) {
        this.ixPadLeft = l;
        this.ixPadRight = r;
        this.iyPadTop = t;
        this.iyPadBottom = b;
        this.sizepanel(true);
        this.invalidate();
    }

    public void setInternalInsets(Insets newInsets) {
        this.internalInsets = newInsets;
        this.sizepanel(true);
        this.invalidate();
    }

    public Insets getInternalInsets() {
        return this.internalInsets;
    }

    public void setLabel(String newLabel) {
        if (newLabel != null && newLabel.length() == 0) {
            newLabel = null;
        }
        this.label = newLabel;
        this.sizepanel(true);
        this.repaint();
    }

    public void setBorderColor(Color newBorderColor) {
        this.borderColor = newBorderColor;
        this.repaint();
    }

    public void setLabelColor(Color newLabelBorderColor) {
        this.labelColor = newLabelBorderColor;
        this.repaint();
    }

    public void setAlignStyle(int newLabelAlignment) {
        this.labelAlignment = newLabelAlignment;
        this.sizepanel(true);
        this.repaint();
    }

    public void setBevelStyle(int newBevelStyle) {
        this.style = newBevelStyle;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension p = this.getSize();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public void setLayout(LayoutManager l) {
        if (this.panel != null) {
            this.panel.setLayout(l);
        }
    }

    public Component getComponent(int i) {
        return this.panel.getComponent(i);
    }

    public Component[] getComponents() {
        return this.panel.getComponents();
    }

    public int getComponentCount() {
        return this.panel.getComponentCount();
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.sizepanel(true);
        if (this.panel != null) {
            this.panel.addContainerListener(this);
        }
    }

    public synchronized void removeNotify() {
        if (this.panel != null) {
            this.panel.removeContainerListener(this);
        }
        super.removeNotify();
    }

    public void doLayout() {
        this.sizepanel(false);
        this.panel.doLayout();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == this.panel) {
            super.addImpl(comp, constraints, index);
        } else {
            this.panel.add(comp, constraints, index);
        }
    }

    public void remove(int index) {
        this.panel.remove(index);
    }

    public void remove(Component comp) {
        this.panel.remove(comp);
    }

    public void removeAll() {
        this.panel.removeAll();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.sizepanel(false);
    }

    public void update(Graphics g) {
        Dimension s = this.getSize();
        Insets insets = this.getInsets();
        g.setColor(this.getBackground());
        if (insets.left > 0) {
            g.fillRect(0, 0, insets.left, s.height);
        }
        if (insets.top > 0) {
            g.fillRect(0, 0, s.width, insets.top);
        }
        if (insets.bottom > 0) {
            g.fillRect(0, s.height - insets.bottom, s.width, insets.bottom);
        }
        if (insets.right > 0) {
            g.fillRect(s.width - insets.right, 0, insets.right, s.height);
        }
        this.paint(g);
        this.panel.repaint();
    }

    public int getComponentsCount() {
        return this.panel.getComponentCount();
    }

    public Insets getInsets() {
        int h = this.getLabelTopMargin();
        Insets insets = this.getInternalInsets();
        return new Insets(h + insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
    }

    public void setInnerBackground(Color c) {
        this.panel.setBackground(c);
    }

    public void componentAdded(ContainerEvent e) {
        if (e.getSource() == this.panel) {
            for (int i = 0; i < this.cListeners.size(); ++i) {
                ((ContainerListener)this.cListeners.elementAt(i)).componentAdded(new ContainerEvent(this, 300, e.getChild()));
            }
        }
    }

    public void componentRemoved(ContainerEvent e) {
        if (e.getSource() == this.panel) {
            for (int i = 0; i < this.cListeners.size(); ++i) {
                ((ContainerListener)this.cListeners.elementAt(i)).componentRemoved(new ContainerEvent(this, 301, e.getChild()));
            }
        }
    }

    public void addContainerListener(ContainerListener l) {
        if (this.panel != null) {
            this.panel.addContainerListener(l);
            this.cListeners.addElement(l);
        }
    }

    public void removeContainerListener(ContainerListener l) {
        if (this.panel != null) {
            this.panel.removeContainerListener(l);
            this.cListeners.removeElement(l);
        }
    }

    protected void sizepanel(boolean force) {
        Dimension s = this.getSize();
        if (force || this.oldSize.width != s.width || this.oldSize.height != s.height) {
            this.oldSize = s;
            this.panel.setBounds(this.padleft + this.ixPadLeft, this.getLabelTopMargin() + this.iyPadTop, s.width - this.padright - this.padleft - this.ixPadLeft - this.ixPadRight - 1, s.height - this.padbottom - this.getLabelTopMargin() - this.iyPadBottom - this.iyPadTop - 1);
        }
    }

    protected void draw(Graphics g) {
        Dimension s = this.getSize();
        int delta = this.padtop;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (this.label != null && fm != null) {
            delta = (fm.getAscent() + fm.getDescent() + this.padtop) / 2;
        }
        int x = this.padleft;
        int y = delta;
        int w = s.width - this.padleft - this.padright - 1;
        int h = s.height - 1 - delta - this.padbottom;
        this.drawBorder(g, x, y, w, h);
        this.drawLabel(g, fm);
    }

    protected void drawBorder(Graphics g, int x, int y, int w, int h) {
        switch (this.style) {
            case 3: {
                g.setColor(this.bevelLighterColor);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.bevelDarkerColor);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 2: {
                g.setColor(this.bevelDarkerColor);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.bevelLighterColor);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 1: {
                g.setColor(this.borderColor);
                g.drawRect(x, y, w, h);
                break;
            }
        }
    }

    protected void drawLabel(Graphics g, FontMetrics fm) {
        if (this.label != null && fm != null) {
            int x;
            int fWidth = 10;
            Dimension s = this.getSize();
            if (this.getFont().getSize() > fWidth) {
                fWidth += this.getFont().getSize() / 2;
            }
            int stringWidth = fm.stringWidth(this.label);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            switch (this.labelAlignment) {
                case 1: {
                    x = (s.width - stringWidth) / 2;
                    break;
                }
                case 2: {
                    x = s.width - fWidth - (stringWidth + 7);
                    break;
                }
                default: {
                    x = fWidth + 7;
                }
            }
            int h = ascent + descent + this.padtop;
            int y = (fWidth - h) / 2 + (this.padtop + ascent);
            g.setColor(this.getBackground());
            g.fillRect(x - 2, y - 1 - ascent - this.padtop / 2, stringWidth + 4, h);
            g.setColor(this.labelColor);
            g.drawString(this.label, x, y - 1);
        }
    }

    public void paint(Graphics g) {
        this.sizepanel(false);
        Color curBackground = this.getBackground();
        this.calculateHilightColors(curBackground);
        g.setColor(curBackground);
        this.draw(g);
    }

    protected int getLabelTopMargin() {
        if (this.label == null) {
            return this.padtop;
        }
        int top = this.padtop;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            top = fm.getAscent() + fm.getDescent() + this.padtop + 0;
        }
        return top;
    }

    protected int getLabelWidthMargin() {
        if (this.label == null) {
            return 0;
        }
        int w = 2 + this.internalInsets.left + this.internalInsets.right;
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fm = this.getFontMetrics(font);
            w = Math.max(w, 2 + fm.stringWidth(this.label) + 10 + 4);
        }
        return w;
    }

    protected void calculateHilightColors(Color c) {
        this.bevelLighterColor = ColorUtils.calculateHilightColor(c);
        this.bevelDarkerColor = ColorUtils.calculateShadowColor(c);
    }
}

