/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DBarSpacer;
import ae.DSeparator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class DBar
extends Container {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int LINE = 3;
    public static final int SEPARED = 4;
    protected int style;
    protected Color dark;
    protected Color light;
    protected int width;
    protected int height;
    protected Insets insets = new Insets(1, 1, 1, 1);

    public DBar() {
        this(3);
    }

    public DBar(int s) {
        this.style = s;
    }

    public void setBevelStyle(int s) {
        this.style = s;
    }

    public void setInsets(Insets in) {
        this.insets = in;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void addSeparator(int w, int h) {
        this.add(new DSeparator(w, h));
    }

    public void addSpacer(int w, int h) {
        this.add(new DBarSpacer(w, h));
    }

    public void setHeight(int h) {
        this.addSpacer(0, h);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        this.width = dim.width;
        this.height = dim.height;
        Color bg = this.getBackground();
        this.light = bg.brighter();
        this.dark = bg.darker();
        g.setColor(bg);
        int x = this.insets.left;
        int y = this.insets.top;
        g.fillRect(x, y, this.width - x - this.insets.right, this.height - y - this.insets.bottom);
        this.drawBorder(g, 0, 0, this.width - 1, this.height - 1);
        super.paint(g);
    }

    protected void drawBorder(Graphics g, int x, int y, int w, int h) {
        switch (this.style) {
            case 1: {
                g.setColor(this.light);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.dark);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 2: {
                g.setColor(this.dark);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.light);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 3: {
                g.setColor(this.getForeground());
                g.drawRect(x, y, w, h);
                break;
            }
            case 4: {
                g.setColor(this.dark);
                g.drawLine(x, y, x + w, y);
                break;
            }
            case 0: {
                break;
            }
        }
    }
}

