/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Effect;
import ae.Timer;
import ae.Tip;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class DButton
extends Component {
    String label;
    String imageURL;
    Image image;
    Image imageNormal;
    Image imageGrayed;
    boolean inButton = false;
    boolean pressed = false;
    boolean bFixed = false;
    static int DefaultWidth;
    static int DefaultHeight;
    static Font DefaultFont;
    int Width = DefaultWidth;
    int Height = DefaultHeight;
    int ImageZoneWidth = 0;
    int ImageZoneHeight = 0;
    static final int NONE = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int NORTH = 4;
    static final int CENTER = 5;
    int labelPosition = 5;
    static boolean ADJUSTSIZE;
    static boolean ADJUSTMAX;
    String actionCommand;
    private DMouse mouse = null;
    ActionListener actionListener = null;
    public Timer notifyTimer = null;
    public int notifyDelay = 1000;
    public boolean notifyWhilePressed = false;
    public transient boolean running = false;
    public transient boolean notified = false;
    public transient boolean released = true;
    Tip tip = null;
    boolean state = true;

    public DButton() {
        this.setFont(DefaultFont);
    }

    public DButton(boolean b) {
        this();
        this.bFixed = b;
    }

    public DButton(Image img) {
        this();
        this.imageNormal = img;
        this.imageGrayed = img;
        this.setup();
    }

    public DButton(Image img, Image gray) {
        this();
        this.imageNormal = img;
        this.imageGrayed = gray;
        this.setup();
    }

    public DButton(Image img, String lab) {
        this();
        this.label = lab;
        this.labelPosition = 1;
        this.imageNormal = img;
        this.imageGrayed = img;
        this.setup();
    }

    public DButton(String img, String lab, int labpos) {
        this();
        this.imageGrayed = this.imageNormal = Toolkit.getDefaultToolkit().getImage(img);
        this.label = lab;
        this.labelPosition = labpos;
        this.setup();
    }

    public DButton(String img, String lab) {
        this(img, lab, 1);
    }

    public DButton(String nomimage) {
        this();
        this.imageGrayed = this.imageNormal = Toolkit.getDefaultToolkit().getImage(nomimage);
        this.setup();
    }

    public DButton(String lab, boolean fixed) {
        this();
        this.label = lab;
        this.labelPosition = 5;
        this.bFixed = fixed;
    }

    public DButton(Image img, String lab, boolean fixed) {
        this(img, lab);
        this.labelPosition = 1;
        this.bFixed = fixed;
    }

    public void setLabelPosition(int p) {
        if (p >= 0 && p <= 5) {
            this.labelPosition = p;
        }
    }

    public static void setDefaultFont(Font f) {
        DefaultFont = f;
    }

    public void setImage(Image img) {
        this.image = img;
        if (this.image.getWidth(this) == -1 || this.image.getHeight(this) == -1) {
            this.ensureImageLoaded(this.image);
        }
        this.repaint();
    }

    public void setLabel(String lab) {
        this.setLabel(lab, false);
    }

    public void setLabel(String lab, boolean resize) {
        this.label = lab;
        if (resize) {
            int w = this.getFontMetrics(this.getFont()).stringWidth(this.label);
            this.setSize(w + 8, this.Height);
        }
        this.repaint();
    }

    private void neededSize(Graphics g) {
        int wl = 0;
        int hl = 0;
        int wi = 0;
        int hi = 0;
        if (!ADJUSTSIZE) {
            return;
        }
        if (this.image != null) {
            int imageWidth = this.image.getWidth(this) + 4;
            wi = this.Width > imageWidth ? this.Width : imageWidth;
            int imageHeight = this.image.getHeight(this) + 4;
            hi = this.Height > imageHeight ? this.Height : imageHeight;
        }
        int nw = wi;
        int nh = hi;
        if (this.label != null) {
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            hl = fm.getHeight() + 4;
            wl = fm.stringWidth(this.label) + 6;
            if (this.labelPosition == 1) {
                nw = wl + wi;
                nh = hi > hl ? hi : hl;
            } else if (this.labelPosition == 2) {
                nw = wi > wl ? wi : wl;
                nh = hi + hl;
            }
        }
        if (ADJUSTMAX) {
            if (nw > this.Width) {
                this.Width = nw;
            }
            if (nh > this.Height) {
                this.Height = nh;
            }
        } else {
            this.Width = nw;
            this.Height = nh;
        }
    }

    private void CalculateZones(int iw, int ih, int lw, int lh) {
        this.ImageZoneWidth = 0;
        this.ImageZoneHeight = 0;
        if (this.labelPosition == 1) {
            this.ImageZoneWidth = this.Width * iw / (iw + lw + 8 + 1);
        } else if (this.labelPosition == 2) {
            this.ImageZoneHeight = this.Height * ih / (ih + lh + 8 + 1);
        }
    }

    public Dimension adjustSize(Graphics g) {
        if (g != null) {
            this.neededSize(g);
        }
        return new Dimension(this.Width, this.Height);
    }

    public void setSize(int w, int h) {
        this.Width = w;
        this.Height = h;
        if (ADJUSTSIZE) {
            this.neededSize(this.getGraphics());
        }
        super.setSize(this.Width, this.Height);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.Width = w;
        this.Height = h;
        if (ADJUSTSIZE) {
            this.neededSize(this.getGraphics());
        }
        super.setBounds(x, y, w, h);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        boolean labelpresent = false;
        if (this.isShowing()) {
            if (!this.isEnabled()) {
                this.inButton = false;
                this.pressed = false;
            }
            Dimension mySize = this.getSize();
            int w = mySize.width - 2;
            int h = mySize.height - 2;
            this.Width = w;
            this.Height = h;
            int lw = 0;
            int lh = 0;
            Color BorderLight = null;
            Color BorderDark = null;
            Color BackColor = this.getBackground();
            Color pressedBackColor = Effect.darken(BackColor, 0.1);
            g.setColor(BackColor);
            boolean drawBorders = false;
            int padding = 0;
            if (this.inButton && this.pressed) {
                BorderLight = BackColor.darker();
                BorderDark = BackColor.brighter();
                g.setColor(pressedBackColor);
                drawBorders = true;
                padding = 0;
            } else if (this.inButton || this.bFixed) {
                BorderLight = BackColor.brighter();
                BorderDark = BackColor.darker();
                drawBorders = true;
                padding = -1;
            }
            g.fillRect(1, 1, w - 2, h - 2);
            if (drawBorders) {
                int x = 1;
                int y = 1;
                int xr = x + w - 1;
                int yb = y + h - 1;
                g.setColor(Color.black);
                g.drawRect(x - 1, y - 1, xr + 1, yb + 1);
                g.setColor(BorderLight);
                g.drawLine(x, y, xr, y);
                g.drawLine(x, y, x, yb);
                g.setColor(BorderDark);
                g.drawLine(x, yb, xr, yb);
                g.drawLine(xr, y, xr, yb);
            }
            if (this.label != null && this.label.length() > 0) {
                labelpresent = true;
                g.setFont(this.getFont());
                FontMetrics fm = g.getFontMetrics();
                lh = fm.getHeight();
                lw = fm.stringWidth(this.label) + 6;
            }
            int xImg = 0;
            int yImg = 0;
            this.image = this.isEnabled() ? this.imageNormal : this.imageGrayed;
            if (this.image != null) {
                int iw = this.image.getWidth(this) + 4;
                int ih = this.image.getHeight(this) + 4;
                if (labelpresent) {
                    this.CalculateZones(iw, ih, lw, lh);
                    if (this.labelPosition == 1) {
                        xImg = (this.ImageZoneWidth - iw) / 2 + 4;
                        yImg = (h - ih) / 2 + 2;
                    } else if (this.labelPosition == 2) {
                        xImg = (w - iw) / 2 + 4;
                        yImg = (this.ImageZoneHeight - ih) / 2 + 2;
                    }
                } else {
                    xImg = (w - iw) / 2 + 4;
                    yImg = (h - ih) / 2 + 4;
                }
                if (this.isEnabled() || labelpresent) {
                    g.drawImage(this.image, xImg + padding, yImg + padding, this);
                } else {
                    g.drawImage(this.image, xImg * 4 / 3 + padding - 1, yImg * 4 / 3 + padding - 1, iw * 3 / 4, ih * 3 / 4, this);
                }
            }
            if (labelpresent) {
                int xLab = 0;
                int yLab = 0;
                int YLoff = 14;
                if (this.labelPosition == 2) {
                    xLab = (w - lw) / 2 + 3;
                    yLab = this.ImageZoneHeight + (h - this.ImageZoneHeight - lh) / 2 + YLoff + 2;
                } else {
                    yLab = (h - lh) / 2 + YLoff + 2;
                    if (this.labelPosition == 1) {
                        xLab = this.ImageZoneWidth + (w - this.ImageZoneWidth - lw) / 2 + 3;
                    } else if (this.labelPosition == 5) {
                        xLab = (w - lw) / 2 + 4;
                    }
                }
                if (this.isEnabled()) {
                    g.setColor(this.getForeground());
                    g.drawString(this.label, xLab + padding, yLab + padding);
                } else {
                    g.setColor(Color.white);
                    g.drawString(this.label, xLab + padding + 1, yLab + padding + 1);
                    g.setColor(this.getBackground().darker());
                    g.drawString(this.label, xLab + padding, yLab + padding);
                }
            }
        }
    }

    private final void ensureImageLoaded(Image image) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final void setup() {
        if (this.image != null && (this.image.getWidth(this) == -1 || this.image.getHeight(this) == -1)) {
            this.ensureImageLoaded(this.image);
        }
    }

    public static void setDefaultSize(int w, int h) {
        DefaultWidth = w;
        DefaultHeight = h;
    }

    public void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addNotify() {
        super.addNotify();
        Dimension d = this.getSize();
        if (d.width == 0 || d.height == 0) {
            this.setSize(this.adjustSize(this.getGraphics()));
        }
        if (this.mouse == null) {
            this.mouse = new DMouse();
            this.addMouseListener(this.mouse);
        }
    }

    public void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        super.removeNotify();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.getSize().width != 0 && this.getSize().height != 0) {
            return this.getSize();
        }
        return this.adjustSize(this.getGraphics());
    }

    public void setEnabled(boolean s) {
        if (this.state != s) {
            this.state = s;
            super.setEnabled(s);
            this.repaint();
        }
    }

    public void setTip(String str) {
        this.tip = new Tip(this, str);
    }

    static {
        DefaultFont = new Font("Dialog", 0, 14);
        ADJUSTSIZE = false;
        ADJUSTMAX = false;
    }

    class DMouse
    extends MouseAdapter
    implements Serializable {
        DMouse() {
        }

        public void mousePressed(MouseEvent e) {
            DButton.this.notified = false;
            if (DButton.this.notifyTimer != null && DButton.this.notifyWhilePressed && !DButton.this.running) {
                DButton.this.running = true;
                DButton.this.notifyTimer.start();
            }
            DButton.this.pressed = true;
            DButton.this.released = false;
            if (DButton.this.tip != null) {
                DButton.this.tip.hideIt();
            }
            DButton.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (DButton.this.notifyTimer != null && DButton.this.running) {
                DButton.this.running = false;
                DButton.this.notifyTimer.stop();
            }
            if (DButton.this.pressed) {
                DButton.this.pressed = false;
                if (!DButton.this.notifyWhilePressed || !DButton.this.notified) {
                    DButton.this.sourceActionEvent();
                }
            }
            DButton.this.released = true;
            if (DButton.this.tip != null) {
                DButton.this.tip.hideIt();
            }
            if (DButton.this.inButton) {
                DButton.this.repaint();
            }
        }

        public void mouseEntered(MouseEvent e) {
            DButton.this.inButton = true;
            if (!DButton.this.released) {
                DButton.this.pressed = true;
                if (DButton.this.notifyTimer != null && DButton.this.notifyWhilePressed && !DButton.this.running) {
                    DButton.this.running = true;
                    DButton.this.notifyTimer.start();
                }
            }
            DButton.this.repaint();
            if (DButton.this.tip != null) {
                DButton.this.tip.showIt();
            }
        }

        public void mouseExited(MouseEvent e) {
            DButton.this.inButton = false;
            DButton.this.pressed = false;
            if (DButton.this.notifyTimer != null && DButton.this.running) {
                DButton.this.running = false;
                DButton.this.notifyTimer.stop();
            }
            if (DButton.this.tip != null) {
                DButton.this.tip.hideIt();
            }
            DButton.this.repaint();
        }
    }
}

