/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorUtils;
import ae.Effect;
import ae.OS;
import ae.Timer;
import ae.Tip;
import java.applet.AppletContext;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;

public abstract class DButtonBase
extends Canvas {
    String label;
    boolean blackBorder = false;
    boolean incrustedBorder = false;
    boolean comboExtension = false;
    Color extendDark = null;
    Color extendLight = null;
    Color borderLight = null;
    Color borderDark = null;
    Color parentColor = null;
    Tip tip = null;
    protected transient boolean pressed = false;
    protected transient boolean released = true;
    protected transient boolean inButton;
    protected boolean notifyWhilePressed = false;
    protected transient boolean running = false;
    protected transient boolean notified = false;
    protected boolean showFocus = false;
    protected boolean useOffset = true;
    protected boolean showURLStatus = true;
    protected transient boolean isAdded = false;
    protected int bevel = 1;
    protected int notifyDelay = 1000;
    protected int pressedAdjustment = 0;
    protected String frame = null;
    protected Color borderColor;
    protected Color buttonColor = Color.black;
    protected Timer notifyTimer = null;
    protected transient Image buttonImage = null;
    protected transient Graphics biG = null;
    protected URL linkURL = null;
    protected transient AppletContext context = null;
    String actionCommand;
    ActionListener actionListener = null;
    transient boolean hasFocus = false;
    private Color hilightColor = null;
    private Color pressedHilightColor = null;
    private Color disabledHilightColor = null;
    private Color shadowColor = null;
    private Color pressedShadowColor = null;
    private Color disabledShadowColor = null;
    private Color disabledBorderColor = null;
    private Color disabledButtonColor = null;
    private Color pressedButtonColor = null;
    private BBKey key = null;
    private BBFocus focus = null;
    private Action action = new Action();
    private BBMouse mouse = null;

    protected DButtonBase() {
        if (OS.isWindows()) {
            this.setShowFocus(true);
        }
    }

    public void setStyle(boolean border, boolean incrusted, int bevel) {
        this.setBorderEnabled(border);
        this.setIncrustedEnabled(incrusted);
        this.setBevelHeight(bevel);
    }

    public void setBorderEnabled(boolean b) {
        this.blackBorder = b;
        if (b) {
            this.borderDark = Color.black;
            this.borderLight = Color.black;
        }
    }

    public void setIncrustedEnabled(boolean i) {
        this.incrustedBorder = i;
    }

    public void setIncrustedBorder() {
        if (this.incrustedBorder) {
            this.borderDark = ColorUtils.darken(this.parentColor, 0.4);
            this.borderLight = ColorUtils.lighten(this.parentColor, 0.4);
        } else {
            this.borderDark = Color.black;
            this.borderLight = Color.black;
        }
    }

    public void setComboEnabled(boolean e) {
        this.comboExtension = e;
        if (e) {
            this.setComboColors(this.buttonColor);
        }
    }

    public void setComboColors(Color c) {
        this.extendDark = ColorUtils.darken(c, 0.4);
        this.extendLight = ColorUtils.lighten(c, 0.5);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!DButtonBase.objectsEqual(this.buttonColor, color)) {
            this.buttonColor = color;
            this.hilightColor = ColorUtils.lighten(this.buttonColor, 0.5);
            this.pressedHilightColor = Effect.darken(this.buttonColor, 0.58);
            this.disabledHilightColor = Effect.lighten(this.buttonColor, 0.666);
            this.shadowColor = ColorUtils.darken(this.buttonColor, 0.4);
            this.pressedShadowColor = Effect.darken(this.buttonColor, 0.1);
            this.disabledShadowColor = Effect.darken(this.buttonColor, 0.166);
            this.disabledButtonColor = Effect.lighten(this.buttonColor, 0.3333333333333333);
            this.pressedButtonColor = Effect.darken(this.buttonColor, 0.1);
        }
    }

    public void setBevelHeight(int b) {
        this.bevel = b;
    }

    public int getBevelHeight() {
        return this.bevel;
    }

    public void setNotifyWhilePressed(boolean flag) {
        if (this.notifyWhilePressed != flag) {
            this.notifyWhilePressed = flag;
            if (this.notifyWhilePressed) {
                this.notifyTimer = new Timer(this.notifyDelay, true);
                this.notifyTimer.addActionListener(this.action);
            } else if (this.notifyTimer != null) {
                this.notifyTimer = null;
            }
        }
    }

    public boolean isNotifyWhilePressed() {
        return this.notifyWhilePressed;
    }

    public void setNotifyDelay(int delay) {
        if (this.notifyDelay != delay) {
            this.notifyDelay = delay;
            if (this.notifyTimer != null) {
                this.notifyTimer.setDelay(this.notifyDelay);
            }
        }
    }

    public int getNotifyDelay() {
        return this.notifyDelay;
    }

    public void setUseOffset(boolean flag) {
        this.useOffset = flag;
    }

    public boolean isUseOffset() {
        return this.useOffset;
    }

    public void setShowFocus(boolean flag) {
        this.showFocus = flag;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowURLStatus(boolean flag) {
        this.showURLStatus = flag;
    }

    public boolean isShowURLStatus() {
        return this.showURLStatus;
    }

    public void setLinkURL(URL url) {
        this.linkURL = url;
        this.context = null;
    }

    public URL getLinkURL() {
        return this.linkURL;
    }

    public void setFrame(String newFrame) {
        this.frame = newFrame;
    }

    public String getFrame() {
        return this.frame;
    }

    public void validate() {
        super.validate();
    }

    public void setEnabled(boolean flag) {
        if (this.isEnabled() != flag) {
            if (flag) {
                super.setEnabled(true);
                this.pressed = false;
                this.pressedAdjustment = 0;
            } else {
                super.setEnabled(false);
                if (this.notifyTimer != null) {
                    this.notifyTimer.stop();
                }
                this.pressed = false;
                this.pressedAdjustment = 0;
            }
            this.repaint();
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.focus == null) {
            this.focus = new BBFocus();
            this.addFocusListener(this.focus);
        }
        if (this.key == null) {
            this.key = new BBKey();
            this.addKeyListener(this.key);
        }
        if (this.mouse == null) {
            this.mouse = new BBMouse();
            this.addMouseListener(this.mouse);
        }
        this.isAdded = true;
        this.validate();
        this.parentColor = this.getParent().getBackground();
        if (DButtonBase.objectsEqual(this.buttonColor, Color.black)) {
            this.setBackground(this.parentColor);
        }
        this.setIncrustedBorder();
    }

    public synchronized void removeNotify() {
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        super.removeNotify();
        this.isAdded = false;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.updateButtonImage();
        g.drawImage(this.buttonImage, 0, 0, this);
    }

    protected boolean isValidBevelSize(int i) {
        Dimension s = this.getSize();
        return i >= 0 && i < s.width / 2 && i < s.height / 2;
    }

    protected void linkToURL() {
        if (this.context != null && this.linkURL != null) {
            if (this.frame == null || this.frame.length() == 0) {
                this.context.showDocument(this.linkURL);
            } else {
                this.context.showDocument(this.linkURL, this.frame);
            }
        }
    }

    protected void setAppletContext(AppletContext c) {
        this.context = c;
    }

    protected void updateButtonImage() {
        int i;
        Color highlight2;
        Color highlight1;
        Color fillColor;
        Dimension s = this.getSize();
        int width = s.width;
        int height = s.height;
        int x = 0;
        int y = 0;
        int w = width - 1;
        int h = height - 1;
        boolean raised = !this.pressed || !this.inButton;
        int iOffset = 0;
        if (this.incrustedBorder) {
            iOffset = 1;
        }
        if (this.isButtonImageInvalid()) {
            this.buttonImage = this.createImage(width, height);
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.buttonImage, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.biG = this.buttonImage.getGraphics();
        Color oldColor = this.biG.getColor();
        if (this.isEnabled()) {
            if (raised) {
                fillColor = this.buttonColor;
                highlight1 = this.hilightColor;
                highlight2 = this.shadowColor;
            } else {
                fillColor = this.pressedButtonColor;
                highlight1 = this.pressedHilightColor;
                highlight2 = this.pressedShadowColor;
            }
        } else {
            fillColor = this.disabledButtonColor;
            highlight1 = this.disabledHilightColor;
            highlight2 = this.disabledShadowColor;
        }
        if (this.comboExtension) {
            int l = 0;
            int t = 0;
            int r = l + width - 1;
            int b = t + height - 1;
            this.biG.setColor(this.extendDark);
            this.biG.drawLine(l, t, r, t);
            this.biG.drawLine(l, t + 1, r - 1, t + 1);
            this.biG.setColor(this.extendLight);
            this.biG.drawLine(r, t + 1, r, b);
            this.biG.drawLine(l, b, r, b);
            x = l;
            y = t + 2;
            w -= 2;
            h -= 4;
        }
        if (this.blackBorder) {
            boolean offset = false;
            this.biG.setColor(this.borderDark);
            this.biG.drawLine(0, 0, w - 0 - 0 - iOffset, 0);
            this.biG.drawLine(0, 0, 0, h - 0 - 0);
            this.biG.setColor(this.borderLight);
            this.biG.drawLine(0, h, w - 0 - 0, h);
            this.biG.drawLine(w, h - 0 - 0, w, 1);
            ++x;
            ++y;
            w -= 2;
            h -= 2;
        }
        int mup = this.bevel;
        if (this.bevel > 1) {
            --mup;
        }
        this.biG.setColor(fillColor);
        this.biG.fillRect(x, y, w - x + 1, h - y + 1);
        if (!raised && this.useOffset) {
            this.biG.setColor(highlight1);
            for (i = 0; i < mup; ++i) {
                this.biG.drawLine(x + i, y + i, x + i, y + h);
                this.biG.drawLine(x + i, y + i, x + w, y + i);
            }
        }
        if (raised || !this.useOffset) {
            this.biG.setColor(highlight1);
            for (i = 0; i < mup; ++i) {
                this.biG.drawLine(x + i, y + i, x + i, y + h - i);
                this.biG.drawLine(x + i, y + i, x + w - i - 1, y + i);
            }
            this.biG.setColor(highlight2);
            for (i = 0; i < this.bevel; ++i) {
                this.biG.drawLine(x + i, y + h - i, x + w - i, y + h - i);
                this.biG.drawLine(x + w - i, y + i + 1, x + w - i, y + h - i);
            }
        }
        if (this.hasFocus && this.showFocus) {
            int j;
            this.biG.setColor(Color.darkGray);
            x = x + mup + 1;
            y = y + mup + 1;
            w = w - mup - this.bevel;
            h = h - mup - this.bevel + 1;
            for (i = x; i <= w; i += 3) {
                this.biG.drawLine(i, y, i + 1, y);
            }
            for (j = y; j < h; j += 3) {
                this.biG.drawLine(x, j, x, j + 1);
            }
            for (i = x; i <= w; i += 3) {
                this.biG.drawLine(i, h, i + 1, h);
            }
            for (j = y; j < h; j += 3) {
                this.biG.drawLine(w, j, w, j + 1);
            }
        }
        this.biG.setColor(oldColor);
    }

    protected boolean isButtonImageInvalid() {
        Dimension s = this.getSize();
        return this.buttonImage == null || s.width != this.buttonImage.getWidth(this) || s.height != this.buttonImage.getHeight(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.bevel + this.bevel + 2, this.bevel + this.bevel + 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusable() {
        return true;
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void sourceActionEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public static boolean objectsEqual(Object objectA, Object objectB) {
        if (objectA == null) {
            return objectB == null;
        }
        return objectA.equals(objectB);
    }

    public void setTip(String str) {
        this.tip = new Tip(this, str);
    }

    class Action
    implements ActionListener,
    Serializable {
        Action() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DButtonBase.this.notifyTimer && DButtonBase.this.notifyWhilePressed) {
                DButtonBase.this.notified = true;
                DButtonBase.this.sourceActionEvent();
                return;
            }
        }
    }

    class BBMouse
    extends MouseAdapter
    implements Serializable {
        BBMouse() {
        }

        public void mousePressed(MouseEvent e) {
            DButtonBase.this.requestFocus();
            DButtonBase.this.notified = false;
            if (DButtonBase.this.notifyTimer != null && DButtonBase.this.notifyWhilePressed && !DButtonBase.this.running) {
                DButtonBase.this.running = true;
                DButtonBase.this.notifyTimer.start();
            }
            DButtonBase.this.pressed = true;
            DButtonBase.this.released = false;
            if (DButtonBase.this.useOffset) {
                DButtonBase.this.pressedAdjustment = DButtonBase.this.bevel;
            }
            DButtonBase.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            if (DButtonBase.this.notifyTimer != null && DButtonBase.this.running) {
                DButtonBase.this.running = false;
                DButtonBase.this.notifyTimer.stop();
            }
            if (DButtonBase.this.pressed) {
                DButtonBase.this.pressed = false;
                DButtonBase.this.pressedAdjustment = 0;
                if (!DButtonBase.this.notifyWhilePressed || !DButtonBase.this.notified) {
                    DButtonBase.this.linkToURL();
                    DButtonBase.this.sourceActionEvent();
                }
            }
            DButtonBase.this.released = true;
            if (DButtonBase.this.inButton) {
                DButtonBase.this.repaint();
            }
            if (DButtonBase.this.tip != null) {
                DButtonBase.this.tip.hideIt();
            }
        }

        public void mouseEntered(MouseEvent e) {
            DButtonBase.this.inButton = true;
            if (!DButtonBase.this.released) {
                DButtonBase.this.pressed = true;
                if (DButtonBase.this.useOffset) {
                    DButtonBase.this.pressedAdjustment = DButtonBase.this.bevel;
                }
                if (DButtonBase.this.notifyTimer != null && DButtonBase.this.notifyWhilePressed && !DButtonBase.this.running) {
                    DButtonBase.this.running = true;
                    DButtonBase.this.notifyTimer.start();
                }
                if (DButtonBase.this.showURLStatus && DButtonBase.this.context != null && DButtonBase.this.linkURL != null) {
                    DButtonBase.this.context.showStatus(DButtonBase.this.linkURL.toString());
                }
                DButtonBase.this.repaint();
            }
            if (DButtonBase.this.tip != null) {
                DButtonBase.this.tip.showIt();
            }
        }

        public void mouseExited(MouseEvent e) {
            DButtonBase.this.inButton = false;
            if (DButtonBase.this.notifyTimer != null && DButtonBase.this.running) {
                DButtonBase.this.running = false;
                DButtonBase.this.notifyTimer.stop();
            }
            if (DButtonBase.this.pressed) {
                DButtonBase.this.pressed = false;
                DButtonBase.this.pressedAdjustment = 0;
                DButtonBase.this.repaint();
            }
            if (DButtonBase.this.showURLStatus && DButtonBase.this.context != null && DButtonBase.this.linkURL != null) {
                DButtonBase.this.context.showStatus("");
            }
            if (DButtonBase.this.tip != null) {
                DButtonBase.this.tip.hideIt();
            }
        }
    }

    class BBKey
    extends KeyAdapter
    implements Serializable {
        BBKey() {
        }

        public void keyPressed(KeyEvent evt) {
            boolean isSpaceBar;
            boolean bl = isSpaceBar = (evt.getKeyCode() & 0x20) == 32;
            if (isSpaceBar && DButtonBase.this.hasFocus && DButtonBase.this.showFocus && !OS.isMacintosh()) {
                DButtonBase.this.inButton = true;
                DButtonBase.this.notified = false;
                if (DButtonBase.this.notifyTimer != null && DButtonBase.this.notifyWhilePressed && !DButtonBase.this.running) {
                    DButtonBase.this.running = true;
                    DButtonBase.this.notifyTimer.start();
                }
                DButtonBase.this.pressed = true;
                DButtonBase.this.released = false;
                if (DButtonBase.this.useOffset) {
                    DButtonBase.this.pressedAdjustment = DButtonBase.this.bevel;
                }
                DButtonBase.this.repaint();
            }
        }

        public void keyReleased(KeyEvent evt) {
            boolean isSpaceBar;
            boolean bl = isSpaceBar = (evt.getKeyCode() & 0x20) == 32;
            if (isSpaceBar && DButtonBase.this.hasFocus && DButtonBase.this.showFocus && !OS.isMacintosh()) {
                DButtonBase.this.inButton = false;
                if (DButtonBase.this.notifyTimer != null && DButtonBase.this.running) {
                    DButtonBase.this.running = false;
                    DButtonBase.this.notifyTimer.stop();
                }
                if (DButtonBase.this.pressed) {
                    DButtonBase.this.pressed = false;
                    DButtonBase.this.pressedAdjustment = 0;
                    if (!DButtonBase.this.notifyWhilePressed || !DButtonBase.this.notified) {
                        DButtonBase.this.linkToURL();
                        DButtonBase.this.sourceActionEvent();
                    }
                }
                DButtonBase.this.released = true;
                DButtonBase.this.repaint();
            }
        }
    }

    class BBFocus
    extends FocusAdapter
    implements Serializable {
        BBFocus() {
        }

        public void focusGained(FocusEvent e) {
            DButtonBase.this.hasFocus = true;
            DButtonBase.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            DButtonBase.this.hasFocus = false;
            DButtonBase.this.repaint();
        }
    }
}

