/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;

public class DCheckbox
extends Component
implements ItemSelectable {
    protected String label;
    protected boolean state = false;
    protected ItemListener itemListener;
    static final boolean CLEARED = false;
    static final boolean CHECKED = true;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    public int position;
    static final int BEVEL_NONE = 0;
    static final int BEVEL_LINE = 1;
    static final int BEVEL_RAISED = 2;
    static final int BEVEL_LOWERED = 3;
    public int border;
    int BORDER_X = 0;
    int BORDER_Y = 0;
    int checksize = 16;

    public DCheckbox() {
        this("", false);
    }

    public DCheckbox(String label) {
        this(label, false);
    }

    public DCheckbox(String label, boolean state) {
        this.enableEvents(16L);
        this.label = label;
        this.state = state;
        this.border = 0;
        this.position = 0;
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.repaint();
    }

    public void setBevel(int b) {
        this.border = b;
    }

    public Dimension getPreferredSize() {
        Dimension actsize = this.getSize();
        Dimension bestsize = this.adjustSize();
        int aw = actsize.width;
        int ah = actsize.height;
        int bw = bestsize.width;
        int bh = bestsize.height;
        if (bw > aw || bh > ah) {
            return bestsize;
        }
        return actsize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public synchronized void setLabel(String newLabel) {
        this.label = newLabel;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setState(boolean newState) {
        this.state = newState;
        this.repaint();
    }

    public boolean getState() {
        return this.state;
    }

    public void setBorder(int b) {
        this.border = b;
    }

    protected Dimension adjustSize() {
        int width = this.checksize + this.BORDER_X * 2;
        int height = this.checksize + this.BORDER_Y * 2;
        int lwidth = 0;
        int lheight = 0;
        Graphics g = this.getGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            if (this.label != null) {
                lheight = fm.getHeight();
                if (lheight > height) {
                    this.BORDER_Y = lheight - height;
                    this.BORDER_Y = (this.BORDER_Y + 1) / 2;
                } else if (this.checksize > lheight) {
                    lheight = this.checksize;
                }
                lwidth = 8 + fm.stringWidth(this.label) + this.BORDER_X * 2;
            }
        }
        if (lheight > height) {
            height = lheight;
        }
        return new Dimension(width + lwidth, height);
    }

    public void addNotify() {
        super.addNotify();
        this.setSize(this.getPreferredSize());
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int loffset;
        int coffset;
        int w = this.getWidth();
        int h = this.getHeight();
        Color background = this.getBackground();
        Color light = background.brighter();
        Color dark = background.darker();
        if (this.border > 0) {
            g.setColor(background);
            g.fillRect(0, 0, w, h);
        }
        if (this.border == 1) {
            g.setColor(this.getForeground());
            g.drawRect(0, 0, w - 1, h - 1);
        } else if (this.border == 2) {
            g.setColor(light);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
            g.setColor(dark);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(2, h - 2, w - 2, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        } else if (this.border == 3) {
            g.setColor(dark);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
            g.setColor(light);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(2, h - 2, w - 2, h - 2);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }
        if (this.position == 0) {
            coffset = this.BORDER_X;
            loffset = this.checksize + this.BORDER_X * 3 + 6;
        } else {
            coffset = w - (this.checksize + this.BORDER_X * 2) - 1;
            loffset = 6;
        }
        int xr = coffset + this.checksize - 1;
        int yb = this.BORDER_Y + this.checksize - 1;
        g.setColor(dark);
        g.drawLine(coffset, this.BORDER_Y, xr, this.BORDER_Y);
        g.drawLine(coffset, this.BORDER_Y, coffset, yb);
        g.drawLine(coffset + 1, this.BORDER_Y + 1, xr - 1, this.BORDER_Y + 1);
        g.drawLine(coffset + 1, this.BORDER_Y + 2, coffset + 1, yb - 1);
        g.setColor(light);
        g.drawLine(xr, this.BORDER_Y, xr, yb);
        g.drawLine(coffset, yb, xr, yb);
        g.setColor(dark);
        g.drawLine(xr - 1, this.BORDER_Y + 1, xr - 1, yb - 1);
        g.drawLine(coffset + 1, yb - 1, xr - 1, yb - 1);
        g.setColor(light);
        g.fillRect(coffset + 2, this.BORDER_Y + 2, this.checksize - 4, this.checksize - 4);
        if (this.state) {
            int cx = coffset + 4;
            int cy = this.BORDER_Y + 4;
            int cx1 = cx + this.checksize - 10;
            int cy1 = cy + this.checksize - 9;
            g.setColor(Color.black);
            g.drawLine(cx, cy, cx1, cy1);
            g.drawLine(cx, cy1, cx1, cy);
            g.drawLine(cx + 1, cy, cx1 + 1, cy1);
            g.drawLine(cx + 1, cy1, cx1 + 1, cy);
        }
        if (this.label != null && this.label.length() > 0) {
            FontMetrics fm = g.getFontMetrics();
            if (this.position == 1) {
                loffset = coffset - fm.stringWidth(this.label);
            }
            int y = this.BORDER_Y + 14;
            if (this.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawString(this.label, loffset, y);
        }
    }

    public void processMouseEvent(MouseEvent evt) {
        if (evt.getID() == 501 && this.isEnabled()) {
            boolean bl = this.state = !this.state;
            if (this.itemListener != null) {
                int stateChange = this.state ? 1 : 2;
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.label, stateChange));
            }
            this.repaint();
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objs = new Object[]{this};
        return objs;
    }

    public synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }
}

