/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DListBox;
import ae.DirButton;
import ae.OS;
import ae.Preferences;
import ae.Sort;
import ae.SortDir;
import ae.Style;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class DComboBox
extends Panel
implements ActionListener,
MouseListener {
    public String actionCommand;
    public ActionListener actionListener = null;
    public ComboField editBox;
    public ComboButton arrow;
    public ComboList list;
    public transient boolean bOverList = false;
    public transient boolean bDown = false;
    public transient String sLastText;
    public boolean bEditable;
    public boolean bSearchable;
    public boolean bCaseSensitive;
    public int ix;
    public int iy;
    public int iwidth;
    public int lheight;
    public int arrowDim;
    public int hPad = 1;
    public int vPad = 0;
    public boolean horizScroll = false;
    public boolean vertiScroll = true;
    public String sSearchText;
    public String sSearchItem;
    public String sSearchOrig;
    public int searchIndex;
    public int searchLen;
    public int searchI;
    public static transient boolean bOsFlag = !OS.isWindows() && !OS.isMacintosh();
    private KeyList keyList = null;
    private KeyBox keyBox = null;
    private Item item = null;
    public int MAXITEMS = 16;
    public int baseSize = 0;
    boolean traversable;
    boolean wasPressed = false;

    public DComboBox() {
        this(true, false, 0);
    }

    public DComboBox(int columns) {
        this(true, false, columns);
    }

    public DComboBox(boolean editable, boolean searchable, int columns) {
        super.setLayout(null);
        this.editBox = new ComboField("", columns);
        this.editBox.addMouseListener(this);
        this.arrow = new ComboButton(3);
        this.arrow.setShowFocus(false);
        this.arrow.setEnabled(false);
        this.arrow.setBevelHeight(2);
        this.arrow.setComboEnabled(false);
        this.arrow.setBorderEnabled(false);
        this.arrow.addActionListener(this);
        this.list = new ComboList(true);
        this.list.setVisible(false);
        this.list.setComboMode(true);
        this.list.setShowHorizontalScroll(false);
        this.list.setShowVerticalScroll(true);
        this.list.addMouseListener(this);
        this.add(this.list);
        this.add(this.editBox);
        this.add(this.arrow);
        this.lheight = 0;
        this.traversable = true;
        this.setEditable(editable);
        this.setSearchable(searchable);
        this.bCaseSensitive = true;
    }

    public void setShowFocus(boolean f) {
        this.traversable = f;
        this.arrow.setShowFocus(f);
    }

    public boolean isFocusable() {
        return this.traversable;
    }

    public void setArrowStyle(boolean inside, boolean border, int bev) {
        this.arrow.setComboEnabled(inside);
        this.arrow.setBorderEnabled(border);
        this.arrow.setBevelHeight(bev);
    }

    public void setEditable(boolean editable) {
        this.bEditable = editable;
        this.editBox.setEditable(this.bEditable || this.bSearchable);
    }

    public void setSearchable(boolean searchable) {
        this.bSearchable = searchable;
        this.editBox.setEditable(this.bEditable || this.bSearchable);
    }

    public void setCaseSensitive(boolean cs) {
        this.bCaseSensitive = cs;
    }

    public void setShowHorizontalScroll(boolean cond) {
        if (this.horizScroll != cond) {
            this.horizScroll = cond;
            this.list.setShowHorizontalScroll(cond);
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.horizScroll;
    }

    public void setShowVerticalScroll(boolean cond) {
        if (this.vertiScroll != cond) {
            this.vertiScroll = cond;
            this.list.setShowVerticalScroll(cond);
        }
    }

    public boolean isShowVerticalScroll() {
        return this.vertiScroll;
    }

    public void setListItems(String[] items) {
        this.reset();
        for (int i = 0; i < items.length; ++i) {
            this.addItem(items[i]);
        }
    }

    public String[] getListItems() {
        int len = this.countItems();
        String[] items = new String[len];
        for (int i = 0; i < len; ++i) {
            items[i] = this.getListText(i);
        }
        return items;
    }

    public synchronized void setFont(Font newFont) {
        super.setFont(newFont);
        this.editBox.setFont(newFont);
        this.list.setFont(newFont);
        this.repaint();
    }

    public String getListText(int index) {
        return this.list.getText(index);
    }

    public void setText(String newText) {
        this.editBox.setText(newText);
    }

    public String getText() {
        this.verify();
        return this.editBox.getText();
    }

    public String getSelectedItem() {
        return this.list.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized boolean isSelected(int index) {
        return this.list.isSelected(index);
    }

    public static boolean addFirstTopDown() {
        return !DComboBox.addLastBottomUp();
    }

    public static boolean addLastBottomUp() {
        return OS.isFirstDrawnOverSecond();
    }

    public static boolean needsPlatformHelp() {
        return bOsFlag;
    }

    public void clear() {
        this.list.clear();
        this.baseSize = 0;
    }

    public void reset() {
        this.list.clear();
        this.editBox.setText("");
    }

    public synchronized void addItem(String item) {
        this.addItem(null, item, true);
    }

    public synchronized void addItem(String item, boolean bEnabled) {
        this.addItem(null, item, bEnabled);
    }

    public synchronized void addItem(Image image, String item) {
        this.addItem(image, item, true);
    }

    public synchronized void addItem(Image image, String item, boolean bEnabled) {
        this.list.addItem(image, item, bEnabled);
        this.arrow.setEnabled(true);
    }

    public synchronized boolean addUnicItem(String item) {
        int siz = this.countItems();
        for (int i = 0; i < siz; ++i) {
            if (!Sort.superEquals(this.getListText(i), item)) continue;
            return false;
        }
        if (siz >= this.MAXITEMS) {
            this.delItem(this.baseSize);
            siz = this.MAXITEMS - 1;
        }
        this.list.addItem(null, item);
        return true;
    }

    public int countItems() {
        return this.list.countItems();
    }

    public void setImage(int index, Image image) {
        this.list.setImage(index, image);
    }

    public void setListText(int index, String text) {
        this.list.setText(index, text);
    }

    public void setEnabled(int index) {
        this.setEnabled(index, true);
    }

    public void setEnabled(int index, boolean cond) {
        this.list.setEnabled(index, cond);
    }

    public synchronized void delItem(int position) {
        this.list.delItem(position);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.setListDown(false);
        }
    }

    public synchronized void delItems(int start, int end) {
        this.list.delItems(start, end);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.setListDown(false);
        }
    }

    public synchronized void delSelectedItem() {
        this.list.delSelectedItems();
    }

    public synchronized void select(int index) {
        if (index >= 0 && index <= this.list.countItems()) {
            this.list.setSelectedIndex(index, true);
            this.editBox.setText(this.list.getSelectedItem());
            if (bOsFlag) {
                this.repaint();
            }
        }
    }

    public void select(String str) {
        this.list.setSelectedItem(str, true);
        this.editBox.setText(this.list.getSelectedItem());
        if (bOsFlag) {
            this.repaint();
        }
    }

    public synchronized void deselect(int index) {
        this.list.setSelectedIndex(index, false);
        this.editBox.setText("");
    }

    public void setListDown(boolean isDown) {
        if (this.bDown != isDown) {
            this.bDown = isDown;
            if (this.bDown) {
                this.list.setVisible(true);
                this.vPad = 1;
            } else {
                this.list.setVisible(false);
                this.vPad = 0;
            }
            this.reshapeInternals();
            super.setBounds(this.ix, this.iy, this.iwidth, this.lheight + this.arrowDim + this.vPad);
            this.invalidate();
        }
    }

    public boolean isListDown() {
        return this.bDown;
    }

    public synchronized void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.ix = x;
        this.iy = y;
        this.iwidth = width;
        this.reshapeInternals();
    }

    public void update(Graphics G) {
        this.paint(G);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.reshapeInternals();
    }

    public Dimension getPreferredSize() {
        this.reshapeInternals();
        int editBoxPreferredWidth = this.editBox.getPreferredSize().width;
        if (this.bDown) {
            return new Dimension(editBoxPreferredWidth + this.arrowDim + this.hPad, this.arrowDim + this.vPad + this.lheight);
        }
        return new Dimension(editBoxPreferredWidth + this.arrowDim + this.hPad, this.arrowDim);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setActionCommand(String command) {
        this.actionCommand = command;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.keyList == null) {
            this.keyList = new KeyList();
            this.list.addKeyListener(this.keyList);
        }
        if (this.keyBox == null) {
            this.keyBox = new KeyBox();
            this.editBox.addKeyListener(this.keyBox);
        }
        if (this.item == null) {
            this.item = new Item();
            this.list.addItemListener(this.item);
        }
    }

    public synchronized void removeNotify() {
        if (this.keyList != null) {
            this.list.removeKeyListener(this.keyList);
            this.keyList = null;
        }
        if (this.keyBox != null) {
            this.editBox.removeKeyListener(this.keyBox);
            this.keyBox = null;
        }
        if (this.item != null) {
            this.list.removeItemListener(this.item);
            this.item = null;
        }
        super.removeNotify();
    }

    public void setLayout(LayoutManager lm) {
    }

    public void validate() {
        super.validate();
        this.reshapeInternals();
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void mouseEntered(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.list) {
            this.bOverList = true;
        }
    }

    public void mouseExited(MouseEvent e) {
        this.bOverList = false;
    }

    public void mousePressed(MouseEvent e) {
        Object source = e.getSource();
        this.wasPressed = source == this.editBox;
    }

    public void mouseReleased(MouseEvent e) {
        Object source = e.getSource();
        if (source == this.editBox && this.wasPressed && !this.bEditable && !this.bSearchable) {
            this.setListDown(!this.bDown);
        }
        this.wasPressed = false;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof DirButton) {
            this.setListDown(!this.bDown);
        } else if (e.getActionCommand().equals("ImageSelected")) {
            this.sourceActionEvent("ImageSelected");
        }
    }

    public void sourceActionEvent(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    public void sourceActionEvent() {
        this.sourceActionEvent(this.actionCommand);
    }

    public void reshapeInternals() {
        Dimension s = this.getSize();
        Dimension arrowSize = this.arrow.getPreferredSize();
        Dimension editBoxPreferredSize = this.editBox.getPreferredSize();
        this.arrowDim = Math.max(arrowSize.width, arrowSize.height);
        if (editBoxPreferredSize.height > this.arrowDim) {
            this.arrowDim = editBoxPreferredSize.height;
        }
        if (OS.isMacintosh()) {
            ++this.arrowDim;
            this.editBox.setBounds(0, 1, s.width + 1 - this.arrowDim - this.hPad, editBoxPreferredSize.height);
        } else {
            this.editBox.setBounds(0, 0, s.width + 1 - this.arrowDim - this.hPad, editBoxPreferredSize.height);
        }
        this.arrow.setBounds(s.width - this.arrowDim, 0, this.arrowDim, this.arrowDim);
        if (this.bDown) {
            this.lheight = this.getParent() != null ? Math.min(this.getParent().getBounds().height - this.iy - this.arrowDim - this.vPad, this.list.getMinimumSize().height) : this.list.getMinimumSize().height;
            this.list.setBounds(0, this.arrowDim + this.vPad, s.width, this.lheight);
        } else {
            this.lheight = 0;
        }
    }

    public void verify() {
        if (this.bSearchable) {
            this.searchIndex = this.editBox.getSelectionStart();
            this.sSearchOrig = this.editBox.getText().substring(0, this.searchIndex);
            this.sSearchText = this.bCaseSensitive ? this.sSearchOrig : this.sSearchOrig.toUpperCase();
            this.searchLen = this.list.countItems();
            if (this.sSearchText.length() > 0) {
                this.searchI = 0;
                while (this.searchI < this.searchLen) {
                    this.sSearchItem = this.bCaseSensitive ? this.list.getText(this.searchI) : this.list.getText(this.searchI).toUpperCase();
                    if (this.sSearchItem.startsWith(this.sSearchText)) {
                        this.editBox.setText(this.sSearchOrig);
                        this.list.setSelectedIndex(this.searchI, true);
                        this.editBox.select(this.searchIndex, this.searchIndex);
                        break;
                    }
                    ++this.searchI;
                }
                if (!this.bEditable && this.searchI == this.searchLen) {
                    this.editBox.setText(this.sLastText);
                    this.editBox.select(this.searchIndex - 1, this.searchIndex - 1);
                }
            }
        }
        this.sLastText = this.editBox.getText();
    }

    public int setMaxItems(int val) {
        int i = this.MAXITEMS;
        this.MAXITEMS = val;
        return i;
    }

    public void setBaseSize(int n) {
        if (n >= this.MAXITEMS) {
            n = this.MAXITEMS;
        }
        this.baseSize = n;
    }

    public int getMaxItems() {
        return this.MAXITEMS;
    }

    public int getBaseSize() {
        return this.baseSize;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.arrow.setBackground(c);
        this.arrow.setComboColors(c);
        this.editBox.setBackground(c);
        this.list.setBackground(c);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.arrow.setForeground(c);
    }

    public void setFieldsBackground(Color c) {
        this.editBox.setBackground(c);
        this.list.setBackground(c);
    }

    public void setFieldsForeground(Color c) {
        this.editBox.setForeground(c);
        this.list.setForeground(c);
    }

    public void setButtonBackground(Color c) {
        this.arrow.setBackground(c);
    }

    public void setStyle(Style s) {
        this.setFieldsBackground(s.background);
        this.setFieldsForeground(s.foreground);
        this.setFont(s.font);
    }

    public void deleteInList() {
        String str = this.editBox.getText();
        this.list.setSelectedItem(str, true);
        int i = this.list.getSelectedIndex();
        this.delSelectedItem();
        if (i >= this.list.countItems()) {
            --i;
        }
        str = i < 0 ? "" : this.list.getText(i);
        this.editBox.setText(str);
    }

    public void Resize(int newsize) {
        int oldsize = this.getMaxItems();
        int newbase = OS.isWindows() ? this.baseSize : Preferences.MemBaseSize;
        int oldbase = this.getBaseSize();
        if (newsize == oldsize && newbase == oldbase) {
            return;
        }
        String[] clist = this.getListItems();
        int l = clist.length;
        newbase = SortDir.separeDrives(clist, 0, l);
        this.clear();
        if (newsize < l) {
            l = newsize;
        }
        for (int i = 0; i < l; ++i) {
            this.addItem(clist[i]);
        }
        this.setMaxItems(newsize);
        this.setBaseSize(newbase);
    }

    void separeDrives() {
        String[] clist = this.getListItems();
        int l = clist.length;
        int base = SortDir.separeDrives(clist, 0, l);
        this.clear();
        for (int i = 0; i < l; ++i) {
            this.addItem(clist[i]);
        }
        this.setBaseSize(base);
    }

    void setBaseSize() {
        this.setBaseSize(SortDir.countDrives(this.getListItems()));
    }

    public int search(String str) {
        if (str.length() < 1) {
            return -1;
        }
        int L = this.list.countItems();
        for (int i = 0; i < L; ++i) {
            if (!(this.bCaseSensitive ? this.list.getText(i).equalsIgnoreCase(str) : this.list.getText(i).equals(str))) continue;
            return i;
        }
        return -1;
    }

    public class ComboList
    extends DListBox {
        public ComboList(boolean b) {
            super(b);
        }

        public boolean isFocusable() {
            return DComboBox.this.traversable;
        }
    }

    public class ComboButton
    extends DirButton {
        public ComboButton(int i) {
            super(i);
        }

        public boolean isFocusable() {
            return DComboBox.this.traversable;
        }
    }

    public class ComboField
    extends TextField {
        public ComboField(String s) {
            super(s);
        }

        public ComboField(String s, int nc) {
            super(s, nc);
        }

        public boolean isFocusable() {
            return DComboBox.this.traversable;
        }
    }

    public class Item
    implements ItemListener,
    Serializable {
        public void itemStateChanged(ItemEvent e) {
            DComboBox.this.editBox.setText(DComboBox.this.list.getSelectedItem());
            DComboBox.this.sourceActionEvent();
            DComboBox.this.setListDown(false);
        }
    }

    public class KeyList
    extends KeyAdapter
    implements Serializable {
        public void keyReleased(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 36: {
                    DComboBox.this.list.setSelectedIndex(0, true);
                    break;
                }
                case 35: {
                    DComboBox.this.list.setSelectedIndex(DComboBox.this.list.countItems() - 1, true);
                    break;
                }
                case 33: 
                case 38: {
                    DComboBox.this.list.setSelectedIndex(DComboBox.this.list.getSelectedIndex() - 1, true);
                    break;
                }
                case 34: 
                case 40: {
                    DComboBox.this.list.setSelectedIndex(DComboBox.this.list.getSelectedIndex() + 1, true);
                }
            }
            DComboBox.this.editBox.setText(DComboBox.this.list.getSelectedItem());
            DComboBox.this.editBox.selectAll();
            DComboBox.this.verify();
        }
    }

    public class KeyBox
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (e.isControlDown()) {
                switch (key) {
                    case 65: {
                        DComboBox.this.addUnicItem(DComboBox.this.editBox.getText());
                        break;
                    }
                    case 90: {
                        DComboBox.this.clear();
                        break;
                    }
                    case 89: {
                        break;
                    }
                    case 88: {
                        DComboBox.this.editBox.setText("");
                    }
                }
            }
            switch (key) {
                case 10: {
                    break;
                }
                default: {
                    DComboBox.this.sLastText = DComboBox.this.editBox.getText();
                }
            }
        }
    }
}

