/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Effect;
import ae.Style;
import ae.Tool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DLabel
extends Component {
    public static final int BEVEL_LOWERED = 3;
    public static final int BEVEL_RAISED = 2;
    public static final int BEVEL_LINE = 1;
    public static final int BEVEL_NONE = 0;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    protected String sLabel;
    protected int alignStyle;
    protected int bevelStyle;
    protected Color textColor;
    protected Color borderColor;
    protected Color hilightColor;
    protected Color shadowColor;
    protected Color cachedBackground = null;
    private transient FontMetrics fm;
    private transient int xTemp;
    private transient int yTemp;

    public DLabel() {
        this("", 0, 0, Color.black);
    }

    public DLabel(int bevel) {
        this("", bevel, 0, Color.black);
    }

    public DLabel(String sText) {
        this(sText, 0, 0, Color.black);
    }

    public DLabel(String sText, int bevelStyle) {
        this(sText, bevelStyle, 0, Color.black);
    }

    public DLabel(String sText, int bevelStyle, int alignStyle) {
        this(sText, bevelStyle, alignStyle, Color.black);
    }

    public DLabel(String sText, int bevelStyle, int alignStyle, Color color) {
        this.sLabel = sText;
        this.textColor = color;
        this.borderColor = Color.black;
        this.cachedBackground = this.getBackground();
        this.alignStyle = alignStyle;
        this.bevelStyle = bevelStyle;
    }

    public void setAlignment(int a) {
        this.alignStyle = a;
        this.repaint();
    }

    public void setBevel(int b) {
        this.bevelStyle = b;
        this.repaint();
    }

    public void setBorderColor(Color bc) {
        this.borderColor = bc;
    }

    public void setText(String newText) {
        this.sLabel = newText;
        this.repaint();
    }

    public String getText() {
        return this.sLabel;
    }

    public void setTextColor(Color tc) {
        this.textColor = tc;
    }

    public void setStyle(Style s) {
        this.setFont(s.font);
        this.setBackground(s.background);
        this.textColor = s.foreground;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Color color2;
        Color color1;
        Color curBackground = this.getBackground();
        if (!Tool.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.hilightColor = Effect.hilight(curBackground);
            this.shadowColor = Effect.shadow(curBackground);
        }
        Rectangle r = this.getBounds();
        g.setFont(this.getFont());
        switch (this.bevelStyle) {
            case 3: {
                color1 = this.shadowColor;
                color2 = this.hilightColor;
                break;
            }
            case 2: {
                color1 = this.hilightColor;
                color2 = this.shadowColor;
                break;
            }
            case 1: {
                color1 = this.borderColor;
                color2 = this.borderColor;
                break;
            }
            default: {
                color2 = null;
                color1 = null;
            }
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, r.width - 1, r.height - 1);
        if (color1 != null) {
            g.setColor(color1);
            g.drawLine(0, 0, r.width - 1, 0);
            g.setColor(color2);
            g.drawLine(0, r.height - 1, r.width - 1, r.height - 1);
            g.setColor(color1);
            g.drawLine(0, 0, 0, r.height - 1);
            g.setColor(color2);
            g.drawLine(r.width - 1, 0, r.width - 1, r.height - 1);
        }
        g.setColor(this.textColor);
        this.fm = this.getFontMetrics(g.getFont());
        this.yTemp = (r.height - 1 + this.fm.getAscent()) / 2 - 2;
        switch (this.alignStyle) {
            default: {
                if (this.bevelStyle == 1) {
                    g.drawString(this.sLabel, 4, this.yTemp);
                    break;
                }
                g.drawString(this.sLabel, 8, this.yTemp);
                break;
            }
            case 2: {
                this.xTemp = r.width - this.fm.stringWidth(this.sLabel);
                if (this.bevelStyle == 1) {
                    g.drawString(this.sLabel, this.xTemp - 6, this.yTemp);
                    break;
                }
                g.drawString(this.sLabel, this.xTemp - 10, this.yTemp);
                break;
            }
            case 1: {
                this.xTemp = (r.width - this.fm.stringWidth(this.sLabel)) / 2;
                g.drawString(this.sLabel, this.xTemp, this.yTemp);
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension s = this.getSize();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(s.width, m.width), Math.max(s.height, m.height));
    }

    public Dimension getMinimumSize() {
        Dimension min = new Dimension(16, 8);
        Font f = this.getFont();
        if (f != null) {
            this.fm = this.getFontMetrics(f);
            min.width = this.fm.stringWidth(this.sLabel) + 16;
            min.height = this.fm.getHeight() + 8;
        }
        return min;
    }
}

