/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Effect;
import ae.ListItem;
import ae.OS;
import ae.Style;
import ae.Tool;
import ae.VectorString;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class DListBox
extends Panel
implements ItemSelectable,
KeyListener,
MouseListener,
AdjustmentListener {
    public static final int EVT_IMAGE_SELECT = 16388;
    public static final int BORDER_REGULAR = 0;
    public static final int BORDER_NONE = 1;
    public static final int IMAGE_WIDTH = 20;
    private static final boolean ABSOLUTE = true;
    public Image image = null;
    public String[] arrayModel;
    boolean listChanged;
    int popx;
    int popy;
    int countTagged;
    int lastTagged;
    protected int nTopRow = 0;
    protected int lWidth = 0;
    protected int cellHt = 0;
    protected int yAdj = 0;
    protected int borderWidth = 4;
    protected int halfBorderWidth = 2;
    ActionListener actionListener = null;
    ItemListener itemListener = null;
    protected final int LINE_SLOP = 4;
    protected String ilbLabel;
    protected Scrollbar VBar = null;
    protected Scrollbar HBar = null;
    protected Vector items;
    protected Font font;
    protected transient FontMetrics fm = null;
    protected transient boolean bAllDirty = true;
    protected boolean bMultipleSelections = false;
    protected boolean bBlockPaint = false;
    protected boolean bVBarVisible = false;
    protected boolean bHBarVisible = false;
    protected transient boolean bInternalBlockPaint = false;
    protected int rowsToShow = -1;
    protected int colsToShow = 10;
    protected transient int visibleRows = 0;
    protected transient int visibleCols = -1;
    protected transient int fontHeight;
    protected transient int fontDescent;
    protected transient int lastDownModifiers = -1;
    protected transient int lastSelected = -1;
    protected transient int lastIndex = -1;
    protected transient int lastTempIndex = -1;
    protected transient int countSelected = 0;
    protected int borderType = 0;
    protected int longestLineValue = 0;
    protected transient int barSize = 17;
    protected int xCoord = 0;
    protected transient long prevSelectTime = -1L;
    protected transient long prevSelectRow = -1L;
    protected boolean bAllowShowVBar = true;
    protected boolean bAllowShowHBar = true;
    protected boolean bComboMode = false;
    protected boolean bCellBorders = false;
    protected Color borderLighterColor = null;
    protected Color borderDarkerColor = null;
    protected Color borderLightColor = null;
    protected Color borderDarkColor = null;
    protected Color cachedBackground = null;
    protected Color textHighlight = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
    protected Color textHighlightText = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
    protected Color enabledColor = OS.isMacintosh() ? Color.black : SystemColor.textText;
    protected Color disabledColor = OS.isMacintosh() ? Color.gray : SystemColor.textInactiveText;
    protected int fastDownCount = 0;
    protected boolean bMouseDrawHandled = false;
    private MouseMotion mouseMotion = null;
    protected Color PanelColor = Color.gray;
    protected Focus focus = null;
    public transient boolean hasFocus = false;

    public DListBox() {
        this(-1, false);
    }

    public DListBox(boolean bMultipleSelections) {
        this(-1, bMultipleSelections);
    }

    public DListBox(int rows, boolean bMultipleSelections) {
        this.items = new Vector();
        this.rowsToShow = rows;
        this.bMultipleSelections = bMultipleSelections;
        this.setLayout(null);
        this.VBar = new Scrollbar();
        this.VBar.setBackground(SystemColor.control);
        this.VBar.setVisible(false);
        this.add(this.VBar);
        this.HBar = new Scrollbar(0);
        this.HBar.setBackground(SystemColor.control);
        this.HBar.setVisible(false);
        this.add(this.HBar);
        this.cachedBackground = this.getBackground();
        this.listChanged = false;
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public boolean isFocusable() {
        return true;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public void setModel(String[] model) {
        this.arrayModel = model;
    }

    public void setShowVerticalScroll(boolean cond) {
        if (this.bAllowShowVBar != cond) {
            this.bAllowShowVBar = cond;
            this.invalidate();
        }
    }

    public boolean isShowVerticalScroll() {
        return this.bAllowShowVBar;
    }

    public void setShowHorizontalScroll(boolean cond) {
        if (this.bAllowShowHBar != cond) {
            this.bAllowShowHBar = cond;
            this.invalidate();
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.bAllowShowHBar;
    }

    public void setComboMode(boolean cond) {
        if (this.bComboMode != cond) {
            this.bComboMode = cond;
            this.yAdj = 0;
            if (OS.isWindows()) {
                this.yAdj = 6;
            }
            this.invalidate();
        }
    }

    public boolean isComboMode() {
        return this.bComboMode;
    }

    public void setRowsToShow(int rows) {
        if (this.rowsToShow != rows) {
            this.rowsToShow = rows;
            this.invalidate();
        }
    }

    public int getRowsToShow() {
        return this.rowsToShow;
    }

    public void setBorderType(int type) {
        if (this.borderType != type) {
            this.borderType = type;
            if (type == 0) {
                this.borderWidth = 4;
                this.halfBorderWidth = 2;
            } else {
                this.borderWidth = 0;
                this.halfBorderWidth = 0;
            }
            this.invalidate();
        }
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setCellBorder(int index, boolean bOn) {
        if (this.validIndex(index)) {
            ListItem li = (ListItem)this.items.elementAt(index);
            if (li.bCellBorder != bOn) {
                li.bCellBorder = bOn;
                li.bDirty = true;
                this.invalidate();
            }
        }
    }

    public void setCellBorders(boolean bOn) {
        if (this.bCellBorders != bOn) {
            this.bCellBorders = bOn;
            int s = this.items.size();
            ListItem li = null;
            for (int x = 0; x < s; ++x) {
                li = (ListItem)this.items.elementAt(x);
                li.bCellBorder = bOn;
            }
            this.bAllDirty = true;
            this.invalidate();
        }
    }

    public boolean isCellBorders() {
        return this.bCellBorders;
    }

    public void setEnabledTextColor(int index, Color color) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.color = color;
        }
    }

    public void crossOut(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.deleted = true;
            tempItem.bDirty = true;
        }
    }

    public void crossOut(int index, boolean val) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.deleted = val;
            tempItem.bDirty = true;
        }
    }

    public boolean isCrossedOff(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.deleted;
        }
        return false;
    }

    public int getCrossedOffIndex() {
        int l = this.items.size();
        for (int index = 0; index < l; ++index) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            if (!tempItem.deleted) continue;
            return index;
        }
        return -1;
    }

    public boolean isCrossedOff() {
        return this.getCrossedOffIndex() != -1;
    }

    public Color getEnabledTextColor(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.color;
        }
        return null;
    }

    public synchronized void setMultiColumnMode(boolean bCellBorders) {
        if (this.isCellBorders() != bCellBorders) {
            this.setComboMode(false);
            this.setBorderType(1);
            this.setCellBorders(bCellBorders);
            this.yAdj = 2;
        }
    }

    public void setListItems(String[] items) {
        this.clear(items.length);
        for (int i = 0; i < items.length; ++i) {
            this.addItem(items[i]);
        }
    }

    public String[] getListItems() {
        int len = this.countItems();
        String[] items = new String[len];
        for (int i = 0; i < len; ++i) {
            items[i] = this.getText(i);
        }
        return items;
    }

    public void setEdited(int index, boolean bCond) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.bEdited = bCond;
        }
    }

    public boolean isEdited(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.bEdited;
        }
        return false;
    }

    public void setMultipleSelections(boolean cond) {
        if (this.bMultipleSelections != cond) {
            if (!cond) {
                this.deselectAll();
            }
            this.bMultipleSelections = cond;
        }
    }

    public boolean isMultipleSelections() {
        return this.bMultipleSelections;
    }

    public void setEnabled(int index, boolean cond) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            if (tempItem.bEnabled != cond) {
                tempItem.bEnabled = cond;
                if (!cond) {
                    this.deselect(index);
                }
                tempItem.bDirty = true;
                if (!this.bInternalBlockPaint) {
                    this.repaint();
                }
            }
        }
    }

    public boolean isEnabled(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.bEnabled;
        }
        return false;
    }

    public void setText(int index, String text) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.sText = text;
            tempItem.bDirty = true;
            tempItem.updateWidth(this.fm);
            this.updateWidth(tempItem);
        }
    }

    public String getText(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).sText;
        }
        return null;
    }

    public void setImageURL(int index, URL aUrl) throws MalformedURLException {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            Image image = this.getToolkit().getImage(aUrl);
            if (image != null) {
                this.setImage(index, image);
            }
            tempItem.url = aUrl;
        }
    }

    public URL getImageURL(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).url;
        }
        return null;
    }

    public void setImage(int index, Image image) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.image = image;
            tempItem.bDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public Image getImage(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).image;
        }
        return null;
    }

    public synchronized void setSelectedItem(String str, boolean isSelected) {
        int z = this.items.size();
        for (int i = 0; i < z; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.sText.equalsIgnoreCase(str) || !li.bEnabled) continue;
            this.setSelectedIndex(i, isSelected);
            return;
        }
    }

    public synchronized String getSelectedItem() {
        return this.lastSelected < 0 ? null : this.getText(this.lastSelected);
    }

    public void setLastSelected(int index) {
        this.lastSelected = index;
    }

    public synchronized void setSelectedIndex(int index, boolean isSelected) {
        ListItem listItem = null;
        if (this.bMultipleSelections) {
            listItem = (ListItem)this.items.elementAt(index);
            this.clearSelected();
            listItem.bSelected = isSelected;
            listItem.bDirty = true;
            if (isSelected) {
                ++this.countSelected;
            }
        } else {
            int s = this.items.size();
            if (index < s && index > -1) {
                listItem = (ListItem)this.items.elementAt(index);
                boolean wasSelected = listItem.bSelected;
                if (isSelected) {
                    this.clearSelected();
                    listItem.bSelected = true;
                    if (wasSelected) {
                        listItem.bDirty = false;
                    }
                    this.countSelected = 1;
                } else {
                    listItem.bSelected = false;
                    listItem.tagged = false;
                    if (wasSelected) {
                        listItem.bDirty = true;
                        --this.countSelected;
                    }
                }
            }
        }
        this.lastSelected = index;
        this.lastIndex = index;
        this.setVisibleIndex(index);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void setDeselected(int index) {
        if (!this.validIndex(index)) {
            return;
        }
        ListItem listItem = (ListItem)this.items.elementAt(index);
        if (listItem.bSelected) {
            listItem.bSelected = false;
            listItem.bDirty = true;
            --this.countSelected;
        }
        this.lastSelected = -1;
    }

    public synchronized void setDeselected() {
        this.setDeselected(this.lastIndex);
        this.repaint();
    }

    public synchronized int getSelectedIndex() {
        return this.lastSelected;
    }

    public synchronized int[] getSelectedIndexes() {
        int[] sel = new int[this.countSelected];
        if (this.countSelected == 1) {
            sel[0] = this.lastSelected;
        } else if (this.countSelected > 1) {
            int x = 0;
            int s = this.items.size();
            for (int i = 0; i < s; ++i) {
                ListItem tempItem = (ListItem)this.items.elementAt(i);
                if (!tempItem.bSelected && !tempItem.tagged) continue;
                sel[x++] = i;
                if (x == this.countSelected) break;
            }
        }
        return sel;
    }

    public synchronized String[] getSelectedItems() {
        String[] str = new String[this.countSelected];
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem tempItem = (ListItem)this.items.elementAt(this.lastSelected);
                str[0] = tempItem.sText;
            }
        } else if (this.countSelected > 0) {
            int x = 0;
            int s = this.items.size();
            for (int i = 0; i < s; ++i) {
                ListItem tempItem = (ListItem)this.items.elementAt(i);
                if (!tempItem.bSelected && !tempItem.tagged) continue;
                str[x] = tempItem.sText;
                if (++x == this.countSelected) break;
            }
        }
        return str;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public synchronized boolean isSelected(int index) {
        if (this.validIndex(index)) {
            ListItem listItem = (ListItem)this.items.elementAt(index);
            return listItem.bSelected || listItem.deleted;
        }
        return false;
    }

    public synchronized void setLabel(String label) {
        this.ilbLabel = label;
    }

    public synchronized String getLabel() {
        return new String(this.ilbLabel);
    }

    public synchronized void setVisibleIndex(int index) {
        if (index < this.nTopRow) {
            this.scrollVertical(index, true);
            return;
        }
        if (index < this.nTopRow + this.visibleRows) {
            return;
        }
        this.scrollVertical(index - this.visibleRows + 1, true);
    }

    public void setTopRow(int index) {
        if (index < 0) {
            return;
        }
        int s = this.items.size();
        if (s < this.visibleRows) {
            index = 0;
        } else if (index > s - this.visibleRows) {
            index = s - this.visibleRows;
        }
        if (this.nTopRow != index) {
            this.nTopRow = index;
            this.bAllDirty = true;
            this.invalidate();
        }
    }

    public synchronized int getTopRow() {
        return this.nTopRow;
    }

    public synchronized void setColumns(int columns) {
        if (this.colsToShow != columns) {
            this.colsToShow = columns;
            this.invalidate();
        }
    }

    public synchronized int getColumns() {
        return this.colsToShow;
    }

    public int getRows() {
        return this.visibleRows;
    }

    public synchronized void setFont(Font f) {
        super.setFont(f);
        this.fm = this.getFontMetrics(f);
        this.updateWidths(this.fm);
        this.xCoord = 0;
        this.bAllDirty = true;
        this.invalidate();
    }

    public synchronized void setDirty(boolean isDirty) {
        this.bAllDirty = isDirty;
    }

    public synchronized boolean isDirty() {
        return this.bAllDirty;
    }

    public boolean isAllSelected() {
        return this.countSelected == this.items.size();
    }

    protected void addItem(ListItem li) {
        if (li != null) {
            this.items.addElement(li);
            this.updateWidth(li);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void addItem(int no) {
        this.addItem(new ListItem(this.image, this.arrayModel[no], true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image img, int no) {
        this.addItem(new ListItem(img, this.arrayModel[no], true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(String item) {
        this.addItem(new ListItem(null, item, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(String item, boolean bEnabled) {
        this.addItem(new ListItem(null, item, bEnabled, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String item) {
        this.addItem(new ListItem(image, item, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String item, boolean bEnabled) {
        this.addItem(new ListItem(image, item, bEnabled, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String item, boolean bEnabled, Color color) {
        ListItem li = new ListItem(image, item, bEnabled, this.fm, this.bCellBorders);
        li.color = color;
        this.addItem(li);
    }

    public synchronized void insertItem(int index, Image image, String item, boolean bEnabled) {
        ListItem li = null;
        if (this.validIndex(index)) {
            li = new ListItem(image, item, bEnabled, this.fm, this.bCellBorders);
            this.items.insertElementAt(li, index);
            this.bAllDirty = true;
            if (this.lastSelected >= index) {
                ++this.lastSelected;
            }
        } else {
            li = new ListItem(image, item, bEnabled, this.fm, this.bCellBorders);
            this.items.addElement(li);
        }
        this.updateWidth(li);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void insertItems(int index, Vector itemVector, Image image, boolean bEnabled) {
        int s = itemVector.size();
        int x = 0;
        if (this.validIndex(index)) {
            for (x = 0; x < s; ++x) {
                this.items.insertElementAt(new ListItem(image, (String)itemVector.elementAt(x), bEnabled, this.fm, this.bCellBorders), index++);
            }
        } else {
            for (x = 0; x < s; ++x) {
                this.items.addElement(new ListItem(image, (String)itemVector.elementAt(x), bEnabled, this.fm, this.bCellBorders));
            }
        }
        this.deselectAll();
        this.bAllDirty = true;
        this.updateWidths(this.fm);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public int countItems() {
        return this.items.size();
    }

    public synchronized void clear() {
        this.clear(16);
    }

    public synchronized void clear(int capacity) {
        this.items = new Vector(capacity, 16);
        this.nTopRow = 0;
        this.lastDownModifiers = -1;
        this.lastSelected = -1;
        this.lastIndex = -1;
        this.lastTempIndex = -1;
        this.countSelected = 0;
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
        this.VBar.setValues(1, 1, 0, 2);
        this.VBar.setVisible(false);
        this.bVBarVisible = false;
        this.HBar.setValues(1, 1, 0, 2);
        this.HBar.setVisible(false);
        this.bHBarVisible = false;
        this.bAllDirty = true;
        this.bInternalBlockPaint = false;
        this.bBlockPaint = false;
        this.longestLineValue = 0;
        this.xCoord = 0;
    }

    public synchronized void delItem(int index) {
        if (this.validIndex(index)) {
            this.items.removeElementAt(index);
            this.bAllDirty = true;
            this.scrollVertical(this.nTopRow, true);
            this.updateWidths(null);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void delItems(int start, int end) {
        int s = this.items.size();
        if (s > 0) {
            if (end >= s) {
                end = s - 1;
            }
            if (start < 0) {
                start = 0;
            }
            if (start <= end) {
                this.bInternalBlockPaint = true;
                for (int i = end; i >= start; --i) {
                    this.items.removeElementAt(i);
                }
                this.bInternalBlockPaint = false;
                this.bAllDirty = true;
                this.scrollVertical(this.nTopRow, true);
                this.updateWidths(null);
                this.repaint();
            }
        }
    }

    public synchronized void delSelectedItems() {
        int s = this.items.size();
        this.bInternalBlockPaint = true;
        int x = 0;
        while (x < s) {
            ListItem tempItem = (ListItem)this.items.elementAt(x);
            if (tempItem.bSelected) {
                this.delItem(x);
                --s;
                continue;
            }
            ++x;
        }
        this.bAllDirty = true;
        this.scrollVertical(this.nTopRow, true);
        this.updateWidths(null);
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public synchronized void selectMultiple(int index, boolean bShift, boolean bControl) {
        if (!this.bMultipleSelections) {
            bShift = false;
            bControl = false;
        }
        if (bShift) {
            this.shiftSelect(index, bControl);
        } else if (bControl) {
            this.ctrlSelect(index);
        } else {
            this.setSelectedIndex(index, true);
        }
    }

    public synchronized void selectAll() {
        if (!this.bMultipleSelections) {
            return;
        }
        int s = this.items.size();
        for (int i = 0; i < s; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.bEnabled) continue;
            li.bSelected = true;
        }
        this.countSelected = s;
        this.lastSelected = s - 1;
        this.repaint();
    }

    public synchronized void deselect(int index) {
        if (this.validIndex(index)) {
            this.setSelectedIndex(index, false);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void deselectAll() {
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem li = (ListItem)this.items.elementAt(this.lastSelected);
                li.bSelected = false;
                li.bDirty = true;
                li.deleted = false;
                li.tagged = false;
            }
        } else {
            int s = this.items.size();
            for (int i = 0; i < s; ++i) {
                ListItem li = (ListItem)this.items.elementAt(i);
                li.bSelected = false;
                li.bDirty = true;
                li.deleted = false;
                li.tagged = false;
            }
        }
        this.lastSelected = -1;
        this.countSelected = 0;
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void uncrossAll() {
        int m;
        for (int i = m = this.items.size(); i >= 0; --i) {
            this.crossOut(i, false);
        }
    }

    public synchronized void clearSelected() {
        int s = this.items.size();
        for (int i = 0; i < s; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.bSelected && !li.tagged) continue;
            li.bSelected = false;
            li.tagged = false;
            li.bDirty = true;
        }
        this.lastSelected = -1;
        this.countSelected = 0;
    }

    public Dimension getPreferredSize(int rows) {
        Dimension d = this.getMinimumSize(rows);
        Dimension s = this.getSize();
        return new Dimension(Math.max(d.width, s.width), Math.max(d.height, s.height));
    }

    public Dimension getPreferredSize() {
        if (this.rowsToShow > 0) {
            return this.getPreferredSize(this.rowsToShow);
        }
        return this.getPreferredSize(this.items.size());
    }

    public Dimension getMinimumSize(int rows) {
        this.font = this.getFont();
        if (this.font != null) {
            this.fm = this.getFontMetrics(this.font);
            if (this.fm != null) {
                this.fontHeight = this.fm.getHeight();
                this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
                return new Dimension(this.fm.stringWidth("WN") * this.colsToShow / 2 + 4, rows * this.cellHt + this.borderWidth + this.yAdj);
            }
        }
        return new Dimension(this.borderWidth + 4, this.borderWidth + this.yAdj);
    }

    public Dimension getMinimumSize() {
        if (this.rowsToShow > 0) {
            return this.getMinimumSize(this.rowsToShow);
        }
        return this.getMinimumSize(this.items.size());
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        this.VBar.addAdjustmentListener(this);
        this.HBar.addAdjustmentListener(this);
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
        this.font = this.getFont();
        this.fm = this.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.updateWidths(this.fm);
    }

    public synchronized void removeNotify() {
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        this.removeKeyListener(this);
        this.VBar.removeAdjustmentListener(this);
        this.HBar.removeAdjustmentListener(this);
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public synchronized void blockPaint(boolean cond) {
        this.bBlockPaint = cond;
        if (!this.bBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void enablePainting(boolean m) {
        this.bInternalBlockPaint = !m;
    }

    public synchronized void scrollVertical(int info, boolean bAbsolute) {
        int temp = this.nTopRow;
        if (this.visibleRows == 0) {
            temp = 0;
        } else {
            if (bAbsolute) {
                temp = info;
            } else {
                switch (info) {
                    case 3: {
                        temp -= this.visibleRows;
                        break;
                    }
                    case 4: {
                        temp += this.visibleRows;
                        break;
                    }
                    case 2: {
                        --temp;
                        break;
                    }
                    case 1: {
                        ++temp;
                    }
                }
            }
            if (temp < 0) {
                temp = 0;
            } else if (temp > this.items.size() - this.visibleRows && (temp = this.items.size() - this.visibleRows) < 0) {
                temp = 0;
            }
        }
        if (this.nTopRow != temp) {
            this.nTopRow = temp;
            this.VBar.setValue(temp);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void scrollHorizontal(int info, boolean bAbsolute) {
        int temp = this.xCoord;
        if (bAbsolute) {
            temp = -info;
        } else {
            switch (info) {
                case 3: {
                    temp += this.lWidth;
                    break;
                }
                case 4: {
                    temp -= this.lWidth;
                    break;
                }
                case 2: {
                    ++temp;
                    break;
                }
                case 1: {
                    --temp;
                }
            }
        }
        if (temp > 0) {
            temp = 0;
        } else if (-temp > this.HBar.getMaximum() - this.lWidth) {
            temp = -(this.HBar.getMaximum() - this.lWidth);
        }
        if (this.xCoord != temp) {
            this.xCoord = temp;
            this.HBar.setValue(-temp);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void update(Graphics g) {
        if (!this.bBlockPaint && !this.bInternalBlockPaint) {
            this.paint(g);
        }
    }

    public synchronized void paint(Graphics g) {
        int vWid = 0;
        int hHt = 0;
        int gridAdj = 0;
        int yLoc = 0;
        int ySLoc = 0;
        boolean bShowV = false;
        boolean bShowH = false;
        Color curBackground = this.getBackground();
        if (!Tool.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateBorderColors(this.PanelColor);
        }
        Rectangle rect = this.getBounds();
        this.font = g.getFont();
        this.fm = g.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
        int nItems = this.items.size();
        this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
        if (nItems == 0) {
            this.nTopRow = 0;
            this.visibleRows = 0;
            bShowH = false;
            bShowV = false;
            this.xCoord = 0;
        } else {
            if (this.bAllowShowHBar && this.longestLineValue > rect.width - this.borderWidth) {
                bShowH = true;
                hHt = this.barSize;
            } else {
                bShowH = false;
                hHt = 0;
                this.xCoord = 0;
            }
            int rows = (rect.height - hHt - this.borderWidth - this.yAdj) / this.cellHt;
            if (this.bAllowShowVBar && nItems > rows) {
                bShowV = true;
                vWid = this.barSize;
                if (!bShowH && this.bAllowShowHBar && this.longestLineValue > rect.width - this.borderWidth - vWid) {
                    bShowH = true;
                    hHt = this.barSize;
                    rows = (rect.height - hHt - this.borderWidth - this.yAdj) / this.cellHt;
                }
            } else {
                bShowV = false;
                vWid = 0;
            }
            if (this.visibleRows != rows) {
                this.visibleRows = rows;
                this.bAllDirty = true;
            }
            if (bShowV) {
                this.VBar.setBounds(rect.width - this.barSize - this.halfBorderWidth, this.halfBorderWidth, this.barSize, rect.height - this.borderWidth - hHt);
                this.VBar.setValues(this.nTopRow, this.visibleRows, 0, nItems);
                this.VBar.setBlockIncrement(this.visibleRows);
                this.lWidth = rect.width - vWid - this.borderWidth;
                if (!this.bVBarVisible) {
                    this.bVBarVisible = true;
                    this.VBar.setVisible(true);
                }
            } else {
                this.lWidth = rect.width - this.borderWidth;
                if (this.bVBarVisible) {
                    this.bVBarVisible = false;
                    this.VBar.setVisible(false);
                }
            }
            if (bShowH) {
                this.HBar.setBounds(this.halfBorderWidth, rect.height - this.barSize - this.halfBorderWidth, rect.width - this.borderWidth - vWid, this.barSize);
                this.HBar.setValues(-this.xCoord, this.lWidth, 0, this.longestLineValue);
                this.HBar.setBlockIncrement(this.lWidth);
                if (!this.bHBarVisible) {
                    this.bHBarVisible = true;
                    this.HBar.setVisible(true);
                }
            } else if (this.bHBarVisible) {
                this.bHBarVisible = false;
                this.HBar.setVisible(false);
            }
        }
        if (nItems == 0 || this.bAllDirty) {
            g.clearRect(this.halfBorderWidth, this.halfBorderWidth, rect.width - this.borderWidth - 1, rect.height - this.borderWidth - 1);
        }
        if (this.borderType == 0) {
            g.setColor(this.borderDarkerColor);
            g.drawLine(0, 0, rect.width - 1, 0);
            g.drawLine(0, 0, 0, rect.height - 1);
            g.setColor(this.borderDarkColor);
            g.drawLine(1, 1, rect.width - 2, 1);
            g.drawLine(1, 1, 1, rect.height - 2);
            g.setColor(this.borderLightColor);
            g.drawLine(1, rect.height - 2, rect.width - 2, rect.height - 2);
            g.drawLine(rect.width - 2, 1, rect.width - 2, rect.height - 2);
            g.setColor(this.borderLighterColor);
            g.drawLine(0, rect.height - 1, rect.width - 1, rect.height - 1);
            g.drawLine(rect.width - 1, 0, rect.width - 1, rect.height - 1);
        }
        g.clipRect(this.halfBorderWidth, this.halfBorderWidth, this.lWidth, rect.height - this.borderWidth);
        if (this.nTopRow >= nItems) {
            this.nTopRow -= this.visibleRows + 1;
        }
        int i = this.nTopRow;
        int j = Math.min(this.nTopRow + this.visibleRows, nItems);
        int dp = 0;
        while (i < j) {
            yLoc = dp * this.cellHt + this.yAdj + this.halfBorderWidth;
            ySLoc = (dp + 1) * this.cellHt + this.yAdj + this.halfBorderWidth;
            ListItem item = (ListItem)this.items.elementAt(i);
            if (item.bDirty || this.bAllDirty) {
                item.bDirty = false;
                g.clearRect(this.halfBorderWidth, yLoc, this.lWidth, this.cellHt);
            }
            int xSelectStartLoc = item.image != null ? this.halfBorderWidth + 20 + 2 : this.halfBorderWidth;
            gridAdj = item.bCellBorder ? 2 : 0;
            int tWidth = this.lWidth - this.xCoord - 20 - 2;
            if (item.bSelected) {
                g.setColor(this.textHighlight);
                g.fillRect(this.xCoord + xSelectStartLoc + gridAdj, yLoc, tWidth, this.cellHt);
                g.setColor(this.textHighlightText);
            } else if (item.bEnabled) {
                if (item.color == null) {
                    g.setColor(this.enabledColor);
                } else {
                    g.setColor(item.color);
                }
            } else {
                g.setColor(this.disabledColor);
            }
            g.drawString(item.sText, this.xCoord + xSelectStartLoc + gridAdj + 2, ySLoc - this.fontDescent);
            if (item.image != null) {
                g.drawImage(item.image, this.xCoord + this.halfBorderWidth + gridAdj + 2, yLoc + 2, 20, this.cellHt - 3, this);
            }
            if (item.deleted) {
                g.setColor(Color.red);
                int yy = yLoc + this.cellHt / 2;
                g.drawLine(this.xCoord + this.halfBorderWidth + gridAdj + 2, yy, this.lWidth, yy);
            }
            if (item.bCellBorder) {
                g.setColor(item.cellBorderColor);
                g.drawRect(this.halfBorderWidth, yLoc, this.lWidth, this.cellHt);
            }
            if (item.tagged) {
                g.setColor(this.textHighlight);
                g.drawRect(this.xCoord + xSelectStartLoc + gridAdj, yLoc + 1, tWidth, this.cellHt - 2);
            }
            ++i;
            ++dp;
        }
        this.bAllDirty = false;
        this.listChanged = false;
    }

    public synchronized void setBounds(int x, int y, int width, int height) {
        this.bAllDirty = true;
        super.setBounds(x, y, width, height);
    }

    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        int x = e.getX();
        int y = e.getY();
        int index = -1;
        if (e.isPopupTrigger()) {
            this.popx = e.getX();
            this.popy = e.getY();
            this.sendActionEvent("Popup");
            return;
        }
        ++this.fastDownCount;
        this.bMouseDrawHandled = false;
        if (x > -1 && x < this.lWidth) {
            index = this.mouseCalcIndex(y);
            if (index == -1) {
                return;
            }
            if (this.bMultipleSelections) {
                if (e.isShiftDown() && e.isControlDown()) {
                    this.bMouseDrawHandled = true;
                    this.shiftSelect(index, true);
                } else if (e.isShiftDown()) {
                    this.bMouseDrawHandled = true;
                    this.shiftSelect(index, false);
                } else if (e.isControlDown()) {
                    this.bMouseDrawHandled = true;
                    this.ctrlSelect(index);
                } else {
                    this.setSelectedIndex(index, true);
                }
            } else {
                this.lastTempIndex = index;
                this.setSelectedIndex(index, true);
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        boolean bDoubleClick;
        int x = e.getX();
        int y = e.getY();
        int index = -1;
        if (e.isPopupTrigger()) {
            this.popx = e.getX();
            this.popy = e.getY();
            this.sendActionEvent("Popup");
            this.requestFocus();
            return;
        }
        --this.fastDownCount;
        if (this.bMouseDrawHandled) {
            this.notifyHelper(-1, y, -1, false);
            return;
        }
        index = this.mouseCalcIndex(y);
        if (index == -1 || x < 0 || x >= this.lWidth) {
            this.fastDownCount = 0;
            index = this.lastTempIndex;
            if (index == -1) {
                return;
            }
        }
        if (this.bComboMode) {
            this.fastDownCount = 0;
            bDoubleClick = false;
        } else if (this.fastDownCount > 0) {
            this.fastDownCount = 0;
            bDoubleClick = true;
            this.prevSelectTime = -1L;
            this.prevSelectRow = -1L;
        } else {
            long selectTime = System.currentTimeMillis();
            if (this.prevSelectTime != -1L && this.prevSelectRow == (long)index && this.prevSelectTime + 250L > selectTime) {
                bDoubleClick = true;
                this.prevSelectTime = -1L;
                this.prevSelectRow = -1L;
            } else {
                bDoubleClick = false;
                this.prevSelectTime = selectTime;
                this.prevSelectRow = index;
            }
        }
        if (this.lastSelected != index) {
            this.setSelectedIndex(index, true);
            this.repaint();
        }
        if (this.bMultipleSelections) {
            this.notifyHelper(x, y, this.lastSelected, bDoubleClick);
            this.lastIndex = this.lastSelected;
        } else {
            this.notifyHelper(x, y, index, bDoubleClick);
            this.lastIndex = index;
        }
        this.lastTempIndex = -1;
        this.lastDownModifiers = -1;
    }

    public void mouseExited(MouseEvent e) {
        if (!this.bMultipleSelections && this.bComboMode) {
            this.lastIndex = -1;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (!this.isVisible()) {
            return;
        }
        if (e.isMetaDown() || e.isAltDown()) {
            return;
        }
        int index = -1;
        if (e.isControlDown()) {
            switch (code) {
                case 38: {
                    index = this.keyCalcIndex(-1, false);
                    break;
                }
                case 40: {
                    index = this.keyCalcIndex(1, false);
                }
            }
            if (index == -1) {
                return;
            }
            if (this.bMultipleSelections) {
                this.setVisibleIndex(index);
                this.ctrlSelect(index);
                this.repaint();
                this.notifyHelper(-1, -1, index, false);
                this.prevSelectTime = -1L;
                this.prevSelectRow = -1L;
            }
            return;
        }
        switch (code) {
            case 10: {
                this.sendActionEvent("Enter");
                this.requestFocus();
                break;
            }
            case 127: {
                this.sendActionEvent("Delete");
                this.requestFocus();
                break;
            }
            case 27: {
                this.sendActionEvent("Esc");
                break;
            }
            case 37: {
                this.sendActionEvent("Up");
                this.requestFocus();
                break;
            }
            case 36: {
                index = this.keyCalcIndex(0, true);
                break;
            }
            case 35: {
                index = this.keyCalcIndex(this.items.size() - 1, true);
                break;
            }
            case 33: {
                index = this.keyCalcIndex(-this.visibleRows, false);
                break;
            }
            case 34: {
                index = this.keyCalcIndex(this.visibleRows, false);
                break;
            }
            case 38: {
                index = this.keyCalcIndex(-1, false);
                break;
            }
            case 32: {
                index = this.keyCalcIndex(1, false);
                if (index == -1) {
                    return;
                }
                if (this.bMultipleSelections) {
                    this.setVisibleIndex(index);
                    this.ctrlSelect(index);
                    this.repaint();
                    this.notifyHelper(-1, -1, index, false);
                    this.prevSelectTime = -1L;
                    this.prevSelectRow = -1L;
                }
                return;
            }
            case 40: {
                index = this.keyCalcIndex(1, false);
                break;
            }
            default: {
                int i;
                if (code < 65 || code > 90) break;
                int li = this.lastIndex;
                if (li < 0 || li >= this.items.size()) {
                    li = -1;
                }
                if ((i = this.moveCursor(code, ++li)) <= -1) break;
                index = this.keyCalcIndex(i, true);
            }
        }
        if (index == -1) {
            return;
        }
        if (this.bMultipleSelections && e.isShiftDown()) {
            this.setVisibleIndex(index);
            this.shiftSelect(index, false);
            return;
        }
        this.setSelectedIndex(index, true);
        this.repaint();
        this.notifyHelper(-1, -1, index, false);
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.VBar) {
            if (e.getAdjustmentType() == 5) {
                this.scrollVertical(e.getValue(), true);
            } else {
                this.scrollVertical(e.getAdjustmentType(), false);
            }
        } else if (e.getSource() == this.HBar) {
            if (e.getAdjustmentType() == 5) {
                this.scrollHorizontal(e.getValue(), true);
            } else {
                this.scrollHorizontal(e.getAdjustmentType(), false);
            }
        }
    }

    protected void sourceItemEvent() {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, 1));
        }
    }

    protected boolean validIndex(int index) {
        return index >= 0 && index < this.items.size();
    }

    protected boolean isVisibleIndex(int index) {
        return index >= this.nTopRow && index < this.nTopRow + this.visibleRows;
    }

    protected String paramString() {
        return super.paramString() + ", selected=" + this.getSelectedItem();
    }

    protected void shiftSelect(int index, boolean bControl) {
        int i = 0;
        int s = 0;
        if (this.lastSelected == -1) {
            this.setSelectedIndex(index, true);
        } else if (this.lastSelected == index) {
            if (!bControl) {
                this.bInternalBlockPaint = true;
                this.setSelectedIndex(index, true);
                this.bInternalBlockPaint = false;
            }
        } else if (this.lastSelected < index) {
            if (!this.isEnabled(index)) {
                return;
            }
            if (bControl) {
                i = this.lastSelected + 1;
                s = Math.min(this.items.size(), index + 1);
            } else {
                i = 0;
                s = this.items.size();
            }
            while (i < s) {
                ListItem li = (ListItem)this.items.elementAt(i);
                if (i < this.lastSelected || i > index) {
                    if (li.bSelected) {
                        li.bDirty = true;
                        li.bSelected = false;
                        --this.countSelected;
                    }
                } else if (!li.bSelected) {
                    li.bDirty = true;
                    li.bSelected = true;
                    ++this.countSelected;
                }
                ++i;
            }
        } else if (this.lastSelected > index) {
            if (!this.isEnabled(index)) {
                return;
            }
            if (bControl) {
                i = index;
                s = Math.min(this.items.size(), this.lastSelected);
            } else {
                i = 0;
                s = this.items.size();
            }
            for (i = 0; i < s; ++i) {
                ListItem li = (ListItem)this.items.elementAt(i);
                if (i < index || i > this.lastSelected) {
                    if (!li.bSelected) continue;
                    li.bDirty = true;
                    li.bSelected = false;
                    --this.countSelected;
                    continue;
                }
                if (li.bSelected) continue;
                li.bDirty = true;
                li.bSelected = true;
                ++this.countSelected;
            }
        }
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected void ctrlSelect(int index) {
        ListItem listItem = (ListItem)this.items.elementAt(index);
        if (!listItem.bEnabled) {
            return;
        }
        if (listItem.bSelected) {
            listItem.bSelected = false;
            --this.countSelected;
            this.lastSelected = -1;
        } else {
            listItem.bSelected = true;
            ++this.countSelected;
            this.lastSelected = index;
        }
        listItem.bDirty = true;
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected int mouseCalcIndex(int y) {
        int mci = y < this.yAdj ? this.nTopRow - 1 : (y - this.yAdj) / this.cellHt + this.nTopRow;
        if (mci >= this.items.size()) {
            mci = -1;
        } else if (mci < 0) {
            mci = 0;
        }
        return mci;
    }

    protected void updateWidth(ListItem li) {
        int lineWidth = li.lineWidth + 4;
        if (li.image != null) {
            lineWidth += 20;
        }
        if (lineWidth > this.longestLineValue) {
            this.longestLineValue = lineWidth;
        }
        this.listChanged = true;
    }

    protected void updateWidths(FontMetrics fm) {
        int s = this.items.size();
        this.longestLineValue = 0;
        for (int x = 0; x < s; ++x) {
            ListItem li = (ListItem)this.items.elementAt(x);
            li.updateWidth(fm);
            int lineWidth = li.lineWidth + 4;
            if (li.image != null) {
                lineWidth += 20;
            }
            if (lineWidth <= this.longestLineValue) continue;
            this.longestLineValue = lineWidth;
        }
        this.listChanged = true;
    }

    protected void notifyHelper(int x, int y, int index, boolean bDoubleClick) {
        if (bDoubleClick) {
            this.sendActionEvent("DoubleClicked");
        } else {
            if (x >= 0 && x - this.xCoord < 20) {
                ListItem listItem = (ListItem)this.items.elementAt(index);
                if (listItem.image != null) {
                    this.sendActionEvent("ImageSelected");
                }
            }
            this.sourceItemEvent();
        }
    }

    protected void calculateBorderColors(Color c) {
        this.borderLighterColor = Effect.hilight(c);
        this.borderDarkerColor = Effect.shadow(c);
        this.borderLightColor = Effect.darken(this.borderLighterColor, 0.2);
        this.borderDarkColor = Effect.darken(this.borderDarkerColor, 0.2);
    }

    protected int keyCalcIndex(int offset, boolean bAbsolute) {
        this.lastIndex = bAbsolute ? offset : (this.lastIndex += offset);
        if (this.lastIndex >= this.items.size()) {
            this.lastIndex = this.items.size() - 1;
        } else if (this.lastIndex < 0) {
            this.lastIndex = 0;
        }
        return this.lastIndex;
    }

    public int moveCursor(int code, int start) {
        int m = this.items.size();
        code = Character.toLowerCase((char)code);
        for (int i = start; i < m; ++i) {
            char c = Character.toLowerCase(this.getText(i).charAt(0));
            if (c != code) continue;
            return i;
        }
        return -1;
    }

    public void setPanelColor(Color c) {
        this.PanelColor = c;
    }

    public void setStyle(Style s) {
        this.setBackground(s.background);
        this.setForeground(s.foreground);
        this.setFont(s.font);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.VBar.setBackground(bg);
        this.HBar.setBackground(bg);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        if (OS.isMacintosh()) {
            return;
        }
        this.textHighlightText = Color.white;
        this.enabledColor = c;
        this.disabledColor = Color.gray;
    }

    public synchronized void update(boolean d) {
        if (d) {
            this.bAllDirty = true;
        }
        this.paint(this.getGraphics());
    }

    public void setPainting(boolean cond) {
        this.bInternalBlockPaint = !cond;
    }

    protected void sendActionEvent(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, new String(command)));
        }
    }

    public int getIndex(String str) {
        int z = this.items.size();
        for (int i = 0; i < z; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.sText.equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    public void showIt(int index) {
        if (this.validIndex(index)) {
            index = this.keyCalcIndex(index, true);
            this.bInternalBlockPaint = false;
            this.setSelectedIndex(index, true);
            this.requestFocus();
        }
    }

    public void showIt(String name) {
        this.showIt(this.getIndex(name));
    }

    public synchronized void setTagged(int index, boolean state) {
        ListItem listItem = (ListItem)this.items.elementAt(index);
        listItem.tagged = state;
        listItem.bDirty = true;
        this.countTagged = state ? ++this.countTagged : --this.countTagged;
        this.lastTagged = index;
    }

    public boolean isTagged(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).tagged;
        }
        return false;
    }

    public boolean isTagged() {
        return this.getTaggedIndex() != -1;
    }

    public int getTaggedIndex() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (!((ListItem)this.items.elementAt((int)i)).tagged) continue;
            return i;
        }
        return -1;
    }

    public String getTaggedItem() {
        return this.getText(this.getTaggedIndex());
    }

    public String[] getTaggedItems() {
        VectorString vs = new VectorString();
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem tempItem = (ListItem)this.items.elementAt(i);
            if (!tempItem.bSelected && !tempItem.tagged) continue;
            vs.addElement(((ListItem)this.items.elementAt((int)i)).sText);
        }
        return vs.toArray();
    }

    public boolean isSelected() {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            ListItem tempItem = (ListItem)this.items.elementAt(i);
            if (tempItem.bSelected) {
                return true;
            }
            if (!tempItem.deleted) continue;
            return true;
        }
        return false;
    }

    public void hideSelection() {
        int s = this.items.size();
        for (int i = 0; i < s; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.bSelected) continue;
            li.bSelected = false;
            li.bDirty = true;
            li.tagged = true;
        }
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public void showSelection() {
        int s = this.items.size();
        for (int i = 0; i < s; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.tagged) continue;
            li.bSelected = true;
            li.tagged = false;
            li.bDirty = true;
        }
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public void clean() {
        this.bInternalBlockPaint = false;
        this.bAllDirty = true;
        this.deselectAll();
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        Focus() {
        }

        public void focusGained(FocusEvent event) {
            DListBox.this.hasFocus = true;
            DListBox.this.showSelection();
        }

        public void focusLost(FocusEvent event) {
            DListBox.this.hasFocus = false;
            DListBox.this.hideSelection();
        }
    }

    class MouseMotion
    implements MouseMotionListener,
    Serializable {
        MouseMotion() {
        }

        public void mouseMoved(MouseEvent e) {
            if (!DListBox.this.bMultipleSelections) {
                int x = e.getX();
                int y = e.getY();
                int index = -1;
                if (x > -1 && x < DListBox.this.lWidth && DListBox.this.bComboMode) {
                    index = DListBox.this.mouseCalcIndex(y);
                    if (index == -1 || index == DListBox.this.lastIndex) {
                        return;
                    }
                    DListBox.this.lastIndex = index;
                    DListBox.this.setSelectedIndex(index, true);
                    DListBox.this.repaint();
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int index = -1;
            if (x > -1 && x < DListBox.this.lWidth) {
                if (DListBox.this.bComboMode) {
                    index = DListBox.this.mouseCalcIndex(y);
                    if (index == -1 || index == DListBox.this.lastIndex) {
                        return;
                    }
                    DListBox.this.lastIndex = index;
                    DListBox.this.setSelectedIndex(index, true);
                    DListBox.this.repaint();
                } else {
                    index = DListBox.this.mouseCalcIndex(y);
                    if (index != -1 && index != DListBox.this.lastIndex) {
                        if (DListBox.this.bMultipleSelections) {
                            if (e.getModifiers() != 0) {
                                return;
                            }
                            DListBox.this.bInternalBlockPaint = true;
                            DListBox.this.setVisibleIndex(index);
                            DListBox.this.bInternalBlockPaint = false;
                            DListBox.this.shiftSelect(index, false);
                        } else {
                            DListBox.this.setSelectedIndex(index, true);
                        }
                        DListBox.this.lastIndex = index;
                    }
                }
            }
        }
    }
}

