/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorList;
import ae.Path;
import ae.Style;
import ae.VectorString;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class DProperties {
    VectorString keys;
    VectorString values;

    public DProperties(int size) {
        this.keys = new VectorString(size);
        this.values = new VectorString(size);
    }

    public DProperties() {
        this(64);
    }

    public void list(PrintStream ps) {
        for (int i = 0; i < this.keys.size(); ++i) {
            ps.println(this.keys.elementAt(i) + "=" + this.values.elementAt(i));
        }
    }

    public String getProperty(String key, String def) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return def;
        }
        return this.values.elementAt(index);
    }

    public String get(String key, String dv) {
        if (dv.equals("null")) {
            dv = null;
        }
        return this.getProperty(key, dv);
    }

    public int get(String key, int defaut) {
        try {
            String tmp = this.get(key, String.valueOf(defaut));
            return Integer.valueOf(tmp);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean get(String key, boolean defaut) {
        try {
            String tmp = this.get(key, String.valueOf(defaut));
            return Boolean.valueOf(tmp);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public VectorString get(String key, String first, String second) {
        VectorString vs = new VectorString(3);
        int index = this.keys.indexOf(key);
        if (index == -1) {
            if (first != null) {
                vs.addElement(first);
            }
            if (second != null) {
                vs.addElement(second);
            }
            return vs;
        }
        StringTokenizer st = new StringTokenizer(this.values.elementAt(index), " ,:\t\n\r", false);
        int size = st.countTokens();
        while (st.hasMoreTokens()) {
            vs.addElement(st.nextToken());
        }
        return vs;
    }

    public static String colorToString(Color c) {
        return Integer.toString(c.getRGB());
    }

    public static Color stringToColor(String s) {
        int index = ColorList.getIndex(s);
        if (index == -1) {
            try {
                int rgb = Integer.valueOf(s);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                return new Color(r, g, b);
            }
            catch (Exception n) {
                n.printStackTrace();
                return Color.lightGray;
            }
        }
        return ColorList.getColor(index);
    }

    public String get(String key, Color c) {
        return this.get(key, DProperties.colorToString(c));
    }

    public String get(String key, SystemColor c) {
        return this.get(key, DProperties.colorToString(c));
    }

    public String get(String key, Style d) {
        return this.get(key, d.getString());
    }

    public void putItem(String str) {
        int j = str.indexOf("=");
        if (j > 0) {
            String lft = str.substring(0, j);
            String rgt = str.substring(j + 1, str.length());
            if (lft != null) {
                this.keys.addElement(lft);
                if (rgt == null) {
                    rgt = "";
                }
                this.values.addElement(rgt);
            }
        }
    }

    public int load(String dir, String filename) {
        String path = Path.merge(dir, filename);
        int counter = 0;
        try {
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            String s = "";
            while (s != null) {
                try {
                    s = br.readLine();
                    if (s == null || s.startsWith("#")) continue;
                    this.putItem(s);
                    ++counter;
                }
                catch (IOException rioe) {
                    s = null;
                }
            }
            try {
                br.close();
            }
            catch (IOException ioe) {}
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(path + " not found");
        }
        return counter;
    }

    public void put(String s) {
        this.keys.addElement(s);
        this.values.addElement((String)null);
    }

    public void put(String k, String val) {
        this.keys.addElement(k);
        this.values.addElement(val);
    }

    public void put(String k, int val) {
        this.put(k, new Integer(val).toString());
    }

    public void put(String k, boolean b) {
        this.put(k, new Boolean(b).toString());
    }

    public void put(String k, Style obj) {
        this.put(k, obj.getString());
    }

    public void put(String k, Color obj) {
        this.put(k, DProperties.colorToString(obj));
    }

    public int save(String dir, String fname) {
        int count = 0;
        String path = Path.merge(dir, fname);
        try {
            FileWriter fw = new FileWriter(path);
            BufferedWriter bw = new BufferedWriter(fw);
            int size = this.keys.size();
            for (int i = 0; i < size; ++i) {
                String s = this.keys.elementAt(i);
                String v = this.values.elementAt(i);
                if (v != null) {
                    s = s + "=" + v;
                }
                bw.write(s, 0, s.length());
                bw.newLine();
                ++count;
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("Error writing " + path);
        }
        return count;
    }

    public static boolean delete(String dir, String fName) {
        return new File(dir, fName).delete();
    }
}

