/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;

public class DSign
extends Canvas {
    public static final int NONE = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int LINE = 3;
    protected int bevel;
    protected Color background;
    protected Color foreground;
    protected Color dark;
    protected Color light;
    protected int width;
    protected int height;
    protected Insets insets = new Insets(1, 1, 1, 1);

    public DSign() {
        this(3);
    }

    public DSign(int bevel) {
        this.bevel = bevel;
    }

    public void setBevel(int s) {
        this.bevel = s;
    }

    public void SetInsets(Insets in) {
        this.insets = in;
    }

    public Insets GetInsets() {
        return this.insets;
    }

    public void setBackground(Color b) {
        this.background = b;
        this.light = b.brighter();
        this.dark = b.darker();
        this.repaint();
    }

    public void setForeground(Color f) {
        this.foreground = f;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        this.width = dim.width;
        this.height = dim.height;
        g.setColor(this.background);
        g.fillRect(1, 1, this.width - 2, this.height - 2);
        this.drawBorder(g, 0, 0, this.width - 1, this.height - 1);
    }

    protected void drawBorder(Graphics g, int x, int y, int w, int h) {
        switch (this.bevel) {
            case 1: {
                g.setColor(this.light);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.dark);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 2: {
                g.setColor(this.dark);
                g.drawLine(x, y, x + w, y);
                g.drawLine(x, y, x, y + h);
                g.setColor(this.light);
                g.drawLine(x, y + h, x + w, y + h);
                g.drawLine(x + w, y, x + w, y + h);
                break;
            }
            case 3: {
                g.setColor(this.foreground);
                g.drawRect(x, y, w, h);
                break;
            }
            case 0: {
                break;
            }
        }
    }
}

