/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DTreeNode;
import ae.OS;
import ae.Style;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class DTreeView
extends Panel
implements ItemSelectable {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    public int selectedIndex;
    public String selectedText;
    public int existIndex;
    int sbVPosition = 0;
    int sbVWidth;
    int sbHPosition = 0;
    int sbHHeight = 0;
    long sbVTimer = -1L;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 14;
    int textBaseLine = 3;
    int doubleClickResolution = 333;
    protected DTreeNode rootNode;
    protected DTreeNode selectedNode;
    protected DTreeNode topVisibleNode;
    protected Scrollbar verticalScrollBar;
    protected boolean sbVShow = false;
    protected int count = 0;
    protected int viewCount = 0;
    protected Scrollbar horizontalScrollBar;
    protected int sbHSize;
    protected int newWidth = 0;
    protected boolean sbHShow = false;
    protected boolean needResetVector;
    protected int sbHLineIncrement = 4;
    protected int viewHeight = 300;
    protected int viewWidth = 300;
    protected int viewWidest = 0;
    protected Key key = null;
    protected Mouse mouse = null;
    protected Adjustment adjustment = null;
    protected ActionListener actionListener = null;
    protected ItemListener itemListener = null;
    protected Focus focus = null;
    protected Vector v;
    protected Vector e;
    protected transient boolean redrawTriggered = false;
    transient boolean hasFocus = false;
    protected transient FontMetrics fm;
    transient long timeMouseDown;
    protected transient boolean isSun1_1;
    protected transient Image im1;
    protected transient Graphics g1 = null;

    public DTreeView() {
        super.setLayout(null);
        this.verticalScrollBar = new Scrollbar(1);
        this.verticalScrollBar.setVisible(false);
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new Scrollbar(0);
        this.horizontalScrollBar.setVisible(false);
        this.add(this.horizontalScrollBar);
        this.needResetVector = true;
    }

    public DTreeView(DTreeNode head) {
        this();
        this.selectedNode = this.rootNode = head;
        this.count = 1;
    }

    public void setStyle(Style s) {
        this.setFont(s.font);
        this.setBackground(s.background);
        this.setForeground(s.foreground);
        this.verticalScrollBar.setBackground(s.background);
        this.horizontalScrollBar.setBackground(s.background);
        this.triggerRedraw();
        this.invalidate();
    }

    public Object[] getSelectedObjects() {
        if (this.selectedNode == null) {
            return null;
        }
        Object[] selectedObjects = new DTreeNode[]{this.selectedNode};
        return selectedObjects;
    }

    public void clear() {
        this.selectedNode = null;
        this.rootNode = null;
        this.count = 0;
        this.v = new Vector();
        this.e = new Vector();
        this.triggerRedraw();
        this.invalidate();
    }

    public DTreeNode getRootNode() {
        return this.rootNode;
    }

    public int getCount() {
        return this.count;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    boolean viewable(DTreeNode node) {
        for (int i = 0; i < this.viewCount; ++i) {
            if (node != this.v.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    boolean viewable(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < this.viewCount; ++i) {
            DTreeNode tn = (DTreeNode)this.v.elementAt(i);
            if (tn.text == null || !s.equals(tn.text)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(DTreeNode node) {
        this.recount();
        for (int i = 0; i < this.count; ++i) {
            if (node != this.e.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String s) {
        this.recount();
        this.existIndex = -1;
        if (s == null) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            DTreeNode tn = (DTreeNode)this.e.elementAt(i);
            if (tn.text == null) continue;
            this.existIndex = i;
            if (!s.equals(tn.text)) continue;
            return true;
        }
        return false;
    }

    public void append(DTreeNode newNode) {
        if (this.rootNode == null) {
            this.selectedNode = this.rootNode = newNode;
            this.count = 1;
            this.redrawTriggered = true;
        } else {
            this.recount();
            if (this.e.contains(newNode)) {
                System.err.println(new Exception("append: Node already exists in tree."));
            } else {
                this.addSibling(newNode, this.rootNode, true);
            }
        }
    }

    public void addChild(DTreeNode newNode, DTreeNode relativeNode) {
        if (relativeNode.child == null) {
            relativeNode.child = newNode;
            newNode.parent = relativeNode;
            ++this.count;
            this.redrawTriggered = true;
        } else {
            this.addSibling(newNode, relativeNode.child, true);
        }
        ++relativeNode.numberOfChildren;
    }

    public void addSibling(DTreeNode newNode, DTreeNode siblingNode) {
        this.addSibling(newNode, siblingNode, true);
    }

    public void addSibling(DTreeNode newNode, DTreeNode siblingNode, boolean asLastSibling) {
        if (asLastSibling) {
            DTreeNode tempNode = siblingNode;
            while (tempNode.sibling != null) {
                tempNode = tempNode.sibling;
            }
            tempNode.sibling = newNode;
        } else {
            newNode.sibling = siblingNode.sibling;
            siblingNode.sibling = newNode;
        }
        newNode.parent = siblingNode.parent;
        ++this.count;
        this.redrawTriggered = true;
    }

    public void insert(DTreeNode newNode, DTreeNode relativeNode, int position) {
        if (newNode == null || relativeNode == null) {
            return;
        }
        if (!this.exists(relativeNode)) {
            return;
        }
        switch (position) {
            case 0: {
                this.addChild(newNode, relativeNode);
                break;
            }
            case 1: {
                this.addSibling(newNode, relativeNode, false);
                break;
            }
            case 2: {
                this.addSibling(newNode, relativeNode, true);
                break;
            }
            default: {
                return;
            }
        }
    }

    public DTreeNode remove(String s) {
        this.recount();
        for (int i = 0; i < this.count; ++i) {
            DTreeNode tn = (DTreeNode)this.e.elementAt(i);
            if (tn.text == null || !s.equals(tn.text)) continue;
            this.remove(tn);
            this.redrawTriggered = true;
            return tn;
        }
        return null;
    }

    public void removeSelected() {
        if (this.selectedNode != null) {
            this.remove(this.selectedNode);
        }
    }

    public void remove(DTreeNode node) {
        if (!this.exists(node)) {
            return;
        }
        if (node == this.selectedNode) {
            int index = this.v.indexOf(this.selectedNode);
            if (index == -1) {
                index = this.e.indexOf(this.selectedNode);
            }
            if (index > this.viewCount - 1) {
                index = this.viewCount - 1;
            }
            if (index > 0) {
                this.changeSelection((DTreeNode)this.v.elementAt(index - 1));
            } else if (this.viewCount > 1) {
                this.changeSelection((DTreeNode)this.v.elementAt(1));
            }
        }
        if (node.parent != null) {
            if (node.parent.child == node) {
                if (node.sibling != null) {
                    node.parent.child = node.sibling;
                } else {
                    node.parent.child = null;
                    node.parent.collapse();
                }
            } else {
                DTreeNode tn = node.parent.child;
                while (tn.sibling != node) {
                    tn = tn.sibling;
                }
                tn.sibling = node.sibling != null ? node.sibling : null;
            }
        } else if (node == this.rootNode) {
            this.rootNode = node.sibling == null ? null : node.sibling;
        } else {
            DTreeNode tn = this.rootNode;
            while (tn.sibling != node) {
                tn = tn.sibling;
            }
            tn.sibling = node.sibling != null ? node.sibling : null;
        }
        this.recount();
        this.redrawTriggered = true;
    }

    public DTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.redrawTriggered || d.width != this.viewWidth || d.height != this.viewHeight) {
            this.redraw(g);
        }
        g.translate(-this.sbHPosition, 0);
        g.clipRect(this.sbHPosition, 0, d.width - this.sbVWidth, d.height - this.sbHHeight);
        g.drawImage(this.im1, 1, 1, this);
        g.setColor(Color.black);
        g.drawRect(this.sbHPosition, 0, d.width - 1, d.height - 1);
    }

    public void redraw(Graphics g) {
        Dimension d = this.getSize();
        this.redrawTriggered = false;
        if (this.needResetVector) {
            this.resetVector();
        } else {
            this.needResetVector = true;
        }
        this.newWidth = this.compWidth(g);
        int inRectCount = (d.height - this.sbHHeight) / this.cellSize;
        if (this.viewCount > inRectCount) {
            this.sbVShow = true;
            this.sbVWidth = this.verticalScrollBar.getPreferredSize().width;
        } else {
            this.sbVShow = false;
            this.sbVWidth = 0;
            this.sbVPosition = 0;
        }
        if (this.newWidth > d.width - this.sbVWidth) {
            this.sbHShow = true;
            this.sbHHeight = this.horizontalScrollBar.getPreferredSize().height;
        } else {
            this.sbHShow = false;
            this.sbHHeight = 0;
            this.sbHPosition = 0;
        }
        this.drawTree();
        if (this.sbVShow) {
            this.verticalScrollBar.setBounds(d.width - this.sbVWidth, 0, this.sbVWidth, d.height - this.sbHHeight);
            this.verticalScrollBar.setValues(this.sbVPosition, inRectCount, 0, this.viewCount);
            this.verticalScrollBar.setBlockIncrement(inRectCount - 1);
            this.verticalScrollBar.setVisible(true);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        if (this.sbHShow) {
            this.horizontalScrollBar.setBounds(0, d.height - this.sbHHeight, d.width - this.sbVWidth, this.sbHHeight);
            this.horizontalScrollBar.setValues(this.sbHPosition, d.width - this.sbVWidth, 0, this.sbHSize - (d.width - this.sbVWidth));
            this.horizontalScrollBar.setBlockIncrement(d.width - this.sbVWidth);
            this.horizontalScrollBar.setUnitIncrement(this.sbHLineIncrement);
            this.horizontalScrollBar.setVisible(true);
        } else {
            this.horizontalScrollBar.setVisible(false);
        }
    }

    public void drawTree() {
        Font f;
        Dimension d = this.getSize();
        if (this.needResetVector) {
            this.resetVector();
        }
        if (d.width != this.viewWidth || d.height != this.viewHeight || this.g1 == null || this.sbHSize != this.newWidth) {
            this.sbHSize = this.newWidth;
            this.im1 = this.createImage(Math.max(this.sbHSize, d.width) - 2 - this.sbVWidth, d.height - 2);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = d.width;
            this.viewHeight = d.height;
        }
        if ((f = this.getFont()) == null) {
            f = new Font("TimesRoman", 0, 13);
            this.g1.setFont(f);
            this.setFont(f);
        }
        if (this.g1.getFont() == null) {
            this.g1.setFont(f);
        }
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.im1.getWidth(this), d.height);
        int lastOne = this.sbVPosition + this.viewHeight / this.cellSize + 1;
        if (lastOne > this.viewCount) {
            lastOne = this.viewCount;
        }
        DTreeNode outerNode = null;
        if (!this.v.isEmpty()) {
            outerNode = (DTreeNode)this.v.elementAt(this.sbVPosition);
        }
        for (int i = this.sbVPosition; i < lastOne; ++i) {
            DTreeNode node = (DTreeNode)this.v.elementAt(i);
            int x = this.cellSize * (node.depth + 1);
            int y = (i - this.sbVPosition) * this.cellSize;
            this.g1.setColor(this.getForeground());
            if (node.sibling != null) {
                int k = this.v.indexOf(node.sibling) - i;
                if (k > lastOne) {
                    k = lastOne;
                }
                this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x - this.cellSize / 2, y + this.cellSize / 2 + k * this.cellSize);
            }
            for (int m = 0; m < i; ++m) {
                DTreeNode sib = (DTreeNode)this.v.elementAt(m);
                if (sib.sibling != node || m >= this.sbVPosition) continue;
                this.drawDotLine(x - this.cellSize / 2, 0, x - this.cellSize / 2, y + this.cellSize / 2);
            }
            if (node.isExpanded()) {
                this.drawDotLine(x + this.cellSize / 2, y + this.cellSize - 2, x + this.cellSize / 2, y + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(this.getForeground());
            this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x + this.cellSize / 2, y + this.cellSize / 2);
            this.drawNodeToggle(node, x, y);
            Image nodeImage = node.getImage();
            if (nodeImage != null) {
                this.g1.drawImage(nodeImage, x + this.imageInset, y, this);
            }
            if (node.text != null) {
                this.drawNodeText(node, y, node == this.selectedNode);
            }
            if (outerNode.depth <= node.depth) continue;
            outerNode = node;
        }
        if (outerNode != null) {
            while ((outerNode = outerNode.parent) != null) {
                if (outerNode.sibling == null) continue;
                this.drawDotLine(this.cellSize * (outerNode.depth + 1) - this.cellSize / 2, 0, this.cellSize * (outerNode.depth + 1) - this.cellSize / 2, d.height);
            }
        }
        this.needResetVector = true;
    }

    protected void drawNodeToggle(DTreeNode node, int x, int y) {
        if (node.isExpandable()) {
            this.g1.setColor(this.getBackground());
            this.g1.fillRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
            this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 4 + 2, y + this.cellSize / 2, this.cellSize * node.depth + this.cellSize / 4 + this.clickSize - 2, y + this.cellSize / 2);
            if (!node.isExpanded()) {
                this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + 2, this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + this.clickSize - 2);
            }
        }
    }

    public synchronized Dimension getPreferredSize() {
        Dimension p = this.getSize();
        Dimension m = this.getMinimumSize();
        return new Dimension(Math.max(p.width, m.width), Math.max(p.height, m.height));
    }

    public synchronized Dimension getMinimumSize() {
        return new Dimension(20, 40);
    }

    public void setLayout(LayoutManager lm) {
    }

    public boolean isFocusable() {
        return true;
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.verticalScrollBar.addAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.addAdjustmentListener(this.adjustment);
        }
        if (this.focus == null) {
            this.focus = new Focus();
            this.addFocusListener(this.focus);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.verticalScrollBar.removeAdjustmentListener(this.adjustment);
            this.horizontalScrollBar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        if (this.focus != null) {
            this.removeFocusListener(this.focus);
            this.focus = null;
        }
        super.removeNotify();
    }

    public void triggerRedraw() {
        this.redrawTriggered = true;
        this.repaint();
    }

    protected void complete(DTreeNode node, int x, int y) {
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    protected void drawNodeText(DTreeNode node, int yPosition, boolean eraseBackground) {
        Color bg;
        Color fg;
        if (node == null) {
            return;
        }
        int depth = node.depth;
        Image nodeImage = node.getImage();
        int textOffset = (depth + 1) * this.cellSize + this.cellSize + this.textInset - (nodeImage == null ? 12 : 0);
        if (node == this.selectedNode && this.hasFocus) {
            if (OS.isMacintosh()) {
                fg = Color.white;
                bg = new Color(0, 0, 128);
            } else {
                fg = SystemColor.textHighlightText;
                bg = SystemColor.textHighlight;
            }
        } else {
            fg = this.getForeground();
            bg = this.getBackground();
        }
        if (eraseBackground) {
            this.g1.setColor(bg);
            this.g1.fillRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        if (node == this.selectedNode) {
            this.g1.setColor(this.getForeground());
            this.g1.drawRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 3, this.cellSize - 2);
            this.repaint(Math.max(0, textOffset - 1 - this.sbHPosition), yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        this.g1.setColor(fg);
        this.g1.drawString(node.text, textOffset, yPosition + this.cellSize - this.textBaseLine);
    }

    protected void sendActionEvent(String command) {
        this.selectedText = new String(this.selectedNode.getText());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    protected void sendSelectionEvent(int index) {
        this.selectedIndex = index;
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "Select"));
        }
    }

    protected int compWidth(Graphics gg) {
        int size = 0;
        Font f = this.getFont();
        if (f == null) {
            f = new Font("TimesRoman", 0, 13);
            if (gg != null) {
                gg.setFont(f);
            }
            this.setFont(f);
        }
        this.fm = gg == null ? null : gg.getFontMetrics();
        if (this.fm == null) {
            this.fm = this.getFontMetrics(f);
        }
        if (this.fm == null || this.v == null) {
            size = 100;
        } else {
            for (int i = 0; i < this.v.size(); ++i) {
                DTreeNode node = (DTreeNode)this.v.elementAt(i);
                int textOffset = (node.depth + 1) * this.cellSize + this.cellSize + this.textInset - (node.getImage() == null ? 12 : 0);
                if (size >= textOffset + this.fm.stringWidth(node.text) + 6) continue;
                size = textOffset + this.fm.stringWidth(node.text) + 6;
            }
        }
        return size;
    }

    protected void drawDotLine(int x0, int y0, int x1, int y1) {
        if (y0 == y1) {
            for (int i = x0; i < x1; i += 2) {
                this.g1.drawLine(i, y0, i, y1);
            }
        } else {
            for (int i = y0; i < y1; i += 2) {
                this.g1.drawLine(x0, i, x1, i);
            }
        }
    }

    protected void changeSelection(DTreeNode node) {
        if (node == this.selectedNode) {
            return;
        }
        DTreeNode oldNode = this.selectedNode;
        this.selectedNode = node;
        this.drawNodeText(oldNode, (this.v.indexOf(oldNode) - this.sbVPosition) * this.cellSize, true);
        this.drawNodeText(node, (this.v.indexOf(node) - this.sbVPosition) * this.cellSize, true);
        int index = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, oldNode, 2));
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (index < this.sbVPosition) {
            --this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (index >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.sendSelectionEvent(index);
        this.repaint();
    }

    protected void absoluteSelection(DTreeNode node) {
        if (node == this.selectedNode) {
            return;
        }
        DTreeNode oldNode = this.selectedNode;
        this.selectedNode = node;
        this.drawNodeText(oldNode, (this.v.indexOf(oldNode) - this.sbVPosition) * this.cellSize, true);
        this.drawNodeText(node, (this.v.indexOf(node) - this.sbVPosition) * this.cellSize, true);
        int index = this.v.indexOf(this.selectedNode);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, oldNode, 2));
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
        }
        if (index < this.sbVPosition) {
            this.sbVPosition = index;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        if (index >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            this.sbVPosition = index;
            this.verticalScrollBar.setValue(this.sbVPosition);
            this.triggerRedraw();
            return;
        }
        this.sendSelectionEvent(index);
        this.repaint();
    }

    protected DTreeNode newTreeNode(String text, DTreeView treeView) {
        return new DTreeNode(text, treeView);
    }

    protected void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    protected void traverse(DTreeNode node) {
        ++this.count;
        this.e.addElement(node);
        if (node.child != null) {
            node.child.depth = node.depth + 1;
            this.traverse(node.child);
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.traverse(node.sibling);
        }
    }

    protected void resetVector() {
        this.v = new Vector(this.count);
        this.viewWidest = 30;
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode, true, this.v);
        this.viewCount = this.v.size();
        this.needResetVector = false;
    }

    protected void vectorize(DTreeNode node, boolean respectExpanded, Vector nodeVector) {
        if (node == null) {
            return;
        }
        nodeVector.addElement(node);
        if (!respectExpanded && node.child != null || node.isExpanded()) {
            node.child.depth = node.depth + 1;
            this.vectorize(node.child, respectExpanded, nodeVector);
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.vectorize(node.sibling, respectExpanded, nodeVector);
        }
    }

    protected void debugVector() {
        for (int i = 0; i < this.count; ++i) {
            DTreeNode node = (DTreeNode)this.v.elementAt(i);
            System.out.println(node.text);
        }
    }

    public int getSelectedIndex() {
        if (this.selectedNode != null) {
            for (int index = 0; index < this.viewCount; ++index) {
                if (this.selectedNode != this.v.elementAt(index)) continue;
                return index;
            }
        }
        return 0;
    }

    protected void handleMousePressed(MouseEvent event) {
        this.requestFocus();
        int x = event.getX();
        int y = event.getY();
        int index = y / this.cellSize + this.sbVPosition;
        if (index > this.viewCount - 1) {
            return;
        }
        DTreeNode oldNode = this.selectedNode;
        DTreeNode newNode = (DTreeNode)this.v.elementAt(index);
        int newDepth = newNode.getDepth();
        Rectangle toggleBox = new Rectangle(this.cellSize * newDepth + this.cellSize / 4, (index - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (toggleBox.contains(x, y)) {
            this.complete(newNode, x, y);
            newNode.toggle();
            this.resetVector();
            if (!newNode.isExpanded() && !this.v.contains(this.selectedNode)) {
                this.changeSelection(newNode);
            }
            this.triggerRedraw();
            this.invalidate();
        } else {
            this.changeSelection(newNode);
            if (newNode == oldNode && event.getWhen() - this.timeMouseDown < (long)this.doubleClickResolution) {
                newNode.toggle();
                this.resetVector();
                this.triggerRedraw();
                this.invalidate();
                return;
            }
            this.timeMouseDown = event.getWhen();
        }
    }

    protected void handleAdjustmentEvent(AdjustmentEvent event) {
        if (event.getAdjustable() == this.verticalScrollBar) {
            if (this.sbVPosition != this.verticalScrollBar.getValue()) {
                this.sbVPosition = this.verticalScrollBar.getValue();
                this.triggerRedraw();
            }
        } else if (event.getAdjustable() == this.horizontalScrollBar && this.sbHPosition != this.horizontalScrollBar.getValue()) {
            this.sbHPosition = this.horizontalScrollBar.getValue();
            this.triggerRedraw();
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        int index = this.v.indexOf(this.selectedNode);
        int h = this.viewHeight / this.cellSize;
        switch (event.getKeyCode()) {
            case 10: {
                this.sendActionEvent("Enter");
                this.requestFocus();
                break;
            }
            case 127: {
                this.sendActionEvent("Del");
                this.requestFocus();
                break;
            }
            case 32: {
                if (event.isControlDown() || event.isAltDown() || event.isShiftDown()) break;
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.complete(this.selectedNode, 0, 0);
                    this.triggerRedraw();
                    break;
                }
                if (!this.selectedNode.isExpanded()) break;
                this.selectedNode.toggle();
                this.triggerRedraw();
                break;
            }
            case 37: {
                if (event.isControlDown()) {
                    if (this.sbHPosition <= 0) break;
                    this.horizontalScrollBar.setValue(Math.max(this.sbHPosition -= this.sbHLineIncrement, 0));
                    this.repaint();
                    break;
                }
                index = this.v.indexOf(this.selectedNode.getParent());
                this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                this.requestFocus();
                break;
            }
            case 38: {
                if (index <= 0) break;
                this.changeSelection((DTreeNode)this.v.elementAt(--index));
                this.requestFocus();
                break;
            }
            case 39: {
                if (event.isControlDown()) {
                    int max = this.horizontalScrollBar.getMaximum() - (this.getSize().width - this.sbVWidth);
                    if (!this.sbHShow || this.sbHPosition >= max) break;
                    this.horizontalScrollBar.setValue(Math.min(this.sbHPosition += this.sbHLineIncrement, max));
                    this.repaint();
                    break;
                }
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle();
                    this.complete(this.selectedNode, 0, 0);
                    this.triggerRedraw();
                    break;
                }
                if (!this.selectedNode.isExpandable()) break;
            }
            case 40: {
                if (index >= this.viewCount - 1) break;
                this.changeSelection((DTreeNode)this.v.elementAt(++index));
                this.requestFocus();
                break;
            }
            case 36: {
                if (index <= 0) break;
                index = 0;
                this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                this.requestFocus();
                break;
            }
            case 33: {
                if (index > this.sbVPosition) {
                    index = this.sbVPosition;
                    this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                    this.requestFocus();
                    break;
                }
                index = Math.max(0, index - h);
                this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                this.requestFocus();
                break;
            }
            case 34: {
                int lastOne = this.sbVPosition + h - 1;
                index = index < lastOne ? lastOne : (index += h);
                this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                this.requestFocus();
                break;
            }
            case 35: {
                if (index < this.viewCount - 1) {
                    index = this.viewCount - 1;
                    this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                    this.requestFocus();
                    break;
                }
                if (index >= this.count - 1) break;
                index = this.count - 1;
                this.absoluteSelection((DTreeNode)this.v.elementAt(index));
                this.requestFocus();
                break;
            }
        }
    }

    class Focus
    extends FocusAdapter
    implements Serializable {
        Focus() {
        }

        public void focusGained(FocusEvent event) {
            DTreeView.this.hasFocus = true;
            if (DTreeView.this.selectedNode != null && DTreeView.this.v != null) {
                DTreeView.this.drawNodeText(DTreeView.this.selectedNode, (DTreeView.this.v.indexOf(DTreeView.this.selectedNode) - DTreeView.this.sbVPosition) * DTreeView.this.cellSize, true);
            }
        }

        public void focusLost(FocusEvent event) {
            DTreeView.this.hasFocus = false;
            if (DTreeView.this.selectedNode != null && DTreeView.this.v != null) {
                DTreeView.this.drawNodeText(DTreeView.this.selectedNode, (DTreeView.this.v.indexOf(DTreeView.this.selectedNode) - DTreeView.this.sbVPosition) * DTreeView.this.cellSize, true);
            }
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        Key() {
        }

        public void keyPressed(KeyEvent event) {
            DTreeView.this.handleKeyPressed(event);
        }
    }

    class Mouse
    extends MouseAdapter {
        Mouse() {
        }

        public void mousePressed(MouseEvent event) {
            DTreeView.this.handleMousePressed(event);
        }

        public void mouseReleased(MouseEvent event) {
        }
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        Adjustment() {
        }

        public void adjustmentValueChanged(AdjustmentEvent event) {
            DTreeView.this.handleAdjustmentEvent(event);
        }
    }
}

