/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Data {
    static void dispError(String name, String error) {
        System.out.println(name + "  " + error);
    }

    public static int getSize(String path) {
        int size = 0;
        try {
            FileInputStream fiS = new FileInputStream(path);
            size = fiS.available();
            fiS.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return size;
    }

    public static byte[] bLoad(String path) {
        int blocksize = 0;
        int offset = 0;
        int size = 0;
        byte[] buffer = null;
        try {
            int available;
            FileInputStream fiS = new FileInputStream(path);
            int notAtEnd = 1;
            size = available = fiS.available();
            buffer = new byte[available];
            while (notAtEnd > 0) {
                blocksize = Math.min(available, 32768);
                if (blocksize > 0) {
                    notAtEnd = fiS.read(buffer, offset, blocksize);
                    offset += blocksize;
                    available -= blocksize;
                    continue;
                }
                notAtEnd = -1;
            }
            fiS.close();
        }
        catch (IOException e) {
            Data.dispError(path, "read error");
        }
        if (buffer.length != size) {
            System.out.println("Data load error: size " + buffer.length + " must be " + size);
        }
        return buffer;
    }

    public static boolean bSave(String name, byte[] buffer) {
        boolean res = false;
        try {
            FileOutputStream foS = new FileOutputStream(name);
            foS.write(buffer);
            foS.close();
            res = true;
        }
        catch (IOException e) {
            Data.dispError(name, "enable to save");
        }
        return res;
    }

    public static int[] iLoad(String path) {
        int loaded = 0;
        int[] buffer = null;
        try {
            DataInputStream fiS = new DataInputStream(new FileInputStream(path));
            int available = fiS.available();
            int size = available / 4;
            buffer = new int[size];
            for (int i = 0; i < size; ++i) {
                try {
                    buffer[i] = fiS.readInt();
                    ++loaded;
                    continue;
                }
                catch (IOException ef) {
                    Data.dispError(path, "error in array");
                }
            }
            fiS.close();
        }
        catch (IOException e) {
            Data.dispError(path, "enable to open");
        }
        return buffer;
    }

    public static int iSave(String path, int[] buffer) {
        int saved = 0;
        int size = buffer.length;
        try {
            DataOutputStream fiS = new DataOutputStream(new FileOutputStream(path));
            for (int i = 0; i < size; ++i) {
                try {
                    fiS.writeInt(buffer[i]);
                    ++saved;
                    continue;
                }
                catch (IOException ef) {
                    Data.dispError(path, "error in array");
                }
            }
            fiS.close();
        }
        catch (IOException e) {
            Data.dispError(path, "enable to write");
        }
        System.out.println("saved " + saved);
        return saved;
    }
}

