/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DMessageBar;
import ae.Disk;
import ae.PalettePanel;
import ae.Path;
import ae.Preferences;
import ae.VirtualDirect;
import java.awt.FileDialog;
import java.awt.Frame;

public class DataText {
    static final int IMAGE = 0;
    static final int JAVA = 1;
    static final int C = 2;
    static final int PASCAL = 3;
    static String eol = System.getProperty("line.separator");
    static DMessageBar status = null;

    static void setStatusBar(DMessageBar dmb) {
        status = dmb;
    }

    static void Message(String message) {
        if (status != null) {
            status.setText(message);
        }
    }

    static byte signed(int value) {
        byte bValue = value < 128 ? (byte)value : (byte)(256 - value);
        return bValue;
    }

    static void save(Frame parent, VirtualDirect offScreen, String path, String name, int mode) {
        FileDialog fd = new FileDialog(parent, "Save source file", 1);
        fd.setDirectory(path);
        fd.setFile(name);
        fd.show();
        String dname = fd.getDirectory();
        String fname = fd.getFile();
        if (fname == null) {
            return;
        }
        int orient = 0;
        if (Preferences.Inversed > 0) {
            orient = 1;
        }
        int comp = Preferences.Compression;
        int transp = PalettePanel.transparentIndex;
        switch (mode) {
            case 0: {
                DataText.saveJava(offScreen, dname, fname);
                break;
            }
            case 1: {
                DataText.saveJavaRaw(offScreen, dname, fname, orient, comp, transp);
                break;
            }
            case 2: {
                DataText.saveC(offScreen, dname, fname, orient, comp, transp);
                break;
            }
            case 3: {
                DataText.savePascal(offScreen, dname, fname, orient, comp, transp);
                break;
            }
        }
    }

    static void saveJava(VirtualDirect offScreen, String dname, String fname) {
        int IMAGEWIDTH = offScreen.width;
        int IMAGEHEIGHT = offScreen.height;
        if (fname.lastIndexOf(46) == -1) {
            fname = fname + ".java";
        }
        DataText.Message("Saving image as Image source file " + Path.merge(dname, fname));
        int lio = fname.lastIndexOf(46);
        String name = fname.substring(0, lio);
        StringBuffer sb = new StringBuffer("// Java Image Code" + eol + eol);
        int m = offScreen.getSize();
        int ret = 0;
        int TranspInt = PalettePanel.colorToInt(PalettePanel.transparentColor);
        String nw = name + "Width";
        String nh = name + "Height";
        sb.append("static Image " + name + ";" + eol);
        sb.append("static int " + nw + " = " + new Integer(IMAGEWIDTH).toString() + ";" + eol);
        sb.append("static int " + nh + " = " + new Integer(IMAGEHEIGHT).toString() + ";" + eol);
        sb.append("static int[] " + name + "RGB = new int[] {" + eol);
        for (int i = 0; i < m; ++i) {
            int pix = offScreen.screen[i];
            sb.append(new Integer(pix).toString());
            if (i < m - 1) {
                sb.append(',');
            }
            if (++ret < 5) continue;
            sb.append(eol);
            ret = 0;
        }
        sb.append(" };" + eol + eol);
        sb.append(name + " = createImage(new MemoryImageSource(" + nw + ", " + nh + ", " + name + "RGB, 0, " + nw + "));" + eol);
        Disk.save(dname, fname, sb.toString());
    }

    static void saveJavaRaw(VirtualDirect offScreen, String dname, String fname, int direction, int compression, int transparent) {
        int IMAGEWIDTH = offScreen.width;
        int IMAGEHEIGHT = offScreen.height;
        if (fname.lastIndexOf(46) == -1) {
            fname = fname + ".java";
        }
        DataText.Message("Saving image as Raw Java source file " + Path.merge(dname, fname));
        int lio = fname.lastIndexOf(46);
        String name = fname.substring(0, lio);
        StringBuffer sb = new StringBuffer("// Java Code in raw AZ format (10 bytes header)" + eol);
        sb.append("// Pixel format: index in palette as signed byte" + eol + eol);
        int m = offScreen.getSize();
        int ret = 0;
        sb.append("public static byte[] " + name + "Header" + " = {" + eol);
        int wh = IMAGEWIDTH / 256;
        int wl = IMAGEWIDTH - wh * 256;
        int hh = IMAGEHEIGHT / 256;
        int hl = IMAGEHEIGHT - hh * 256;
        sb.append(new Integer(wl).toString() + ",");
        sb.append(new Integer(wh).toString() + ",");
        sb.append(new Integer(hl).toString() + ",");
        sb.append(new Integer(hh).toString() + ",");
        sb.append(DataText.signed(direction) + ",");
        sb.append(DataText.signed(compression) + ",");
        sb.append("0,");
        sb.append("0,");
        sb.append(DataText.signed(transparent) + ",");
        sb.append("0" + eol);
        sb.append(" };" + eol + eol);
        sb.append("public static byte[] " + name + "Code" + " = {" + eol);
        for (int i = 0; i < m; ++i) {
            int pix = offScreen.screen[i];
            int val = PalettePanel.searchIndex(pix);
            if (val < 128) {
                sb.append("" + val);
            } else {
                sb.append("" + (val - 256));
            }
            if (i < m - 1) {
                sb.append(',');
            }
            if (++ret < 10) continue;
            sb.append(eol);
            ret = 0;
        }
        sb.append(" };" + eol + eol);
        Disk.save(dname, fname, sb.toString());
    }

    static void saveC(VirtualDirect offScreen, String dname, String fname, int direction, int compression, int transparent) {
        int IMAGEWIDTH = offScreen.width;
        int IMAGEHEIGHT = offScreen.height;
        if (fname.lastIndexOf(46) == -1) {
            fname = fname + ".cpp";
        }
        DataText.Message("Saving image as C source file " + Path.merge(dname, fname));
        int lio = fname.lastIndexOf(46);
        String name = fname.substring(0, lio);
        StringBuffer sb = new StringBuffer("// C Code in raw AZ format (10 bytes header)" + eol);
        sb.append("// Pixel format: alpha, red, green, blue" + eol + eol);
        int m = offScreen.getSize();
        int ret = 0;
        sb.append("unsigned char[] " + name + " = {" + eol);
        int wh = IMAGEWIDTH / 256;
        int wl = IMAGEWIDTH - wh * 256;
        int hh = IMAGEHEIGHT / 256;
        int hl = IMAGEHEIGHT - hh * 256;
        sb.append(new Integer(wl).toString() + ",");
        sb.append(new Integer(wh).toString() + ",");
        sb.append(new Integer(hl).toString() + ",");
        sb.append(new Integer(hh).toString() + ",");
        sb.append(new Integer(direction).toString() + ",");
        sb.append(new Integer(compression).toString() + ",");
        sb.append("0,");
        sb.append("0,");
        sb.append(new Integer(transparent).toString() + ",");
        sb.append("0," + eol);
        for (int i = 0; i < m; ++i) {
            int pix = offScreen.screen[i];
            int a = pix >> 24 & 0xFF;
            int r = pix >> 16 & 0xFF;
            int g = pix >> 8 & 0xFF;
            int b = pix & 0xFF;
            sb.append(new Integer(a).toString() + ",");
            sb.append(new Integer(r).toString() + ",");
            sb.append(new Integer(g).toString() + ",");
            sb.append(new Integer(b).toString());
            if (i < m - 1) {
                sb.append(',');
            }
            if (++ret < 5) continue;
            sb.append(eol);
            ret = 0;
        }
        sb.append(" };" + eol + eol);
        Disk.save(dname, fname, sb.toString());
    }

    static void savePascal(VirtualDirect offScreen, String dname, String fname, int direction, int compression, int transparent) {
        int IMAGEWIDTH = offScreen.width;
        int IMAGEHEIGHT = offScreen.height;
        if (fname.lastIndexOf(46) == -1) {
            fname = fname + ".pas";
        }
        DataText.Message("Saving image as Pascal source file " + Path.merge(dname, fname));
        int lio = fname.lastIndexOf(46);
        String name = fname.substring(0, lio);
        StringBuffer sb = new StringBuffer("// Pascal Code in raw AZ format (10 bytes header)" + eol);
        sb.append("// Pixel format: alpha, red, green, blue" + eol + eol);
        int m = offScreen.getSize();
        int ret = 0;
        int wh = IMAGEWIDTH / 256;
        int wl = IMAGEWIDTH - wh * 256;
        int hh = IMAGEHEIGHT / 256;
        int hl = IMAGEHEIGHT - hh * 256;
        sb.append("Const  " + name + " := Array[0.." + (m * 4 + 10) + "] Of Byte = (" + eol);
        sb.append(new Integer(wl).toString() + ",");
        sb.append(new Integer(wh).toString() + ",");
        sb.append(new Integer(hl).toString() + ",");
        sb.append(new Integer(hh).toString() + ",");
        sb.append(new Integer(direction).toString() + ",");
        sb.append(new Integer(compression).toString() + ",");
        sb.append("0,");
        sb.append("0,");
        sb.append(new Integer(transparent).toString() + ",");
        sb.append("0," + eol);
        for (int i = 0; i < m; ++i) {
            int pix = offScreen.screen[i];
            int a = pix >> 24 & 0xFF;
            int r = pix >> 16 & 0xFF;
            int g = pix >> 8 & 0xFF;
            int b = pix & 0xFF;
            sb.append(new Integer(a).toString() + ",");
            sb.append(new Integer(r).toString() + ",");
            sb.append(new Integer(g).toString() + ",");
            sb.append(new Integer(b).toString());
            if (i < m - 1) {
                sb.append(',');
            }
            if (++ret < 5) continue;
            sb.append(eol);
            ret = 0;
        }
        sb.append(" );" + eol + eol);
        Disk.save(dname, fname, sb.toString());
    }
}

