/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Box;
import ae.Canvas3d;
import ae.DDialog;
import ae.TSpinner;
import ae.Texture;
import ae.Vertex;
import ae.Viewpoint;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Dialog3D
extends DDialog
implements ActionListener {
    Panel panelScroll;
    Canvas3d canvas;
    Panel panelControl;
    Button buttonOk;
    Button buttonCancel;
    Label labelX;
    Label labelY;
    Label labelZ;
    TSpinner fieldX;
    TSpinner fieldY;
    TSpinner fieldZ;
    int width;
    int height;
    int iX = 0;
    int iY = 0;
    int iZ = 0;
    Image image = null;
    Image model = null;
    boolean accept = false;

    public Dialog3D(Frame parent, boolean modal) {
        super(parent, modal);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.setSize(this.insets().left + this.insets().right + 450, this.insets().top + this.insets().bottom + 320);
        this.setFont(new Font("Dialog", 0, 14));
        this.panelScroll = new Panel(new BorderLayout());
        this.add((Component)this.panelScroll, "Center");
        this.canvas = new Canvas3d(new Viewpoint(new Vertex(0.0, 0.0, -25.0)));
        this.canvas.setBackground(Color.blue);
        this.panelScroll.add((Component)this.canvas, "Center");
        this.panelControl = new Panel(null);
        this.panelControl.setBounds(this.insets().left + 334, this.insets().top + 0, 116, 320);
        this.add((Component)this.panelControl, "East");
        this.buttonOk = new Button("OK");
        this.buttonOk.setBounds(8, 204, 100, 30);
        this.buttonOk.addActionListener(this);
        this.panelControl.add(this.buttonOk);
        this.buttonCancel = new Button("Cancel");
        this.buttonCancel.setBounds(8, 264, 100, 30);
        this.buttonCancel.addActionListener(this);
        this.panelControl.add(this.buttonCancel);
        this.labelX = new Label("X");
        this.labelX.setBounds(16, 16, 16, 24);
        this.panelControl.add(this.labelX);
        this.fieldX = new TSpinner(0, 0, 359);
        this.fieldX.setBounds(48, 16, 72, 24);
        this.fieldX.addActionListener(this);
        this.panelControl.add(this.fieldX);
        this.labelY = new Label("Y");
        this.labelY.setBounds(16, 48, 16, 24);
        this.panelControl.add(this.labelY);
        this.fieldY = new TSpinner(0, 0, 359);
        this.fieldY.setBounds(48, 48, 72, 24);
        this.fieldY.addActionListener(this);
        this.panelControl.add(this.fieldY);
        this.labelZ = new Label("Z");
        this.labelZ.setBounds(16, 80, 16, 24);
        this.panelControl.add(this.labelZ);
        this.fieldZ = new TSpinner(0, 0, 359);
        this.fieldZ.setBounds(48, 80, 72, 24);
        this.fieldZ.addActionListener(this);
        this.panelControl.add(this.fieldZ);
        this.setTitle("3D transformations");
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(0, 0);
        this.setVisible(false);
    }

    public Dialog3D(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public Dialog3D(Frame parent) {
        this(parent, true);
    }

    public Dialog3D(Frame parent, Image img) {
        this(parent, true);
        this.setImage(img);
    }

    void setX() {
        this.fieldX.setCurrent(this.iX);
    }

    void setY() {
        this.fieldY.setCurrent(this.iY);
    }

    void setZ() {
        this.fieldZ.setCurrent(this.iZ);
    }

    public void setImage(Image image) {
        this.image = image;
        this.model = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Texture texture = new Texture(image, 1, 1);
        Box box = new Box(new Vertex(5.0, 5.0, 5.0), new Vertex(-1.0, -1.0, -1.0), texture);
        this.canvas.clearWorld();
        this.canvas.add(box);
    }

    public Image getImage() {
        return this.canvas.getImage();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        System.out.println("Dialog3d - paint  w " + this.width + " h " + this.height);
        this.setX();
        this.setY();
        this.setZ();
        this.canvas.setX(this.iX);
        this.canvas.setY(this.iY);
        this.canvas.setZ(this.iZ);
        System.out.println("Dialog3d appel canvas3d.draw");
    }

    public void transform() {
        this.setX();
        this.setY();
        this.setZ();
        this.canvas.setX(this.iX);
        this.canvas.setY(this.iY);
        this.canvas.setZ(this.iZ);
        this.setImage(this.model);
        this.canvas.rotate();
        this.canvas.repaint();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    int get(TSpinner field) {
        int i = field.current;
        if (i < 0) {
            i = 0;
        }
        if (i > 359) {
            i = 359;
        }
        field.setCurrent(i);
        return i;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonCancel) {
            this.image = this.model;
            this.accept = false;
            this.setVisible(false);
        } else if (object == this.buttonOk) {
            this.accept = true;
            this.setVisible(false);
        } else if (object == this.fieldX) {
            this.iX = this.get(this.fieldX);
            this.transform();
        } else if (object == this.fieldY) {
            this.iY = this.get(this.fieldY);
            this.transform();
        } else if (object == this.fieldZ) {
            this.iZ = this.get(this.fieldZ);
            this.transform();
        }
    }
}

