/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DDialog;
import ae.ImageViewer;
import ae.Rotate;
import ae.TSpinner;
import ae.VirtualImage;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DialogRotate
extends DDialog
implements ActionListener {
    Panel panelScroll;
    static ImageViewer viewer;
    static Rotate rotate;
    Panel panelControl;
    Button buttonOk;
    Button buttonCancel;
    Label labelAngle;
    TSpinner fieldAngle;
    int angle = 0;
    Image image = null;
    boolean accept = false;

    public DialogRotate(Frame parent, boolean modal) {
        super(parent, modal);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.setSize(this.insets().left + this.insets().right + 450, this.insets().top + this.insets().bottom + 320);
        this.setFont(new Font("Dialog", 0, 14));
        this.panelScroll = new Panel(new BorderLayout());
        this.add((Component)this.panelScroll, "Center");
        viewer = new ImageViewer();
        viewer.setBackground(Color.blue);
        this.panelScroll.add((Component)viewer, "Center");
        this.panelControl = new Panel(null);
        this.panelControl.setBounds(334, 0, 132, 320);
        this.add((Component)this.panelControl, "East");
        this.buttonOk = new Button("OK");
        this.buttonOk.setBounds(16, 204, 100, 30);
        this.buttonOk.addActionListener(this);
        this.panelControl.add(this.buttonOk);
        this.buttonCancel = new Button("Cancel");
        this.buttonCancel.setBounds(16, 264, 100, 30);
        this.buttonCancel.addActionListener(this);
        this.panelControl.add(this.buttonCancel);
        this.labelAngle = new Label("Angle");
        this.labelAngle.setBounds(48, 48, 60, 24);
        this.panelControl.add(this.labelAngle);
        this.fieldAngle = new TSpinner(0, 0, 359);
        this.fieldAngle.setBounds(48, 76, 72, 24);
        this.fieldAngle.addActionListener(this);
        this.panelControl.add(this.fieldAngle);
        this.setTitle(" Rotate");
    }

    public DialogRotate(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public DialogRotate(Frame parent) {
        this(parent, true);
    }

    public DialogRotate(Frame parent, Image img) {
        this(parent, true);
        this.setImage(img);
    }

    void setAngle() {
        this.fieldAngle.setCurrent(this.angle);
    }

    public void setImage(Image img) {
        VirtualImage vi = new VirtualImage();
        vi.load(img);
        this.image = vi.image;
        rotate = new Rotate(vi.getPixels(), vi.width, vi.height);
    }

    public Image getImage() {
        return this.image;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.setAngle();
        viewer.setBackground(Color.black);
        viewer.clear();
        viewer.setImage(this.image);
        viewer.repaint();
    }

    public void transform() {
        this.setAngle();
        switch (this.angle) {
            case 90: 
            case 180: 
            case 270: {
                rotate.clear();
                rotate.rotate(this.angle);
                break;
            }
            default: {
                rotate.clear();
                rotate.rotate(this.angle);
            }
        }
        this.image = rotate.getImage();
        this.repaint();
    }

    int get(TSpinner field) {
        int i = field.current;
        if (i < 0) {
            i = 0;
        }
        if (i > 359) {
            i = 359;
        }
        field.setCurrent(i);
        return i;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonCancel) {
            this.accept = false;
            this.setVisible(false);
        } else if (object == this.buttonOk) {
            this.accept = true;
            this.setVisible(false);
        } else if (object == this.fieldAngle) {
            this.angle = this.get(this.fieldAngle);
            this.transform();
        }
    }
}

