/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DListBox;
import ae.ListItem;
import ae.Tool;
import ae.VectorBoolean;
import ae.VectorLong;
import ae.VectorString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;

public class DirBox
extends DListBox {
    VectorBoolean VType;
    VectorLong VSize;
    VectorLong VDate;
    public long TotalSize;
    public long TaggedSize;
    int namePos = 20;
    int sizePos;
    int datePos;
    int endPos;
    int charWidth = 8;
    int dateWidth;
    int sizeWidth;
    static final int sizeLen = 9;
    static final int dateLen = 11;
    static DateFormat df = DateFormat.getDateTimeInstance(3, 0);
    int oldWidth = 0;
    boolean restarted = true;
    int fullLineLength;

    DirBox(boolean mselect) {
        super(mselect);
    }

    DirBox() {
        this(false);
    }

    public void crossOut(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.deleted = true;
            tempItem.bDirty = true;
        }
    }

    public void crossOut(int index, boolean val) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            tempItem.deleted = val;
            tempItem.bDirty = true;
        }
    }

    public boolean isCrossOut(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.deleted;
        }
        return false;
    }

    public boolean isCrossOut() {
        int l = this.items.size();
        for (int index = 0; index < l; ++index) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            if (!tempItem.deleted) continue;
            return true;
        }
        return false;
    }

    public synchronized void selectAllFiles(int MAXINDIRS) {
        if (!this.bMultipleSelections) {
            return;
        }
        int s = this.items.size();
        for (int i = MAXINDIRS; i < s; ++i) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (!li.bEnabled) continue;
            li.bSelected = true;
        }
        this.countSelected = s;
        this.lastSelected = s - 1;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.restarted = true;
    }

    public void adjustFontWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.charWidth = fm.charWidth('0');
        this.sizeWidth = 9 * this.charWidth;
        this.dateWidth = fm.stringWidth("00/00/2010 00:00");
        this.restarted = false;
    }

    public void adjustWidth() {
        int ENDMARGIN = 28;
        int SIZEMARGIN = 12;
        int BORDERS = 4;
        Dimension size = this.getSize();
        if (this.restarted) {
            this.adjustFontWidth();
        }
        this.fullLineLength = this.longestLineValue;
        int width = size.width - this.barSize - 4;
        int rightWidth = this.sizeWidth + this.dateWidth + 12 + 28;
        int leftWidth = width - rightWidth;
        int minPart = 20 * this.charWidth;
        if (leftWidth < minPart) {
            leftWidth = minPart;
        }
        if (this.fullLineLength + 4 < leftWidth) {
            this.fullLineLength = leftWidth;
        }
        this.sizePos = this.fullLineLength;
        this.datePos = this.sizePos + this.sizeWidth + 12;
        this.endPos = this.datePos + this.dateWidth + 28;
        this.fullLineLength = this.endPos - 4;
    }

    public String[] getFiles(String dir) {
        int len = this.countItems();
        VectorString items = new VectorString(len);
        for (int i = 0; i < len; ++i) {
            String fic = this.getText(i);
            if (new File(dir, fic).isDirectory()) continue;
            items.addElement(this.getText(i));
        }
        return items.toArray();
    }

    public void update(Graphics g) {
        super.update(g);
    }

    public synchronized void paint(Graphics g) {
        Color curBackground;
        int vWid = 0;
        int hHt = 0;
        int gridAdj = 0;
        int yLoc = 0;
        int ySLoc = 0;
        boolean bShowV = false;
        boolean bShowH = false;
        if (this.listChanged) {
            this.adjustWidth();
        }
        if (!Tool.objectsEqual(curBackground = this.getBackground(), this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateBorderColors(this.PanelColor);
        }
        Rectangle rect = this.getBounds();
        this.font = g.getFont();
        this.fm = g.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
        int nItems = this.items.size();
        this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
        if (nItems == 0) {
            this.nTopRow = 0;
            this.visibleRows = 0;
            bShowH = false;
            bShowV = false;
            this.xCoord = 0;
        } else {
            if (this.bAllowShowHBar && this.fullLineLength > rect.width - this.borderWidth) {
                bShowH = true;
                hHt = this.barSize;
            } else {
                bShowH = false;
                hHt = 0;
            }
            int rows = (rect.height - hHt - this.borderWidth - this.yAdj) / this.cellHt;
            if (this.bAllowShowVBar && nItems > rows) {
                bShowV = true;
                vWid = this.barSize;
                if (!bShowH && this.bAllowShowHBar && this.fullLineLength > rect.width - this.borderWidth - vWid) {
                    bShowH = true;
                    hHt = this.barSize;
                    rows = (rect.height - hHt - this.borderWidth - this.yAdj) / this.cellHt;
                }
            } else {
                bShowV = false;
                vWid = 0;
            }
            if (this.visibleRows != rows) {
                this.visibleRows = rows;
                this.bAllDirty = true;
            }
            if (bShowV) {
                this.VBar.setBounds(rect.width - this.barSize - this.halfBorderWidth, this.halfBorderWidth, this.barSize, rect.height - this.borderWidth - hHt);
                this.VBar.setValues(this.nTopRow, this.visibleRows, 0, nItems);
                this.VBar.setBlockIncrement(this.visibleRows);
                this.lWidth = rect.width - vWid - this.borderWidth;
                if (!this.bVBarVisible) {
                    this.bVBarVisible = true;
                    this.VBar.setVisible(true);
                }
            } else {
                this.lWidth = rect.width - this.borderWidth;
                if (this.bVBarVisible) {
                    this.bVBarVisible = false;
                    this.VBar.setVisible(false);
                }
            }
            if (bShowH) {
                this.HBar.setBounds(this.halfBorderWidth, rect.height - this.barSize - this.halfBorderWidth, rect.width - this.borderWidth - vWid, this.barSize);
                this.HBar.setValues(-this.xCoord, this.lWidth, 0, this.fullLineLength);
                this.HBar.setBlockIncrement(this.lWidth);
                if (!this.bHBarVisible) {
                    this.bHBarVisible = true;
                    this.HBar.setVisible(true);
                }
            } else if (this.bHBarVisible) {
                this.bHBarVisible = false;
                this.HBar.setVisible(false);
            }
        }
        if (this.borderType == 0) {
            g.setColor(this.borderDarkerColor);
            g.drawLine(0, 0, rect.width - 1, 0);
            g.drawLine(0, 0, 0, rect.height - 1);
            g.setColor(this.borderDarkColor);
            g.drawLine(1, 1, rect.width - 2, 1);
            g.drawLine(1, 1, 1, rect.height - 2);
            g.setColor(this.borderLightColor);
            g.drawLine(1, rect.height - 2, rect.width - 2, rect.height - 2);
            g.drawLine(rect.width - 2, 1, rect.width - 2, rect.height - 2);
            g.setColor(this.borderLighterColor);
            g.drawLine(0, rect.height - 1, rect.width - 1, rect.height - 1);
            g.drawLine(rect.width - 1, 0, rect.width - 1, rect.height - 1);
        }
        g.clipRect(this.halfBorderWidth, this.halfBorderWidth, this.lWidth, rect.height - this.borderWidth);
        if (this.nTopRow >= nItems) {
            this.nTopRow -= this.visibleRows + 1;
        }
        int i = this.nTopRow;
        int j = Math.min(this.nTopRow + this.visibleRows, nItems);
        int dp = 0;
        while (i < j) {
            yLoc = dp * this.cellHt + this.yAdj + this.halfBorderWidth;
            ySLoc = (dp + 1) * this.cellHt + this.yAdj + this.halfBorderWidth;
            ListItem item = (ListItem)this.items.elementAt(i);
            if (item.bDirty || this.bAllDirty) {
                item.bDirty = false;
                g.clearRect(this.halfBorderWidth, yLoc, this.lWidth, this.cellHt);
            }
            int xSelectStartLoc = item.image != null ? this.halfBorderWidth + 20 + 2 : this.halfBorderWidth;
            gridAdj = item.bCellBorder ? 2 : 0;
            int tWidth = this.lWidth - this.xCoord - 20 - 2;
            if (item.bSelected) {
                g.setColor(this.textHighlight);
                g.fillRect(this.xCoord + xSelectStartLoc + gridAdj, yLoc, tWidth, this.cellHt);
                g.setColor(this.textHighlightText);
            } else {
                g.setColor(this.enabledColor);
            }
            int x = this.xCoord + xSelectStartLoc + gridAdj + 2;
            int y = ySLoc - this.fontDescent;
            g.drawString(item.sText, x, y);
            if (this.VType.elementData[i]) {
                try {
                    String s = Tool.longToString(this.VSize.elementAt(i), 9);
                    String d = df.format(new Date(this.VDate.elementAt(i)));
                    int depl = this.sizeWidth - s.length() * this.charWidth;
                    g.drawString(s, x + this.sizePos + depl, y);
                    g.drawString(d, x + this.datePos, y);
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    aie.printStackTrace();
                }
            }
            if (item.image != null) {
                g.drawImage(item.image, this.xCoord + this.halfBorderWidth + gridAdj + 2, yLoc + 2, 20, this.cellHt - 3, this);
            }
            if (item.deleted) {
                g.setColor(Color.red);
                int yy = yLoc + this.cellHt / 2;
                g.drawLine(this.xCoord + this.halfBorderWidth + gridAdj + 2, yy, this.lWidth, yy);
            }
            if (item.tagged) {
                g.setColor(this.textHighlight);
                g.drawRect(this.xCoord + xSelectStartLoc + gridAdj, yLoc + 1, tWidth - this.xCoord - 2, this.cellHt - 2);
            }
            ++i;
            ++dp;
        }
        this.bAllDirty = false;
        this.listChanged = false;
    }

    public long getTaggedSize() {
        this.TaggedSize = 0L;
        for (int i = 0; i < this.countItems(); ++i) {
            if (!this.isSelected(i)) continue;
            this.TaggedSize += this.VSize.elementAt(i);
        }
        return this.TaggedSize;
    }

    public void clear(int capacity) {
        super.clear(capacity);
        this.VType = new VectorBoolean(capacity, 16);
        this.VSize = new VectorLong(capacity, 16);
        this.VDate = new VectorLong(capacity, 16);
        this.TotalSize = 0L;
    }

    public synchronized void addItemDir(int no) {
        this.addItem(no);
        this.VType.addElement(false);
        this.VSize.addElement(0L);
        this.VDate.addElement(0L);
    }

    public void addItemFile(Image img, int no, long size, long time) {
        this.addItem(img, no);
        this.VType.addElement(true);
        this.VSize.addElement(size);
        this.VDate.addElement(time);
        this.TotalSize += size;
    }

    public void delItem(int index) {
        super.delItem(index);
        this.TotalSize -= this.VSize.elementAt(index);
        this.VType.removeElementAt(index);
        this.VSize.removeElementAt(index);
        this.VDate.removeElementAt(index);
    }

    public long[] getSelectedSizes() {
        long[] l = new long[this.countSelected];
        if (this.countSelected > 0) {
            int x = 0;
            int s = this.items.size();
            for (int i = 0; i < s; ++i) {
                ListItem tempItem = (ListItem)this.items.elementAt(i);
                if (!tempItem.bSelected && !tempItem.tagged) continue;
                l[x] = this.VSize.elementAt(i);
                if (++x == this.countSelected) break;
            }
        }
        return l;
    }
}

