/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DButtonBase;
import ae.OS;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;

public class DirButton
extends DButtonBase
implements Serializable {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    protected Color arrowColor = null;
    protected Color disabledArrowColor = null;
    protected int direction;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;

    public DirButton() {
        this(3);
    }

    public DirButton(int d) {
        this.direction = d;
        this.left = 0;
        this.right = 0;
        this.bottom = 0;
        this.setArrowColor(Color.black);
    }

    public void setDirection(int d) {
        this.direction = d;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setArrowColor(Color newValue) {
        this.arrowColor = newValue;
        this.disabledArrowColor = Color.lightGray;
    }

    public Color getArrowColor() {
        return this.arrowColor;
    }

    public Dimension getPreferredSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 5, defaultSize.height + 5);
    }

    public Dimension getMinimumSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 3, defaultSize.height + 3);
    }

    protected void updateButtonImage() {
        super.updateButtonImage();
        Graphics g = this.buttonImage.getGraphics();
        Dimension s = this.getSize();
        int trueBevel = this.bevel + 1;
        if (this.blackBorder) {
            ++trueBevel;
        }
        if (this.isEnabled()) {
            g.setColor(this.arrowColor);
        } else {
            g.setColor(this.disabledArrowColor);
        }
        int centerHorizontal = (s.width - 1) / 2 + this.pressedAdjustment;
        int centerVertical = (s.height - 1) / 2 + this.pressedAdjustment;
        switch (this.direction) {
            case 2: 
            case 3: {
                int tiers = s.width / 3;
                int huit = s.width / 8;
                this.top = tiers;
                this.bottom = tiers;
                this.left = huit;
                this.right = huit;
                break;
            }
            case 0: 
            case 1: {
                int huit;
                int tiers = s.height / 3;
                this.top = huit = s.height / 8;
                this.bottom = huit;
                this.left = tiers;
                this.right = tiers;
            }
        }
        int topSide = this.top + trueBevel - 1 + this.pressedAdjustment;
        int bottomSide = s.height - this.bottom - trueBevel + this.pressedAdjustment;
        int leftSide = this.left + trueBevel - 1 + this.pressedAdjustment;
        int rightSide = s.width - 1 - this.right - trueBevel + this.pressedAdjustment;
        if (OS.isMacintosh()) {
            ++leftSide;
            ++topSide;
        }
        switch (this.direction) {
            case 2: {
                int hParity = rightSide - leftSide;
                if (hParity == hParity / 2 * 2) {
                    --rightSide;
                }
                this.fillTriangle(g, centerHorizontal, topSide, leftSide, bottomSide, rightSide, bottomSide);
                break;
            }
            case 3: {
                int hParity = rightSide - leftSide;
                if (hParity == hParity / 2 * 2) {
                    --rightSide;
                }
                this.fillTriangle(g, centerHorizontal, bottomSide, leftSide, topSide, rightSide, topSide);
                break;
            }
            case 0: {
                int vParity = bottomSide - topSide;
                if (vParity == vParity / 2 * 2) {
                    --bottomSide;
                }
                this.fillTriangle(g, leftSide, centerVertical, rightSide, bottomSide, rightSide, topSide);
                break;
            }
            case 1: {
                int vParity = bottomSide - topSide;
                if (vParity == vParity / 2 * 2) {
                    --bottomSide;
                }
                this.fillTriangle(g, rightSide, centerVertical, leftSide, bottomSide, leftSide, topSide);
                break;
            }
        }
        if (g != null) {
            g.dispose();
        }
    }

    protected void fillTriangle(Graphics g, int tipX, int tipY, int aX, int aY, int bX, int bY) {
        int[] xp = new int[]{tipX, aX, bX, tipX};
        int[] yp = new int[]{tipY, aY, bY, tipY};
        g.drawPolyline(xp, yp, 4);
    }

    protected boolean isValidBevelSize(int i) {
        Dimension s = this.getSize();
        int temp = i * 2 + 4;
        return i >= 0 && s.width >= temp && s.height >= temp;
    }

    protected boolean isValidDirection(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }
}

