/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Archiver;
import ae.ComboDir;
import ae.DButton;
import ae.DMessageBar;
import ae.DPanel;
import ae.DToolBar;
import ae.Deleter;
import ae.DialogMessage;
import ae.DirBox;
import ae.DirTools;
import ae.Directory;
import ae.Disk;
import ae.History;
import ae.Icons;
import ae.Input;
import ae.Path;
import ae.Preferences;
import ae.Style;
import ae.Temporary;
import ae.Tool;
import ae.VectorString;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;

public class DirManager
extends Panel
implements ActionListener,
ComponentListener,
KeyListener,
MouseListener {
    public Directory dir = new Directory(true);
    public ComboDir combo;
    public DirBox dirList;
    public DMessageBar statusBar;
    public History history = null;
    public Archiver archiver = null;
    public Temporary tempo = null;
    public String ZipName;
    public String m_dirName;
    public String m_fileName;
    public String m_pathName;
    public Label labelDirSize;
    public DToolBar toolbar;
    public DButton buttonOpen;
    public DButton buttonHome;
    public DButton buttonParent;
    public DButton buttonMake;
    public DButton buttonDelete;
    public DButton buttonCancel;
    public MenuItem miOpen;
    public MenuItem miRun;
    public MenuItem miEdit;
    public MenuItem miRename;
    public MenuItem miDelete;
    public MenuItem miInfo;
    public MenuItem miAddPrg;
    public MenuItem miAddDoc;
    public MenuItem miCopy;
    public MenuItem miUnarc;
    public Frame frame;
    public DPanel panelDirList;
    public Component vParent;
    public PopupMenu popup = null;
    public String MemName = "IZ.Memory";
    public String MemDir = System.getProperty("user.dir");
    public boolean associated = false;
    public boolean modified = false;
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    public static final int UNKNOW = 2;
    public int usage = 2;
    public String dirmade = "";
    public static String graflist = ".gif.jpg.ico.raw.pal.aaz.bmp.pcx.pic.tga.png.xbm.tiff.jpeg.jpe.";
    public static String others = ".class.hlp.";
    public static String soundlist = ".wav.au.aif.";
    public boolean addit = false;
    Process process;
    transient ActionListener actionListener;
    KeyListener keyListener;

    public DirManager(Frame f) {
        this.frame = f;
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        this.toolbar = new DToolBar();
        this.add((Component)this.toolbar, "North");
        this.panelDirList = new DPanel();
        this.panelDirList.setLayout(new BorderLayout(0, 0));
        this.add(this.panelDirList);
        this.combo = new ComboDir();
        this.combo.setBounds(2, 3, 368, 22);
        this.combo.setArrowStyle(true, false, 1);
        this.combo.setMaxItems(16);
        this.combo.setEditable(true);
        this.combo.setShowFocus(true);
        this.combo.addKeyListener(this);
        this.combo.addActionListener(this);
        this.combo.editBox.addKeyListener(this);
        this.panelDirList.add((Component)this.combo, "North");
        this.dirList = new DirBox(true);
        this.dirList.addActionListener(this);
        this.dirList.addMouseListener(this);
        this.dirList.addKeyListener(this);
        this.dirList.setFocusable(true);
        this.panelDirList.add((Component)this.dirList, "Center");
        this.labelDirSize = new Label("");
        this.labelDirSize.setBounds(14, 335, 258, 16);
        this.labelDirSize.setFont(new Font("SansSerif", 0, 14));
        this.add((Component)this.labelDirSize, "South");
        DButton.ADJUSTSIZE = false;
        DButton.setDefaultSize(36, 24);
        this.buttonOpen = new DButton(Icons.DirOpen);
        this.buttonOpen.setTip("Open or process according to the extension");
        this.buttonOpen.addActionListener(this);
        this.toolbar.add(this.buttonOpen);
        this.buttonHome = new DButton(Icons.DirHome);
        this.buttonHome.setTip("Go to home directory");
        this.buttonHome.addActionListener(this);
        this.toolbar.add(this.buttonHome);
        this.buttonParent = new DButton(Icons.DirParent);
        this.buttonParent.setTip("Go to parent directory");
        this.buttonParent.addActionListener(this);
        this.toolbar.add(this.buttonParent);
        this.toolbar.setHeight(24);
        this.toolbar.addSeparator(11, 22);
        this.buttonMake = new DButton(Icons.DirMake);
        this.buttonMake.setTip("Create a new sub-directory");
        this.buttonMake.addActionListener(this);
        this.toolbar.add(this.buttonMake);
        this.buttonDelete = new DButton(Icons.DirDel);
        this.buttonDelete.setTip("Cross out / Delete selection");
        this.buttonDelete.addActionListener(this);
        this.toolbar.add(this.buttonDelete);
        this.buttonCancel = new DButton(Icons.Cancel);
        this.buttonCancel.setTip("Cancel selection / Refresh the display");
        this.buttonCancel.addActionListener(this);
        this.toolbar.add(this.buttonCancel);
        this.setPath(this.MemDir);
        this.addComponentListener(this);
        this.dir.jarMask = true;
        this.addMouseListener(this);
    }

    public DirManager(Frame f, DMessageBar sb) {
        this(f);
        this.setObjets(sb);
    }

    public void setPopupParent(Component p, Font font) {
        this.popup = new PopupMenu();
        this.vParent = p;
        this.vParent.add(this.popup);
        Font fontBold = new Font(font.getName(), 1, font.getSize());
        this.miOpen = new MenuItem("Open");
        this.miOpen.addActionListener(this);
        this.miOpen.setFont(fontBold);
        this.popup.add(this.miOpen);
        this.miRun = new MenuItem("Run");
        this.miRun.addActionListener(this);
        this.miRun.setFont(font);
        this.popup.add(this.miRun);
        this.miEdit = new MenuItem("Edit");
        this.miEdit.addActionListener(this);
        this.miEdit.setFont(font);
        this.popup.add(this.miEdit);
        this.popup.addSeparator();
        this.miInfo = new MenuItem("More info", new MenuShortcut(73));
        this.miInfo.addActionListener(this);
        this.miInfo.setFont(font);
        this.popup.add(this.miInfo);
        this.miRename = new MenuItem("Rename", new MenuShortcut(78));
        this.miRename.addActionListener(this);
        this.miRename.setFont(font);
        this.popup.add(this.miRename);
        this.miDelete = new MenuItem("Delete");
        this.miDelete.addActionListener(this);
        this.miDelete.setFont(font);
        this.popup.add(this.miDelete);
        this.miAddPrg = new MenuItem("Add to Tools");
        this.miAddPrg.addActionListener(this);
        this.miAddPrg.setFont(font);
        this.popup.add(this.miAddPrg);
        this.miAddDoc = new MenuItem("Add to References");
        this.miAddDoc.addActionListener(this);
        this.miAddDoc.setFont(font);
        this.popup.add(this.miAddDoc);
        this.popup.addSeparator();
        this.miCopy = new MenuItem("Copy", new MenuShortcut(67));
        this.miCopy.addActionListener(this);
        this.miCopy.setFont(font);
        this.popup.add(this.miCopy);
        this.miUnarc = new MenuItem("Extract", new MenuShortcut(85));
        this.miUnarc.addActionListener(this);
        this.miUnarc.setFont(font);
        this.popup.add(this.miUnarc);
    }

    public void setUsage(int u) {
        this.usage = u;
    }

    public int getUsage() {
        return this.usage;
    }

    public void setObjets(DMessageBar sb) {
        this.statusBar = sb;
    }

    public void setHistory(History h) {
        this.history = h;
    }

    public void setFilename(String n) {
        this.MemName = n;
    }

    public void setArchiver(Archiver a) {
        this.archiver = a;
    }

    public void setTemporary(Temporary t) {
        this.tempo = t;
    }

    public void addNotify() {
        super.addNotify();
        this.combo.setBackground(this.getParent().getBackground());
    }

    public void addButton(DButton b) {
        this.toolbar.add(b);
    }

    public void setModified(boolean mode) {
        this.modified = mode;
        if (this.modified) {
            this.dir.updated = false;
        }
    }

    public void requestFocus() {
        this.dirList.requestFocus();
    }

    public void comboResize(int s) {
        this.combo.Resize(s);
    }

    public void setStyle(Style s) {
        this.dirList.setStyle(s);
        this.combo.setStyle(s);
        Dimension newd = new Dimension();
        Dimension oldd = this.combo.getSize();
        newd.height = s.font.getSize();
        newd.width = oldd.width;
        this.combo.setSize(newd);
    }

    public void message(String message) {
        this.dispTip(message);
        if (this.history != null) {
            this.history.tell(message);
        }
    }

    public void dispTip(String message) {
        if (this.statusBar != null) {
            this.statusBar.setText(" " + message);
        }
    }

    public boolean testSelected(int no) {
        if (this.dirList.isSelected()) {
            return true;
        }
        this.noSelected(no);
        return false;
    }

    public void noSelected(int no) {
        String[] win = new String[]{" in source", " in target", ""};
        this.dispTip("Select a file" + win[no] + ", please...");
        Tool.beep();
    }

    public void noSelected() {
        this.noSelected(2);
    }

    boolean error(String s) {
        System.out.println(s);
        return false;
    }

    public String getDrive() {
        return this.dir.getDrive();
    }

    public String getPath() {
        return this.dir.getPath();
    }

    public String getDir() {
        return this.dir.getDir();
    }

    public int firstFile() {
        return this.dir.MAXINDIRS;
    }

    public void setPath(String str) {
        if (str == null) {
            str = this.MemDir;
        }
        this.dir.setPath(str);
        this.updatePath(str);
    }

    public void updatePath(String str) {
        try {
            String suffix = this.dir.filter.length() > 0 ? " filter " + this.dir.filter : "";
            this.dispTip("New path " + this.dir.getPath() + suffix);
        }
        catch (NullPointerException n) {
            this.dir.filter = "";
            String suffix = "";
        }
    }

    public void makePath(String dir, String fic) {
        this.m_dirName = dir;
        this.m_fileName = fic;
        this.m_pathName = Path.merge(this.m_dirName, this.m_fileName);
    }

    public boolean selected() {
        return this.isSelected();
    }

    public boolean isSelected() {
        return this.dirList.isSelected();
    }

    public boolean isTagged() {
        return this.dirList.isTagged();
    }

    public void setSelected(String s, boolean mode) {
        if (this.dirList.countItems() > 0) {
            this.dirList.setSelectedItem(s, mode);
        }
    }

    public void showIt(int no) {
        this.dirList.showIt(no);
    }

    public void setSelected(int i) {
        if (this.dirList.countItems() > 0) {
            this.dirList.setSelectedIndex(i, true);
        }
    }

    public void selectCtrl(String fic) {
        this.dirList.selectMultiple(this.dirList.getIndex(fic), false, true);
    }

    public int getSelectedIndex() {
        return this.dirList.getSelectedIndex();
    }

    public String[] getFiles() {
        return this.dirList.getFiles(this.getDir());
    }

    public String[] getSelectedItems() {
        return this.dirList.getSelectedItems();
    }

    public int[] getSelectedIndexes() {
        return this.dirList.getSelectedIndexes();
    }

    public String getSelected() {
        return this.dirList.getSelectedItem();
    }

    public String[] getTaggedItems() {
        return this.dirList.getTaggedItems();
    }

    public String getTagged() {
        return this.dirList.getTaggedItem();
    }

    public void deselectAll() {
        this.dirList.deselectAll();
    }

    public void selectAll() {
        this.dirList.selectAllFiles(this.firstFile());
    }

    public void selectAny() {
        this.dirList.selectAll();
    }

    public int countSelected() {
        return this.dirList.countSelected;
    }

    public void setArcSort(boolean b) {
        this.dir.setArcSort(b);
    }

    public String[] getListItems() {
        return this.dirList.getListItems();
    }

    public int countItems() {
        return this.dirList.countItems();
    }

    public void setPainting(boolean mode) {
        this.dirList.setPainting(mode);
    }

    public void update(boolean b) {
        this.dirList.update(b);
    }

    public void selectMultiple(int s) {
        this.dirList.selectMultiple(s, false, true);
    }

    public boolean isDir() {
        int[] num = this.dirList.getSelectedIndexes();
        if (num.length > 1) {
            return false;
        }
        String dst = Path.merge(this.dir.getDir(), this.dirList.getSelectedItem());
        return new File(dst).isDirectory();
    }

    public void refresh(boolean atstart) {
        int no = atstart ? 0 : this.dirList.getTopRow();
        this.dirDisp(no);
        this.showIt(no);
    }

    public void dirDisp(boolean atStart) {
        int no = atStart ? 0 : this.dirList.getTopRow();
        this.dirDisp(no);
    }

    public void dirDisp(int no) {
        this.dir.dispDir(this.dirList, this.dir.filter, no);
        String labdir = this.dir.MAXINDIRS > 1 ? " directories   " : " directory   ";
        String labfile = this.dir.MAXINFILES > 1 ? " files" : " file";
        String labmask = this.dir.Masked > 0 ? "   " + this.dir.Masked + " hidden" : "";
        long size = this.dirList.TotalSize;
        String labsize = size > 0xA00000L ? size / 0x100000L + " megas used" : size + " bytes used";
        this.labelDirSize.setText(" " + this.dir.MAXINDIRS + labdir + this.dir.Displayed + labfile + labmask + "   " + labsize);
        this.combo.setText(this.dir.getPath());
        this.modified = false;
    }

    public void parent() {
        String current = this.dir.goParent();
        this.updatePath(this.dir.getPath());
        this.dirDisp(true);
        if (current.length() > 0) {
            this.dirList.showIt(current);
        } else {
            this.dirList.showIt(0);
        }
    }

    public void home() {
        this.dir.goHome();
        this.updatePath(this.dir.getPath());
        this.dirDisp(true);
        this.setSelected(0);
    }

    public void make() {
        this.make("Creating a sub-directory");
    }

    public void make(String title) {
        if (this.isInside()) {
            return;
        }
        this.dispTip(title);
        Input md = new Input(this.frame);
        md.setTitle(title);
        md.setLabel("Type a name for the sub-directory to create:");
        md.setInput("");
        md.setVisible(true);
        String name = md.getInput();
        if (md.ok()) {
            File f = new File(this.dir.getDir(), name);
            if (f.mkdir()) {
                this.message(name + " directory created");
                this.modified = true;
                this.dirmade = name;
                if (this.usage != 1) {
                    this.dirDisp(true);
                }
                this.sendAction("md");
            } else {
                this.dispTip("Not made");
            }
        } else {
            this.dispTip("Cancelled");
        }
    }

    public void cancel() {
        this.dirDisp(true);
    }

    public boolean isInside() {
        if (this.dir.zipMode) {
            this.dispTip("This can't be performed inside archive");
            return true;
        }
        return false;
    }

    public void moreInfo() {
        if (this.isInside()) {
            return;
        }
        String dirname = this.dir.getDir();
        String[] l = this.dirList.getSelectedItems();
        if (l.length == 1) {
            String name = this.dirList.getSelectedItem();
            if (!new File(this.getDir(), name).isDirectory()) {
                this.message(DirTools.info(Path.merge(dirname, name)));
                return;
            }
        }
        int mode = 0;
        this.dirList.setCursor(new Cursor(3));
        this.dispTip("calculating...");
        if (l.length == 0) {
            l = this.dirList.getListItems();
            mode = 1;
        }
        DirTools.occupation(dirname, l, mode);
        this.message(DirTools.message);
        this.dirList.setCursor(Cursor.getDefaultCursor());
    }

    public boolean open() {
        if (!this.selected()) {
            return false;
        }
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        if (this.dir.zipMode) {
            return this.openInside(false);
        }
        return this.openCommon(true);
    }

    public boolean openInside(boolean program) {
        this.message("Viewing " + this.m_fileName + " inside " + this.dir.arcname);
        if (this.tempo == null) {
            System.out.println("Temporary dir not created");
            return false;
        }
        if (this.tempo.open(this.m_dirName, this.dir.arcname, this.m_fileName)) {
            if (program) {
                this.executable(this.tempo.createdPath, this.tempo.createdFile);
            } else {
                this.openPath(this.tempo.createdPath, this.tempo.createdFile, false, false);
            }
        } else {
            this.message(this.tempo.message);
        }
        return this.tempo.result;
    }

    public boolean openCommon(boolean addit) {
        File which = new File(this.m_dirName, this.m_fileName);
        if (which.isDirectory()) {
            this.dispTip("Directory");
            this.setPath(this.m_pathName);
            this.dirDisp(true);
            this.setSelected(0);
            this.dirList.requestFocusInWindow();
            return true;
        }
        return this.openAny(this.m_pathName, this.m_fileName, true, true);
    }

    public boolean openAny(String path, String name, boolean addit, boolean withexe) {
        if (Directory.isArchive(path)) {
            return this.openZip();
        }
        this.openPath(path, name, addit, withexe);
        return true;
    }

    public void viewZip() {
        if (!this.testSelected(0)) {
            return;
        }
        File f = new File(this.dir.getDir(), this.dirList.getSelectedItem());
        if (f.isDirectory()) {
            this.noSelected();
            return;
        }
        this.openZip();
    }

    public boolean openZip() {
        this.message("Opening archive " + this.m_fileName);
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        this.ZipName = this.m_fileName;
        this.dir.setArchive(true);
        this.setPath(this.m_pathName);
        this.setCursor(new Cursor(3));
        this.dirDisp(true);
        this.setCursor(Cursor.getDefaultCursor());
        if (this.dir.zipMode) {
            this.message("Inside archive " + this.m_fileName);
            this.showIt(0);
            return true;
        }
        this.ZipName = "";
        this.setPath(this.m_dirName);
        this.message("Format not supported");
        new DialogMessage(this.frame, "Zip format not supported").setVisible(true);
        return false;
    }

    public static boolean inside(String str, String search) {
        int i;
        if (search == null) {
            return false;
        }
        if (search.equals("")) {
            return false;
        }
        String ext = search.toLowerCase();
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        if (!ext.endsWith(".")) {
            ext = ext + ".";
        }
        return (i = str.indexOf(ext)) != -1;
    }

    public void openPath(String path, String name, boolean addit, boolean withexe) {
        this.addit = addit;
        this.m_pathName = path = path.toLowerCase();
        this.m_fileName = name;
        if (Preferences.AssFirst) {
            System.out.println("first");
            this.associated = false;
            this.sendAction("assoc");
            if (this.associated) {
                return;
            }
        }
        if (DirTools.isExecutable(name)) {
            if (withexe) {
                this.executable(this.m_pathName, name);
            }
            return;
        }
        String extension = Path.getExtension(name);
        if (DirManager.inside(graflist, extension)) {
            this.sendAction("graph");
            return;
        }
        if (DirManager.inside(soundlist, extension)) {
            this.sendAction("sound");
            return;
        }
        if (!Preferences.AssFirst) {
            this.associated = false;
            this.sendAction("assoc");
            if (this.associated) {
                return;
            }
        }
        this.sendAction("text");
    }

    public boolean openRun() {
        if (!this.selected()) {
            return false;
        }
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        File which = new File(this.m_dirName, this.m_fileName);
        if (which.isDirectory()) {
            return false;
        }
        if (this.dir.zipMode) {
            return this.openInside(true);
        }
        return this.executable(this.m_pathName, this.m_fileName);
    }

    public boolean executable(String path, String fName) {
        if (DirTools.isMSDOS(path)) {
            this.dispTip(fName + " is a MS-DOS program. Run it with Explorer");
            return false;
        }
        if (DirTools.isCOMMAND()) {
            this.dispTip(fName + " is a command, open the DOS window and type it");
            return false;
        }
        String winver = "";
        if (DirTools.isWIN31()) {
            winver = "Windows 3.1 program ";
        }
        this.message("Launching " + winver + fName);
        this.launch(path, fName);
        return true;
    }

    public void launch(String fullpath, String name) {
        boolean ok = false;
        String message = "Enable to run " + fullpath;
        try {
            this.process = Runtime.getRuntime().exec(fullpath);
            try {
                this.process.waitFor();
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            ok = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (!ok) {
            this.message(message);
        }
    }

    public boolean run(String prog, String path, String name) {
        Runtime rc = Runtime.getRuntime();
        boolean result = false;
        String message = "Enable to run " + prog + " with " + path;
        try {
            Process process = Runtime.getRuntime().exec(prog + " " + path);
            try {
                process.waitFor();
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            message = "Launched " + prog + " with " + path;
            result = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.message(message);
        return result;
    }

    String pluriel(int number) {
        if (number > 1) {
            return "s";
        }
        return "";
    }

    public void crossOut() {
        boolean changed = false;
        int m = this.dirList.countItems();
        int crossed = 0;
        for (int i = 0; i < m; ++i) {
            if (!this.dirList.isSelected(i)) continue;
            this.dirList.setDeselected(i);
            this.dirList.crossOut(i);
            changed = true;
            ++crossed;
        }
        if (changed) {
            this.dirList.blockPaint(false);
            this.message(crossed + " file" + this.pluriel(crossed) + " crossed out for deletion");
        } else {
            this.noSelected();
        }
    }

    public int deleteConditional(String curdir, String fic) {
        Deleter.message = fic + " not deleted";
        int ret = Deleter.conditional(this.frame, curdir, fic);
        if (ret < 1) {
            this.message(Deleter.message);
            return 0;
        }
        if (ret == 1) {
            this.message(fic + " deleted");
        }
        return ret;
    }

    public void deleteSecond() {
        int counter = 0;
        int counterHere = 0;
        String curdir = this.dir.getDir();
        this.dispTip("Deleting crossed out files");
        int m = this.dirList.countItems();
        int index = -1;
        int toprow = this.dirList.getTopRow();
        for (int i = 0; i < m; ++i) {
            if (!this.dirList.isCrossOut(i)) continue;
            this.dirList.crossOut(i, false);
            ++counterHere;
            counter += this.deleteConditional(curdir, this.dirList.getText(i));
            if (index == -1) {
                index = i;
            }
            if (i >= toprow) continue;
            toprow = i;
        }
        if (counter > 0) {
            m = Math.max(0, m - counter);
            index = Math.min(index, m - 1);
            index = Math.max(0, index);
            if (counter > 1) {
                this.message(counter + " deleted");
            }
            this.dirDisp(this.dirList.getTopRow());
            this.setSelected(index);
            this.sendAction("modified");
        }
    }

    void delete() {
        if (this.isInside()) {
            return;
        }
        if (this.dirList.isCrossOut()) {
            this.deleteSecond();
        } else {
            this.crossOut();
        }
    }

    boolean rename() {
        if (this.isInside()) {
            return false;
        }
        boolean renFlag = false;
        int index = this.dirList.getSelectedIndex();
        String name = this.dirList.getSelectedItem();
        String direct = this.dir.getDir();
        if (index == -1) {
            Tool.beep();
            return false;
        }
        if (name == null || name.length() == 0) {
            Tool.beep();
            return false;
        }
        Input ren = new Input(this.frame);
        ren.setTitle("Rename a file or a directory");
        ren.setLabel("Type the new name:");
        ren.setInput(name);
        ren.setVisible(true);
        if (ren.ok()) {
            File oldname = new File(direct, name);
            File newname = new File(direct, ren.getInput());
            try {
                if (oldname.renameTo(newname)) {
                    this.dirList.setText(index, newname.getName());
                    renFlag = true;
                } else {
                    renFlag = false;
                }
            }
            catch (SecurityException e) {
                renFlag = false;
            }
            if (renFlag) {
                this.message(name + " renamed " + newname.getName());
                this.sendAction("modified");
            } else {
                this.message("Enable to rename " + name + " to " + newname.getName());
            }
        }
        return true;
    }

    public boolean unArchive(String destination) {
        this.makePath(this.getDir(), this.getSelected());
        Archiver.setMessage("Error");
        if (this.dir.zipMode) {
            String[] list = this.dirList.getSelectedItems();
            int l = list.length;
            if (l > 0) {
                String things = l > 1 ? "tagged list" : this.m_fileName;
                this.message("Extracting " + things + " from " + this.dir.arcname);
                String arc = Path.merge(this.m_dirName, this.dir.arcname);
                for (int i = 0; i < l; ++i) {
                    String fic = list[i];
                    if (Archiver.extractFile(arc, fic, destination, Preferences.ArcRestore)) continue;
                    this.message(Archiver.getMessage());
                }
                return true;
            }
            this.dispTip("Select entries to unarchive, please!");
            return false;
        }
        if (Path.isDirectory(this.m_pathName)) {
            this.noSelected();
            return false;
        }
        this.dispTip("Unarchiving " + this.m_pathName);
        Point p = this.archiver.unArchive(this.m_pathName, destination);
        if (p.y == 0) {
            this.message(Archiver.getMessage());
            Tool.beep();
        } else {
            String prefix = "";
            if (p.y < p.x) {
                prefix = "Error - ";
            }
            this.message(prefix + this.m_pathName + " unarchived in " + p.y + "/" + p.x + " file(s)");
        }
        if (Archiver.error) {
            new DialogMessage(this.frame, "Error, not unarchived!").setVisible(true);
        }
        return true;
    }

    public boolean testSelected() {
        this.makePath(this.dir.getDir(), this.dirList.getSelectedItem());
        if (this.m_pathName == null) {
            return false;
        }
        return !new File(this.m_pathName).isDirectory();
    }

    public void addPrg() {
        if (!this.testSelected()) {
            return;
        }
        this.sendAction("addprg");
    }

    public void addDoc() {
        if (!this.testSelected()) {
            return;
        }
        this.sendAction("adddoc");
    }

    public void setPathCombo() {
        String entry = Path.setCanonical(this.combo.getText());
        this.setPath(entry);
        this.dirDisp(true);
    }

    public void pathDelete() {
        this.message("Removing " + this.dir.getPath() + " from list");
        this.combo.deleteInList();
        this.combo.setBaseSize();
        this.setPath(this.combo.getText());
        this.dirDisp(true);
    }

    public void showMenu() {
        if (this.vParent == null) {
            return;
        }
        this.popup.show(this.dirList, this.dirList.popx, this.dirList.popy);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonParent) {
            this.parent();
        } else if (object == this.buttonHome) {
            this.home();
        } else if (object == this.buttonOpen) {
            this.open();
        } else if (object == this.buttonMake) {
            this.make();
        } else if (object == this.buttonDelete) {
            this.delete();
        } else if (object == this.buttonCancel) {
            this.cancel();
        } else {
            if (object == this.combo) {
                String command = event.getActionCommand();
                if (command != null && command.equals("del")) {
                    this.pathDelete();
                    return;
                }
                this.setPath(this.combo.getSelectedItem());
                this.dirDisp(true);
                this.dirList.showIt(0);
                return;
            }
            if (object == this.dirList) {
                String command = event.getActionCommand();
                if (command.equals("Enter")) {
                    this.open();
                    return;
                }
                if (command.equals("Popup")) {
                    this.showMenu();
                    return;
                }
                if (command.equals("Delete")) {
                    this.delete();
                    return;
                }
                if (command.equals("Esc")) {
                    this.cancel();
                    return;
                }
                if (command.equals("Up")) {
                    this.parent();
                    return;
                }
            } else if (object == this.miOpen) {
                this.open();
            } else if (object == this.miRun) {
                this.openRun();
            } else if (object == this.miEdit) {
                this.sendAction("edit");
            } else if (object == this.miRename) {
                this.rename();
            } else if (object == this.miDelete) {
                this.delete();
            } else if (object == this.miInfo) {
                this.moreInfo();
            } else if (object == this.miCopy) {
                if (this.dir.zipMode) {
                    this.sendAction("unarc");
                } else {
                    this.sendAction("copy");
                }
            } else if (object == this.miUnarc) {
                this.sendAction("unarc");
            } else if (object == this.miAddPrg) {
                this.addPrg();
            } else if (object == this.miAddDoc) {
                this.addDoc();
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void sendAction(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    public void addKeyListener(KeyListener k) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, k);
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        Object object = event.getSource();
        int keypressed = event.getKeyCode();
        if (event.isAltDown()) {
            switch (keypressed) {
                default: 
            }
            if (this.keyListener != null) {
                this.keyListener.keyPressed(event);
            }
        }
        if (object == this.combo.editBox) {
            if (keypressed == 10) {
                this.setPathCombo();
                event.consume();
                return;
            }
            if (event.isControlDown()) {
                if (keypressed == 65) {
                    this.combo.addUnicItem(this.combo.editBox.getText());
                    this.combo.separeDrives();
                    event.consume();
                    return;
                }
                if (keypressed == 89 || keypressed == 68) {
                    this.pathDelete();
                    event.consume();
                    return;
                }
            }
        } else if (object == this.dirList && event.isControlDown()) {
            switch (keypressed) {
                case 78: {
                    this.rename();
                    break;
                }
                case 75: 
                case 77: {
                    this.make();
                    break;
                }
                case 73: {
                    this.moreInfo();
                    break;
                }
                default: {
                    return;
                }
            }
            event.consume();
        }
    }

    public void mouseClicked(MouseEvent event) {
        Object object = event.getSource();
        int click = event.getClickCount();
        if (click == 2 && object == this.dirList) {
            this.open();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void save() {
        int size;
        String[] MemorySrc = this.combo.getListItems();
        int ls = MemorySrc.length;
        if (ls > (size = 16)) {
            ls = size;
        }
        VectorString vmem = new VectorString();
        vmem.addElement("SEB=" + this.getDir());
        for (int i = 0; i < ls; ++i) {
            vmem.addElement("BKM=" + MemorySrc[i]);
        }
        int result = Disk.saveLines(this.MemDir, this.MemName, vmem);
    }

    public boolean load(String dir, String name) {
        this.MemDir = dir;
        return this.load(name);
    }

    public boolean load(String name) {
        this.MemName = name;
        return this.load();
    }

    public boolean load() {
        int i;
        VectorString src = new VectorString();
        VectorString vlist = new VectorString();
        int maxsize = 16;
        int loaded = Disk.loadUnicLines(this.MemDir, this.MemName, vlist);
        int size = vlist.size();
        for (i = 0; i < size; ++i) {
            String test = vlist.elementAt(i);
            int j = test.indexOf("=");
            if (j <= 0) continue;
            String lft = test.substring(0, j);
            String rgt = test.substring(j + 1, test.length());
            if (lft == null || rgt == null) continue;
            if (rgt.length() < 1) {
                System.out.println(lft + " Error: Empty field");
                continue;
            }
            if (lft.equals("BKM")) {
                src.addElement(rgt);
                continue;
            }
            if (!lft.equals("SEB")) continue;
            this.setPath(rgt);
        }
        this.combo.clear();
        this.combo.setMaxItems(16);
        if (size < 1) {
            return false;
        }
        int lbs = src.separeDrives();
        this.combo.setBaseSize(lbs);
        int l = src.size();
        for (i = 0; i < l; ++i) {
            this.combo.addItem(src.elementAt(i));
        }
        return true;
    }

    public void componentShown(ComponentEvent e) {
        String dirname = this.dir.getDir();
        if (!dirname.equalsIgnoreCase(this.m_dirName)) {
            this.modified = true;
        }
        if (this.modified) {
            this.refresh(false);
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }
}

