/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DialogCompare;
import ae.OS;
import ae.Path;
import ae.Tool;
import java.awt.AWTEventMulticaster;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DirTools {
    public static long fileSize;
    public static int fileNumber;
    public static String message;
    public static final int SELECT = 0;
    public static final int FULL = 1;
    public static String base;
    public static boolean EXECUTABLE;
    public static boolean MSDOS;
    public static boolean COMMANDLINE;
    public static boolean WIN31;
    public static boolean WIN95;
    static int countnf;
    static int countok;
    static int countbad;
    static int count;
    static int dirNoFound;
    static DialogCompare cd;
    static boolean stopFlag;
    public static int messnum;
    public static final int MESSAGE = 0;
    public static final int TIP = 1;
    ActionListener actionListener = null;
    static Process process;
    boolean actionresult = true;
    ProgThread tSound = null;
    public static SimpleDateFormat fileDate;

    public static void scanDir(String dir) {
        for (String fic : new File(dir).list()) {
            File file = new File(dir, fic);
            if (file.isDirectory()) {
                DirTools.scanDir(Path.merge(dir, fic));
                continue;
            }
            fileSize += file.length();
            ++fileNumber;
        }
    }

    public static void folderSize(String path, String name) {
        File file = new File(path, name);
        if (file.isDirectory()) {
            DirTools.scanDir(Path.merge(path, name));
        } else {
            fileSize += file.length();
            ++fileNumber;
        }
    }

    public static void occupation(String dir, String[] l, int mode) {
        String name = null;
        fileNumber = 0;
        fileSize = 0L;
        if (l.length == 0) {
            message = "No files";
            return;
        }
        name = mode == 0 ? (l.length == 1 ? l[0] : "tagged list") : "";
        for (int i = 0; i < l.length; ++i) {
            DirTools.folderSize(dir, l[i]);
        }
        base = " bytes";
        if (fileSize > 10240L) {
            fileSize /= 1024L;
            base = " k. bytes";
        }
        if (fileSize > 10240L) {
            fileSize /= 1024L;
            base = " mega bytes";
        }
        name = Path.merge(dir, name);
        String plur = "";
        if (fileNumber > 1) {
            plur = "s";
        }
        message = name + ", disk occupation is " + fileSize + base + "   " + fileNumber + " file" + plur;
    }

    public static int intConvert(int origin) {
        int un = origin >> 24 & 0xFF;
        int deux = origin >> 16 & 0xFF;
        int trois = origin >> 8 & 0xFF;
        int quatre = origin & 0xFF;
        return (quatre << 24) + (trois << 16) + (deux << 8) + un;
    }

    public static short shortConvert(short origin) {
        int high = origin >> 8 & 0xFF;
        int low = origin & 0xFF;
        return (short)((low << 8) + high);
    }

    public static void exeTest(String path) {
        EXECUTABLE = false;
        MSDOS = false;
        WIN31 = false;
        COMMANDLINE = false;
        WIN95 = false;
        try {
            DataInputStream fiS = new DataInputStream(new FileInputStream(path));
            int available = fiS.available();
            if (available >= 28) {
                try {
                    byte high = fiS.readByte();
                    byte low = fiS.readByte();
                    EXECUTABLE = high == 77 && low == 90;
                    fiS.readInt();
                    short items = DirTools.shortConvert(fiS.readShort());
                    short para = DirTools.shortConvert(fiS.readShort());
                    MSDOS = para < 3 || items > 0;
                    fiS.readInt();
                    fiS.readInt();
                    fiS.readInt();
                    fiS.readShort();
                    short relocOffset = DirTools.shortConvert(fiS.readShort());
                    MSDOS |= relocOffset < 64;
                    boolean bl = items == 0 && relocOffset != 64;
                    fiS.readShort();
                    if (!(MSDOS |= bl)) {
                        int i;
                        for (i = 0; i < 8; ++i) {
                            fiS.readInt();
                        }
                        int offset = DirTools.intConvert(fiS.readInt());
                        for (i = 64; i < offset; ++i) {
                            fiS.readByte();
                        }
                        high = fiS.readByte();
                        low = fiS.readByte();
                        if (high == 78 && low == 69) {
                            WIN31 = true;
                        } else {
                            if (high == 80 && low == 69) {
                                WIN95 = true;
                            }
                            for (i = 2; i < 20; ++i) {
                                fiS.readByte();
                            }
                            short optsize = DirTools.shortConvert(fiS.readShort());
                            fiS.readShort();
                            high = fiS.readByte();
                            low = fiS.readByte();
                            if (high != 11 || low != 1) {
                                System.out.println("Magic number not found " + high + " " + low);
                            }
                            if (optsize > 68) {
                                for (i = 2; i < 68; ++i) {
                                    fiS.readByte();
                                }
                                byte mode = fiS.readByte();
                                if (mode == 3) {
                                    COMMANDLINE = true;
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            fiS.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isMSDOS(String path, String name) {
        return DirTools.isMSDOS(Path.merge(path, name));
    }

    public static boolean isMSDOS(String path) {
        if (!OS.isWindows()) {
            return false;
        }
        DirTools.exeTest(path);
        return EXECUTABLE & MSDOS;
    }

    public static boolean isCOMMAND() {
        return COMMANDLINE;
    }

    public static boolean isWIN31() {
        return WIN31;
    }

    public static boolean isExecutable(String path) {
        path = path.toLowerCase();
        if (OS.isWindows()) {
            if (path.endsWith(".exe")) {
                return true;
            }
            if (path.endsWith(".pif")) {
                return true;
            }
            return path.endsWith(".com");
        }
        return false;
    }

    public static boolean compareBytes(byte[] buf1, byte[] buf2, int count) {
        for (int i = 0; i < count; ++i) {
            if (buf1[i] == buf2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(String path1, String path2) {
        if (stopFlag) {
            return false;
        }
        File f1 = new File(path1);
        File f2 = new File(path2);
        long total = f1.length();
        if (total != f2.length()) {
            return false;
        }
        long totalRead = 0L;
        try {
            int bytesRead;
            FileInputStream fis1 = new FileInputStream(f1);
            FileInputStream fis2 = new FileInputStream(f2);
            byte[] buffer1 = new byte[32768];
            byte[] buffer2 = new byte[32768];
            while ((bytesRead = fis1.read(buffer1, 0, buffer1.length)) > 0) {
                if (fis2.read(buffer2, 0, buffer2.length) != bytesRead) {
                    return false;
                }
                if (!DirTools.compareBytes(buffer1, buffer2, bytesRead)) {
                    return false;
                }
                totalRead += (long)bytesRead;
            }
            fis1.close();
            fis2.close();
        }
        catch (FileNotFoundException f) {
            f.printStackTrace();
        }
        catch (IOException i) {
            i.printStackTrace();
        }
        return total == totalRead;
    }

    public static void dirComp(String origine, String destination, String[] fics) {
        if (stopFlag) {
            return;
        }
        for (int i = 0; i < fics.length; ++i) {
            try {
                String fic = fics[i];
                File fSource = new File(origine, fic);
                File fTarget = new File(destination, fic);
                String source = Path.merge(origine, fic);
                cd.setSource(source);
                if (!fTarget.exists()) {
                    cd.setTarget("");
                    cd.setResult(source + " skipped, no found in target");
                    if (fSource.isDirectory()) {
                        ++dirNoFound;
                    } else {
                        ++countnf;
                        ++count;
                    }
                } else {
                    String target = Path.merge(destination, fic);
                    cd.setTarget(target);
                    if (fSource.isDirectory()) {
                        DirTools.dirComp(source, target, fSource.list());
                    } else {
                        ++count;
                        boolean compared = DirTools.compare(source, target);
                        if (compared) {
                            ++countok;
                        } else {
                            cd.setResult(source + " and " + target + " *** differ");
                            ++countbad;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            cd.setTotal(count);
            cd.setGood(countok);
            cd.setSkip(countnf);
            cd.setBad(countbad);
        }
    }

    public static void setDialog(Object o) {
        cd = (DialogCompare)o;
    }

    public static String treeComp(Frame f, String origine, String destination, String[] fics) {
        countnf = 0;
        countok = 0;
        countbad = 0;
        count = 0;
        dirNoFound = 0;
        stopFlag = false;
        cd.setSource(origine);
        cd.setTarget(destination);
        DialogCompare.alreadyFlag = false;
        DirTools.dirComp(origine, destination, fics);
        DialogCompare.alreadyFlag = false;
        if (stopFlag) {
            String res = "Interrupted by user...";
            cd.setResult(res);
            return res;
        }
        String res = "Files identical: " + countok + " / " + count;
        cd.setResult(res);
        cd.setResult("Files not found: " + countnf);
        cd.setResult("Files different: " + countbad);
        cd.setResult("Directories not found: " + dirNoFound);
        int err = countnf + countbad + dirNoFound;
        if (err == 0) {
            cd.setResult("PERFECT COPY or BURNING");
        } else {
            cd.setResult("There are errors");
        }
        return res;
    }

    public void Message(String s) {
        message = s;
        messnum = 0;
        this.sourceActionEvent();
    }

    public void dispTip(String s) {
        message = s;
        messnum = 1;
        this.sourceActionEvent();
    }

    protected void sourceActionEvent() {
        if (this.actionListener == null) {
            return;
        }
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, ""));
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void Run(String prog, String path, boolean dispmess) {
        String command = prog;
        if (path != null) {
            command = command + " " + path;
        }
        if (dispmess) {
            this.dispTip("Launching " + prog);
        }
        try {
            process = Runtime.getRuntime().exec(command);
            try {
                process.waitFor();
            }
            catch (InterruptedException i) {}
        }
        catch (IOException ioe) {
            this.Message(prog + " not in PATH, update AUTOEXEC.BAT");
            return;
        }
    }

    public void Launch(String fullpath, String name) {
        boolean ok = false;
        String message = "Enable to run " + fullpath;
        try {
            process = Runtime.getRuntime().exec(fullpath);
            try {
                process.waitFor();
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            ok = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (!ok) {
            this.Message(message);
        }
    }

    public void runJava(String prog, String path) {
        String ext = Path.getExtension(path).toLowerCase();
        if (ext.compareTo("jar") == 0) {
            prog = " -jar";
            prog = " -jar";
        } else if (ext.compareTo("class") != 0) {
            return;
        }
        String node = Path.getNode(path);
        String dir = Path.getPath(path);
        this.Message("Launching java program: " + node);
        path = "\"" + node + "\"";
        System.out.println("Process " + prog + " " + path);
        this.LaunchPrgFile(prog, path);
    }

    private String enclose(String prog, String path) {
        String name = Path.getFile(prog);
        String sep = "\"";
        if (name.equalsIgnoreCase("winhelp.exe")) {
            sep = "";
        }
        return prog + " " + sep + path + sep;
    }

    boolean ProgAction(String prog, String path, boolean dispmess) {
        boolean result = true;
        String message = "Enable to run " + prog + " with " + path;
        try {
            process = Runtime.getRuntime().exec(this.enclose(prog, path));
            try {
                process.waitFor();
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            message = "Launched " + prog + " with " + path;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            result = false;
        }
        if (dispmess) {
            this.Message(message);
        }
        this.actionresult = result;
        return result;
    }

    public boolean LaunchPrgFile(String prog, String path) {
        ProgThread p = new ProgThread();
        p.prog = prog;
        p.path = path;
        p.dispmess = true;
        p.start();
        return this.actionresult;
    }

    public void sound(String path, String name) {
        this.dispTip("Playing " + name);
        if (process != null) {
            process.destroy();
        }
        this.tSound = new ProgThread();
        this.tSound.prog = "sndrec32.Exe /play /embedding";
        this.tSound.path = path;
        this.tSound.dispmess = false;
        this.tSound.start();
    }

    public void free() {
        Runtime rc = Runtime.getRuntime();
        long before = rc.freeMemory();
        long total = rc.totalMemory();
        System.gc();
        this.dispTip("Free memory now increased from " + before + " to " + rc.freeMemory() + " bytes, out of " + total + " bytes.");
    }

    public static String info(String fname) {
        File f = new File(fname);
        long l = f.length();
        long t = f.lastModified();
        String s = Tool.longToString(l);
        String d = fileDate.format(new Date(t));
        return Path.getFile(fname) + ",  " + s + " bytes,  " + d;
    }

    public void console(String dir) {
        String[] cmd = new String[3];
        cmd[1] = "/C";
        cmd[2] = "cd " + dir;
        if (OS.isWindowsNT()) {
            cmd[0] = "cmd.exe";
        } else if (OS.isWindows()) {
            cmd[0] = "command.com";
        } else {
            return;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmd);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.Run("dosprmpt.pif", null, false);
    }

    static {
        message = "";
        EXECUTABLE = false;
        MSDOS = false;
        COMMANDLINE = false;
        WIN31 = false;
        WIN95 = false;
        messnum = 0;
        fileDate = new SimpleDateFormat("EEEE d MMMM yyyy   kk:mm:ss");
    }

    public class ProgThread
    extends Thread
    implements Runnable {
        String path = null;
        String prog = null;
        boolean dispmess = true;
        boolean result = false;

        public void run() {
            this.result = DirTools.this.ProgAction(this.prog, this.path, this.dispmess);
        }
    }
}

