/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DirBox;
import ae.DirIcons;
import ae.OS;
import ae.Path;
import ae.Sort;
import ae.VectorLong;
import ae.VectorString;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Directory {
    public final int MAXINDISKS = 0;
    public int MAXINDIRS;
    public int MAXINFILES;
    public int MAXINLIST;
    final short TYPE_DISK = 0;
    final short TYPE_FLOPPY = 1;
    final short TYPE_CDROM = (short)2;
    final short TYPE_REM = (short)3;
    final short TYPE_MEDIA = (short)8;
    final short TYPE_DIR = (short)16;
    final short TYPE_FILE = (short)24;
    final short TYPE_HTML = (short)25;
    final short TYPE_EXE = (short)26;
    final short TYPE_DOC = (short)27;
    final short TYPE_SOUND = (short)32;
    final short TYPE_IMAGE = (short)48;
    final short TYPE_ZIP = (short)64;
    DirBox dirbox;
    public Image image;
    Sort sort = null;
    String[] Contenu;
    int[] Idx;
    VectorLong EntrySizes;
    VectorLong EntryTimes;
    int Index;
    String path;
    String directory;
    String filter;
    boolean updated;
    public String arcname = null;
    public boolean EXTENDED = false;
    public boolean maskOther = false;
    public boolean maskImage = false;
    public static boolean Sorting = true;
    public boolean zipMode = false;
    public boolean isArchive = false;
    public boolean isImage = false;
    public boolean isOther = false;
    public boolean jarMask = false;
    public static String root;
    static DirIcons di;
    private boolean arcSort = true;
    public int Displayed;
    public int Masked;

    public Directory(boolean mode) {
        this.EXTENDED = mode;
        root = OS.isWindows() ? "\\" : "/";
    }

    public Directory() {
        this(false);
    }

    public int getMax() {
        return this.MAXINLIST;
    }

    public int getNumber() {
        return this.MAXINLIST;
    }

    public String getDir() {
        return this.directory;
    }

    public String getDrive() {
        return Path.splitDrive(this.directory);
    }

    public String getPath() {
        return this.path;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null && this.filter.length() > 0;
    }

    void setArchive(boolean isArc) {
        this.isArchive = isArc;
    }

    void setZipMode(boolean mode) {
        this.zipMode = mode;
    }

    void setFileMask(boolean m) {
        this.maskOther = m;
        this.updated = false;
    }

    void setImageMask(boolean m) {
        this.maskImage = m;
        this.updated = false;
    }

    void setArcSort(boolean b) {
        if (b != this.arcSort) {
            this.arcSort = b;
            this.updated = false;
        }
    }

    public void setPath(String newpath) {
        try {
            this.path = newpath;
            this.directory = Path.splitPath(newpath);
            this.arcname = this.filter = Path.splitFile(newpath);
            this.updated = false;
        }
        catch (NullPointerException e) {
            System.out.println("Error directory empty");
        }
    }

    public void setArcFile(String fic) {
        try {
            this.arcname = fic;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.arcname = "";
        }
    }

    public static boolean createDir(String path, String dname) {
        File f = new File(path, dname);
        if (f.exists()) {
            return f.isDirectory();
        }
        return f.mkdirs();
    }

    public static boolean createDir(String path) {
        return new File(path).mkdirs();
    }

    public void goDrive(String newdrive) {
        if (!this.directory.startsWith(newdrive)) {
            this.setPath(newdrive);
        }
        this.setArchive(false);
    }

    public String nullDir() {
        if (OS.isWindows()) {
            return "";
        }
        return "/";
    }

    public String goParent() {
        String current = "";
        if (this.filter.length() > 0) {
            if (this.zipMode) {
                current = this.filter;
            }
            this.setPath(this.directory);
        } else {
            File dir = new File(this.directory);
            String newpath = dir.getParent();
            if (newpath == null) {
                return this.nullDir();
            }
            if (newpath.length() == 0) {
                return this.nullDir();
            }
            current = Path.splitLast(this.directory);
            int i = newpath.lastIndexOf(File.separator);
            if (i == newpath.length() - 1) {
                newpath = newpath.substring(0, i);
            }
            this.setPath(newpath);
        }
        this.setArchive(false);
        return current;
    }

    public void goHome() {
        if (OS.isWindows()) {
            String drive = Path.splitDrive(this.directory);
            if (Path.isValidDrive(drive)) {
                this.setPath(drive);
            } else {
                this.setPath(File.separator);
            }
        } else {
            this.setPath("/");
        }
        this.setArchive(false);
    }

    public static boolean IsEmpty(File fichier) {
        String[] test;
        return !fichier.exists() || !(fichier.isDirectory() ? (test = fichier.list()) != null && test.length > 0 : fichier.length() > 0L);
    }

    public static boolean isArchive(String path) {
        if (Directory.isZip(path)) {
            return true;
        }
        return Directory.isGZip(path);
    }

    public static boolean isZip(String path) {
        String ul = path.toLowerCase();
        if (ul.indexOf("*") != -1) {
            return false;
        }
        if (ul.endsWith(".zip")) {
            return true;
        }
        if (ul.endsWith(".jar")) {
            return true;
        }
        return ul.endsWith(".sxw");
    }

    public static boolean isGZip(String path) {
        String ul = path.toLowerCase();
        if (ul.indexOf("*") != -1) {
            return false;
        }
        if (ul.endsWith(".gz")) {
            return true;
        }
        return ul.endsWith(".tgz");
    }

    public boolean isZip() {
        if (this.isArchive) {
            return true;
        }
        if (this.arcname == null) {
            return false;
        }
        return Directory.isZip(this.arcname);
    }

    private void swapList(int i, int j) {
        int T = this.Idx[i];
        this.Idx[i] = this.Idx[j];
        this.Idx[j] = T;
    }

    public void separeDirs() {
        this.MAXINDIRS = 0;
        int ptr = this.MAXINDIRS + 1;
        while (ptr <= this.MAXINLIST) {
            if (new File(this.directory, this.Contenu[this.Idx[this.MAXINDIRS]]).isDirectory()) {
                ++this.MAXINDIRS;
                if (ptr != this.MAXINDIRS) continue;
                ++ptr;
                continue;
            }
            if (ptr < this.MAXINLIST && new File(this.directory, this.Contenu[this.Idx[ptr]]).isDirectory()) {
                this.swapList(this.MAXINDIRS, ptr);
                ++this.MAXINDIRS;
            }
            ++ptr;
        }
        this.MAXINFILES = this.MAXINLIST - this.MAXINDIRS;
    }

    public void sortList() throws Exception {
        this.sort = new Sort(this.Contenu, this.Idx);
        if (this.MAXINDIRS > 0) {
            this.SortRange(0, this.MAXINDIRS);
        }
        if (this.MAXINFILES > 0) {
            this.SortRange(this.MAXINDIRS, this.MAXINLIST);
        }
    }

    public void SortRange(int st, int limit) {
        this.sort.insertion(st, limit);
    }

    public boolean getList() {
        this.Contenu = null;
        System.gc();
        this.MAXINDIRS = 0;
        this.MAXINLIST = 0;
        if (this.directory == null) {
            this.directory = Path.getSysPath();
        }
        if (this.EXTENDED) {
            this.EntrySizes = new VectorLong(1024, 16);
            this.EntryTimes = new VectorLong(1024, 16);
        }
        if (this.isZip()) {
            this.zipMode = true;
            this.isArchive = false;
            try {
                ZipFile archive = new ZipFile(Path.merge(this.directory, this.arcname));
                Enumeration<? extends ZipEntry> e = archive.entries();
                VectorString temp = new VectorString(1024, 16);
                boolean again = true;
                while (e.hasMoreElements() && again) {
                    try {
                        String s = ((Object)e.nextElement()).toString();
                        temp.addElement(s);
                        if (!this.EXTENDED) continue;
                        ZipEntry ze = archive.getEntry(s);
                        this.EntrySizes.addElement(ze.getSize());
                        this.EntryTimes.addElement(ze.getTime());
                    }
                    catch (NoSuchElementException ex) {
                        System.out.println("No such element");
                        again = false;
                    }
                }
                this.Contenu = temp.toArray();
                archive.close();
            }
            catch (IOException e) {
                System.out.println("Error in Zip");
                this.zipMode = false;
            }
            if (!this.zipMode) {
                return false;
            }
        } else {
            this.zipMode = false;
            this.arcname = "";
            File path = new File(this.directory, root);
            if (!OS.isWindows()) {
                System.out.println(this.directory);
            }
            try {
                this.Contenu = path.list();
                if (this.EXTENDED) {
                    for (int ne = 0; ne < this.Contenu.length; ++ne) {
                        File f = new File(this.directory, this.Contenu[ne]);
                        this.EntrySizes.addElement(f.length());
                        this.EntryTimes.addElement(f.lastModified());
                    }
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                System.out.println("Dir list not filled");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        if (this.Contenu == null) {
            return false;
        }
        this.MAXINLIST = this.Contenu.length;
        this.Idx = new int[this.MAXINLIST];
        for (int k = 0; k < this.MAXINLIST; ++k) {
            this.Idx[k] = k;
        }
        this.separeDirs();
        if (this.zipMode ? !this.arcSort : !Sorting) {
            return true;
        }
        try {
            this.sortList();
        }
        catch (Exception e) {
            System.out.println("Enable to sort");
        }
        return true;
    }

    public int getType(int no) {
        String suffix;
        if (no < 0) {
            return 0;
        }
        if (no < this.MAXINDIRS) {
            return 16;
        }
        no = this.Idx[no];
        int l = this.Contenu[no].length();
        int li = this.Contenu[no].lastIndexOf(46);
        if (l > 5 && li == l - 5) {
            String suffix2 = this.Contenu[no].substring(l - 4, l);
            if (suffix2.equalsIgnoreCase("html")) {
                return 27;
            }
            if (suffix2.equalsIgnoreCase("php4")) {
                return 27;
            }
            if (suffix2.equalsIgnoreCase("php5")) {
                return 27;
            }
            return 24;
        }
        if (l > 4 && li == l - 4) {
            String suffix3 = this.Contenu[no].substring(l - 3, l);
            if (suffix3.equalsIgnoreCase("zip")) {
                return 64;
            }
            if (suffix3.equalsIgnoreCase("gif")) {
                return 48;
            }
            if (suffix3.equalsIgnoreCase("jpg")) {
                return 48;
            }
            if (suffix3.equalsIgnoreCase("pcx")) {
                return 48;
            }
            if (suffix3.equalsIgnoreCase("png")) {
                return 48;
            }
            if (suffix3.equalsIgnoreCase("wav")) {
                return 32;
            }
            if (suffix3.equalsIgnoreCase("exe")) {
                return 26;
            }
            if (suffix3.equalsIgnoreCase("doc")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("rtf")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("hlp")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("htm")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("php")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("asp")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("wri")) {
                return 27;
            }
            if (suffix3.equalsIgnoreCase("mid")) {
                return 32;
            }
            if (this.jarMask) {
                if (suffix3.equalsIgnoreCase("jar")) {
                    return 64;
                }
                if (suffix3.equalsIgnoreCase("sxw")) {
                    return 64;
                }
                if (suffix3.equalsIgnoreCase("ico")) {
                    return 48;
                }
                if (suffix3.equalsIgnoreCase("raw")) {
                    return 48;
                }
                if (suffix3.equalsIgnoreCase("pal")) {
                    return 48;
                }
                if (suffix3.equalsIgnoreCase("aaz")) {
                    return 64;
                }
            }
            return 24;
        }
        if (l > 3 && li == l - 3 && (suffix = this.Contenu[no].substring(l - 2, l)).equalsIgnoreCase("au")) {
            return 32;
        }
        return 24;
    }

    public String getFile(int i) {
        if (i < this.MAXINLIST) {
            return this.Contenu[this.Idx[i]];
        }
        return null;
    }

    void setCategory(int i) {
        this.isImage = false;
        this.isOther = false;
        switch (this.getType(i)) {
            case 64: {
                this.image = DirIcons.IconZip;
                this.isImage = true;
                break;
            }
            case 48: {
                this.image = DirIcons.IconPic;
                this.isImage = true;
                break;
            }
            case 32: {
                this.image = DirIcons.IconWav;
                this.isImage = true;
                break;
            }
            case 27: {
                this.image = DirIcons.IconDoc;
                break;
            }
            case 26: {
                this.image = DirIcons.IconExe;
                break;
            }
            default: {
                this.image = DirIcons.IconFile;
                this.isOther = true;
            }
        }
    }

    public void dispDir(DirBox ilr, String Filter) {
        this.dispDir(ilr, Filter, 0);
    }

    public void dispDir(DirBox ilr, String Filter, int firstitem) {
        int i;
        boolean Filtering;
        String Node = null;
        String Ext = null;
        boolean accept = true;
        this.dirbox = ilr;
        int lastselected = this.dirbox.getSelectedIndex();
        if (!this.getList()) {
            this.dirbox.clear(0);
            this.dirbox.setVisible(false);
            this.dirbox.setVisible(true);
            this.updated = true;
            return;
        }
        if (Filter == null || this.zipMode) {
            Filtering = false;
        } else {
            Node = Path.splitNode(Filter);
            Ext = Path.getExtension(Filter);
            Filtering = Filter.length() > 0;
        }
        this.Displayed = 0;
        this.Masked = 0;
        this.dirbox.clear(this.Contenu.length);
        this.dirbox.setModel(this.Contenu);
        this.dirbox.setImage(DirIcons.IconDir);
        for (i = 0; i < this.MAXINDIRS; ++i) {
            this.dirbox.addItemDir(this.Idx[i]);
        }
        for (i = this.MAXINDIRS; i < this.MAXINLIST; ++i) {
            this.setCategory(i);
            accept = true;
            if (this.maskImage && !this.isImage) {
                accept = false;
            }
            if (this.maskOther && this.isOther) {
                accept = false;
            }
            int no = this.Idx[i];
            if (Filtering) {
                String CExt;
                String CNode;
                String s = this.Contenu[no];
                int lio = s.indexOf(46);
                if (lio == -1) {
                    CNode = s;
                    CExt = "";
                } else {
                    CNode = s.substring(0, lio);
                    CExt = s.substring(lio + 1);
                }
                boolean bl = accept = !(!Node.equals("*") && !Node.equalsIgnoreCase(CNode) || !Ext.equals("*") && !Ext.equalsIgnoreCase(CExt));
            }
            if (accept) {
                this.dirbox.addItemFile(this.image, no, this.EntrySizes.elementAt(no), this.EntryTimes.elementAt(no));
                ++this.Displayed;
                continue;
            }
            ++this.Masked;
        }
        this.dirbox.setVisible(false);
        this.dirbox.setTopRow(firstitem);
        this.dirbox.setLastSelected(lastselected);
        this.dirbox.setVisible(true);
        this.updated = true;
    }

    static {
        di = new DirIcons();
    }
}

