/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Path;
import ae.Preferences;
import ae.TextModel;
import ae.VectorString;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Disk {
    public static final int BINARY = 0;
    public static final int TEXT = 1;
    public static final int AREA = 2;

    public static int size(String path) {
        int size = 0;
        try {
            FileInputStream fiS = new FileInputStream(path);
            size = fiS.available();
            fiS.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return size;
    }

    public static int open(String dirname, String fname, TextArea text) {
        int blocksize = 0;
        int textsize = 0;
        String path = Path.merge(dirname, fname);
        System.gc();
        try {
            FileInputStream fiS = new FileInputStream(path);
            int notAtEnd = 1;
            int available = fiS.available();
            if (available > 0) {
                StringBuffer buffer = new StringBuffer(available);
                while (notAtEnd > 0) {
                    blocksize = Math.min(available, 32768);
                    if (blocksize > 0) {
                        textsize += blocksize;
                        available -= blocksize;
                        byte[] byteBuffer = new byte[blocksize];
                        notAtEnd = fiS.read(byteBuffer);
                        buffer.append(new String(byteBuffer));
                        continue;
                    }
                    notAtEnd = -1;
                }
                text.setText(buffer.toString());
            }
            fiS.close();
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + path);
        }
        return textsize;
    }

    public static String loadText(String dir, String filename) {
        String path = Path.merge(dir, filename);
        String ch = System.getProperty("line.separator");
        int seplen = ch.length();
        int size = Disk.size(path);
        int loaded = 0;
        if (size == 0) {
            return "";
        }
        System.gc();
        StringBuffer sbuffer = new StringBuffer(size);
        try {
            BufferedReader br = new BufferedReader(new FileReader(path));
            String s = "";
            while (s != null) {
                s = br.readLine();
                if (s == null) continue;
                sbuffer.append(s);
                sbuffer.append(ch);
                loaded = loaded + s.length() + seplen;
            }
            br.close();
        }
        catch (IOException e) {
            System.out.println("Enable to read " + path);
        }
        return sbuffer.toString();
    }

    public static int insert(String dirname, String fname, TextModel text) {
        int inserted = 0;
        String path = dirname + File.separator + fname;
        System.gc();
        try {
            FileInputStream fiS = new FileInputStream(path);
            int size = fiS.available();
            if (size > 0) {
                int notAtEnd = 1;
                while (notAtEnd > 0) {
                    byte[] byteBuffer = new byte[size];
                    notAtEnd = fiS.read(byteBuffer);
                    if (notAtEnd <= 0) continue;
                    text.insert(new String(byteBuffer));
                    inserted += byteBuffer.length;
                }
            }
            fiS.close();
        }
        catch (IOException e) {
            System.out.print("Error reading file: " + path);
        }
        return inserted;
    }

    public static int save(String dirname, String fName, String textbuffer) {
        String path = Path.merge(dirname, fName);
        int size = 0;
        try {
            FileOutputStream foS = new FileOutputStream(path);
            size = textbuffer.length();
            foS.write(textbuffer.getBytes());
            foS.close();
        }
        catch (IOException e) {
            System.out.println("Error writing file " + fName);
        }
        return size;
    }

    public static int saveText(String dir, String filename, String text) {
        String path = Path.merge(dir, filename);
        String ch = System.getProperty("line.separator");
        int index = 0;
        int oldindex = 0;
        int saved = 0;
        System.gc();
        try {
            FileWriter fw = new FileWriter(path);
            BufferedWriter bw = new BufferedWriter(fw);
            int size = text.length();
            int seplen = ch.length();
            while (index < size) {
                boolean addsep = true;
                index = text.indexOf(ch, oldindex);
                if (index == -1) {
                    index = size;
                    addsep = false;
                }
                String s = text.substring(oldindex, index);
                bw.write(s, 0, s.length());
                if (addsep) {
                    bw.newLine();
                    saved += seplen;
                }
                oldindex = index + seplen;
                saved += s.length();
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("Error writing " + path);
        }
        return saved;
    }

    public static String changeExtension(String name, String ext) {
        int i = name.lastIndexOf(".");
        if (i > 0) {
            return name.substring(0, i) + ext;
        }
        return name + ext;
    }

    public static int saveProtect(String PATH, String filename, int mode, String textstr) {
        File freal = new File(PATH, filename);
        int size = 0;
        if (freal.exists()) {
            try {
                if (!freal.canWrite()) {
                    return 0;
                }
            }
            catch (SecurityException se) {
                System.out.println("Security exception for " + filename);
            }
        }
        String NAME_TMP = Disk.changeExtension(filename, ".tmp");
        String NAME_BAK = Disk.changeExtension(filename, ".bak");
        File ftmp = new File(PATH, NAME_TMP);
        if (ftmp.exists()) {
            ftmp.delete();
        }
        switch (mode) {
            case 0: {
                size = Disk.save(PATH, NAME_TMP, textstr);
                break;
            }
            case 1: {
                size = Disk.saveText(PATH, NAME_TMP, textstr);
                break;
            }
            case 2: {
                size = Disk.save(PATH, NAME_TMP, textstr);
                break;
            }
        }
        if (freal.exists()) {
            if (Preferences.MakeBak) {
                File fbak = new File(PATH, NAME_BAK);
                if (fbak.exists()) {
                    fbak.delete();
                }
                freal.renameTo(fbak);
            } else {
                freal.delete();
            }
        }
        ftmp.renameTo(freal);
        return size;
    }

    public static int saveBlock(String dir, String fname, String textstr) {
        return Disk.saveProtect(dir, fname, 1, textstr);
    }

    public static int loadLines(String dir, String filename, VectorString vlist) {
        String path = Path.merge(dir, filename);
        int counter = 0;
        try {
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            String s = "";
            while (s != null) {
                try {
                    s = br.readLine();
                    if (s == null) continue;
                    vlist.addElement(s);
                    ++counter;
                }
                catch (IOException rioe) {
                    rioe.printStackTrace();
                    s = null;
                }
            }
            try {
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(path + " not found");
        }
        return counter;
    }

    public static int loadUnicLines(String dir, String filename, VectorString vlist) {
        String path = Path.merge(dir, filename);
        int counter = 0;
        try {
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            String s = "";
            while (s != null) {
                try {
                    s = br.readLine();
                    if (s == null || !vlist.addUnicElement(s)) continue;
                    ++counter;
                }
                catch (IOException e) {
                    s = null;
                }
            }
            try {
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(path + " not found");
        }
        return counter;
    }

    public static int saveLines(String dir, String filename, VectorString vstring) {
        int count = 0;
        String path = Path.merge(dir, filename);
        try {
            FileWriter fw = new FileWriter(path);
            BufferedWriter bw = new BufferedWriter(fw);
            int size = vstring.size();
            for (int i = 0; i < size; ++i) {
                String s = vstring.elementAt(i);
                bw.write(s, 0, s.length());
                bw.newLine();
                ++count;
            }
            bw.close();
        }
        catch (IOException ioe) {
            System.out.println("Error writing " + path);
        }
        return count;
    }
}

