/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Color;

public class Effect {
    public static Color darken(int r, int g, int b, double percent) {
        return new Color(Math.max((int)((double)r * (1.0 - percent)), 0), Math.max((int)((double)g * (1.0 - percent)), 0), Math.max((int)((double)b * (1.0 - percent)), 0));
    }

    public static Color darken(Color c, double percent) {
        return Effect.darken(c.getRed(), c.getGreen(), c.getBlue(), percent);
    }

    public static Color lighten(int r, int g, int b, double percent) {
        int r2 = r + (int)((double)(255 - r) * percent);
        int g2 = g + (int)((double)(255 - g) * percent);
        int b2 = b + (int)((double)(255 - b) * percent);
        return new Color(r2, g2, b2);
    }

    public static Color lighten(Color c, double percent) {
        return Effect.lighten(c.getRed(), c.getGreen(), c.getBlue(), percent);
    }

    public static Color fade(Color from, Color to, double percent) {
        int from_r = from.getRed();
        int from_g = from.getGreen();
        int from_b = from.getBlue();
        int to_r = to.getRed();
        int to_g = to.getGreen();
        int to_b = to.getBlue();
        int r = from_r > to_r ? to_r + (int)((double)(from_r - to_r) * (1.0 - percent)) : to_r - (int)((double)(to_r - from_r) * (1.0 - percent));
        int g = from_g > to_r ? to_g + (int)((double)(from_g - to_g) * (1.0 - percent)) : to_g - (int)((double)(to_g - from_g) * (1.0 - percent));
        int b = from_b > to_b ? to_b + (int)((double)(from_b - to_b) * (1.0 - percent)) : to_b - (int)((double)(to_b - from_b) * (1.0 - percent));
        return new Color(r, g, b);
    }

    public static double lightness(Color c) {
        if (c == null) {
            return 0.0;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        double max = Math.max(r, Math.max(g, b)) / 255.0 / 2.0;
        double min = Math.min(r, Math.min(g, b)) / 255.0 / 2.0;
        return max + min;
    }

    public static Color hilight(Color c) {
        if (c == null) {
            return null;
        }
        double lightness = Effect.lightness(c);
        if (lightness >= 0.9) {
            return Effect.darken(c, 0.1);
        }
        if (lightness <= 0.2) {
            return Effect.lighten(c, 0.6);
        }
        return Effect.lighten(c, 0.6);
    }

    public static Color shadow(Color c) {
        if (c == null) {
            return null;
        }
        double lightness = Effect.lightness(c);
        if (lightness >= 0.9) {
            return Effect.darken(c, 0.25);
        }
        if (lightness <= 0.2) {
            return Effect.lighten(c, 0.2);
        }
        return Effect.darken(c, 0.25);
    }
}

