/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DDialog;
import ae.DialogCYN;
import ae.DialogMessage;
import ae.Path;
import ae.Preferences;
import java.awt.AWTEventMulticaster;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileCopy
extends DDialog {
    public static boolean success;
    public static boolean always;
    public static boolean cancel;
    Frame fParent = null;
    ActionListener actionListener = null;
    public String actionCommand;

    public FileCopy(Frame parent) {
        super(parent);
        this.fParent = parent;
    }

    public static boolean success() {
        return success;
    }

    public int testReplace(File dst) {
        if (Preferences.AskReplace && !always && dst.exists()) {
            DialogCYN ask = new DialogCYN(this.fParent, dst.getName() + " exists, replace?");
            ask.setVisible(true);
            return ask.answer;
        }
        return 1;
    }

    public boolean testSame(File src, File dst) {
        String source = src.getPath();
        if (source.equalsIgnoreCase(dst.getPath())) {
            String name = Path.getFile(source);
            new DialogMessage(this.fParent, "Can't copy " + name + " over itself").setVisible(true);
            return true;
        }
        return false;
    }

    public int copyFile(File fsrc, File fdst) {
        cancel = true;
        success = true;
        if (this.testSame(fsrc, fdst)) {
            return 0;
        }
        if (!always) {
            int r = this.testReplace(fdst);
            if (r == 0) {
                return 0;
            }
            if (r == 2) {
                return 0;
            }
        }
        success = false;
        cancel = false;
        FileInputStream source = null;
        FileOutputStream destination = null;
        int counter = 0;
        int totalread = (int)fsrc.length();
        int totalwrite = 0;
        this.sourceAction(fsrc.getPath() + "  to  " + fdst.getPath());
        try {
            int bytes_read;
            source = new FileInputStream(fsrc);
            destination = new FileOutputStream(fdst);
            byte[] buffer = new byte[2048];
            while ((bytes_read = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytes_read);
                totalwrite += bytes_read;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (source != null) {
            try {
                source.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (destination != null) {
            try {
                destination.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        boolean bl = success = totalread == totalwrite;
        if (success) {
            ++counter;
            long lm = fsrc.lastModified();
            if (lm != 0L) {
                fdst.setLastModified(lm);
            }
        }
        return counter;
    }

    public int copy(File fsrc, File fdst) throws IOException {
        cancel = false;
        int r = this.copyLoop(fsrc, fdst);
        always = false;
        return r;
    }

    public int copyLoop(File fsrc, File fdst) throws IOException {
        String name = fsrc.getName();
        return this.copyRename(fsrc, fdst, name);
    }

    public int copyRename(File fsrc, File fdst, String newName) throws IOException {
        cancel = false;
        int r = this.copyRLoop(fsrc, fdst, newName);
        always = false;
        return r;
    }

    public int copyRLoop(File fsrc, File fdst, String newName) throws IOException {
        int counter = 0;
        if (cancel) {
            return counter;
        }
        if (!Path.isDrive(fdst.getName()) && !fdst.isDirectory()) {
            throw new IOException(fsrc + " not found");
        }
        if (!fsrc.exists()) {
            throw new IOException(fsrc + " not found");
        }
        if (!fsrc.canRead()) {
            throw new IOException(fsrc + " is unreadable");
        }
        if (fsrc.isFile()) {
            if (!fdst.exists()) {
                fdst.mkdirs();
            }
            fdst = new File(fdst, newName);
            counter += this.copyFile(fsrc, fdst);
        } else if (fsrc.isDirectory()) {
            String[] files = fsrc.list();
            if (!(fdst = new File(fdst, newName)).exists()) {
                fdst.mkdirs();
            }
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i];
                String sourcefile = fsrc + File.separator + filename;
                String targetfile = fdst + File.separator + filename;
                counter = new File(sourcefile).isDirectory() ? (counter += this.copyLoop(new File(sourcefile), fdst)) : (counter += this.copyFile(new File(sourcefile), new File(targetfile)));
                if (!cancel) continue;
                return counter;
            }
        } else {
            System.out.println("Source is nothing!");
        }
        return counter;
    }

    private static File parent(File f) {
        String dirname = f.getParent();
        if (dirname == null) {
            if (f.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(dirname);
    }

    public void sourceAction(String texte) {
        if (this.actionListener != null) {
            this.actionCommand = texte;
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, texte));
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    static {
        always = false;
        cancel = false;
    }
}

