/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Path;
import java.awt.Menu;

public class FileList {
    Menu menu;
    String[] paths;
    String[] names;
    int index;
    int maxsize;

    public FileList(int size) {
        this.maxsize = size;
        this.paths = new String[size];
        this.names = new String[size];
        this.index = 0;
    }

    public FileList() {
        this(8);
    }

    public FileList(Menu m) {
        this();
        this.menu = m;
    }

    public void setSize(int size) {
        this.maxsize = size;
        while (this.index > this.maxsize) {
            this.remove(0);
        }
    }

    public boolean add(String path, String fic) {
        if (this.index >= this.maxsize) {
            this.remove(0);
        }
        this.paths[this.index] = path;
        this.names[this.index] = fic;
        ++this.index;
        return true;
    }

    public boolean add(String fullpath) {
        Path.split(fullpath);
        return this.add(Path.ADir, Path.Filename);
    }

    public boolean already(String path, String fic) {
        return this.find(path, fic) != -1;
    }

    public int find(String path, String fic) {
        for (int i = 0; i < this.index; ++i) {
            if (!fic.equalsIgnoreCase(this.names[i]) || !path.equalsIgnoreCase(this.paths[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean addUnic(String path, String fic) {
        if (this.already(path, fic)) {
            return false;
        }
        return this.add(path, fic);
    }

    public void remove(int no) {
        if (no < 0) {
            return;
        }
        if (no >= this.index) {
            return;
        }
        int last = this.index - 1;
        for (int i = no; i < last; ++i) {
            this.paths[i] = this.paths[i + 1];
            this.names[i] = this.names[i + 1];
        }
        --this.index;
    }

    public void remove(String path, String fic) {
        this.remove(this.find(path, fic));
    }

    public String get(int index) {
        return Path.merge(this.paths[index], this.names[index]);
    }

    public void clear() {
        this.index = 0;
        for (int i = 0; i < this.maxsize; ++i) {
            this.names[i] = "";
        }
    }

    public String getName(int no) {
        return this.names[no];
    }

    public String getDir(int no) {
        return this.paths[no];
    }

    public String getFullPath(int no) {
        return this.get(no);
    }
}

