/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private boolean brighter;
    private int percent;

    public GrayFilter(boolean b, int p) {
        this.brighter = b;
        this.percent = p;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        int gray = ((rgb >> 16 & 0xFF) * 3 / 10 + (rgb >> 8 & 0xFF) * 59 / 100 + (rgb & 0xFF) * 11 / 100) / 3;
        gray = this.brighter ? 255 - (255 - gray) * (100 - this.percent) / 100 : gray * (100 - this.percent) / 100;
        if (gray < 0) {
            gray = 0;
        }
        if (gray > 255) {
            gray = 255;
        }
        return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
    }

    public static Image createDisabledImage(Image i) {
        GrayFilter filter = new GrayFilter(true, 50);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return grayImage;
    }
}

