/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.HSliderThumb;
import ae.HSliderThumbBot;
import ae.HSliderThumbBoth;
import ae.HSliderThumbTop;
import ae.Slider;
import ae.SliderTick;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;

public class HSlider
extends Slider {
    protected static final int TICK_HEIGHT = 4;
    protected String actionCommand = "HSliderMoved";
    private HSliderThumb thumb = new HSliderThumbBoth();
    private Mouse mouse = null;
    private MouseMtn mouseMotion = null;

    public HSlider() {
        this.width = 24 + this.freq * (this.max + 1);
        this.height = 20;
    }

    protected HSlider(int x, int y) {
        this();
        this.setBounds(x, y, this.width, this.height);
    }

    protected HSlider(int x, int y, int startval) {
        this();
        this.setValue(startval);
        this.setBounds(x, y, this.width, this.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.width = w;
        this.height = h;
    }

    public void setTickStyle(int style) {
        if (this.style != style) {
            super.setTickStyle(style);
            switch (style) {
                case 2: {
                    this.thumb = new HSliderThumbTop();
                    break;
                }
                case 1: {
                    this.thumb = new HSliderThumbBot();
                    break;
                }
                default: {
                    this.thumb = new HSliderThumbBoth();
                }
            }
            this.repaint();
        }
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMtn();
            this.addMouseMotionListener(this.mouseMotion);
        }
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        super.removeNotify();
    }

    protected void do_reshape(int w, int h) {
        int hb = 12;
        int vb = 8;
        if (w < hb) {
            hb = w / 4;
        }
        if (h < vb) {
            vb = h / 4;
        }
        int xl = hb;
        int xr = w - hb - 1;
        int yt = vb + 1;
        int yb = h - vb - 1;
        int n = (this.max - this.min) / this.freq + 1;
        this.tick = new SliderTick[n];
        int hs = this.tickWidth;
        for (int i = 0; i < n; ++i) {
            int x = i * hs;
            this.tick[i] = new SliderTick(yt, yb, xl + x, x);
        }
        this.thumb.resize(5, yb - yt - 4 - 1);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (!this.notified) {
            return;
        }
        super.paint(g);
        if (this.tick.length == 0) {
            return;
        }
        int w = this.width - 1;
        int h = this.height - 1;
        boolean xl = true;
        boolean yt = true;
        int xr = 1 + w - 2;
        int yb = 1 + h - 2;
        g.setColor(Color.black);
        g.drawRect(0, 0, w, h);
        g.setColor(this.background);
        g.fillRect(2, 2, w - 4, h - 4);
        if (this.borderStyle == 2) {
            g.setColor(this.background.brighter());
            g.drawLine(1, 1, xr, 1);
            g.drawLine(1, 1, 1, yb);
            g.drawLine(2, 2, xr - 1, 2);
            g.drawLine(2, 2, 2, yb - 1);
            g.setColor(this.background.darker());
            g.drawLine(2, yb, xr, yb);
            g.drawLine(xr, 2, xr, yb);
            g.drawLine(3, yb - 1, xr - 1, yb - 1);
            g.drawLine(xr - 1, 3, xr - 1, yb - 1);
        } else if (this.borderStyle == 1) {
            g.setColor(this.background.darker());
            g.drawLine(1, 1, xr, 1);
            g.drawLine(1, 1, 1, yb);
            g.drawLine(2, 2, xr - 1, 2);
            g.drawLine(2, 2, 2, yb - 1);
            g.setColor(this.background.brighter());
            g.drawLine(2, yb, xr, yb);
            g.drawLine(xr, 2, xr, yb);
            g.drawLine(3, yb - 1, xr - 1, yb - 1);
            g.drawLine(xr - 1, 3, xr - 1, yb - 1);
        }
        g.setColor(Color.black);
        if (this.style > 0) {
            for (int i = 0; i < this.tick.length; i += this.tickStep) {
                boolean end = i == 0 || i == this.tick.length - 1;
                SliderTick t = this.tick[i];
                if (this.style == 2 || this.style == 3) {
                    g.drawLine(t.x, t.yt + (end ? 0 : 1), t.x, t.yt + 4);
                }
                if (this.style != 1 && this.style != 3) continue;
                g.drawLine(t.x, t.yb - 4, t.x, t.yb - (end ? 0 : 1));
            }
        }
        SliderTick t = this.tick[0];
        int y = 9;
        int x0 = t.x - 5;
        int x1 = this.tick[this.tick.length - 1].x + 5;
        g.drawLine(x0, y, x1, y);
        g.drawLine(x0, y + 1, x1, y + 1);
        g.setColor(Color.gray);
        g.drawLine(x1 + 1, y - 1, x0 - 1, y - 1);
        g.drawLine(x0 - 1, y - 1, x0 - 1, y + 1);
        g.setColor(Color.lightGray);
        g.drawLine(x1 + 1, y + 1, x1 + 1, y);
        g.setColor(Color.white);
        g.drawLine(x0 - 1, y + 2, x1 + 2, y + 2);
        g.drawLine(x1 + 2, y + 2, x1 + 2, y - 1);
        this.thumb.draw(g, this.tick[this.curPos]);
        this.prevPos = this.curPos;
    }

    class MouseMtn
    extends MouseMotionAdapter
    implements Serializable {
        MouseMtn() {
        }

        public void mouseDragged(MouseEvent e) {
            HSlider.this.moveThumb(e.getX(), false);
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        Mouse() {
        }

        public void mousePressed(MouseEvent e) {
            HSlider.this.moveThumb(e.getX(), true);
        }
    }
}

