/*
 * Decompiled with CFR 0.152.
 */
package ae;

class IVector {
    public int[] elementData;
    public int elementCount;
    protected int capacityIncrement = 1;

    public IVector(int capacity) {
        this.elementData = new int[capacity];
        this.capacityIncrement = 1;
    }

    public IVector() {
        this(16);
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.elementData;
            int newCapacity = oldCapacity + this.capacityIncrement;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            this.copy(oldData, this.elementData, this.elementCount);
        }
    }

    public final int size() {
        return this.elementCount;
    }

    public final synchronized int elementAt(int index) {
        return this.elementData[index];
    }

    public final synchronized void setElementAt(int val, int index) {
        this.elementData[index] = val;
    }

    public final synchronized void addElement(int val) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = val;
    }

    public final synchronized void removeElementAt(int index) {
        int j = this.elementCount - index - 1;
        if (j > 0) {
            this.copy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = 0;
    }

    void copy(int[] src, int sdeb, int[] dst, int ddeb, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i + ddeb] = src[i + sdeb];
        }
    }

    void copy(int[] src, int[] dst, int len) {
        for (int i = 0; i < len; ++i) {
            dst[i] = src[i];
        }
    }

    public void clear() {
        this.elementCount = 0;
    }
}

