/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.PaletteShaded;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Icon {
    short idReserved = 0;
    byte idType = 1;
    byte idType1 = 0;
    byte idCount = 1;
    byte idCount1 = 0;
    byte width = (byte)32;
    byte height = (byte)32;
    byte bColorCount = (byte)16;
    byte bColorCount1 = 0;
    short wPlanes = 0;
    short wBitCount = 0;
    byte dwBytesInRes = (byte)-2;
    byte dwBytesInRes1 = (byte)2;
    byte dwBytesInRes2 = 0;
    byte dwBytesInRes3 = 0;
    byte dwImageOffset = (byte)22;
    byte dwImageOffset1 = 0;
    byte dwImageOffset2 = 0;
    byte dwImageOffset3 = 0;
    byte biSize = (byte)40;
    byte biSize1 = 0;
    byte biSize2 = 0;
    byte biSize3 = 0;
    byte biWidth = (byte)32;
    byte biWidth1 = 0;
    byte biWidth2 = 0;
    byte biWidth3 = 0;
    byte biHeight = (byte)32;
    byte biHeight1 = 0;
    byte biHeight2 = 0;
    byte biHeight3 = 0;
    byte biPlanes = 1;
    byte biPlanes1 = 0;
    byte biBitCount = (byte)4;
    byte biBitCount1 = 0;
    byte biCompression = 0;
    byte biCompression1 = 0;
    byte biCompression2 = 0;
    byte biCompression3 = 0;
    byte biSizeImage = (byte)-128;
    byte biSizeImage1 = (byte)2;
    byte biSizeImage2 = 0;
    byte biSizeImage3 = 0;
    int biXPelsPerMeter = 0;
    int biYPelsPerMeter = 0;
    int biClrUsed = 0;
    int biClrImportant = 0;
    byte[][] icColors = new byte[16][4];
    byte[] icXOR = new byte[512];
    byte[] icAND = new byte[128];
    transient int[] pixels;
    transient int transparent = 7;
    transient int maxColors = 16;

    public Icon() {
    }

    public Icon(int colors, int w, int h) {
        this.setMaxColors(colors);
        this.icColors = new byte[colors][4];
        this.width = (byte)w;
        this.height = (byte)h;
        this.biWidth = (byte)w;
        this.biHeight = (byte)h;
    }

    void setMaxColors(int colors) {
        this.bColorCount = (byte)(colors & 0xFF);
        this.bColorCount1 = (byte)(colors >> 8 & 0xFF);
        this.maxColors = colors;
    }

    void setMaxColors() {
        this.maxColors = this.unsigned(this.bColorCount1) * 256 + this.unsigned(this.bColorCount);
        System.out.println("count " + this.bColorCount + " " + this.maxColors);
    }

    int translate(int c) {
        if (c == 1 || c == 4) {
            c = 5 - c;
        }
        if (c == 3 || c == 6) {
            c = 9 - c;
        }
        if (c == 7 || c == 8) {
            c = 15 - c;
        }
        if (c == 9 || c == 12) {
            c = 21 - c;
        }
        if (c == 11 || c == 14) {
            c = 25 - c;
        }
        return c;
    }

    int icoToRGB(int i) {
        int r = this.unsigned(this.icColors[i][2]);
        int g = this.unsigned(this.icColors[i][1]);
        int b = this.unsigned(this.icColors[i][0]);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    int unsigned(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    Color[] getColors() {
        Color[] couleurs = new Color[this.maxColors];
        for (int i = 0; i < this.maxColors; ++i) {
            int b = this.unsigned(this.icColors[i][0]);
            int g = this.unsigned(this.icColors[i][1]);
            int r = this.unsigned(this.icColors[i][2]);
            couleurs[this.translate((int)i)] = new Color(r, g, b);
        }
        return couleurs;
    }

    void capture(Image image, PaletteShaded palette) {
        int i;
        this.pixels = new int[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, (int)this.width, (int)this.height, this.pixels, 0, (int)this.width);
        pg.setColorModel(palette.getColorModel());
        try {
            pg.grabPixels();
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("Icon capture aborted or errored");
            return;
        }
        for (i = 0; i < this.maxColors; ++i) {
            int j = this.translate(i);
            Color color = palette.getColor(j);
            this.icColors[i][0] = (byte)color.getBlue();
            this.icColors[i][1] = (byte)color.getGreen();
            this.icColors[i][2] = (byte)color.getRed();
            this.icColors[i][3] = -1;
        }
        for (i = this.pixels.length - 1; i >= 0; --i) {
            int k = this.pixels[i];
            int l = this.transparent;
            for (int j = 0; j < this.maxColors; ++j) {
                if (k != this.icoToRGB(j)) continue;
                l = j;
            }
            this.pixels[i] = l;
        }
        switch (this.maxColors) {
            case 256: {
                this.make256();
                break;
            }
            default: {
                this.make16();
            }
        }
    }

    void make256() {
    }

    void make16() {
        int adr = 0;
        int maskadr = 0;
        int lmask = 0;
        int maskval = 0;
        int COLORMASK = 15;
        for (int j = this.height - 1; j >= 0; --j) {
            for (int k = 0; k < this.width; k += 2) {
                int i = j * this.width + k;
                int c = this.pixels[i];
                int m = c == this.transparent ? 1 : 0;
                int val = (c & 0xF) << 4;
                maskval = maskval << 1 | m;
                c = this.pixels[i + 1];
                m = c == this.transparent ? 1 : 0;
                maskval = maskval << 1 | m;
                byte b = (val |= c & 0xF) < 128 ? (byte)val : (byte)(val - 256);
                this.icXOR[adr++] = b;
                if ((lmask += 2) != 8) continue;
                lmask = 0;
                this.icAND[maskadr++] = (byte)maskval;
                maskval = 0;
            }
        }
    }

    Image getImage() {
        int len = this.icXOR.length;
        int i = 0;
        int j = 0;
        int k = 0;
        int maskbit = 128;
        boolean maskptr = false;
        this.setMaxColors();
        switch (this.maxColors) {
            case 256: {
                this.pixels = new int[len];
                for (j = this.height - 1; j >= 0; --j) {
                    for (i = 0; i < this.width; ++i) {
                        this.pixels[k++] = this.icoToRGB(this.icXOR[j * this.width + i]);
                    }
                }
                break;
            }
            default: {
                this.pixels = new int[len * 2];
                try {
                    int w = this.width / 2;
                    for (j = this.height - 1; j >= 0; --j) {
                        for (i = 0; i < w; ++i) {
                            byte pix = this.icXOR[j * w + i];
                            int high = pix >> 4 & 0xF;
                            int low = pix & 0xF;
                            this.pixels[k++] = this.icoToRGB(high);
                            this.pixels[k++] = this.icoToRGB(low);
                        }
                    }
                    break;
                }
                catch (ArrayIndexOutOfBoundsException a) {
                    System.out.println("Icon: error in getImage");
                }
            }
        }
        MemoryImageSource mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    void load(String path) {
        try {
            DataInputStream p = new DataInputStream(new FileInputStream(path));
            this.idReserved = p.readShort();
            this.idType = p.readByte();
            this.idType1 = p.readByte();
            this.idCount = p.readByte();
            this.idCount1 = p.readByte();
            this.width = p.readByte();
            this.height = p.readByte();
            this.bColorCount = p.readByte();
            this.bColorCount1 = p.readByte();
            this.wPlanes = p.readShort();
            this.wBitCount = p.readShort();
            this.dwBytesInRes = p.readByte();
            this.dwBytesInRes1 = p.readByte();
            this.dwBytesInRes2 = p.readByte();
            this.dwBytesInRes3 = p.readByte();
            this.dwImageOffset = p.readByte();
            this.dwImageOffset1 = p.readByte();
            this.dwImageOffset2 = p.readByte();
            this.dwImageOffset3 = p.readByte();
            this.biSize = p.readByte();
            this.biSize1 = p.readByte();
            this.biSize2 = p.readByte();
            this.biSize3 = p.readByte();
            this.biWidth = p.readByte();
            this.biWidth1 = p.readByte();
            this.biWidth2 = p.readByte();
            this.biWidth3 = p.readByte();
            this.biHeight = p.readByte();
            this.biHeight1 = p.readByte();
            this.biHeight2 = p.readByte();
            this.biHeight3 = p.readByte();
            this.biPlanes = p.readByte();
            this.biPlanes1 = p.readByte();
            this.biBitCount = p.readByte();
            this.biBitCount1 = p.readByte();
            this.biCompression = p.readByte();
            this.biCompression1 = p.readByte();
            this.biCompression2 = p.readByte();
            this.biCompression3 = p.readByte();
            this.biSizeImage = p.readByte();
            this.biSizeImage1 = p.readByte();
            this.biSizeImage2 = p.readByte();
            this.biSizeImage3 = p.readByte();
            this.biXPelsPerMeter = p.readInt();
            this.biYPelsPerMeter = p.readInt();
            this.biClrUsed = p.readInt();
            this.biClrImportant = p.readInt();
            for (int i = 0; i < 16; ++i) {
                p.read(this.icColors[i], 0, 4);
            }
            p.read(this.icXOR, 0, 512);
            p.read(this.icAND, 0, 128);
            p.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean save(String path) {
        try {
            DataOutputStream p = new DataOutputStream(new FileOutputStream(path));
            p.writeShort(this.idReserved);
            p.writeByte(this.idType);
            p.writeByte(this.idType1);
            p.writeByte(this.idCount);
            p.writeByte(this.idCount1);
            p.writeByte(this.width);
            p.writeByte(this.height);
            p.writeByte(this.bColorCount);
            p.writeByte(this.bColorCount1);
            p.writeShort(this.wPlanes);
            p.writeShort(this.wBitCount);
            p.writeByte(this.dwBytesInRes);
            p.writeByte(this.dwBytesInRes1);
            p.writeByte(this.dwBytesInRes2);
            p.writeByte(this.dwBytesInRes3);
            p.writeByte(this.dwImageOffset);
            p.writeByte(this.dwImageOffset1);
            p.writeByte(this.dwImageOffset2);
            p.writeByte(this.dwImageOffset3);
            p.writeByte(this.biSize);
            p.writeByte(this.biSize1);
            p.writeByte(this.biSize2);
            p.writeByte(this.biSize3);
            p.writeByte(this.biWidth);
            p.writeByte(this.biWidth1);
            p.writeByte(this.biWidth2);
            p.writeByte(this.biWidth3);
            p.writeByte(this.biHeight);
            p.writeByte(this.biHeight1);
            p.writeByte(this.biHeight2);
            p.writeByte(this.biHeight3);
            p.writeByte(this.biPlanes);
            p.writeByte(this.biPlanes1);
            p.writeByte(this.biBitCount);
            p.writeByte(this.biBitCount1);
            p.writeByte(this.biCompression);
            p.writeByte(this.biCompression1);
            p.writeByte(this.biCompression2);
            p.writeByte(this.biCompression3);
            p.writeByte(this.biSizeImage);
            p.writeByte(this.biSizeImage1);
            p.writeByte(this.biSizeImage2);
            p.writeByte(this.biSizeImage3);
            p.writeInt(this.biXPelsPerMeter);
            p.writeInt(this.biYPelsPerMeter);
            p.writeInt(this.biClrUsed);
            p.writeInt(this.biClrImportant);
            for (int i = 0; i < 16; ++i) {
                p.write(this.icColors[i], 0, 4);
            }
            p.write(this.icXOR, 0, 512);
            p.write(this.icAND, 0, 128);
            p.flush();
            p.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

