/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.net.URL;

public class ImagePanel
extends Panel {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_MAPPED = 2;
    public static final int IMAGE_NORMAL = 3;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public int border;
    private transient Image image;
    private URL imageURL;
    private int imageStyle;
    public int stringX = 0;
    public int stringY = 0;
    public String iString = null;

    public ImagePanel() {
        super.setLayout(null);
        this.image = null;
        this.border = 0;
        this.imageStyle = 1;
    }

    public ImagePanel(int b, int s) {
        super.setLayout(null);
        this.image = null;
        this.imageStyle = s;
        this.border = b;
    }

    public void setStyle(int newStyle) {
        this.imageStyle = newStyle;
    }

    public void setBorder(int b) {
        this.border = b;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        int panelW = dim.width;
        int panelH = dim.height;
        g.clearRect(0, 0, panelW, panelH);
        if (this.image != null) {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            switch (this.imageStyle) {
                case 0: {
                    int numHImages = panelW / imageWidth;
                    if (panelW % imageWidth != 0) {
                        ++numHImages;
                    }
                    int numVImages = panelH / imageHeight;
                    if (panelH % imageHeight != 0) {
                        ++numVImages;
                    }
                    int v = 0;
                    for (int vCount = 0; vCount < numVImages; ++vCount) {
                        int h = 0;
                        for (int hCount = 0; hCount < numHImages; ++hCount) {
                            g.drawImage(this.image, h, v, imageWidth, imageHeight, this);
                            h += imageWidth;
                        }
                        v += imageHeight;
                    }
                    break;
                }
                default: {
                    int x = (panelW - imageWidth) / 2;
                    int y = (panelH - imageHeight) / 2;
                    int b = 0;
                    if (this.border != 0) {
                        g.setColor(Color.black);
                        g.drawRect(x, y, imageWidth - 1, imageHeight - 1);
                        b = 1;
                    }
                    g.drawImage(this.image, x + b, y + b, imageWidth - b * 2, imageHeight - b * 2, this);
                    break;
                }
                case 2: {
                    int b = 0;
                    if (this.border != 0) {
                        g.setColor(Color.black);
                        g.drawRect(0, 0, panelW - 1, panelH - 1);
                        b = 1;
                    }
                    g.drawImage(this.image, b, b, panelW - b * 2, panelH - b * 2, this);
                    break;
                }
                case 3: {
                    g.drawImage(this.image, 0, 0, this);
                }
            }
        }
        if (this.iString != null) {
            g.drawString(this.iString, this.stringX, this.stringY);
        }
        super.paint(g);
    }

    public void setImage(URL url) {
        if (!this.imageURL.equals(url)) {
            this.imageURL = url;
            if (this.imageURL != null) {
                this.image = this.getToolkit().getImage(this.imageURL);
                if (this.image != null) {
                    MediaTracker mt = new MediaTracker(this);
                    try {
                        mt.addImage(this.image, 0);
                        mt.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.repaint();
        }
    }

    public void setImage(Image img) {
        if (img != null) {
            this.image = img;
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(this.image, 0);
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public void setImage(String name) {
        if (name != null) {
            this.setImage(this.getToolkit().getImage(name));
        } else if (this.image != null) {
            this.image.flush();
            this.image = null;
            this.repaint();
        }
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public Image getImage() {
        return this.image;
    }

    public void setString(String str, int x, int y) {
        this.stringX = x;
        this.stringY = y;
        this.iString = str;
    }
}

