/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;

public class ImageViewer
extends Panel
implements MouseListener {
    public static final int NORMAL = 0;
    public static final int TEXTURE = 1;
    public static final int CENTERED = 2;
    public static final int TILED = 4;
    protected int imageStyle = 2;
    public static final int NONE = 0;
    public static final int SCALED = 2;
    public int scaleMode = 0;
    public boolean newSize = false;
    Dimension oldSize = new Dimension(0, 0);
    Dimension dim;
    public int originW;
    public int originH;
    public int imageW;
    public int imageH;
    public transient Image image = null;
    protected String fileName = null;
    protected URL url = null;
    public String name = null;
    protected transient Image model;
    protected transient Image oldModel;
    ActionListener imgAL;

    public ImageViewer() {
        this.addMouseListener(this);
    }

    public ImageViewer(String str) {
        this();
        this.setImage(str);
    }

    public ImageViewer(URL url) {
        this();
        this.setURL(url);
    }

    public ImageViewer(Image img) {
        this();
        this.setImage(img);
    }

    void error(String s) {
        System.out.println(s);
    }

    public void nameIt(String n) {
        this.name = n;
    }

    public void setStyle(int newStyle) {
        this.imageStyle = newStyle;
    }

    public void setScaleMode(int sm) {
        this.scaleMode = sm;
    }

    public Dimension getDimension() {
        return new Dimension(this.imageW, this.imageH);
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getModel() {
        return this.model;
    }

    public Image loadImage(String path) {
        return this.loadImage(this.getToolkit().getImage(path));
    }

    public Image loadImage(Image img) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
            return img;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void setModel(Image img) {
        this.oldModel = this.model = this.loadImage(img);
        this.imageW = this.model.getWidth(this);
        this.imageH = this.model.getHeight(this);
        this.originW = this.imageW;
        this.originH = this.imageH;
    }

    public void setModel(String path) {
        this.fileName = path;
        this.setModel(this.getToolkit().getImage(path));
    }

    public static Image resize(Image model, int originW, int originH, int ivw, int ivh) {
        int H = ivh;
        int W = (int)((float)originW * (float)ivh / (float)originH);
        if (W > ivw) {
            W = ivw;
            H = (int)((float)originH * (float)ivw / (float)originW);
        }
        return model.getScaledInstance(W, H, 1);
    }

    public Image resize(Image model) {
        int ivh;
        int ivw = this.getWidth();
        this.imageH = ivh = this.getHeight();
        this.imageW = (int)((float)this.originW * (float)ivh / (float)this.originH);
        if (this.imageW > ivw) {
            this.imageW = ivw;
            this.imageH = (int)((float)this.originH * (float)ivw / (float)this.originW);
        }
        return model.getScaledInstance(this.imageW, this.imageH, 1);
    }

    boolean scaleNeeded() {
        return this.originW >= this.getWidth() || this.originH >= this.getHeight();
    }

    public void setImage(String path) {
        this.setModel(path);
        this.image = this.scaleNeeded() ? this.resize(this.model) : this.model;
    }

    public void setImage(Image img) {
        this.setModel(img);
        this.image = this.scaleNeeded() ? this.resize(this.model) : this.model;
        this.fileName = null;
    }

    public void setImage(String path, int scaleflag) {
        this.scaleMode = scaleflag;
        this.setModel(path);
        switch (scaleflag) {
            case 2: {
                this.image = this.resize(this.model);
                this.imageStyle = 2;
            }
        }
        this.image = this.model;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setURL(URL aUrl) {
        Image loadedImage = null;
        this.url = aUrl;
        this.fileName = null;
        if (this.url != null) {
            loadedImage = this.getToolkit().getImage(this.url);
        }
        this.setImage(loadedImage);
        this.repaint();
    }

    public URL getURL() {
        return this.url;
    }

    public void clear() {
        Graphics g = this.getGraphics();
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.dim = this.getSize();
        int panelW = this.dim.width;
        int panelH = this.dim.height;
        if (this.imageW + this.imageH < 512) {
            g.clearRect(0, 0, panelW, panelH);
        }
        if (this.image == null) {
            return;
        }
        if (this.model != null) {
            this.newSize = !this.model.equals(this.oldModel) || !this.oldSize.equals(this.dim);
        }
        switch (this.imageStyle) {
            default: {
                if (this.scaleMode == 2) {
                    if (this.newSize) {
                        this.image = this.resize(this.model);
                    }
                } else if (this.newSize) {
                    if (this.originW >= panelW || this.originH >= panelH) {
                        this.image = this.resize(this.model);
                    } else if (this.imageW != this.originW || this.imageH != this.originH) {
                        this.image = this.model;
                        this.imageW = this.originW;
                        this.imageH = this.originH;
                    }
                }
                int x = (panelW - this.imageW) / 2;
                int y = (panelH - this.imageH) / 2;
                g.drawImage(this.image, x, y, this.imageW, this.imageH, this);
                break;
            }
            case 4: {
                int numHImages = panelW / this.imageW;
                if (panelW % this.imageW != 0) {
                    ++numHImages;
                }
                int numVImages = panelH / this.imageH;
                if (panelH % this.imageH != 0) {
                    ++numVImages;
                }
                int v = 0;
                for (int vCount = 0; vCount < numVImages; ++vCount) {
                    int h = 0;
                    for (int hCount = 0; hCount < numHImages; ++hCount) {
                        g.drawImage(this.image, h, v, this.imageW, this.imageH, this);
                        h += this.imageW;
                    }
                    v += this.imageH;
                }
                break;
            }
            case 1: {
                g.drawImage(this.image, 0, 0, panelW, panelH, this);
                break;
            }
            case 0: {
                g.drawImage(this.image, 0, 0, this);
            }
        }
        this.oldSize = this.dim;
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(10, 10);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addActionListener(ActionListener l) {
        this.imgAL = AWTEventMulticaster.add(this.imgAL, l);
    }

    public void removeActionListener(ActionListener l) {
        this.imgAL = AWTEventMulticaster.remove(this.imgAL, l);
    }

    public void sendAction(String command) {
        if (this.imgAL != null) {
            this.imgAL.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    protected void sendResizeEvent() {
        this.sendAction("Resized");
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.sendAction("full");
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

