/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.Serializable;
import java.net.URL;

public class ListItem
implements Serializable {
    URL url = null;
    transient Image image;
    String sText;
    boolean bEnabled;
    boolean bSelected;
    transient boolean bDirty;
    Color color;
    int lineWidth;
    boolean bCellBorder;
    Color cellBorderColor;
    boolean bEdited = false;
    boolean deleted = false;
    boolean tagged = false;

    public ListItem(Image image, String sText, boolean bEnabled, FontMetrics fm, boolean bCellBorder) {
        this.image = image;
        this.sText = sText;
        this.bEnabled = bEnabled;
        this.bSelected = false;
        this.bDirty = true;
        this.color = null;
        this.bCellBorder = bCellBorder;
        this.cellBorderColor = Color.black;
        this.updateWidth(fm);
    }

    public ListItem(Image image, URL url, String sText, boolean bEnabled, FontMetrics fm, boolean bCellBorder) {
        this(image, sText, bEnabled, fm, bCellBorder);
        this.url = url;
    }

    public void updateWidth(FontMetrics fm) {
        this.lineWidth = fm != null ? fm.stringWidth(this.sText) : 0;
    }

    public String toString() {
        String s = "ListItem " + this.sText;
        if (this.image != null) {
            s = s + " [Image]";
        }
        if (this.color != Color.black) {
            s = s + " [Colored]";
        }
        s = this.bEnabled ? s + " [Enabled]" : s + " [Disabled]";
        s = this.bSelected ? s + " [Selected]" : s + " [Not Selected]";
        if (this.bDirty) {
            s = s + " [Dirty]";
        }
        return s;
    }
}

