/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DBPanel;
import ae.DDialog;
import ae.LocateEngine;
import ae.OS;
import ae.Path;
import ae.Style;
import ae.Tool;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LocateDialog
extends DDialog
implements ActionListener {
    LocateEngine fre = null;
    List textLocate = null;
    boolean achieved = false;
    public String dirfound = null;
    public String filefound = null;
    public static final int CANCEL = 0;
    public static final int GO = 1;
    public static final int OPEN = 2;
    public int result = 0;
    String CurDrive = "";
    DBPanel panelControl;
    TextField inputFilename;
    Button buttonCancel;
    Button buttonSearch;
    Label labelFilename;
    Button buttonGo;
    Button buttonOpen;
    Label labelResult;
    Panel panelText;
    Label labelDir;
    SWThread searchThread = null;

    public LocateDialog(Frame parent, boolean gopath) {
        super(parent);
        int textSize = 30;
        if (OS.isWindows()) {
            textSize = 24;
        }
        this.setLayout(new BorderLayout(0, 0));
        this.setBounds(80, 80, this.getInsets().left + this.getInsets().right + 556, this.getInsets().top + this.getInsets().bottom + 360);
        this.panelControl = new DBPanel(3);
        this.panelControl.setLayout(null);
        this.panelControl.setBounds(this.getInsets().left + 0, this.getInsets().top + 0, 556, 152);
        this.panelControl.setFont(new Font("Dialog", 0, 14));
        this.panelControl.setBackground(this.getBackground());
        this.add("North", this.panelControl);
        this.buttonSearch = new Button("Search");
        this.buttonSearch.setBounds(8, 8, 94, 32);
        this.buttonSearch.setBackground(this.getBackground());
        this.buttonSearch.addActionListener(this);
        this.panelControl.add(this.buttonSearch);
        this.buttonOpen = new Button("Open");
        this.buttonOpen.setBounds(106, 8, 96, 32);
        this.buttonOpen.setBackground(this.getBackground());
        this.buttonOpen.setEnabled(false);
        this.buttonOpen.addActionListener(this);
        this.panelControl.add(this.buttonOpen);
        this.buttonGo = new Button("Go to path");
        this.buttonGo.setBounds(206, 8, 112, 32);
        this.buttonGo.setBackground(this.getBackground());
        this.buttonGo.setEnabled(false);
        this.buttonGo.addActionListener(this);
        if (gopath) {
            this.panelControl.add(this.buttonGo);
        }
        this.buttonCancel = new Button("Cancel");
        this.buttonCancel.setBounds(446, 8, 94, 32);
        this.buttonCancel.setBackground(this.getBackground());
        this.buttonCancel.addActionListener(this);
        this.panelControl.add(this.buttonCancel);
        this.labelFilename = OS.isWindows() ? new Label("File to locate:  filename  or  drive:filename") : new Label("File to locate:  filename");
        this.labelFilename.setBounds(8, 60, 312, 16);
        this.panelControl.add(this.labelFilename);
        this.inputFilename = new TextField();
        this.inputFilename.setBounds(8, 82, 300, textSize);
        this.panelControl.add(this.inputFilename);
        this.labelResult = new Label();
        this.labelResult.setBounds(340, 83, 180, textSize - 2);
        this.labelResult.setBackground(Color.black);
        this.labelResult.setForeground(Color.green);
        this.labelResult.setAlignment(1);
        this.panelControl.add(this.labelResult);
        this.labelDir = new Label("Searching directory...");
        this.labelDir.setBounds(8, 116, 516, textSize - 2);
        this.panelControl.add(this.labelDir);
        this.panelText = new Panel();
        this.panelText.setLayout(new GridLayout(1, 0, 0, 0));
        this.panelText.setBounds(this.getInsets().left + 0, this.getInsets().top + 10, 556, 260);
        this.add("Center", this.panelText);
        this.textLocate = new List();
        this.textLocate.setBackground(this.getBackground().brighter());
        this.textLocate.setForeground(Color.black);
        this.textLocate.setFont(new Font("Courier", 0, 14));
        this.textLocate.setMultipleMode(false);
        this.panelText.add(this.textLocate);
        this.setTitle(" Locate a file or directory");
        this.CurDrive = OS.isWindows() ? "c:" : "";
    }

    public LocateDialog(Frame parent) {
        this(parent, false);
    }

    public LocateDialog(Frame parent, String previous) {
        this(parent, true);
        this.inputFilename.setText(previous);
    }

    public void setTextStyle(Style s) {
        this.textLocate.setFont(s.font);
        this.textLocate.setBackground(s.background);
        this.textLocate.setForeground(s.foreground);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.buttonSearch) {
            this.searchThread = new SWThread();
            this.setThread(this.searchThread);
            this.searchThread.start();
        } else {
            if (object == this.buttonCancel) {
                if (this.searchThread != null) {
                    this.searchThread.interrupt();
                    this.searchThread = null;
                    if (!this.achieved) {
                        this.setResult("Stopped");
                        return;
                    }
                }
                this.hide();
                this.dispose();
                return;
            }
            if (object == this.buttonGo) {
                this.Action(1);
            } else if (object == this.buttonOpen) {
                this.Action(2);
            } else if (object == this.fre) {
                this.textLocate.select(0);
                this.buttonGo.setEnabled(true);
                this.buttonOpen.setEnabled(true);
            }
        }
    }

    public void setCurDrive(String drive) {
        this.CurDrive = drive;
    }

    public void setInput(String previous) {
        this.inputFilename.setText(previous);
    }

    public void setResult(String str) {
        this.labelResult.setText(str);
    }

    public String getInput() {
        return this.inputFilename.getText();
    }

    public void findAction() {
        String textToLocate = this.inputFilename.getText().trim();
        String basepath = this.CurDrive;
        if (textToLocate.length() == 0) {
            return;
        }
        this.setCursor(new Cursor(3));
        int dskdelim = textToLocate.indexOf(":");
        if (dskdelim != -1) {
            int l = textToLocate.length();
            basepath = textToLocate.substring(0, dskdelim + 1);
            textToLocate = textToLocate.substring(dskdelim + 1, l);
        }
        this.inputFilename.setText(basepath + textToLocate);
        this.setResult("Searching...");
        this.textLocate.removeAll();
        this.fre = new LocateEngine(basepath, textToLocate, this.textLocate, true);
        this.fre.addActionListener(this);
        this.fre.setOccur(0);
        this.fre.setLabel(this.labelDir);
        this.fre.FindIt();
        int num = this.fre.getOccur();
        if (num > 0) {
            this.setResult("Found " + num);
            this.buttonGo.setEnabled(true);
            this.buttonOpen.setEnabled(true);
        } else {
            this.setResult("No found");
        }
        this.achieved = true;
        this.setCursor(Cursor.getDefaultCursor());
        Tool.beep();
    }

    void Action(int action) {
        String name;
        int m;
        if (this.searchThread != null) {
            this.searchThread.interrupt();
            this.searchThread = null;
        }
        if ((m = this.textLocate.getItemCount()) < 1) {
            return;
        }
        if (m == 1) {
            this.textLocate.select(0);
        }
        if ((name = this.textLocate.getSelectedItem()) == null) {
            return;
        }
        this.dirfound = Path.splitPath(name);
        this.filefound = Path.splitFile(name);
        this.result = action;
        this.hide();
        this.dispose();
    }

    public class SWThread
    extends Thread {
        SWThread() {
        }

        public void run() {
            LocateDialog.this.findAction();
        }
    }
}

