/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.CardPanel;
import ae.DComboBox;
import ae.Disk;
import ae.FileList;
import ae.OS;
import ae.Path;
import ae.Preferences;
import ae.VectorString;

public class Memory {
    static String AEListFile = "AE.Memory";
    DComboBox comboSrc;
    DComboBox comboDst;
    FileList progDyn;
    FileList textDyn;
    FileList lastDyn;
    CardPanel cardPanel;
    DComboBox comboExt;
    DComboBox comboAss;
    public String SetupPanel = "0";
    public String srcPath;
    public String dstPath;

    public Memory() {
    }

    public Memory(String dir) {
        AEListFile = dir;
    }

    public void setComponents(DComboBox src, DComboBox dst, FileList prog, FileList text, FileList last, CardPanel tab1, DComboBox ext, DComboBox ass) {
        this.comboSrc = src;
        this.comboDst = dst;
        this.progDyn = prog;
        this.textDyn = text;
        this.lastDyn = last;
        this.cardPanel = tab1;
        this.comboExt = ext;
        this.comboAss = ass;
    }

    public static int getBaseSize(VectorString vs) {
        if (!OS.isWindows()) {
            return Preferences.MemBaseSize;
        }
        int l = vs.size();
        int bsize = 0;
        for (int i = 0; i < l; ++i) {
            if (!Path.isDrive(vs.elementAt(i))) continue;
            ++bsize;
        }
        return bsize;
    }

    public int save(String AEDir) {
        int i;
        String[] AEMemorySrc = this.comboSrc.getListItems();
        String[] AEMemoryDst = this.comboDst.getListItems();
        int ls = AEMemorySrc.length;
        int ld = AEMemoryDst.length;
        int size = Preferences.MemorySize;
        if (ls > size) {
            ls = size;
        }
        if (ld > size) {
            ld = size;
        }
        VectorString vmem = new VectorString();
        vmem.addElement("SEB=" + this.srcPath);
        vmem.addElement("DEB=" + this.dstPath);
        for (i = 0; i < ls; ++i) {
            vmem.addElement("SRC=" + AEMemorySrc[i]);
        }
        for (int j = 0; j < ld; ++j) {
            vmem.addElement("DST=" + AEMemoryDst[j]);
        }
        int index = this.progDyn.index;
        for (i = 0; i < index; ++i) {
            vmem.addElement("PRG=" + this.progDyn.get(i));
        }
        index = this.textDyn.index;
        for (i = 0; i < index; ++i) {
            vmem.addElement("TXT=" + this.textDyn.get(i));
        }
        index = this.lastDyn.index;
        for (i = 0; i < index; ++i) {
            vmem.addElement("REC=" + this.lastDyn.get(i));
        }
        vmem.addElement("SPN=" + new Integer(this.cardPanel.getTab()).toString());
        String[] ExtArray = this.comboExt.getListItems();
        String[] AssArray = this.comboAss.getListItems();
        index = this.comboExt.countItems();
        for (i = 0; i < index; ++i) {
            vmem.addElement("ASS=" + ExtArray[i] + " " + AssArray[i]);
        }
        int result = Disk.saveLines(AEDir, AEListFile, vmem);
        return result;
    }

    public boolean load(String AEDir) {
        int i;
        VectorString src = new VectorString();
        VectorString dst = new VectorString();
        VectorString vlist = new VectorString();
        int loaded = Disk.loadUnicLines(AEDir, AEListFile, vlist);
        int size = vlist.size();
        for (i = 0; i < size; ++i) {
            String test = vlist.elementAt(i);
            int j = test.indexOf("=");
            if (j <= 0) continue;
            String lft = test.substring(0, j);
            String rgt = test.substring(j + 1, test.length());
            if (lft == null || rgt == null) continue;
            if (rgt.length() < 1) {
                System.out.println(lft + " Error: Empty field");
                continue;
            }
            if (lft.equals("SRC")) {
                src.addElement(rgt);
                continue;
            }
            if (lft.equals("DST")) {
                dst.addElement(rgt);
                continue;
            }
            if (lft.equals("SEB")) {
                this.srcPath = rgt;
                continue;
            }
            if (lft.equals("DEB")) {
                this.dstPath = rgt;
                continue;
            }
            if (lft.equals("PRG")) {
                this.progDyn.add(rgt);
                continue;
            }
            if (lft.equals("TXT")) {
                this.textDyn.add(rgt);
                continue;
            }
            if (lft.equals("REC")) {
                this.lastDyn.add(rgt);
                continue;
            }
            if (lft.equals("SPN")) {
                this.SetupPanel = rgt;
                continue;
            }
            if (!lft.equals("ASS")) continue;
            int x = rgt.indexOf(" ");
            int l = rgt.length();
            if (x <= 0 || x >= l) continue;
            this.comboExt.addItem(rgt.substring(0, x));
            this.comboAss.addItem(rgt.substring(x + 1, l));
        }
        this.comboSrc.clear();
        this.comboSrc.setMaxItems(Preferences.MemorySize);
        this.comboDst.clear();
        this.comboDst.setMaxItems(Preferences.MemorySize);
        if (size < 1) {
            return false;
        }
        int lbs = src.separeDrives();
        this.comboSrc.setBaseSize(lbs);
        int dbs = dst.separeDrives();
        this.comboDst.setBaseSize(dbs);
        int l = src.size();
        for (i = 0; i < l; ++i) {
            this.comboSrc.addItem(src.elementAt(i));
        }
        l = dst.size();
        for (i = 0; i < l; ++i) {
            this.comboDst.addItem(dst.elementAt(i));
        }
        return true;
    }

    public void addDrives(VectorString diskslist) {
        for (int i = 0; i < diskslist.size(); ++i) {
            String drive = diskslist.elementAt(i);
            this.comboSrc.addUnicItem(drive);
            this.comboDst.addUnicItem(drive);
        }
        int newsize = Memory.getBaseSize(diskslist);
        if (newsize > Preferences.MemorySize) {
            Preferences.MemorySize = newsize;
        }
        this.comboSrc.setBaseSize(newsize);
        this.comboSrc.separeDrives();
        this.comboDst.setBaseSize(newsize);
        this.comboDst.separeDrives();
    }
}

