/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.DMenu;
import ae.FileList;
import java.awt.AWTEventMulticaster;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class MenuDynamic
extends DMenu
implements ActionListener {
    Vector permanents = new Vector(8);
    int maxsize;
    public FileList dynList;
    ActionListener actionListener = null;

    public MenuDynamic(String text, int size) {
        super(text);
        this.dynList = new FileList(size);
        this.maxsize = size;
    }

    public MenuDynamic(String text) {
        this(text, 8);
    }

    public MenuDynamic(String text, Font f, int s) {
        this(text, s);
        font = f;
        this.setFont(f);
    }

    public void setSize(int size) {
        this.maxsize = size;
        this.dynList.setSize(size);
        this.restore();
    }

    public MenuItem add(MenuItem mi) {
        mi.setFont(font);
        this.permanents.addElement(mi);
        super.add(mi);
        return mi;
    }

    public boolean addDynamic(String path, String fic) {
        MenuItem mi = new MenuItem(fic);
        mi.setActionCommand(Integer.toString(this.dynList.index));
        mi.addActionListener(this);
        mi.setFont(font);
        boolean res = this.dynList.addUnic(path, fic);
        if (res) {
            this.restore();
        }
        return res;
    }

    public void clear() {
        this.removeAll();
        this.dynList.clear();
    }

    public void restore() {
        this.removeAll();
        for (int p = 0; p < this.permanents.size(); ++p) {
            super.add((MenuItem)this.permanents.elementAt(p));
        }
        this.addList();
    }

    public void addList() {
        for (int d = 0; d < this.dynList.index; ++d) {
            MenuItem mi = new MenuItem(this.dynList.names[d]);
            mi.setActionCommand(Integer.toString(d));
            mi.addActionListener(this);
            mi.setFont(font);
            super.add(mi);
        }
    }

    public String get(int numero) {
        return this.dynList.get(numero);
    }

    public String getName(int numero) {
        return this.dynList.getName(numero);
    }

    public boolean already(String dir, String name) {
        return this.dynList.already(dir, name);
    }

    public void remove(String dir, String name) {
        this.dynList.remove(dir, name);
        this.restore();
    }

    public void actionPerformed(ActionEvent e) {
        this.sendSource(e.getActionCommand());
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void sendSource(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }
}

