/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.Path;
import ae.Preferences;
import ae.VectorString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Outline {
    int width;
    int height;
    FileWriter fw;
    BufferedWriter bw;
    static String g = "\"";
    public String htmlFile = "";
    public String htmlName = "";
    public String htmlDir = "";
    String path;
    String name;
    VectorString title;
    VectorString lines;
    VectorString body;
    VectorString summary;
    static final int TEXT = 16;
    static final int INDENT0 = 0;
    static final int INDENT1 = 1;
    static final int INDENT2 = 2;
    static final int INDENT3 = 3;
    static final int INDENT4 = 4;
    static final int INDENT5 = 5;
    static final int TITLE = 15;
    static final int BLANK = 32;
    int previousStatus;
    int status;
    int count;
    String codeTitle;
    int no;
    boolean fermeture = false;

    public Outline(String dir, String textfile) {
        this.name = textfile;
        this.path = Path.merge(dir, textfile);
    }

    public void setFile(String dir, String name) {
        this.htmlFile = Path.merge(dir, name);
        this.htmlDir = dir;
        this.htmlName = name;
    }

    public int load() {
        int count = 0;
        this.lines = new VectorString(1024, 128);
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader(this.path));
            do {
                if ((s = br.readLine()) == null) continue;
                this.lines.addElement(s);
                ++count;
            } while (s != null);
            br.close();
        }
        catch (IOException e) {
            System.out.println("Enable to read " + this.path);
        }
        return count;
    }

    private void put(String s) {
        try {
            this.bw.write(s, 0, s.length());
            this.bw.newLine();
        }
        catch (IOException i) {
            System.out.println("Enable to write " + s);
        }
    }

    void indent(String s, int indentation, int header, String size) {
        String sIndent = "";
        this.codeTitle = "h" + Integer.toString(header);
        for (int i = 0; i < indentation; ++i) {
            sIndent = sIndent + "&nbsp;";
        }
        String name = "title" + this.no++;
        String ref = sIndent + "<a href=" + g + "#" + name + g + ">" + "<span style=\"font size=" + size + ";color=green\">" + s + "</span>" + "</a>";
        this.summary.addElement(ref);
        if (this.fermeture) {
            this.body.addElement("</pre>");
        }
        this.body.addElement("<" + this.codeTitle + "><a name=" + g + name + g + "></a>");
        this.body.addElement(s + "</" + this.codeTitle + "> <pre>");
        this.fermeture = true;
    }

    private void addLine(String s) {
        if (s == null) {
            return;
        }
        this.previousStatus = this.status;
        switch (this.status) {
            case 15: {
                this.title.addElement("<center>" + s + "</center>");
                break;
            }
            case 0: {
                this.indent(s, 0, 3, "14pt");
                break;
            }
            case 1: {
                this.indent(s, 1, 3, "12pt");
                break;
            }
            case 2: {
                this.indent(s, 2, 4, "11pt");
                break;
            }
            case 3: {
                this.indent(s, 3, 5, "10pt");
                break;
            }
            case 4: {
                this.indent(s, 4, 6, "9pt");
                break;
            }
            case 5: {
                this.indent(s, 5, 6, "9pt");
                break;
            }
            case 32: {
                this.body.addElement(s);
                break;
            }
            default: {
                this.previousStatus = 16;
                this.body.addElement(s);
            }
        }
    }

    private boolean isBlank(String s) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isSpaceChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isBlank(int index) {
        return this.isBlank(this.lines.elementAt(index));
    }

    private void parseLine(int index) {
        int i;
        String s = this.lines.elementAt(index);
        if (this.summary.size() == 0 && s.length() > 6 && s.substring(0, 6).equals("      ")) {
            this.status = 15;
            this.addLine(s);
            return;
        }
        if (this.isBlank(s)) {
            this.status = 32;
            this.addLine(s);
            return;
        }
        if (this.previousStatus != 32) {
            this.status = 16;
            this.addLine(s);
            return;
        }
        if (index >= this.lines.size() || index < this.lines.size() - 1 && !this.isBlank(index + 1)) {
            this.status = 16;
            this.addLine(s);
            return;
        }
        int l = Math.min(s.length(), 5);
        for (i = 0; i < l && Character.isSpaceChar(s.charAt(i)); ++i) {
        }
        this.status = i;
        this.addLine(s);
    }

    private void putTitle(int index) {
        this.put(this.title.elementAt(index));
        ++this.count;
    }

    private void putSummary(int index) {
        this.put(this.summary.elementAt(index) + "<br>");
        ++this.count;
    }

    private void putBody(int index) {
        this.put(this.body.elementAt(index));
        ++this.count;
    }

    public int createHtml() {
        if (this.load() == 0) {
            return 0;
        }
        this.title = new VectorString();
        this.summary = new VectorString(this.count / 10, 32);
        this.body = new VectorString(this.count * 9 / 10, 32);
        try {
            this.fw = new FileWriter(this.htmlFile);
            this.bw = new BufferedWriter(this.fw);
        }
        catch (IOException i) {
            System.out.println("Enable to make " + this.htmlFile);
        }
        this.no = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            this.parseLine(i);
        }
        this.put("<HTML>");
        this.put("<HEAD>");
        this.put("<TITLE> Manual </TITLE>");
        this.put("<STYLE TYPE=" + g + "text/css" + g + " MEDIA=screen >");
        this.put("<!--");
        this.put(" BODY { font-family: " + g + "Courrier New" + g + ", Courrier, mono, Monospaced, Arial }");
        this.put(" TABLE { font-family: " + g + "Courrier New" + g + ", Courrier, mono, Monospaced, Arial  }");
        this.put(" H3 { font-size: 12pt; color: green }");
        this.put(" H4 { font-size: 11pt; color: green }");
        this.put(" H5 { font-size: 10pt; color: green }");
        this.put(" H6 { font-size: 9pt; color: green }");
        this.put(" H7 { font-size: 9pt; color: green }");
        this.put(" PRE { font-family: " + g + "Courrier New" + g + ", Courrier, mono, Monospaced, Arial  }");
        this.put(" A:link { text-decoration: none }");
        this.put(" A:visited { text-decoration: none }");
        this.put(" A:hover { text-decoration: none }");
        this.put("-->");
        this.put("</STYLE>");
        this.put("</HEAD>");
        if (Preferences.pageColor.equalsIgnoreCase("None")) {
            this.put("<BODY>");
        } else {
            this.put("<BODY bgcolor=" + Preferences.pageColor + ">");
        }
        for (int h = 0; h < this.title.size(); ++h) {
            this.putTitle(h);
        }
        this.put("<br><hr>");
        this.put("<TABLE align=" + g + "center" + g + " width=" + g + "500" + g + ">");
        this.put("<TR><TD>");
        for (int s = 0; s < this.summary.size(); ++s) {
            this.putSummary(s);
        }
        this.put("</TD></TR>");
        this.put("</TABLE>");
        this.put("<HR><br>");
        for (int b = 0; b < this.body.size(); ++b) {
            this.putBody(b);
        }
        if (this.fermeture) {
            this.put("</PRE>");
        }
        this.put("</BODY>");
        this.put("</HTML>");
        try {
            this.bw.close();
        }
        catch (IOException ic) {
            ic.printStackTrace();
        }
        return this.count;
    }
}

