/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.ColorList;
import ae.OS;
import ae.Preferences;
import java.awt.AWTEventMulticaster;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PageSetup
extends Panel
implements ActionListener,
ItemListener {
    TextField colorField;
    Choice choiceColor;
    Frame parent;
    ActionListener actionListener = null;

    public PageSetup(Frame parent) {
        this.setLayout(null);
        this.setVisible(false);
        this.parent = parent;
        int textSize = 30;
        if (OS.isWindows()) {
            textSize = 24;
        }
        Label pc = new Label("Page color", 2);
        pc.setBounds(16, 96, 80, 20);
        this.add(pc);
        this.colorField = new TextField(Preferences.pageColor);
        this.colorField.setBounds(100, 96, 96, textSize);
        this.colorField.addActionListener(this);
        this.add(this.colorField);
        this.choiceColor = new Choice();
        this.choiceColor.setBackground(parent.getBackground());
        this.choiceColor.setBounds(200, 96, 100, textSize);
        this.choiceColor.addItemListener(this);
        this.add(this.choiceColor);
        ColorList.fillChoice(this.choiceColor);
        this.choiceColor.select(0);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.colorField) {
            Preferences.pageColor = this.colorField.getText();
        }
    }

    protected void sourceActionEvent(int action) {
        if (this.actionListener == null) {
            return;
        }
        String actionCommand = new Integer(action).toString();
        this.actionListener.actionPerformed(new ActionEvent(this, 1001, actionCommand));
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (object == this.choiceColor) {
            String strevent = (String)event.getItem();
            this.colorField.setText(strevent);
            Preferences.pageColor = strevent;
        }
    }
}

