/*
 * Decompiled with CFR 0.152.
 */
package ae;

import ae.PalettePanel;
import ae.RealView;
import ae.VirtualBig;
import ae.VirtualDirect;
import ae.VirtualImage;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Painter
extends Canvas
implements MouseListener,
ActionListener,
MouseMotionListener,
KeyListener,
FocusListener {
    static VirtualBig bigScreen;
    static VirtualDirect realScreen;
    static VirtualDirect undoScreen;
    static PalettePanel palette;
    static final int PICK = 32;
    static final int DOT = 0;
    static final int LINE = 1;
    static final int FILL = 2;
    static final int MOVE = 4;
    static final int SPRAY = 5;
    static final int RUBBER = 6;
    static final int RECTANGLE = 7;
    static final int ELLIPSE = 8;
    static int MODE;
    int OLDCOLOR;
    int X;
    int Y;
    static boolean TRACE;
    static int SQUARE;
    static int WIDTH;
    static int HEIGHT;
    static int x1;
    static int y1;
    static int x2;
    static int y2;
    static int colorInt;
    PopupMenu mousemenu = new PopupMenu();
    RealView realView = null;
    ActionListener actionListener = null;
    Panel panel;
    Label labelX;
    Label labelY;
    int PICKCOLOR;
    static VirtualBig bClone;
    static VirtualDirect tempScreen;
    int mx;
    int my;
    int oldX = -1;
    int oldY = -1;

    static void error(String s) {
        System.out.println(s);
    }

    public Painter() {
        this.BuildMouseMenus();
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.OLDCOLOR = 0;
        this.X = 0;
        this.Y = 0;
    }

    public Painter(Panel p, VirtualBig vs, VirtualDirect rs) {
        this();
        this.panel = p;
        this.setVirtualScreen(vs, rs);
    }

    public void setSize(int w, int h) {
        Dimension d = this.panel.getSize();
        int pw = d.width;
        int ph = d.height;
        this.setBounds((pw - w) / 2, (ph - h) / 2, w, h);
    }

    void setVirtualScreen(VirtualBig vs, VirtualDirect rs) {
        bigScreen = vs;
        realScreen = rs;
        SQUARE = vs.SQUARE;
        WIDTH = rs.width;
        HEIGHT = rs.height;
        this.setSize(Painter.bigScreen.width, Painter.bigScreen.height);
    }

    void setRealView(RealView p) {
        this.realView = p;
    }

    void setPalette(PalettePanel pal) {
        palette = pal;
    }

    void setPosIndicators(Label lx, Label ly) {
        this.labelX = lx;
        this.labelY = ly;
    }

    public void BuildMouseMenus() {
        Font menuFont = new Font("Dialog", 0, 14);
        MenuItem pickItem = new MenuItem("Pick Color");
        pickItem.addActionListener(this);
        pickItem.setFont(menuFont);
        this.mousemenu.add(pickItem);
        MenuItem moveItem = new MenuItem("Move Cursor");
        moveItem.setFont(menuFont);
        moveItem.addActionListener(this);
        this.mousemenu.add(moveItem);
        MenuItem fillItem = new MenuItem("Fill");
        fillItem.addActionListener(this);
        fillItem.setFont(menuFont);
        this.mousemenu.add(fillItem);
        MenuItem shadeItem = new MenuItem("Shade");
        shadeItem.addActionListener(this);
        shadeItem.setFont(menuFont);
        this.mousemenu.add(shadeItem);
        this.mousemenu.addSeparator();
        MenuItem dotItem = new MenuItem("Dot Mode");
        dotItem.addActionListener(this);
        dotItem.setFont(menuFont);
        this.mousemenu.add(dotItem);
        MenuItem rubberItem = new MenuItem("Rubber Mode");
        rubberItem.addActionListener(this);
        rubberItem.setFont(menuFont);
        this.mousemenu.add(rubberItem);
        MenuItem sprayItem = new MenuItem("Spray Mode");
        sprayItem.addActionListener(this);
        sprayItem.setFont(menuFont);
        this.mousemenu.add(sprayItem);
        MenuItem lineItem = new MenuItem("Line");
        lineItem.addActionListener(this);
        lineItem.setFont(menuFont);
        this.mousemenu.add(lineItem);
        MenuItem rItem = new MenuItem("Rectangle");
        rItem.addActionListener(this);
        rItem.setFont(menuFont);
        this.mousemenu.add(rItem);
        MenuItem eItem = new MenuItem("Ellipse");
        eItem.addActionListener(this);
        eItem.setFont(menuFont);
        this.mousemenu.add(eItem);
        this.add(this.mousemenu);
        this.addMouseListener(this);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Image img = bigScreen.getImage();
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            g.drawImage(img, 0, 0, this.getBackground(), this);
        }
        catch (Exception e) {
            Painter.error("Painter - " + e.toString());
            Painter.error("Image size: " + img.getWidth(null) + " " + img.getHeight(null));
        }
    }

    public static void setColor(int c) {
        Painter.realScreen.COLOR = c;
        Painter.bigScreen.COLOR = c;
    }

    public static void setColor(Color color) {
        Painter.setColor(PalettePanel.colorToInt(color));
    }

    public static int invert(int couleur) {
        return -1 - couleur | 0xFF000000;
    }

    public void unCursor() {
        Painter.realScreen.COLOR = this.OLDCOLOR;
        Painter.bigScreen.COLOR = this.OLDCOLOR;
        this.setPixel();
    }

    public void cursor() {
        this.OLDCOLOR = realScreen.getPixel(this.X, this.Y);
        Painter.bigScreen.COLOR = Painter.realScreen.COLOR = Painter.invert(this.OLDCOLOR);
        this.setPixel();
    }

    void doImage() {
        undoScreen = new VirtualDirect(Painter.realScreen.width, Painter.realScreen.height);
        realScreen.copy(undoScreen);
    }

    void undoImage() {
        undoScreen.copy(realScreen);
    }

    public int pickColor(int x, int y) {
        return realScreen.getPixel(x, y);
    }

    public int pickColor() {
        int x = this.mx / SQUARE;
        int y = this.my / SQUARE;
        y = HEIGHT - 1 - y;
        return this.pickColor(x, y);
    }

    public void setPixel() {
        this.setPixel(this.X, this.Y);
    }

    public void setPixel(int x, int y) {
        int color = PalettePanel.penInt;
        realScreen.pixel(x, y, color);
        bigScreen.pixel(x, y, color);
        this.realView.repaint();
        this.repaint();
    }

    public void setPixel(int x, int y, int color) {
        realScreen.pixel(x, y, color);
        bigScreen.pixel(x, y, color);
        this.realView.repaint();
        this.repaint();
    }

    void update() {
        bigScreen.update();
        this.realView.repaint();
        this.repaint();
        Painter.setColor(PalettePanel.penInt);
    }

    public void fill() {
        this.doImage();
        this.setXY();
        realScreen.fill(this.X, this.Y);
        this.update();
    }

    void spray() {
        this.spray(this.X, this.Y);
    }

    void spray(int x, int y) {
        realScreen.spray(x, y);
        this.update();
    }

    void shade() {
        this.doImage();
        this.setXY();
        realScreen.shade(this.pickColor(this.X, this.Y), 1, palette);
        this.update();
    }

    void flipV() {
        realScreen.flipV();
        this.update();
    }

    void flipH() {
        realScreen.flipH();
        this.update();
    }

    void mirrorH() {
        this.doImage();
        realScreen.mirrorH();
        this.update();
    }

    void mirrorV() {
        this.doImage();
        realScreen.mirrorV();
        this.update();
    }

    void insertV() {
        this.doImage();
        realScreen.insertV(this.Y);
        this.update();
    }

    void deleteV() {
        this.doImage();
        realScreen.deleteV(this.Y);
        this.update();
    }

    void insertH() {
        this.doImage();
        realScreen.insertH(this.X);
        this.update();
    }

    void deleteH() {
        this.doImage();
        realScreen.deleteH(this.X);
        this.update();
    }

    public void c2c() {
        this.doImage();
        int old = PalettePanel.selectedInt;
        int next = PalettePanel.colorToInt(PalettePanel.replaceColor);
        realScreen.colorToColor(old, next);
        this.update();
    }

    public void scrollUp() {
        realScreen.scrollUp();
        this.update();
    }

    public void scrollLeft() {
        realScreen.scrollLeft();
        this.update();
    }

    public void scrollRight() {
        realScreen.scrollRight();
        this.update();
    }

    public void scrollDown() {
        realScreen.scrollDown();
        this.update();
    }

    public void rotate() {
    }

    public void merge(Image vImage) {
        this.doImage();
        VirtualImage vi = new VirtualImage();
        vi.load(vImage);
        int transp = PalettePanel.transparentInt;
        realScreen.merge(vi.getPixels(), vi.width, vi.height, transp);
        this.update();
    }

    void setXY() {
        this.X = this.mx / SQUARE;
        this.Y = this.my / SQUARE;
        this.Y = HEIGHT - 1 - this.Y;
    }

    void doShape() {
        tempScreen = new VirtualDirect(Painter.realScreen.width, Painter.realScreen.height);
        realScreen.copy(tempScreen);
        if (bClone == null) {
            bClone = new VirtualBig(Painter.bigScreen.width, Painter.bigScreen.height);
        }
        bigScreen.copy(bClone);
    }

    void undoShape() {
        bClone.copy(bigScreen);
        tempScreen.copy(realScreen);
    }

    void line() {
        this.undoShape();
        realScreen.line(x1, y1, this.X, this.Y, colorInt);
        bigScreen.line(x1, y1, this.X, this.Y, colorInt);
        this.realView.repaint();
        this.repaint();
    }

    void ellipse() {
        this.undoShape();
        int r = this.X - x1;
        int r2 = this.Y - y1;
        realScreen.ellipse(x1, y1, r, r2, colorInt);
        bigScreen.ellipse(x1, y1, r, r2, colorInt);
        this.realView.repaint();
        this.repaint();
    }

    void rectangle() {
        this.undoShape();
        realScreen.rectangle(x1, y1, this.X, this.Y, colorInt);
        bigScreen.rectangle(x1, y1, this.X, this.Y, colorInt);
        this.realView.repaint();
        this.repaint();
    }

    void lineMode() {
        this.doImage();
        MODE = 1;
        this.doShape();
        colorInt = PalettePanel.penInt;
        x1 = this.X;
        y1 = this.Y;
        this.X = x1 + 10;
        this.Y = y1 + 10;
        this.line();
    }

    void ellipseMode() {
        this.doImage();
        MODE = 8;
        this.doShape();
        colorInt = PalettePanel.penInt;
        x1 = this.X;
        y1 = this.Y;
        this.X += 10;
        this.Y += 10;
        this.ellipse();
    }

    void rectangleMode() {
        this.doImage();
        MODE = 7;
        this.doShape();
        colorInt = PalettePanel.penInt;
        x1 = this.X;
        y1 = this.Y;
        this.X = x1 + 10;
        this.Y = y1 + 10;
        this.rectangle();
    }

    public void mouseMoved(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
        int x = this.mx / SQUARE;
        int y = HEIGHT - 1 - this.my / SQUARE;
        this.labelX.setText(Integer.toString(x));
        this.labelY.setText(Integer.toString(y));
    }

    public void mouseDragged(MouseEvent e) {
        e.consume();
        if (e.isPopupTrigger()) {
            return;
        }
        this.mx = e.getX();
        this.my = e.getY();
        this.X = this.mx / SQUARE;
        this.Y = this.my / SQUARE;
        if (this.X < 0) {
            return;
        }
        if (this.Y < 0) {
            return;
        }
        if (this.X >= WIDTH) {
            return;
        }
        if (this.Y >= HEIGHT) {
            return;
        }
        this.Y = HEIGHT - 1 - this.Y;
        switch (MODE) {
            case 0: {
                if (this.oldX == this.X && this.oldY == this.Y) break;
                this.oldX = this.X;
                this.oldY = this.Y;
                this.setPixel(this.X, this.Y);
                break;
            }
            case 6: {
                if (this.oldX == this.X && this.oldY == this.Y) break;
                this.oldX = this.X;
                this.oldY = this.Y;
                this.setPixel(this.X, this.Y, PalettePanel.transparentIndex);
                break;
            }
            case 5: {
                this.spray();
                break;
            }
            case 1: {
                this.line();
                break;
            }
            case 7: {
                this.rectangle();
                break;
            }
            case 8: {
                this.ellipse();
                break;
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.mousemenu.show(this, this.mx, this.my);
            return;
        }
    }

    public void mouseReleased(MouseEvent e) {
        e.consume();
        this.mx = e.getX();
        this.my = e.getY();
        this.X = this.mx / SQUARE;
        this.Y = this.my / SQUARE;
        this.Y = HEIGHT - 1 - this.Y;
        if (e.isPopupTrigger()) {
            this.mousemenu.show(this, this.mx, this.my);
            return;
        }
        switch (MODE) {
            case 0: {
                this.doImage();
                this.setPixel(this.X, this.Y);
                break;
            }
            case 6: {
                this.doImage();
                this.setPixel(this.X, this.Y, PalettePanel.transparentIndex);
                break;
            }
            case 5: {
                this.doImage();
                this.spray();
                break;
            }
            case 7: {
                MODE = 0;
                break;
            }
            case 1: {
                MODE = 0;
                break;
            }
            case 8: {
                MODE = 0;
                break;
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        System.gc();
        if (ac.equals("Pick Color")) {
            this.PICKCOLOR = this.pickColor();
            this.sendAction("pick");
        } else if (ac.equals("Move Cursor")) {
            this.setXY();
        } else if (ac.equals("Fill")) {
            this.fill();
        } else if (ac.equals("Shade")) {
            this.shade();
        } else if (ac.equals("Dot Mode")) {
            MODE = 0;
            Painter.setColor(PalettePanel.penInt);
        } else if (ac.equals("Rubber Mode")) {
            MODE = 6;
        } else if (ac.equals("Line")) {
            this.lineMode();
        } else if (ac.equals("Rectangle")) {
            this.rectangleMode();
        } else if (ac.equals("Ellipse")) {
            this.ellipseMode();
        } else if (ac.equals("Spray Mode")) {
            MODE = 5;
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (e.isMetaDown() || e.isAltDown()) {
            return;
        }
        if (e.isControlDown()) {
            switch (code) {
                case 38: {
                    break;
                }
                case 40: {
                    break;
                }
                case 90: {
                    this.sendAction("undo");
                }
            }
            return;
        }
        this.unCursor();
        switch (code) {
            case 10: {
                this.sendAction("Enter");
                this.requestFocus();
                break;
            }
            case 127: {
                this.sendAction("Delete");
                this.requestFocus();
                break;
            }
            case 27: {
                this.sendAction("Esc");
                break;
            }
            case 36: {
                this.X = 0;
                this.Y = 0;
                break;
            }
            case 35: {
                break;
            }
            case 38: {
                ++this.Y;
                break;
            }
            case 37: {
                --this.X;
                break;
            }
            case 39: {
                ++this.X;
                break;
            }
            case 40: {
                --this.Y;
                break;
            }
            case 32: {
                TRACE = !TRACE;
                return;
            }
        }
        this.cursor();
    }

    protected void sendAction(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, new String(command)));
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    static {
        undoScreen = new VirtualDirect();
        MODE = 0;
        TRACE = true;
        SQUARE = 0;
        WIDTH = 0;
        HEIGHT = 0;
        colorInt = 0;
        bClone = null;
    }
}

