/*
 * Decompiled with CFR 0.152.
 */
package ae;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class Palette {
    protected ColorModel colorModel;
    protected byte[] a = new byte[256];
    protected byte[] r = new byte[256];
    protected byte[] g = new byte[256];
    protected byte[] b = new byte[256];
    int transparent = 7;

    Palette() {
        this.fill();
        this.setColorModel();
    }

    public void setColorModel() {
        this.colorModel = new IndexColorModel(8, this.r.length, this.r, this.g, this.b, this.a);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void fill() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = -1;
            this.r[i] = (byte)i;
            this.g[i] = (byte)i;
            this.b[i] = (byte)i;
        }
        this.a[this.transparent] = 0;
    }

    public void setTransparent(int transp) {
        this.transparent = transp;
        this.colorModel = new IndexColorModel(8, this.r.length, this.r, this.g, this.b, transp);
    }

    public int getRGB(int i) {
        return this.a[i] << 24 | this.r[i] << 16 | this.g[i] << 8 | this.b[i];
    }

    public Color getColor(int index) {
        int red = this.colorModel.getRed(index);
        int green = this.colorModel.getGreen(index);
        int blue = this.colorModel.getBlue(index);
        return new Color(red, green, blue);
    }

    public Color[] getColors() {
        int l = this.r.length;
        Color[] colors = new Color[l];
        for (int i = 0; i < l; ++i) {
            colors[i] = this.getColor(i);
        }
        return colors;
    }

    public void changeColor(int index, Color col) {
        int rgb = col.getRGB();
        this.r[index] = (byte)(rgb >> 16 & 0xFF);
        this.g[index] = (byte)(rgb >> 8 & 0xFF);
        this.b[index] = (byte)(rgb & 0xFF);
    }

    public void display(Graphics g, int x, int y, int sw, int sh) {
        int h = sh / 16;
        int w = sw / 16;
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                g.setColor(this.getColor(j * 16 + i));
                g.fillRect(x + i * w, y + j * h, w, h);
            }
        }
        g.setColor(Color.black);
        g.drawRect(x, y, sw, sh);
    }

    public void rotate(int rotateNo) {
        int i;
        int start = i = rotateNo;
        int l = this.r.length;
        while (start != 0) {
            int oldi = i;
            i = (i + rotateNo) % l;
            byte temp = this.r[oldi];
            this.r[oldi] = this.r[i];
            this.r[i] = temp;
            temp = this.g[oldi];
            this.g[oldi] = this.g[i];
            this.g[i] = temp;
            temp = this.b[oldi];
            this.b[oldi] = this.b[i];
            this.b[i] = temp;
            if (i != start) continue;
            i = --start;
        }
    }

    public void rotateRed(int rotateNo) {
        int i;
        int start = i = rotateNo;
        int l = this.r.length;
        while (start != 0) {
            int oldi = i;
            i = (i + rotateNo) % l;
            byte temp = this.r[oldi];
            this.r[oldi] = this.r[i];
            this.r[i] = temp;
            if (i != start) continue;
            i = --start;
        }
    }

    public void rotateGreen(int rotateNo) {
        int i;
        int start = i = rotateNo;
        int l = this.r.length;
        while (start != 0) {
            int oldi = i;
            i = (i + rotateNo) % l;
            byte temp = this.g[oldi];
            this.g[oldi] = this.g[i];
            this.g[i] = temp;
            if (i != start) continue;
            i = --start;
        }
    }

    public void rotateBlue(int rotateNo) {
        int i;
        int start = i = rotateNo;
        int l = this.r.length;
        while (start != 0) {
            int oldi = i;
            i = (i + rotateNo) % l;
            byte temp = this.b[oldi];
            this.b[oldi] = this.b[i];
            this.b[i] = temp;
            if (i != start) continue;
            i = --start;
        }
    }
}

